/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.text;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.mahout.text.LuceneSegmentInputSplit;
import org.apache.mahout.text.LuceneSegmentRecordReader;
import org.apache.mahout.text.LuceneStorageConfiguration;
import org.apache.mahout.text.ReadOnlyFileSystemDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSegmentInputFormat
extends InputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneSegmentInputFormat.class);

    public List<LuceneSegmentInputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        LuceneStorageConfiguration lucene2SeqConfiguration = new LuceneStorageConfiguration(configuration);
        ArrayList<LuceneSegmentInputSplit> inputSplits = Lists.newArrayList();
        List<Path> indexPaths = lucene2SeqConfiguration.getIndexPaths();
        for (Path indexPath : indexPaths) {
            ReadOnlyFileSystemDirectory directory = new ReadOnlyFileSystemDirectory(FileSystem.get((Configuration)configuration), indexPath, false, configuration);
            SegmentInfos segmentInfos = new SegmentInfos();
            segmentInfos.read(directory);
            for (SegmentCommitInfo segmentInfo : segmentInfos) {
                LuceneSegmentInputSplit inputSplit = new LuceneSegmentInputSplit(indexPath, segmentInfo.info.name, segmentInfo.sizeInBytes());
                inputSplits.add(inputSplit);
                LOG.info("Created {} byte input split for index '{}' segment {}", new Object[]{segmentInfo.sizeInBytes(), indexPath.toUri(), segmentInfo.info.name});
            }
        }
        return inputSplits;
    }

    public RecordReader<Text, NullWritable> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        LuceneSegmentRecordReader luceneSegmentRecordReader = new LuceneSegmentRecordReader();
        luceneSegmentRecordReader.initialize(inputSplit, context);
        return luceneSegmentRecordReader;
    }
}

