/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.FloatLongProcedure;
import org.apache.mahout.math.function.FloatProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.list.LongArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractFloatLongMap
extends AbstractSet {
    public boolean containsKey(final float key) {
        return !this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final long value) {
        return !this.forEachPair(new FloatLongProcedure(){

            @Override
            public boolean apply(float iterKey, long iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractFloatLongMap copy() {
        return (AbstractFloatLongMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractFloatLongMap)) {
            return false;
        }
        final AbstractFloatLongMap other = (AbstractFloatLongMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new FloatLongProcedure(){

            @Override
            public boolean apply(float key, long value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new FloatLongProcedure(){

            @Override
            public boolean apply(float key, long value) {
                return AbstractFloatLongMap.this.containsKey(key) && AbstractFloatLongMap.this.get(key) == value;
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachPair(new FloatLongProcedure(){
            int i = 0;

            @Override
            public boolean apply(float key, long value) {
                buf[this.i++] = HashUtils.hash(key) ^ HashUtils.hash(value);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(FloatProcedure var1);

    public boolean forEachPair(final FloatLongProcedure procedure) {
        return this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float key) {
                return procedure.apply(key, AbstractFloatLongMap.this.get(key));
            }
        });
    }

    public abstract long get(float var1);

    public FloatArrayList keys() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(FloatArrayList keyList) {
        this.pairsSortedByValue(keyList, new LongArrayList(this.size()));
    }

    public void pairsMatching(final FloatLongProcedure condition, final FloatArrayList keyList, final LongArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new FloatLongProcedure(){

            @Override
            public boolean apply(float key, long value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(FloatArrayList keyList, LongArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(FloatArrayList keyList, LongArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final float[] k = keyList.elements();
        final long[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                long t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                float t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(float var1, long var2);

    public abstract boolean removeKey(float var1);

    public String toString() {
        FloatArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        FloatArrayList theKeys = new FloatArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            float key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public LongArrayList values() {
        LongArrayList list = new LongArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final LongArrayList list) {
        list.clear();
        this.forEachKey(new FloatProcedure(){

            @Override
            public boolean apply(float key) {
                list.add(AbstractFloatLongMap.this.get(key));
                return true;
            }
        });
    }

    public long adjustOrPutValue(float key, long newValue, long incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

