/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd.qr;

import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;

public final class GramSchmidt {
    private GramSchmidt() {
    }

    public static void orthonormalizeColumns(Matrix mx) {
        int n = mx.numCols();
        for (int c = 0; c < n; ++c) {
            Vector col = mx.viewColumn(c);
            for (int c1 = 0; c1 < c; ++c1) {
                Vector viewC1 = mx.viewColumn(c1);
                col.assign(col.minus(viewC1.times(viewC1.dot(col))));
            }
            final double norm2 = col.norm(2.0);
            col.assign(new DoubleFunction(){

                @Override
                public double apply(double x) {
                    return x / norm2;
                }
            });
        }
    }
}

