/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterator;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterator;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseSymmetricMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.UpperTriangular;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.Functions;

public final class SSVDHelper {
    private static final Pattern OUTPUT_FILE_PATTERN = Pattern.compile("(\\w+)-(m|r)-(\\d+)(\\.\\w+)?");
    static final Comparator<FileStatus> PARTITION_COMPARATOR = new Comparator<FileStatus>(){
        private final Matcher matcher = SSVDHelper.access$000().matcher("");

        @Override
        public int compare(FileStatus o1, FileStatus o2) {
            this.matcher.reset(o1.getPath().getName());
            if (!this.matcher.matches()) {
                throw new IllegalArgumentException("Unexpected file name, unable to deduce partition #:" + o1.getPath());
            }
            int p1 = Integer.parseInt(this.matcher.group(3));
            this.matcher.reset(o2.getPath().getName());
            if (!this.matcher.matches()) {
                throw new IllegalArgumentException("Unexpected file name, unable to deduce partition #:" + o2.getPath());
            }
            int p2 = Integer.parseInt(this.matcher.group(3));
            return p1 - p2;
        }
    };

    private SSVDHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector loadVector(Path glob, Configuration conf) throws IOException {
        SequenceFileDirValueIterator iter = new SequenceFileDirValueIterator(glob, PathType.GLOB, null, null, true, conf);
        try {
            if (!iter.hasNext()) {
                throw new IOException("Empty input while reading vector");
            }
            VectorWritable vw = (VectorWritable)((Object)iter.next());
            if (iter.hasNext()) {
                throw new IOException("Unexpected data after the end of vector file");
            }
            Vector vector = vw.get();
            return vector;
        }
        finally {
            Closeables.close(iter, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveVector(Vector v, Path vectorFilePath, Configuration conf) throws IOException {
        VectorWritable vw = new VectorWritable(v);
        FileSystem fs = FileSystem.get((Configuration)conf);
        SequenceFile.Writer w = new SequenceFile.Writer(fs, conf, vectorFilePath, IntWritable.class, VectorWritable.class);
        try {
            w.append((Writable)new IntWritable(), (Writable)vw);
        }
        finally {
            w.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<? extends Writable> sniffInputLabelType(Path[] inputPath, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (Path p : inputPath) {
            Class<Writable> clazz;
            FileStatus[] fstats = fs.globStatus(p);
            if (fstats == null || fstats.length == 0) continue;
            FileStatus firstSeqFile = fstats[0].isDir() ? fs.listStatus(fstats[0].getPath(), PathFilters.logsCRCFilter())[0] : fstats[0];
            SequenceFile.Reader r = null;
            try {
                r = new SequenceFile.Reader(fs, firstSeqFile.getPath(), conf);
                clazz = r.getKeyClass().asSubclass(Writable.class);
            }
            catch (Throwable throwable) {
                Closeables.close(r, true);
                throw throwable;
            }
            Closeables.close((Closeable)r, true);
            return clazz;
        }
        throw new IOException("Unable to open input files to determine input label type.");
    }

    public static Iterator<Pair<Writable, Vector>> drmIterator(FileSystem fs, Path glob, Configuration conf, Deque<Closeable> closeables) throws IOException {
        SequenceFileDirIterator ret = new SequenceFileDirIterator(glob, PathType.GLOB, PathFilters.logsCRCFilter(), PARTITION_COMPARATOR, true, conf);
        closeables.addFirst(ret);
        return Iterators.transform(ret, new Function<Pair<Writable, VectorWritable>, Pair<Writable, Vector>>(){

            @Override
            public Pair<Writable, Vector> apply(Pair<Writable, VectorWritable> p) {
                return new Pair<Writable, Vector>(p.getFirst(), p.getSecond().get());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DenseMatrix drmLoadAsDense(FileSystem fs, Path glob, Configuration conf) throws IOException {
        ArrayDeque<Closeable> closeables = new ArrayDeque<Closeable>();
        try {
            DenseMatrix denseMatrix;
            ArrayList<double[]> denseData = new ArrayList<double[]>();
            Iterator<Pair<Writable, Vector>> iter = SSVDHelper.drmIterator(fs, glob, conf, closeables);
            while (iter.hasNext()) {
                Pair<Writable, Vector> p = iter.next();
                Vector v = p.getSecond();
                double[] dd = new double[v.size()];
                if (v.isDense()) {
                    for (int i = 0; i < v.size(); ++i) {
                        dd[i] = v.getQuick(i);
                    }
                } else {
                    for (Vector.Element el : v.nonZeroes()) {
                        dd[el.index()] = el.get();
                    }
                }
                denseData.add(dd);
            }
            if (denseData.size() == 0) {
                denseMatrix = null;
                return denseMatrix;
            }
            denseMatrix = new DenseMatrix((double[][])denseData.toArray((T[])new double[denseData.size()][]));
            return denseMatrix;
        }
        finally {
            IOUtils.close(closeables);
        }
    }

    public static DenseSymmetricMatrix loadAndSumUpperTriangularMatricesAsSymmetric(Path glob, Configuration conf) throws IOException {
        Vector v = SSVDHelper.loadAndSumUpVectors(glob, conf);
        return v == null ? null : new DenseSymmetricMatrix(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector loadAndSumUpVectors(Path glob, Configuration conf) throws IOException {
        SequenceFileDirValueIterator iter = new SequenceFileDirValueIterator(glob, PathType.GLOB, null, PARTITION_COMPARATOR, true, conf);
        try {
            Vector v = null;
            while (iter.hasNext()) {
                if (v == null) {
                    v = new DenseVector(((VectorWritable)((Object)iter.next())).get());
                    continue;
                }
                v.assign(((VectorWritable)((Object)iter.next())).get(), Functions.PLUS);
            }
            Vector vector = v;
            return vector;
        }
        finally {
            Closeables.close(iter, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpperTriangular loadUpperTriangularMatrix(Path glob, Configuration conf) throws IOException {
        SequenceFileDirValueIterator iter = new SequenceFileDirValueIterator(glob, PathType.GLOB, null, null, true, conf);
        try {
            if (!iter.hasNext()) {
                throw new IOException("No triangular matrices found");
            }
            Vector v = ((VectorWritable)((Object)iter.next())).get();
            UpperTriangular result = new UpperTriangular(v);
            if (iter.hasNext()) {
                throw new IOException("Unexpected overrun in upper triangular matrix files");
            }
            UpperTriangular upperTriangular = result;
            return upperTriangular;
        }
        finally {
            iter.close();
        }
    }

    public static double[][] extractRawData(Matrix m) {
        int rows = m.numRows();
        int cols = m.numCols();
        double[][] result = new double[rows][];
        for (int i = 0; i < rows; ++i) {
            result[i] = new double[cols];
            for (int j = 0; j < cols; ++j) {
                result[i][j] = m.getQuick(i, j);
            }
        }
        return result;
    }

    static /* synthetic */ Pattern access$000() {
        return OUTPUT_FILE_PATTERN;
    }
}

