/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.similarity.cooccurrence;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.PriorityQueue;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.MutableElement;

public class TopElementsQueue
extends PriorityQueue<MutableElement> {
    private final int maxSize;
    private static final int SENTINEL_INDEX = Integer.MIN_VALUE;

    public TopElementsQueue(int maxSize) {
        super(maxSize);
        this.maxSize = maxSize;
    }

    public List<MutableElement> getTopElements() {
        ArrayList<MutableElement> topElements = Lists.newArrayListWithCapacity(this.maxSize);
        while (this.size() > 0) {
            MutableElement top = (MutableElement)this.pop();
            if (top.index() == Integer.MIN_VALUE) continue;
            topElements.add(top);
        }
        Collections.reverse(topElements);
        return topElements;
    }

    @Override
    protected MutableElement getSentinelObject() {
        return new MutableElement(Integer.MIN_VALUE, Double.MIN_VALUE);
    }

    @Override
    protected boolean lessThan(MutableElement e1, MutableElement e2) {
        return e1.get() < e2.get();
    }
}

