/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer.hebbian;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.decomposer.AsyncEigenVerifier;
import org.apache.mahout.math.decomposer.EigenStatus;
import org.apache.mahout.math.decomposer.SingularVectorVerifier;
import org.apache.mahout.math.decomposer.hebbian.EigenUpdater;
import org.apache.mahout.math.decomposer.hebbian.HebbianUpdater;
import org.apache.mahout.math.decomposer.hebbian.TrainingState;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.function.TimesFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HebbianSolver {
    private static final Logger log = LoggerFactory.getLogger(HebbianSolver.class);
    private static final boolean DEBUG = false;
    private final EigenUpdater updater;
    private final SingularVectorVerifier verifier;
    private final double convergenceTarget;
    private final int maxPassesPerEigen;
    private final Random rng = RandomUtils.getRandom();
    private int numPasses = 0;

    public HebbianSolver(EigenUpdater updater, SingularVectorVerifier verifier, double convergenceTarget, int maxPassesPerEigen) {
        this.updater = updater;
        this.verifier = verifier;
        this.convergenceTarget = convergenceTarget;
        this.maxPassesPerEigen = maxPassesPerEigen;
    }

    public HebbianSolver(EigenUpdater updater, SingularVectorVerifier verifier, double convergenceTarget) {
        this(updater, verifier, convergenceTarget, Integer.MAX_VALUE);
    }

    public HebbianSolver(double convergenceTarget, int maxPassesPerEigen) {
        this(new HebbianUpdater(), new AsyncEigenVerifier(), convergenceTarget, maxPassesPerEigen);
    }

    public HebbianSolver(double convergenceTarget) {
        this(convergenceTarget, Integer.MAX_VALUE);
    }

    public HebbianSolver(int numPassesPerEigen) {
        this(0.0, numPassesPerEigen);
    }

    public TrainingState solve(Matrix corpus, int desiredRank) {
        int cols = corpus.numCols();
        DenseMatrix eigens = new DenseMatrix(desiredRank, cols);
        ArrayList<Double> eigenValues = Lists.newArrayList();
        log.info("Finding {} singular vectors of matrix with {} rows, via Hebbian", (Object)desiredRank, (Object)corpus.numRows());
        DenseMatrix corpusProjections = new DenseMatrix(corpus.numRows(), desiredRank);
        TrainingState state = new TrainingState(eigens, corpusProjections);
        for (int i = 0; i < desiredRank; ++i) {
            DenseVector currentEigen = new DenseVector(cols);
            Object previousEigen = null;
            while (this.hasNotConverged(currentEigen, corpus, state)) {
                int randomStartingIndex = this.getRandomStartingIndex(corpus, eigens);
                Vector initialTrainingVector = corpus.viewRow(randomStartingIndex);
                state.setTrainingIndex(randomStartingIndex);
                this.updater.update(currentEigen, initialTrainingVector, state);
                for (int corpusRow = 0; corpusRow < corpus.numRows(); ++corpusRow) {
                    state.setTrainingIndex(corpusRow);
                    if (corpusRow == randomStartingIndex) continue;
                    this.updater.update(currentEigen, corpus.viewRow(corpusRow), state);
                }
                state.setFirstPass(false);
            }
            double eigenValue = state.getStatusProgress().get(state.getStatusProgress().size() - 1).getEigenValue();
            currentEigen.assign(new TimesFunction(), 1.0 / currentEigen.norm(2.0));
            eigens.assignRow(i, currentEigen);
            eigenValues.add(eigenValue);
            state.setCurrentEigenValues(eigenValues);
            log.info("Found eigenvector {}, eigenvalue: {}", (Object)i, (Object)eigenValue);
            state.setFirstPass(true);
            state.setNumEigensProcessed(state.getNumEigensProcessed() + 1);
            state.setActivationDenominatorSquared(0.0);
            state.setActivationNumerator(0.0);
            state.getStatusProgress().clear();
            this.numPasses = 0;
        }
        return state;
    }

    private int getRandomStartingIndex(Matrix corpus, Matrix eigens) {
        double r;
        int index;
        Vector v;
        while ((v = corpus.viewRow(index = (int)((r = this.rng.nextDouble()) * (double)corpus.numRows()))) == null || v.norm(2.0) == 0.0 || v.getNumNondefaultElements() < 5) {
        }
        return index;
    }

    protected boolean hasNotConverged(Vector currentPseudoEigen, Matrix corpus, TrainingState state) {
        ++this.numPasses;
        if (state.isFirstPass()) {
            log.info("First pass through the corpus, no need to check convergence...");
            return true;
        }
        Matrix previousEigens = state.getCurrentEigens();
        log.info("Have made {} passes through the corpus, checking convergence...", (Object)this.numPasses);
        for (int i = 0; i < state.getNumEigensProcessed(); ++i) {
            Vector previousEigen = previousEigens.viewRow(i);
            currentPseudoEigen.assign(previousEigen, new PlusMult(-state.getHelperVector().get(i)));
            state.getHelperVector().set(i, 0.0);
        }
        EigenStatus status = this.verify(corpus, currentPseudoEigen);
        if (status.inProgress()) {
            log.info("Verifier not finished, making another pass...");
        } else {
            log.info("Has 1 - cosAngle: {}, convergence target is: {}", (Object)(1.0 - status.getCosAngle()), (Object)this.convergenceTarget);
            state.getStatusProgress().add(status);
        }
        return state.getStatusProgress().size() <= this.maxPassesPerEigen && 1.0 - status.getCosAngle() > this.convergenceTarget;
    }

    protected EigenStatus verify(Matrix corpus, Vector currentPseudoEigen) {
        return this.verifier.verify(corpus, currentPseudoEigen);
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        String propertiesFile = args.length > 0 ? args[0] : "config/solver.properties";
        String corpusDir = props.getProperty("solver.input.dir");
        String outputDir = props.getProperty("solver.output.dir");
        if (corpusDir == null || corpusDir.isEmpty() || outputDir == null || outputDir.isEmpty()) {
            log.error("{} must contain values for solver.input.dir and solver.output.dir", (Object)propertiesFile);
            return;
        }
        int rank = Integer.parseInt(props.getProperty("solver.output.desiredRank"));
        double convergence = Double.parseDouble(props.getProperty("solver.convergence"));
        int maxPasses = Integer.parseInt(props.getProperty("solver.maxPasses"));
        HebbianUpdater updater = new HebbianUpdater();
        AsyncEigenVerifier verifier = new AsyncEigenVerifier();
        HebbianSolver solver = new HebbianSolver(updater, verifier, convergence, maxPasses);
        Matrix corpus = null;
        long now = System.currentTimeMillis();
        TrainingState finalState = solver.solve(corpus, rank);
        long time = (System.currentTimeMillis() - now) / 1000L;
        log.info("Solved {} eigenVectors in {} seconds.  Persisted to {}", new Object[]{finalState.getCurrentEigens().rowSize(), time, outputDir});
    }
}

