/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.VectorIterable;

public final class OrthonormalityVerifier {
    private OrthonormalityVerifier() {
    }

    public static VectorIterable pairwiseInnerProducts(Iterable<MatrixSlice> basis) {
        DenseMatrix out = null;
        for (MatrixSlice slice1 : basis) {
            ArrayList<Double> dots = Lists.newArrayList();
            for (MatrixSlice slice2 : basis) {
                dots.add(slice1.vector().dot(slice2.vector()));
            }
            if (out == null) {
                out = new DenseMatrix(dots.size(), dots.size());
            }
            for (int i = 0; i < dots.size(); ++i) {
                out.set(slice1.index(), i, (double)((Double)dots.get(i)));
            }
        }
        return out;
    }
}

