/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.Parameters;
import org.apache.mahout.fpm.pfpgrowth.PFPGrowth;

public class ParallelCountingMapper
extends Mapper<LongWritable, Text, Text, LongWritable> {
    private static final LongWritable ONE = new LongWritable(1L);
    private Pattern splitter;

    protected void map(LongWritable offset, Text input, Mapper.Context context) throws IOException, InterruptedException {
        String[] items = this.splitter.split(input.toString());
        HashSet<String> uniqueItems = Sets.newHashSet(Arrays.asList(items));
        for (String item : uniqueItems) {
            if (item.trim().isEmpty()) continue;
            context.setStatus("Parallel Counting Mapper: " + item);
            context.write((Object)new Text(item), (Object)ONE);
        }
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Parameters params = new Parameters(context.getConfiguration().get("pfp.parameters", ""));
        this.splitter = Pattern.compile(params.get("splitPattern", PFPGrowth.SPLITTER.toString()));
    }
}

