/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterator;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HadoopUtil {
    private static final Logger log = LoggerFactory.getLogger(HadoopUtil.class);

    private HadoopUtil() {
    }

    public static Job prepareJob(Path inputPath, Path outputPath, Class<? extends InputFormat> inputFormat, Class<? extends Mapper> mapper, Class<? extends Writable> mapperKey, Class<? extends Writable> mapperValue, Class<? extends OutputFormat> outputFormat, Configuration conf) throws IOException {
        Job job = new Job(new Configuration(conf));
        Configuration jobConf = job.getConfiguration();
        if (mapper.equals(Mapper.class)) {
            throw new IllegalStateException("Can't figure out the user class jar file from mapper/reducer");
        }
        job.setJarByClass(mapper);
        job.setInputFormatClass(inputFormat);
        jobConf.set("mapred.input.dir", inputPath.toString());
        job.setMapperClass(mapper);
        job.setMapOutputKeyClass(mapperKey);
        job.setMapOutputValueClass(mapperValue);
        job.setOutputKeyClass(mapperKey);
        job.setOutputValueClass(mapperValue);
        jobConf.setBoolean("mapred.compress.map.output", true);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(outputFormat);
        jobConf.set("mapred.output.dir", outputPath.toString());
        return job;
    }

    public static Job prepareJob(Path inputPath, Path outputPath, Class<? extends InputFormat> inputFormat, Class<? extends Mapper> mapper, Class<? extends Writable> mapperKey, Class<? extends Writable> mapperValue, Class<? extends Reducer> reducer, Class<? extends Writable> reducerKey, Class<? extends Writable> reducerValue, Class<? extends OutputFormat> outputFormat, Configuration conf) throws IOException {
        Job job = new Job(new Configuration(conf));
        Configuration jobConf = job.getConfiguration();
        if (reducer.equals(Reducer.class)) {
            if (mapper.equals(Mapper.class)) {
                throw new IllegalStateException("Can't figure out the user class jar file from mapper/reducer");
            }
            job.setJarByClass(mapper);
        } else {
            job.setJarByClass(reducer);
        }
        job.setInputFormatClass(inputFormat);
        jobConf.set("mapred.input.dir", inputPath.toString());
        job.setMapperClass(mapper);
        if (mapperKey != null) {
            job.setMapOutputKeyClass(mapperKey);
        }
        if (mapperValue != null) {
            job.setMapOutputValueClass(mapperValue);
        }
        jobConf.setBoolean("mapred.compress.map.output", true);
        job.setReducerClass(reducer);
        job.setOutputKeyClass(reducerKey);
        job.setOutputValueClass(reducerValue);
        job.setOutputFormatClass(outputFormat);
        jobConf.set("mapred.output.dir", outputPath.toString());
        return job;
    }

    public static String getCustomJobName(String className, JobContext job, Class<? extends Mapper> mapper, Class<? extends Reducer> reducer) {
        StringBuilder name = new StringBuilder(100);
        String customJobName = job.getJobName();
        if (customJobName == null || customJobName.trim().isEmpty()) {
            name.append(className);
        } else {
            name.append(customJobName);
        }
        name.append('-').append(mapper.getSimpleName());
        name.append('-').append(reducer.getSimpleName());
        return name.toString();
    }

    public static void delete(Configuration conf, Iterable<Path> paths) throws IOException {
        if (conf == null) {
            conf = new Configuration();
        }
        for (Path path : paths) {
            FileSystem fs = path.getFileSystem(conf);
            if (!fs.exists(path)) continue;
            log.info("Deleting {}", (Object)path);
            fs.delete(path, true);
        }
    }

    public static void delete(Configuration conf, Path ... paths) throws IOException {
        HadoopUtil.delete(conf, Arrays.asList(paths));
    }

    public static long countRecords(Path path, Configuration conf) throws IOException {
        long count = 0L;
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(path, true, conf);
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static long countRecords(Path path, PathType pt, PathFilter filter, Configuration conf) throws IOException {
        long count = 0L;
        SequenceFileDirValueIterator iterator = new SequenceFileDirValueIterator(path, pt, filter, null, true, conf);
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static InputStream openStream(Path path, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        return fs.open(path.makeQualified(fs));
    }

    public static FileStatus[] getFileStatus(Path path, PathType pathType, PathFilter filter, Comparator<FileStatus> ordering, Configuration conf) throws IOException {
        FileStatus[] statuses;
        FileSystem fs = path.getFileSystem(conf);
        if (filter == null) {
            statuses = pathType == PathType.GLOB ? fs.globStatus(path) : HadoopUtil.listStatus(fs, path);
        } else {
            FileStatus[] fileStatusArray = statuses = pathType == PathType.GLOB ? fs.globStatus(path, filter) : HadoopUtil.listStatus(fs, path, filter);
        }
        if (ordering != null) {
            Arrays.sort(statuses, ordering);
        }
        return statuses;
    }

    public static FileStatus[] listStatus(FileSystem fs, Path path) throws IOException {
        try {
            return fs.listStatus(path);
        }
        catch (FileNotFoundException e) {
            return new FileStatus[0];
        }
    }

    public static FileStatus[] listStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        try {
            return fs.listStatus(path, filter);
        }
        catch (FileNotFoundException e) {
            return new FileStatus[0];
        }
    }

    public static void cacheFiles(Path fileToCache, Configuration conf) {
        DistributedCache.setCacheFiles((URI[])new URI[]{fileToCache.toUri()}, (Configuration)conf);
    }

    public static Path getSingleCachedFile(Configuration conf) throws IOException {
        return HadoopUtil.getCachedFiles(conf)[0];
    }

    public static Path[] getCachedFiles(Configuration conf) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path[] cacheFiles = DistributedCache.getLocalCacheFiles((Configuration)conf);
        URI[] fallbackFiles = DistributedCache.getCacheFiles((Configuration)conf);
        if (cacheFiles == null) {
            Preconditions.checkState(fallbackFiles != null, "Unable to find cached files!");
            cacheFiles = new Path[fallbackFiles.length];
            for (int n = 0; n < fallbackFiles.length; ++n) {
                cacheFiles[n] = new Path(fallbackFiles[n].getPath());
            }
        } else {
            for (int n = 0; n < cacheFiles.length; ++n) {
                cacheFiles[n] = localFs.makeQualified(cacheFiles[n]);
                if (localFs.exists(cacheFiles[n])) continue;
                cacheFiles[n] = new Path(fallbackFiles[n].getPath());
            }
        }
        Preconditions.checkState(cacheFiles.length > 0, "Unable to find cached files!");
        return cacheFiles;
    }

    public static void setSerializations(Configuration configuration) {
        configuration.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization,org.apache.hadoop.io.serializer.WritableSerialization");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInt(int value, Path path, Configuration configuration) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)configuration);
        FSDataOutputStream out = fs.create(path);
        try {
            out.writeInt(value);
        }
        finally {
            Closeables.close((Closeable)out, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readInt(Path path, Configuration configuration) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)configuration);
        FSDataInputStream in = fs.open(path);
        try {
            int n = in.readInt();
            return n;
        }
        finally {
            Closeables.close((Closeable)in, true);
        }
    }

    public static String buildDirList(FileSystem fs, FileStatus fileStatus) throws IOException {
        boolean containsFiles = false;
        ArrayList<String> directoriesList = Lists.newArrayList();
        for (FileStatus childFileStatus : fs.listStatus(fileStatus.getPath())) {
            if (childFileStatus.isDir()) {
                String subDirectoryList = HadoopUtil.buildDirList(fs, childFileStatus);
                directoriesList.add(subDirectoryList);
                continue;
            }
            containsFiles = true;
        }
        if (containsFiles) {
            directoriesList.add(fileStatus.getPath().toUri().getPath());
        }
        return Joiner.on(',').skipNulls().join(directoriesList.iterator());
    }

    public static String buildDirList(FileSystem fs, FileStatus fileStatus, PathFilter pathFilter) throws IOException {
        boolean containsFiles = false;
        ArrayList<String> directoriesList = Lists.newArrayList();
        for (FileStatus childFileStatus : fs.listStatus(fileStatus.getPath(), pathFilter)) {
            if (childFileStatus.isDir()) {
                String subDirectoryList = HadoopUtil.buildDirList(fs, childFileStatus);
                directoriesList.add(subDirectoryList);
                continue;
            }
            containsFiles = true;
        }
        if (containsFiles) {
            directoriesList.add(fileStatus.getPath().toUri().getPath());
        }
        return Joiner.on(',').skipNulls().join(directoriesList.iterator());
    }

    public static String calcRelativeFilePath(Configuration configuration, Path filePath) throws IOException {
        String[] parts;
        FileSystem fs = filePath.getFileSystem(configuration);
        FileStatus fst = fs.getFileStatus(filePath);
        String currentPath = fst.getPath().toString().replaceFirst("file:", "");
        String basePath = configuration.get("baseinputpath");
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        if ((parts = currentPath.split(basePath = basePath.replaceFirst("file:", ""))).length == 2) {
            return parts[1];
        }
        if (parts.length == 1) {
            return parts[0];
        }
        return currentPath;
    }
}

