/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.syntheticcontrol.fuzzykmeans;

import java.util.List;
import java.util.Map;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.canopy.CanopyDriver;
import org.apache.mahout.clustering.conversion.InputDriver;
import org.apache.mahout.clustering.fuzzykmeans.FuzzyKMeansDriver;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;
import org.apache.mahout.utils.clustering.ClusterDumper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Job
extends AbstractJob {
    private static final Logger log = LoggerFactory.getLogger(Job.class);
    private static final String DIRECTORY_CONTAINING_CONVERTED_INPUT = "data";
    private static final String M_OPTION = "m";

    private Job() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            log.info("Running with only user-supplied arguments");
            ToolRunner.run((Configuration)new Configuration(), (Tool)new Job(), (String[])args);
        } else {
            log.info("Running with default arguments");
            Path output = new Path("output");
            Configuration conf = new Configuration();
            HadoopUtil.delete(conf, output);
            Job.run(conf, new Path("testdata"), output, new EuclideanDistanceMeasure(), 80.0, 55.0, 10, 2.0f, 0.5);
        }
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption(DefaultOptionCreator.distanceMeasureOption().create());
        this.addOption(DefaultOptionCreator.convergenceOption().create());
        this.addOption(DefaultOptionCreator.maxIterationsOption().create());
        this.addOption(DefaultOptionCreator.overwriteOption().create());
        this.addOption(DefaultOptionCreator.t1Option().create());
        this.addOption(DefaultOptionCreator.t2Option().create());
        this.addOption(M_OPTION, M_OPTION, "coefficient normalization factor, must be greater than 1", true);
        Map<String, List<String>> argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        String measureClass = this.getOption("distanceMeasure");
        if (measureClass == null) {
            measureClass = SquaredEuclideanDistanceMeasure.class.getName();
        }
        double convergenceDelta = Double.parseDouble(this.getOption("convergenceDelta"));
        int maxIterations = Integer.parseInt(this.getOption("maxIter"));
        float fuzziness = Float.parseFloat(this.getOption(M_OPTION));
        this.addOption(new DefaultOptionBuilder().withLongName(M_OPTION).withRequired(true).withArgument(new ArgumentBuilder().withName(M_OPTION).withMinimum(1).withMaximum(1).create()).withDescription("coefficient normalization factor, must be greater than 1").withShortName(M_OPTION).create());
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(this.getConf(), output);
        }
        DistanceMeasure measure = ClassUtils.instantiateAs(measureClass, DistanceMeasure.class);
        double t1 = Double.parseDouble(this.getOption("t1"));
        double t2 = Double.parseDouble(this.getOption("t2"));
        Job.run(this.getConf(), input, output, measure, t1, t2, maxIterations, fuzziness, convergenceDelta);
        return 0;
    }

    public static void run(Configuration conf, Path input, Path output, DistanceMeasure measure, double t1, double t2, int maxIterations, float fuzziness, double convergenceDelta) throws Exception {
        Path directoryContainingConvertedInput = new Path(output, DIRECTORY_CONTAINING_CONVERTED_INPUT);
        log.info("Preparing Input");
        InputDriver.runJob(input, directoryContainingConvertedInput, "org.apache.mahout.math.RandomAccessSparseVector");
        log.info("Running Canopy to get initial clusters");
        Path canopyOutput = new Path(output, "canopies");
        CanopyDriver.run(new Configuration(), directoryContainingConvertedInput, canopyOutput, measure, t1, t2, false, 0.0, false);
        log.info("Running FuzzyKMeans");
        FuzzyKMeansDriver.run(directoryContainingConvertedInput, new Path(canopyOutput, "clusters-0-final"), output, convergenceDelta, maxIterations, fuzziness, true, true, 0.0, false);
        ClusterDumper clusterDumper = new ClusterDumper(new Path(output, "clusters-*-final"), new Path(output, "clusteredPoints"));
        clusterDumper.printClusters(null);
    }
}

