/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.streaming.mapreduce;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.streaming.mapreduce.CentroidWritable;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Centroid;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.neighborhood.BruteSearch;
import org.apache.mahout.math.neighborhood.FastProjectionSearch;
import org.apache.mahout.math.neighborhood.LocalitySensitiveHashSearch;
import org.apache.mahout.math.neighborhood.ProjectionSearch;
import org.apache.mahout.math.neighborhood.UpdatableSearcher;

public final class StreamingKMeansUtilsMR {
    private StreamingKMeansUtilsMR() {
    }

    public static UpdatableSearcher searcherFromConfiguration(Configuration conf) {
        DistanceMeasure distanceMeasure;
        String distanceMeasureClass = conf.get("distanceMeasure");
        try {
            distanceMeasure = (DistanceMeasure)Class.forName(distanceMeasureClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate distanceMeasure", e);
        }
        int numProjections = conf.getInt("numProjections", 20);
        int searchSize = conf.getInt("searchSize", 10);
        String searcherClass = conf.get("searcherClass");
        if (searcherClass.equals(BruteSearch.class.getName())) {
            return ClassUtils.instantiateAs(searcherClass, UpdatableSearcher.class, new Class[]{DistanceMeasure.class}, new Object[]{distanceMeasure});
        }
        if (searcherClass.equals(FastProjectionSearch.class.getName()) || searcherClass.equals(ProjectionSearch.class.getName())) {
            return ClassUtils.instantiateAs(searcherClass, UpdatableSearcher.class, new Class[]{DistanceMeasure.class, Integer.TYPE, Integer.TYPE}, new Object[]{distanceMeasure, numProjections, searchSize});
        }
        if (searcherClass.equals(LocalitySensitiveHashSearch.class.getName())) {
            return ClassUtils.instantiateAs(searcherClass, LocalitySensitiveHashSearch.class, new Class[]{DistanceMeasure.class, Integer.TYPE}, new Object[]{distanceMeasure, searchSize});
        }
        throw new IllegalStateException("Unknown class instantiation requested");
    }

    public static Iterable<Centroid> getCentroidsFromVectorWritable(Iterable<VectorWritable> inputIterable) {
        return Iterables.transform(inputIterable, new Function<VectorWritable, Centroid>(){
            private int numVectors = 0;

            @Override
            public Centroid apply(VectorWritable input) {
                Preconditions.checkNotNull(input);
                return new Centroid(this.numVectors++, (Vector)new RandomAccessSparseVector(input.get()), 1.0);
            }
        });
    }

    public static Iterable<Centroid> castVectorsToCentroids(Iterable<Vector> input) {
        return Iterables.transform(input, new Function<Vector, Centroid>(){
            private int numVectors = 0;

            @Override
            public Centroid apply(Vector input) {
                Preconditions.checkNotNull(input);
                if (input instanceof Centroid) {
                    return (Centroid)input;
                }
                return new Centroid(this.numVectors++, input, 1.0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCentroidsToSequenceFile(Iterable<Centroid> centroids, Path path, Configuration conf) throws IOException {
        SequenceFile.Writer writer = null;
        try {
            writer = SequenceFile.createWriter((FileSystem)FileSystem.get((Configuration)conf), (Configuration)conf, (Path)path, IntWritable.class, CentroidWritable.class);
            int i = 0;
            for (Centroid centroid : centroids) {
                writer.append((Writable)new IntWritable(i++), (Writable)new CentroidWritable(centroid));
            }
        }
        catch (Throwable throwable) {
            Closeables.close(writer, true);
            throw throwable;
        }
        Closeables.close((Closeable)writer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVectorsToSequenceFile(Iterable<? extends Vector> datapoints, Path path, Configuration conf) throws IOException {
        SequenceFile.Writer writer = null;
        try {
            writer = SequenceFile.createWriter((FileSystem)FileSystem.get((Configuration)conf), (Configuration)conf, (Path)path, IntWritable.class, VectorWritable.class);
            int i = 0;
            for (Vector vector : datapoints) {
                writer.append((Writable)new IntWritable(i++), (Writable)new VectorWritable(vector));
            }
        }
        catch (Throwable throwable) {
            Closeables.close(writer, true);
            throw throwable;
        }
        Closeables.close((Closeable)writer, true);
    }
}

