/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.lda.cvb;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.lda.cvb.CachingCVB0Mapper;
import org.apache.mahout.clustering.lda.cvb.ModelTrainer;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class CVB0DocInferenceMapper
extends CachingCVB0Mapper {
    private final VectorWritable topics = new VectorWritable();

    @Override
    public void map(IntWritable docId, VectorWritable doc, Mapper.Context context) throws IOException, InterruptedException {
        int numTopics = this.getNumTopics();
        Vector docTopics = new DenseVector(numTopics).assign(1.0 / (double)numTopics);
        SparseRowMatrix docModel = new SparseRowMatrix(numTopics, doc.get().size());
        int maxIters = this.getMaxIters();
        ModelTrainer modelTrainer = this.getModelTrainer();
        for (int i = 0; i < maxIters; ++i) {
            modelTrainer.getReadModel().trainDocTopicModel(doc.get(), docTopics, docModel);
        }
        this.topics.set(docTopics);
        context.write((Object)docId, (Object)this.topics);
    }

    @Override
    protected void cleanup(Mapper.Context context) {
        this.getModelTrainer().stop();
    }
}

