/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.kmeans;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EigenSeedGenerator {
    private static final Logger log = LoggerFactory.getLogger(EigenSeedGenerator.class);
    public static final String K = "k";

    private EigenSeedGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path buildFromEigens(Configuration conf, Path input, Path output, int k, DistanceMeasure measure) throws IOException {
        FileSystem fs = FileSystem.get((URI)output.toUri(), (Configuration)conf);
        HadoopUtil.delete(conf, output);
        Path outFile = new Path(output, "part-eigenSeed");
        boolean newFile = fs.createNewFile(outFile);
        if (newFile) {
            Path inputPathPattern = fs.getFileStatus(input).isDir() ? new Path(input, "*") : input;
            FileStatus[] inputFiles = fs.globStatus(inputPathPattern, PathFilters.logsCRCFilter());
            SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)outFile, Text.class, ClusterWritable.class);
            HashMap<Integer, Double> maxEigens = Maps.newHashMapWithExpectedSize(k);
            HashMap<Integer, Text> chosenTexts = Maps.newHashMapWithExpectedSize(k);
            HashMap<Integer, ClusterWritable> chosenClusters = Maps.newHashMapWithExpectedSize(k);
            for (FileStatus fileStatus : inputFiles) {
                if (fileStatus.isDir()) continue;
                for (Pair record : new SequenceFileIterable(fileStatus.getPath(), true, conf)) {
                    Writable key = (Writable)record.getFirst();
                    VectorWritable value = (VectorWritable)((Object)record.getSecond());
                    for (Vector.Element e : value.get().nonZeroes()) {
                        int index = e.index();
                        double v = Math.abs(e.get());
                        if (maxEigens.containsKey(index) && !(v > (Double)maxEigens.get(index))) continue;
                        maxEigens.put(index, v);
                        Text newText = new Text(key.toString());
                        chosenTexts.put(index, newText);
                        Kluster newCluster = new Kluster(value.get(), index, measure);
                        newCluster.observe(value.get(), 1.0);
                        ClusterWritable clusterWritable = new ClusterWritable();
                        clusterWritable.setValue(newCluster);
                        chosenClusters.put(index, clusterWritable);
                    }
                }
            }
            try {
                for (Integer key : maxEigens.keySet()) {
                    writer.append((Writable)chosenTexts.get(key), (Writable)chosenClusters.get(key));
                }
                log.info("EigenSeedGenerator:: Wrote {} Klusters to {}", (Object)chosenTexts.size(), (Object)outFile);
            }
            finally {
                Closeables.close((Closeable)writer, false);
            }
        }
        return outFile;
    }
}

