/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.cdbw;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.OnlineGaussianAccumulator;
import org.apache.mahout.clustering.evaluation.RepresentativePointsMapper;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.ClassUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDbwEvaluator {
    private static final Logger log = LoggerFactory.getLogger(CDbwEvaluator.class);
    private final Map<Integer, List<VectorWritable>> representativePoints;
    private final Map<Integer, Double> stDevs = Maps.newHashMap();
    private final List<Cluster> clusters;
    private final DistanceMeasure measure;
    private Double interClusterDensity = null;
    private Map<Integer, Map<Integer, Double>> minimumDistances = null;
    private Map<Integer, Map<Integer, Double>> interClusterDensities = null;
    private Map<Integer, Map<Integer, int[]>> closestRepPointIndices = null;

    public CDbwEvaluator(Map<Integer, List<VectorWritable>> representativePoints, List<Cluster> clusters, DistanceMeasure measure) {
        this.representativePoints = representativePoints;
        this.clusters = clusters;
        this.measure = measure;
        for (Integer cId : representativePoints.keySet()) {
            this.computeStd(cId);
        }
    }

    public CDbwEvaluator(Configuration conf, Path clustersIn) {
        this.measure = ClassUtils.instantiateAs(conf.get("org.apache.mahout.clustering.measure"), DistanceMeasure.class);
        this.representativePoints = RepresentativePointsMapper.getRepresentativePoints(conf);
        this.clusters = CDbwEvaluator.loadClusters(conf, clustersIn);
        for (Integer cId : this.representativePoints.keySet()) {
            this.computeStd(cId);
        }
    }

    private static List<Cluster> loadClusters(Configuration conf, Path clustersIn) {
        ArrayList<Cluster> clusters = Lists.newArrayList();
        for (ClusterWritable clusterWritable : new SequenceFileDirValueIterable(clustersIn, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            Cluster cluster = clusterWritable.getValue();
            clusters.add(cluster);
        }
        return clusters;
    }

    private void computeStd(int cI) {
        List<VectorWritable> repPts = this.representativePoints.get(cI);
        OnlineGaussianAccumulator accumulator = new OnlineGaussianAccumulator();
        for (VectorWritable vw : repPts) {
            accumulator.observe(vw.get(), 1.0);
        }
        accumulator.compute();
        double d = accumulator.getAverageStd();
        this.stDevs.put(cI, d);
    }

    private double density(Vector uIJ, int cI, int cJ, double avgStd) {
        List<VectorWritable> repI = this.representativePoints.get(cI);
        List<VectorWritable> repJ = this.representativePoints.get(cJ);
        double sum = 0.0;
        for (VectorWritable vwI : repI) {
            if (uIJ == null || !(this.measure.distance(uIJ, vwI.get()) <= avgStd)) continue;
            sum += 1.0;
        }
        for (VectorWritable vwJ : repJ) {
            if (uIJ == null || !(this.measure.distance(uIJ, vwJ.get()) <= avgStd)) continue;
            sum += 1.0;
        }
        int nI = repI.size();
        int nJ = repJ.size();
        return sum / (double)(nI + nJ);
    }

    public double getCDbw() {
        return this.intraClusterDensity() * this.separation();
    }

    public double intraClusterDensity() {
        double avgDensity = 0.0;
        int count = 0;
        for (Vector.Element elem : this.intraClusterDensities().nonZeroes()) {
            double value = elem.get();
            if (Double.isNaN(value)) continue;
            avgDensity += value;
            ++count;
        }
        return avgDensity / (double)count;
    }

    public Map<Integer, Map<Integer, Double>> interClusterDensities() {
        if (this.interClusterDensities != null) {
            return this.interClusterDensities;
        }
        this.interClusterDensities = new TreeMap<Integer, Map<Integer, Double>>();
        for (int i = 0; i < this.clusters.size(); ++i) {
            int cI = this.clusters.get(i).getId();
            TreeMap<Integer, Double> map = new TreeMap<Integer, Double>();
            this.interClusterDensities.put(cI, map);
            for (int j = i + 1; j < this.clusters.size(); ++j) {
                int cJ = this.clusters.get(j).getId();
                double minDistance = this.minimumDistance(cI, cJ);
                Vector uIJ = this.midpointVector(cI, cJ);
                double stdSum = this.stDevs.get(cI) + this.stDevs.get(cJ);
                double density = this.density(uIJ, cI, cJ, stdSum / 2.0);
                double interDensity = minDistance * density / stdSum;
                map.put(cJ, interDensity);
                if (!log.isDebugEnabled()) continue;
                log.debug("minDistance[{},{}]={}", new Object[]{cI, cJ, minDistance});
                log.debug("interDensity[{},{}]={}", new Object[]{cI, cJ, density});
                log.debug("density[{},{}]={}", new Object[]{cI, cJ, interDensity});
            }
        }
        return this.interClusterDensities;
    }

    public double separation() {
        double minDistanceSum = 0.0;
        Map<Integer, Map<Integer, Double>> distances = this.minimumDistances();
        for (Map<Integer, Double> map : distances.values()) {
            for (Double dist : map.values()) {
                if (Double.isInfinite(dist)) continue;
                minDistanceSum += dist * 2.0;
            }
        }
        return minDistanceSum / (1.0 + this.interClusterDensity());
    }

    public double interClusterDensity() {
        if (this.interClusterDensity != null) {
            return this.interClusterDensity;
        }
        double sum = 0.0;
        int count = 0;
        Map<Integer, Map<Integer, Double>> distances = this.interClusterDensities();
        for (Map<Integer, Double> row : distances.values()) {
            for (Double density : row.values()) {
                if (Double.isNaN(density)) continue;
                sum += density.doubleValue();
                ++count;
            }
        }
        log.debug("interClusterDensity={}", (Object)sum);
        this.interClusterDensity = sum / (double)count;
        return this.interClusterDensity;
    }

    public Vector intraClusterDensities() {
        RandomAccessSparseVector densities = new RandomAccessSparseVector(Integer.MAX_VALUE);
        double stdev = 0.0;
        for (Integer cI : this.representativePoints.keySet()) {
            stdev += this.stDevs.get(cI).doubleValue();
        }
        int c = this.representativePoints.size();
        stdev /= (double)c;
        for (Cluster cluster : this.clusters) {
            Integer cI = cluster.getId();
            List<VectorWritable> repPtsI = this.representativePoints.get(cI);
            int r = repPtsI.size();
            double sumJ = 0.0;
            for (VectorWritable pt : repPtsI) {
                Vector repJ = pt.get();
                double densityIJ = this.measure.distance(cluster.getCenter(), repJ) <= stdev ? 1.0 : 0.0;
                sumJ += densityIJ / stdev;
            }
            densities.set(cI, sumJ / (double)r);
        }
        return densities;
    }

    private Map<Integer, Map<Integer, Double>> minimumDistances() {
        if (this.minimumDistances != null) {
            return this.minimumDistances;
        }
        this.minimumDistances = new TreeMap<Integer, Map<Integer, Double>>();
        this.closestRepPointIndices = new TreeMap<Integer, Map<Integer, int[]>>();
        for (int i = 0; i < this.clusters.size(); ++i) {
            Integer cI = this.clusters.get(i).getId();
            TreeMap<Integer, Double> map = new TreeMap<Integer, Double>();
            TreeMap<Integer, int[]> treeMap = new TreeMap<Integer, int[]>();
            this.closestRepPointIndices.put(cI, treeMap);
            this.minimumDistances.put(cI, map);
            List<VectorWritable> closRepI = this.representativePoints.get(cI);
            for (int j = i + 1; j < this.clusters.size(); ++j) {
                Integer cJ = this.clusters.get(j).getId();
                List<VectorWritable> closRepJ = this.representativePoints.get(cJ);
                double minDistance = Double.MAX_VALUE;
                int[] midPointIndices = null;
                for (int xI = 0; xI < closRepI.size(); ++xI) {
                    VectorWritable aRepI = closRepI.get(xI);
                    for (int xJ = 0; xJ < closRepJ.size(); ++xJ) {
                        VectorWritable aRepJ = closRepJ.get(xJ);
                        double distance = this.measure.distance(aRepI.get(), aRepJ.get());
                        if (!(distance < minDistance)) continue;
                        minDistance = distance;
                        midPointIndices = new int[]{xI, xJ};
                    }
                }
                map.put(cJ, minDistance);
                treeMap.put(cJ, midPointIndices);
            }
        }
        return this.minimumDistances;
    }

    private double minimumDistance(int cI, int cJ) {
        Map<Integer, Double> distances = this.minimumDistances().get(cI);
        if (distances != null) {
            return distances.get(cJ);
        }
        return this.minimumDistances().get(cJ).get(cI);
    }

    private Vector midpointVector(int cI, int cJ) {
        Map<Integer, Double> distances = this.minimumDistances().get(cI);
        if (distances != null) {
            int[] ks = this.closestRepPointIndices.get(cI).get(cJ);
            if (ks == null) {
                return null;
            }
            return this.representativePoints.get(cI).get(ks[0]).get().plus(this.representativePoints.get(cJ).get(ks[1]).get()).divide(2.0);
        }
        int[] ks = this.closestRepPointIndices.get(cJ).get(cI);
        if (ks == null) {
            return null;
        }
        return this.representativePoints.get(cJ).get(ks[1]).get().plus(this.representativePoints.get(cI).get(ks[0]).get()).divide(2.0);
    }
}

