/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes.training;

import com.google.common.base.Preconditions;
import org.apache.mahout.math.Vector;

public abstract class AbstractThetaTrainer {
    private final Vector weightsPerFeature;
    private final Vector weightsPerLabel;
    private final Vector perLabelThetaNormalizer;
    private final double alphaI;
    private final double totalWeightSum;
    private final double numFeatures;

    protected AbstractThetaTrainer(Vector weightsPerFeature, Vector weightsPerLabel, double alphaI) {
        Preconditions.checkNotNull(weightsPerFeature);
        Preconditions.checkNotNull(weightsPerLabel);
        this.weightsPerFeature = weightsPerFeature;
        this.weightsPerLabel = weightsPerLabel;
        this.alphaI = alphaI;
        this.perLabelThetaNormalizer = weightsPerLabel.like();
        this.totalWeightSum = weightsPerLabel.zSum();
        this.numFeatures = weightsPerFeature.getNumNondefaultElements();
    }

    public abstract void train(int var1, Vector var2);

    protected double alphaI() {
        return this.alphaI;
    }

    protected double numFeatures() {
        return this.numFeatures;
    }

    protected double labelWeight(int label) {
        return this.weightsPerLabel.get(label);
    }

    protected double totalWeightSum() {
        return this.totalWeightSum;
    }

    protected double featureWeight(int feature) {
        return this.weightsPerFeature.get(feature);
    }

    protected void updatePerLabelThetaNormalizer(int label, double weight) {
        this.perLabelThetaNormalizer.set(label, this.perLabelThetaNormalizer.get(label) + weight);
    }

    public Vector retrievePerLabelThetaNormalizer() {
        return this.perLabelThetaNormalizer.clone();
    }
}

