/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;
import org.apache.mahout.classifier.naivebayes.training.ThetaMapper;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public final class BayesUtils {
    private static final Pattern SLASH = Pattern.compile("/");

    private BayesUtils() {
    }

    public static NaiveBayesModel readModelFromDir(Path base, Configuration conf) {
        float alphaI = conf.getFloat(ThetaMapper.ALPHA_I, 1.0f);
        Vector scoresPerLabel = null;
        Vector scoresPerFeature = null;
        for (Pair record : new SequenceFileDirIterable(new Path(base, "weights"), PathType.LIST, PathFilters.partFilter(), conf)) {
            String key = ((Text)record.getFirst()).toString();
            VectorWritable value = (VectorWritable)((Object)record.getSecond());
            if (key.equals("__SPF")) {
                scoresPerFeature = value.get();
                continue;
            }
            if (!key.equals("__SPL")) continue;
            scoresPerLabel = value.get();
        }
        Preconditions.checkNotNull(scoresPerFeature);
        Preconditions.checkNotNull(scoresPerLabel);
        SparseMatrix scoresPerLabelAndFeature = new SparseMatrix(scoresPerLabel.size(), scoresPerFeature.size());
        for (Pair entry : new SequenceFileDirIterable(new Path(base, "summedObservations"), PathType.LIST, PathFilters.partFilter(), conf)) {
            scoresPerLabelAndFeature.assignRow(((IntWritable)entry.getFirst()).get(), ((VectorWritable)((Object)entry.getSecond())).get());
        }
        Vector perlabelThetaNormalizer = scoresPerLabel.like();
        return new NaiveBayesModel(scoresPerLabelAndFeature, scoresPerFeature, scoresPerLabel, perlabelThetaNormalizer, alphaI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeLabelIndex(Configuration conf, Iterable<String> labels, Path indexPath) throws IOException {
        FileSystem fs = FileSystem.get((URI)indexPath.toUri(), (Configuration)conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, indexPath, Text.class, IntWritable.class);
        int i = 0;
        try {
            for (String label : labels) {
                writer.append((Writable)new Text(label), (Writable)new IntWritable(i++));
            }
        }
        finally {
            Closeables.close((Closeable)writer, false);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeLabelIndex(Configuration conf, Path indexPath, Iterable<Pair<Text, IntWritable>> labels) throws IOException {
        FileSystem fs = FileSystem.get((URI)indexPath.toUri(), (Configuration)conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, indexPath, Text.class, IntWritable.class);
        HashSet<String> seen = Sets.newHashSet();
        int i = 0;
        try {
            for (Pair<Text, IntWritable> label : labels) {
                String theLabel = SLASH.split(label.getFirst().toString())[1];
                if (seen.contains(theLabel)) continue;
                writer.append((Writable)new Text(theLabel), (Writable)new IntWritable(i++));
                seen.add(theLabel);
            }
        }
        finally {
            Closeables.close((Closeable)writer, false);
        }
        return i;
    }

    public static Map<Integer, String> readLabelIndex(Configuration conf, Path indexPath) {
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        for (Pair pair : new SequenceFileIterable(indexPath, true, conf)) {
            labelMap.put(((IntWritable)pair.getSecond()).get(), ((Text)pair.getFirst()).toString());
        }
        return labelMap;
    }

    public static OpenObjectIntHashMap<String> readIndexFromCache(Configuration conf) throws IOException {
        OpenObjectIntHashMap<String> index = new OpenObjectIntHashMap<String>();
        for (Pair entry : new SequenceFileIterable(HadoopUtil.getSingleCachedFile(conf), conf)) {
            index.put(((Writable)entry.getFirst()).toString(), ((IntWritable)entry.getSecond()).get());
        }
        return index;
    }

    public static Map<String, Vector> readScoresFromCache(Configuration conf) throws IOException {
        HashMap<String, Vector> sumVectors = Maps.newHashMap();
        for (Pair entry : new SequenceFileDirIterable(HadoopUtil.getSingleCachedFile(conf), PathType.LIST, PathFilters.partFilter(), conf)) {
            sumVectors.put(((Text)entry.getFirst()).toString(), ((VectorWritable)((Object)entry.getSecond())).get());
        }
        return sumVectors;
    }
}

