/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.recommender.AbstractRecommender;
import org.apache.mahout.cf.taste.impl.recommender.EstimatedPreferenceCapper;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.cf.taste.recommender.UserBasedRecommender;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;
import org.apache.mahout.common.LongPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericUserBasedRecommender
extends AbstractRecommender
implements UserBasedRecommender {
    private static final Logger log = LoggerFactory.getLogger(GenericUserBasedRecommender.class);
    private final UserNeighborhood neighborhood;
    private final UserSimilarity similarity;
    private final RefreshHelper refreshHelper;
    private EstimatedPreferenceCapper capper;

    public GenericUserBasedRecommender(DataModel dataModel, UserNeighborhood neighborhood, UserSimilarity similarity) {
        super(dataModel);
        Preconditions.checkArgument(neighborhood != null, "neighborhood is null");
        this.neighborhood = neighborhood;
        this.similarity = similarity;
        this.refreshHelper = new RefreshHelper(new Callable<Void>(){

            @Override
            public Void call() {
                GenericUserBasedRecommender.this.capper = GenericUserBasedRecommender.this.buildCapper();
                return null;
            }
        });
        this.refreshHelper.addDependency(dataModel);
        this.refreshHelper.addDependency(similarity);
        this.refreshHelper.addDependency(neighborhood);
        this.capper = this.buildCapper();
    }

    public UserSimilarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        Preconditions.checkArgument(howMany >= 1, "howMany must be at least 1");
        log.debug("Recommending items for user ID '{}'", (Object)userID);
        long[] theNeighborhood = this.neighborhood.getUserNeighborhood(userID);
        if (theNeighborhood.length == 0) {
            return Collections.emptyList();
        }
        FastIDSet allItemIDs = this.getAllOtherItems(theNeighborhood, userID);
        Estimator estimator = new Estimator(userID, theNeighborhood);
        List<RecommendedItem> topItems = TopItems.getTopItems(howMany, allItemIDs.iterator(), rescorer, estimator);
        log.debug("Recommendations are: {}", topItems);
        return topItems;
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        DataModel model = this.getDataModel();
        Float actualPref = model.getPreferenceValue(userID, itemID);
        if (actualPref != null) {
            return actualPref.floatValue();
        }
        long[] theNeighborhood = this.neighborhood.getUserNeighborhood(userID);
        return this.doEstimatePreference(userID, theNeighborhood, itemID);
    }

    @Override
    public long[] mostSimilarUserIDs(long userID, int howMany) throws TasteException {
        return this.mostSimilarUserIDs(userID, howMany, null);
    }

    @Override
    public long[] mostSimilarUserIDs(long userID, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        MostSimilarEstimator estimator = new MostSimilarEstimator(userID, this.similarity, rescorer);
        return this.doMostSimilarUsers(howMany, estimator);
    }

    private long[] doMostSimilarUsers(int howMany, TopItems.Estimator<Long> estimator) throws TasteException {
        DataModel model = this.getDataModel();
        return TopItems.getTopUsers(howMany, model.getUserIDs(), null, estimator);
    }

    protected float doEstimatePreference(long theUserID, long[] theNeighborhood, long itemID) throws TasteException {
        if (theNeighborhood.length == 0) {
            return Float.NaN;
        }
        DataModel dataModel = this.getDataModel();
        double preference = 0.0;
        double totalSimilarity = 0.0;
        int count = 0;
        for (long userID : theNeighborhood) {
            double theSimilarity;
            Float pref;
            if (userID == theUserID || (pref = dataModel.getPreferenceValue(userID, itemID)) == null || Double.isNaN(theSimilarity = this.similarity.userSimilarity(theUserID, userID))) continue;
            preference += theSimilarity * (double)pref.floatValue();
            totalSimilarity += theSimilarity;
            ++count;
        }
        if (count <= 1) {
            return Float.NaN;
        }
        float estimate = (float)(preference / totalSimilarity);
        if (this.capper != null) {
            estimate = this.capper.capEstimate(estimate);
        }
        return estimate;
    }

    protected FastIDSet getAllOtherItems(long[] theNeighborhood, long theUserID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        FastIDSet possibleItemIDs = new FastIDSet();
        for (long userID : theNeighborhood) {
            possibleItemIDs.addAll(dataModel.getItemIDsFromUser(userID));
        }
        possibleItemIDs.removeAll(dataModel.getItemIDsFromUser(theUserID));
        return possibleItemIDs;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "GenericUserBasedRecommender[neighborhood:" + this.neighborhood + ']';
    }

    private EstimatedPreferenceCapper buildCapper() {
        DataModel dataModel = this.getDataModel();
        if (Float.isNaN(dataModel.getMinPreference()) && Float.isNaN(dataModel.getMaxPreference())) {
            return null;
        }
        return new EstimatedPreferenceCapper(dataModel);
    }

    private final class Estimator
    implements TopItems.Estimator<Long> {
        private final long theUserID;
        private final long[] theNeighborhood;

        Estimator(long theUserID, long[] theNeighborhood) {
            this.theUserID = theUserID;
            this.theNeighborhood = theNeighborhood;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            return GenericUserBasedRecommender.this.doEstimatePreference(this.theUserID, this.theNeighborhood, itemID);
        }
    }

    private static final class MostSimilarEstimator
    implements TopItems.Estimator<Long> {
        private final long toUserID;
        private final UserSimilarity similarity;
        private final Rescorer<LongPair> rescorer;

        private MostSimilarEstimator(long toUserID, UserSimilarity similarity, Rescorer<LongPair> rescorer) {
            this.toUserID = toUserID;
            this.similarity = similarity;
            this.rescorer = rescorer;
        }

        @Override
        public double estimate(Long userID) throws TasteException {
            if (userID == this.toUserID) {
                return Double.NaN;
            }
            if (this.rescorer == null) {
                return this.similarity.userSimilarity(this.toUserID, userID);
            }
            LongPair pair = new LongPair(this.toUserID, userID);
            if (this.rescorer.isFiltered(pair)) {
                return Double.NaN;
            }
            double originalEstimate = this.similarity.userSimilarity(this.toUserID, userID);
            return this.rescorer.rescore(pair, originalEstimate);
        }
    }
}

