/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.neighborhood;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;

public final class CachingUserNeighborhood
implements UserNeighborhood {
    private final UserNeighborhood neighborhood;
    private final Cache<Long, long[]> neighborhoodCache;

    public CachingUserNeighborhood(UserNeighborhood neighborhood, DataModel dataModel) throws TasteException {
        Preconditions.checkArgument(neighborhood != null, "neighborhood is null");
        this.neighborhood = neighborhood;
        int maxCacheSize = dataModel.getNumUsers();
        this.neighborhoodCache = new Cache<Long, long[]>(new NeighborhoodRetriever(neighborhood), maxCacheSize);
    }

    @Override
    public long[] getUserNeighborhood(long userID) throws TasteException {
        return this.neighborhoodCache.get(userID);
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.neighborhoodCache.clear();
        Collection<Refreshable> refreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(refreshed, this.neighborhood);
    }

    private static final class NeighborhoodRetriever
    implements Retriever<Long, long[]> {
        private final UserNeighborhood neighborhood;

        private NeighborhoodRetriever(UserNeighborhood neighborhood) {
            this.neighborhood = neighborhood;
        }

        @Override
        public long[] get(Long key) throws TasteException {
            return this.neighborhood.getUserNeighborhood(key);
        }
    }
}

