/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.model.BooleanPreference;
import org.apache.mahout.cf.taste.impl.model.jdbc.AbstractJDBCDataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.common.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBooleanPrefJDBCDataModel
extends AbstractJDBCDataModel {
    private static final Logger log = LoggerFactory.getLogger(AbstractBooleanPrefJDBCDataModel.class);
    static final String NO_SUCH_COLUMN = "NO_SUCH_COLUMN";
    private final String setPreferenceSQL;

    protected AbstractBooleanPrefJDBCDataModel(DataSource dataSource, String preferenceTable, String userIDColumn, String itemIDColumn, String preferenceColumn, String getPreferenceSQL, String getPreferenceTimeSQL, String getUserSQL, String getAllUsersSQL, String getNumItemsSQL, String getNumUsersSQL, String setPreferenceSQL, String removePreferenceSQL, String getUsersSQL, String getItemsSQL, String getPrefsForItemSQL, String getNumPreferenceForItemSQL, String getNumPreferenceForItemsSQL, String getMaxPreferenceSQL, String getMinPreferenceSQL) {
        super(dataSource, preferenceTable, userIDColumn, itemIDColumn, preferenceColumn, getPreferenceSQL, getPreferenceTimeSQL, getUserSQL, getAllUsersSQL, getNumItemsSQL, getNumUsersSQL, setPreferenceSQL, removePreferenceSQL, getUsersSQL, getItemsSQL, getPrefsForItemSQL, getNumPreferenceForItemSQL, getNumPreferenceForItemsSQL, getMaxPreferenceSQL, getMinPreferenceSQL);
        this.setPreferenceSQL = setPreferenceSQL;
    }

    @Override
    protected Preference buildPreference(ResultSet rs) throws SQLException {
        return new BooleanPreference(this.getLongColumn(rs, 1), this.getLongColumn(rs, 2));
    }

    @Override
    String getSetPreferenceSQL() {
        return this.setPreferenceSQL;
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        Preconditions.checkArgument(!Float.isNaN(value), "NaN value");
        log.debug("Setting preference for user {}, item {}", (Object)userID, (Object)itemID);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getDataSource().getConnection();
            stmt = conn.prepareStatement(this.setPreferenceSQL);
            this.setLongParameter(stmt, 1, userID);
            this.setLongParameter(stmt, 2, itemID);
            log.debug("Executing SQL update: {}", (Object)this.setPreferenceSQL);
            stmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                log.warn("Exception while setting preference", (Throwable)sqle);
                throw new TasteException(sqle);
            }
            catch (Throwable throwable) {
                IOUtils.quietClose(null, stmt, conn);
                throw throwable;
            }
        }
        IOUtils.quietClose(null, stmt, conn);
    }

    @Override
    public boolean hasPreferenceValues() {
        return false;
    }

    @Override
    public float getMaxPreference() {
        return 1.0f;
    }

    @Override
    public float getMinPreference() {
        return 1.0f;
    }
}

