/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.encoding.IntDecoder;
import org.apache.lucene.facet.encoding.IntEncoder;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public class OrdinalMappingAtomicReader
extends FilterAtomicReader {
    private final int[] ordinalMap;
    private final Map<String, CategoryListParams> dvFieldMap = new HashMap<String, CategoryListParams>();

    public OrdinalMappingAtomicReader(AtomicReader in, int[] ordinalMap) {
        this(in, ordinalMap, FacetIndexingParams.DEFAULT);
    }

    public OrdinalMappingAtomicReader(AtomicReader in, int[] ordinalMap, FacetIndexingParams indexingParams) {
        super(in);
        this.ordinalMap = ordinalMap;
        for (CategoryListParams params : indexingParams.getAllCategoryListParams()) {
            this.dvFieldMap.put(params.field, params);
        }
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        BinaryDocValues inner = super.getBinaryDocValues(field);
        if (inner == null) {
            return inner;
        }
        CategoryListParams clp = this.dvFieldMap.get(field);
        if (clp == null) {
            return inner;
        }
        return new OrdinalMappingBinaryDocValues(clp, inner);
    }

    private class OrdinalMappingBinaryDocValues
    extends BinaryDocValues {
        private final IntEncoder encoder;
        private final IntDecoder decoder;
        private final IntsRef ordinals = new IntsRef(32);
        private final BinaryDocValues delegate;
        private final BytesRef scratch = new BytesRef();

        protected OrdinalMappingBinaryDocValues(CategoryListParams clp, BinaryDocValues delegate) {
            this.delegate = delegate;
            this.encoder = clp.createEncoder();
            this.decoder = this.encoder.createMatchingDecoder();
        }

        @Override
        public void get(int docID, BytesRef result) {
            this.delegate.get(docID, this.scratch);
            if (this.scratch.length > 0) {
                this.decoder.decode(this.scratch, this.ordinals);
                for (int i = 0; i < this.ordinals.length; ++i) {
                    this.ordinals.ints[i] = OrdinalMappingAtomicReader.this.ordinalMap[this.ordinals.ints[i]];
                }
                this.encoder.encode(this.ordinals, result);
            }
        }
    }
}

