/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.OrdinalValueResolver;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.IntsRef;

public class SumValueSourceFacetRequest
extends FacetRequest {
    private final ValueSource valueSource;
    private final boolean requiresDocScores;

    public SumValueSourceFacetRequest(CategoryPath path, int num, ValueSource valueSource, boolean requiresDocScores) {
        super(path, num);
        this.valueSource = valueSource;
        this.requiresDocScores = requiresDocScores;
    }

    @Override
    public FacetsAggregator createFacetsAggregator(FacetIndexingParams fip) {
        if (this.requiresDocScores) {
            return new ScoreValueSourceFacetsAggregator(this.valueSource);
        }
        return new NoScoreValueSourceFacetsAggregator(this.valueSource);
    }

    private static class NoScoreValueSourceFacetsAggregator
    extends SumValueSourceFacetsAggregator {
        NoScoreValueSourceFacetsAggregator(ValueSource valueSource) {
            super(valueSource);
        }

        @Override
        public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
            CategoryListIterator cli = clp.createCategoryListIterator(0);
            if (!cli.setNextReader(matchingDocs.context)) {
                return;
            }
            FunctionValues fvalues = this.valueSource.getValues(Collections.emptyMap(), matchingDocs.context);
            int length = matchingDocs.bits.length();
            float[] aggValues = facetArrays.getFloatArray();
            for (int doc = 0; doc < length && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
                cli.getOrdinals(doc, this.ordinals);
                int upto = this.ordinals.offset + this.ordinals.length;
                float val = (float)fvalues.doubleVal(doc);
                for (int i = this.ordinals.offset; i < upto; ++i) {
                    int n = this.ordinals.ints[i];
                    aggValues[n] = aggValues[n] + val;
                }
            }
        }

        @Override
        public boolean requiresDocScores() {
            return false;
        }
    }

    private static class ScoreValueSourceFacetsAggregator
    extends SumValueSourceFacetsAggregator {
        ScoreValueSourceFacetsAggregator(ValueSource valueSource) {
            super(valueSource);
        }

        @Override
        public void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
            CategoryListIterator cli = clp.createCategoryListIterator(0);
            if (!cli.setNextReader(matchingDocs.context)) {
                return;
            }
            assert (matchingDocs.scores != null);
            FakeScorer scorer = new FakeScorer();
            HashMap<String, FakeScorer> context = new HashMap<String, FakeScorer>();
            context.put("scorer", scorer);
            FunctionValues fvalues = this.valueSource.getValues(context, matchingDocs.context);
            int length = matchingDocs.bits.length();
            float[] aggValues = facetArrays.getFloatArray();
            int scoresIdx = 0;
            for (int doc = 0; doc < length && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
                scorer.docID = doc;
                scorer.score = matchingDocs.scores[scoresIdx++];
                cli.getOrdinals(doc, this.ordinals);
                int upto = this.ordinals.offset + this.ordinals.length;
                float val = (float)fvalues.doubleVal(doc);
                for (int i = this.ordinals.offset; i < upto; ++i) {
                    int n = this.ordinals.ints[i];
                    aggValues[n] = aggValues[n] + val;
                }
            }
        }

        @Override
        public boolean requiresDocScores() {
            return true;
        }

        private static final class FakeScorer
        extends Scorer {
            float score;
            int docID;

            FakeScorer() {
                super(null);
            }

            @Override
            public float score() throws IOException {
                return this.score;
            }

            @Override
            public int freq() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int nextDoc() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int advance(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long cost() {
                return 0L;
            }
        }
    }

    private static abstract class SumValueSourceFacetsAggregator
    implements FacetsAggregator {
        protected final ValueSource valueSource;
        protected final IntsRef ordinals = new IntsRef(32);

        protected SumValueSourceFacetsAggregator(ValueSource valueSource) {
            this.valueSource = valueSource;
        }

        private float doRollup(int ordinal, int[] children, int[] siblings, float[] values) {
            float value = 0.0f;
            while (ordinal != -1) {
                float childValue = values[ordinal];
                values[ordinal] = childValue += this.doRollup(children[ordinal], children, siblings, values);
                value += childValue;
                ordinal = siblings[ordinal];
            }
            return value;
        }

        @Override
        public void rollupValues(FacetRequest fr, int ordinal, int[] children, int[] siblings, FacetArrays facetArrays) {
            float[] values = facetArrays.getFloatArray();
            int n = ordinal;
            values[n] = values[n] + this.doRollup(children[ordinal], children, siblings, values);
        }

        @Override
        public OrdinalValueResolver createOrdinalValueResolver(FacetRequest facetRequest, FacetArrays arrays) {
            return new OrdinalValueResolver.FloatValueResolver(arrays);
        }
    }
}

