/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.encoding.DGapVInt8IntDecoder;
import org.apache.lucene.facet.params.CategoryListParams;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.IntRollupFacetsAggregator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;

public final class FastCountingFacetsAggregator
extends IntRollupFacetsAggregator {
    private final BytesRef buf = new BytesRef(32);

    @Override
    public final void aggregate(FacetsCollector.MatchingDocs matchingDocs, CategoryListParams clp, FacetArrays facetArrays) throws IOException {
        assert (clp.createEncoder().createMatchingDecoder().getClass() == DGapVInt8IntDecoder.class) : "this aggregator assumes ordinals were encoded as dgap+vint";
        BinaryDocValues dv = matchingDocs.context.reader().getBinaryDocValues(clp.field);
        if (dv == null) {
            return;
        }
        int length = matchingDocs.bits.length();
        int[] counts = facetArrays.getIntArray();
        for (int doc = 0; doc < length && (doc = matchingDocs.bits.nextSetBit(doc)) != -1; ++doc) {
            dv.get(doc, this.buf);
            if (this.buf.length <= 0) continue;
            int upto = this.buf.offset + this.buf.length;
            int ord = 0;
            int offset = this.buf.offset;
            int prev = 0;
            while (offset < upto) {
                byte b;
                if ((b = this.buf.bytes[offset++]) >= 0) {
                    prev = ord = (ord << 7 | b) + prev;
                    assert (ord < counts.length) : "ord=" + ord + " vs maxOrd=" + counts.length;
                    int n = ord;
                    counts[n] = counts[n] + 1;
                    ord = 0;
                    continue;
                }
                ord = ord << 7 | b & 0x7F;
            }
        }
    }
}

