/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;

class DrillSidewaysScorer
extends Scorer {
    private final Collector drillDownCollector;
    private final DocsEnumsAndFreq[] dims;
    private final Scorer baseScorer;
    private final AtomicReaderContext context;
    private static final int CHUNK = 2048;
    private static final int MASK = 2047;
    private int collectDocID = -1;
    private float collectScore;

    DrillSidewaysScorer(Weight w, AtomicReaderContext context, Scorer baseScorer, Collector drillDownCollector, DocsEnumsAndFreq[] dims) {
        super(w);
        this.dims = dims;
        this.context = context;
        this.baseScorer = baseScorer;
        this.drillDownCollector = drillDownCollector;
    }

    @Override
    public void score(Collector collector) throws IOException {
        collector.setScorer(this);
        if (this.drillDownCollector != null) {
            this.drillDownCollector.setScorer(this);
            this.drillDownCollector.setNextReader(this.context);
        }
        for (DocsEnumsAndFreq dim : this.dims) {
            dim.sidewaysCollector.setScorer(this);
            dim.sidewaysCollector.setNextReader(this.context);
        }
        assert (this.baseScorer != null);
        this.baseScorer.nextDoc();
        for (DocsEnumsAndFreq dim : this.dims) {
            for (DocsEnum docsEnum : dim.docsEnums) {
                if (docsEnum == null) continue;
                docsEnum.nextDoc();
            }
        }
        int numDims = this.dims.length;
        DocsEnum[][] docsEnums = new DocsEnum[numDims][];
        Collector[] sidewaysCollectors = new Collector[numDims];
        long drillDownCost = 0L;
        for (int dim = 0; dim < numDims; ++dim) {
            docsEnums[dim] = this.dims[dim].docsEnums;
            sidewaysCollectors[dim] = this.dims[dim].sidewaysCollector;
            for (DocsEnum de : this.dims[dim].docsEnums) {
                if (de == null) continue;
                drillDownCost += de.cost();
            }
        }
        long baseQueryCost = this.baseScorer.cost();
        if (baseQueryCost < drillDownCost / 10L) {
            this.doBaseAdvanceScoring(collector, docsEnums, sidewaysCollectors);
        } else if (numDims > 1 && this.dims[1].maxCost < baseQueryCost / 10L) {
            this.doDrillDownAdvanceScoring(collector, docsEnums, sidewaysCollectors);
        } else {
            this.doUnionScoring(collector, docsEnums, sidewaysCollectors);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doDrillDownAdvanceScoring(Collector collector, DocsEnum[][] docsEnums, Collector[] sidewaysCollectors) throws IOException {
        maxDoc = this.context.reader().maxDoc();
        numDims = this.dims.length;
        filledSlots = new int[2048];
        docIDs = new int[2048];
        scores = new float[2048];
        missingDims = new int[2048];
        counts = new int[2048];
        docIDs[0] = -1;
        nextChunkStart = 2048;
        seen = new FixedBitSet(2048);
        while (true) lbl-1000:
        // 5 sources

        {
            for (DocsEnum docsEnum : docsEnums[0]) {
                if (docsEnum == null) continue;
                docID = docsEnum.docID();
                while (docID < nextChunkStart) {
                    slot = docID & 2047;
                    if (docIDs[slot] != docID) {
                        seen.set(slot);
                        docIDs[slot] = docID;
                        missingDims[slot] = 1;
                        counts[slot] = 1;
                    }
                    docID = docsEnum.nextDoc();
                }
            }
            for (DocsEnum docsEnum : docsEnums[1]) {
                if (docsEnum == null) continue;
                docID = docsEnum.docID();
                while (docID < nextChunkStart) {
                    slot = docID & 2047;
                    if (docIDs[slot] != docID) {
                        seen.set(slot);
                        docIDs[slot] = docID;
                        missingDims[slot] = 0;
                        counts[slot] = 1;
                    } else if (missingDims[slot] >= 1) {
                        missingDims[slot] = 2;
                        counts[slot] = 2;
                    } else {
                        counts[slot] = 1;
                    }
                    docID = docsEnum.nextDoc();
                }
            }
            filledCount = 0;
            for (slot0 = 0; slot0 < 2048 && (slot0 = seen.nextSetBit(slot0)) != -1; ++slot0) {
                ddDocID = docIDs[slot0];
                if (!DrillSidewaysScorer.$assertionsDisabled && ddDocID == -1) {
                    throw new AssertionError();
                }
                baseDocID = this.baseScorer.docID();
                if (baseDocID < ddDocID) {
                    baseDocID = this.baseScorer.advance(ddDocID);
                }
                if (baseDocID == ddDocID) {
                    scores[slot0] = this.baseScorer.score();
                    filledSlots[filledCount++] = slot0;
                    v0 = slot0;
                    counts[v0] = counts[v0] + 1;
                    continue;
                }
                docIDs[slot0] = -1;
            }
            seen.clear(0, 2048);
            if (filledCount == 0) {
                if (nextChunkStart >= maxDoc) break;
                nextChunkStart += 2048;
                ** continue;
            }
            for (dim = 2; dim < numDims; ++dim) {
                for (DocsEnum docsEnum : docsEnums[dim]) {
                    if (docsEnum == null) continue;
                    docID = docsEnum.docID();
                    while (docID < nextChunkStart) {
                        slot = docID & 2047;
                        if (docIDs[slot] == docID && counts[slot] >= dim) {
                            if (missingDims[slot] >= dim) {
                                missingDims[slot] = dim + 1;
                                counts[slot] = dim + 2;
                            } else {
                                counts[slot] = dim + 1;
                            }
                        }
                        docID = docsEnum.nextDoc();
                    }
                }
            }
            for (i = 0; i < filledCount; ++i) {
                slot = filledSlots[i];
                this.collectDocID = docIDs[slot];
                this.collectScore = scores[slot];
                if (counts[slot] == 1 + numDims) {
                    this.collectHit(collector, sidewaysCollectors);
                    continue;
                }
                if (counts[slot] != numDims) continue;
                this.collectNearMiss(sidewaysCollectors, missingDims[slot]);
            }
            if (nextChunkStart >= maxDoc) break;
            nextChunkStart += 2048;
        }
    }

    private void doBaseAdvanceScoring(Collector collector, DocsEnum[][] docsEnums, Collector[] sidewaysCollectors) throws IOException {
        int docID = this.baseScorer.docID();
        int numDims = this.dims.length;
        block0: while (docID != Integer.MAX_VALUE) {
            int failedDim = -1;
            for (int dim = 0; dim < numDims; ++dim) {
                boolean found = false;
                for (DocsEnum docsEnum : docsEnums[dim]) {
                    if (docsEnum == null) continue;
                    if (docsEnum.docID() < docID) {
                        docsEnum.advance(docID);
                    }
                    if (docsEnum.docID() != docID) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (failedDim != -1) {
                    docID = this.baseScorer.nextDoc();
                    continue block0;
                }
                failedDim = dim;
            }
            this.collectDocID = docID;
            this.collectScore = this.baseScorer.score();
            if (failedDim == -1) {
                this.collectHit(collector, sidewaysCollectors);
            } else {
                this.collectNearMiss(sidewaysCollectors, failedDim);
            }
            docID = this.baseScorer.nextDoc();
        }
    }

    private void collectHit(Collector collector, Collector[] sidewaysCollectors) throws IOException {
        collector.collect(this.collectDocID);
        if (this.drillDownCollector != null) {
            this.drillDownCollector.collect(this.collectDocID);
        }
        for (int dim = 0; dim < sidewaysCollectors.length; ++dim) {
            sidewaysCollectors[dim].collect(this.collectDocID);
        }
    }

    private void collectNearMiss(Collector[] sidewaysCollectors, int dim) throws IOException {
        sidewaysCollectors[dim].collect(this.collectDocID);
    }

    private void doUnionScoring(Collector collector, DocsEnum[][] docsEnums, Collector[] sidewaysCollectors) throws IOException {
        int maxDoc = this.context.reader().maxDoc();
        int numDims = this.dims.length;
        int[] filledSlots = new int[2048];
        int[] docIDs = new int[2048];
        float[] scores = new float[2048];
        int[] missingDims = new int[2048];
        int[] counts = new int[2048];
        docIDs[0] = -1;
        int nextChunkStart = 2048;
        while (true) {
            int filledCount = 0;
            int docID = this.baseScorer.docID();
            while (docID < nextChunkStart) {
                int slot = docID & 0x7FF;
                assert (docIDs[slot] != docID) : "slot=" + slot + " docID=" + docID;
                docIDs[slot] = docID;
                scores[slot] = this.baseScorer.score();
                filledSlots[filledCount++] = slot;
                missingDims[slot] = 0;
                counts[slot] = 1;
                docID = this.baseScorer.nextDoc();
            }
            if (filledCount == 0) {
                if (nextChunkStart >= maxDoc) break;
                nextChunkStart += 2048;
                continue;
            }
            for (DocsEnum docsEnum : docsEnums[0]) {
                if (docsEnum == null) continue;
                docID = docsEnum.docID();
                while (docID < nextChunkStart) {
                    int slot = docID & 0x7FF;
                    if (docIDs[slot] == docID) {
                        missingDims[slot] = 1;
                        counts[slot] = 2;
                    }
                    docID = docsEnum.nextDoc();
                }
            }
            for (int dim = 1; dim < numDims; ++dim) {
                for (DocsEnum docsEnum : docsEnums[dim]) {
                    if (docsEnum == null) continue;
                    docID = docsEnum.docID();
                    while (docID < nextChunkStart) {
                        int slot = docID & 0x7FF;
                        if (docIDs[slot] == docID && counts[slot] >= dim) {
                            if (missingDims[slot] >= dim) {
                                missingDims[slot] = dim + 1;
                                counts[slot] = dim + 2;
                            } else {
                                counts[slot] = dim + 1;
                            }
                        }
                        docID = docsEnum.nextDoc();
                    }
                }
            }
            for (int i = 0; i < filledCount; ++i) {
                int slot = filledSlots[i];
                this.collectDocID = docIDs[slot];
                this.collectScore = scores[slot];
                if (counts[slot] == 1 + numDims) {
                    this.collectHit(collector, sidewaysCollectors);
                    continue;
                }
                if (counts[slot] != numDims) continue;
                this.collectNearMiss(sidewaysCollectors, missingDims[slot]);
            }
            if (nextChunkStart >= maxDoc) break;
            nextChunkStart += 2048;
        }
    }

    @Override
    public int docID() {
        return this.collectDocID;
    }

    @Override
    public float score() {
        return this.collectScore;
    }

    @Override
    public int freq() {
        return 1 + this.dims.length;
    }

    @Override
    public int nextDoc() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int advance(int target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long cost() {
        return this.baseScorer.cost();
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        return Collections.singletonList(new Scorer.ChildScorer(this.baseScorer, "MUST"));
    }

    static class DocsEnumsAndFreq
    implements Comparable<DocsEnumsAndFreq> {
        DocsEnum[] docsEnums;
        long maxCost;
        Collector sidewaysCollector;
        String dim;

        DocsEnumsAndFreq() {
        }

        @Override
        public int compareTo(DocsEnumsAndFreq other) {
            if (this.maxCost < other.maxCost) {
                return -1;
            }
            if (this.maxCost > other.maxCost) {
                return 1;
            }
            return 0;
        }
    }
}

