/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;

public class RangeFacetRequest<T extends Range>
extends FacetRequest {
    public final Range[] ranges;
    public final String label;
    private final ValueSource valueSource;

    public RangeFacetRequest(String field, T ... ranges) {
        this(field, new LongFieldSource(field), (Range[])ranges);
    }

    public RangeFacetRequest(String field, List<T> ranges) {
        this(field, ranges.toArray(new Range[ranges.size()]));
    }

    public RangeFacetRequest(String label, ValueSource valueSource, T ... ranges) {
        super(new CategoryPath(label), 1);
        this.ranges = ranges;
        this.valueSource = valueSource;
        this.label = label;
    }

    public RangeFacetRequest(String label, ValueSource valueSource, List<T> ranges) {
        this(label, valueSource, ranges.toArray(new Range[ranges.size()]));
    }

    public FunctionValues getValues(AtomicReaderContext context) throws IOException {
        return this.valueSource.getValues(Collections.emptyMap(), context);
    }

    @Override
    public FacetsAggregator createFacetsAggregator(FacetIndexingParams fip) {
        throw new UnsupportedOperationException("this FacetRequest does not support categories aggregation and only works with RangeAccumulator");
    }
}

