/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;

public final class FileBasedSparseBinaryMatrix
extends AbstractMatrix {
    private static final int MAGIC_NUMBER_V0 = 316081789;
    private final List<IntBuffer> data = Lists.newArrayList();
    private int[] bufferIndex;
    private int[] rowOffset;
    private int[] rowSize;

    public FileBasedSparseBinaryMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public void setData(File f) throws IOException {
        ArrayList buffers = Lists.newArrayList();
        FileChannel input = new FileInputStream(f).getChannel();
        buffers.add(input.map(FileChannel.MapMode.READ_ONLY, 0L, Math.min(Integer.MAX_VALUE, f.length())));
        this.data.add(((ByteBuffer)buffers.get(0)).asIntBuffer());
        Preconditions.checkArgument((((ByteBuffer)buffers.get(0)).getInt() == 316081789 ? 1 : 0) != 0, (Object)"Wrong type of file");
        int rows = ((ByteBuffer)buffers.get(0)).getInt();
        int cols = ((ByteBuffer)buffers.get(0)).getInt();
        Preconditions.checkArgument((rows == this.rowSize() ? 1 : 0) != 0);
        Preconditions.checkArgument((cols == this.columnSize() ? 1 : 0) != 0);
        this.rowOffset = new int[rows];
        this.rowSize = new int[rows];
        this.bufferIndex = new int[rows];
        int offset = 12 + 4 * rows;
        for (int i = 0; i < rows; ++i) {
            int size = ((ByteBuffer)buffers.get(0)).getInt();
            int buffer = 0;
            while (buffer < buffers.size() && offset + size * 4 > ((ByteBuffer)buffers.get(buffer)).limit()) {
                offset -= ((ByteBuffer)buffers.get(buffer)).capacity();
            }
            if (buffer == buffers.size()) {
                buffers.add(input.map(FileChannel.MapMode.READ_ONLY, 0L, Math.min(Integer.MAX_VALUE, f.length() - (long)offset)));
                this.data.add(((ByteBuffer)buffers.get(buffer)).asIntBuffer());
            }
            this.rowOffset[i] = offset / 4;
            this.rowSize[i] = size;
            this.bufferIndex[i] = buffer;
            offset += size * 4;
        }
    }

    public static void writeMatrix(File f, Matrix m) throws IOException {
        Preconditions.checkArgument((boolean)f.canWrite(), (Object)"Can't write to output file");
        FileOutputStream fos = new FileOutputStream(f);
        DataOutputStream out = new DataOutputStream(fos);
        out.writeInt(316081789);
        out.writeInt(m.rowSize());
        out.writeInt(m.columnSize());
        for (MatrixSlice row : m) {
            int nondefaultElements = row.vector().getNumNondefaultElements();
            out.writeInt(nondefaultElements);
        }
        for (MatrixSlice row : m) {
            ArrayList columns = Lists.newArrayList((Iterable)Iterables.transform(row.vector().nonZeroes(), (Function)new Function<Vector.Element, Integer>(){

                public Integer apply(Vector.Element element) {
                    return element.index();
                }
            }));
            Collections.sort(columns);
            for (Integer column : columns) {
                out.writeInt(column);
            }
        }
        out.close();
        fos.close();
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public double getQuick(int rowIndex, int columnIndex) {
        IntBuffer tmp = this.data.get(this.bufferIndex[rowIndex]).asReadOnlyBuffer();
        tmp.position(this.rowOffset[rowIndex]);
        tmp.limit(this.rowSize[rowIndex]);
        tmp = tmp.slice();
        return FileBasedSparseBinaryMatrix.searchForIndex(tmp, columnIndex);
    }

    private static double searchForIndex(IntBuffer row, int columnIndex) {
        int high = row.limit();
        if (high == 0) {
            return 0.0;
        }
        int low = 0;
        while (high > low) {
            int mid = (low + high) / 2;
            if (row.get(mid) < columnIndex) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        if (low >= row.limit()) {
            return 0.0;
        }
        if (high == low && row.get(low) == columnIndex) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Matrix like() {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public Vector viewRow(int rowIndex) {
        IntBuffer tmp = this.data.get(this.bufferIndex[rowIndex]).asReadOnlyBuffer();
        tmp.position(this.rowOffset[rowIndex]);
        tmp.limit(this.rowOffset[rowIndex] + this.rowSize[rowIndex]);
        tmp = tmp.slice();
        return new SparseBinaryVector(tmp, this.columnSize());
    }

    public static class BinaryReadOnlyElement
    implements Vector.Element {
        private final int index;

        public BinaryReadOnlyElement(int index) {
            this.index = index;
        }

        @Override
        public double get() {
            return 1.0;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            throw new UnsupportedOperationException("Can't set binary value");
        }
    }

    private static class SparseBinaryVector
    extends AbstractVector {
        private final IntBuffer buffer;
        private final int maxIndex;

        private SparseBinaryVector(IntBuffer buffer, int maxIndex) {
            super(maxIndex);
            this.buffer = buffer;
            this.maxIndex = maxIndex;
        }

        SparseBinaryVector(ByteBuffer row, int maxIndex, int offset, int size) {
            super(maxIndex);
            row = row.asReadOnlyBuffer();
            row.position(offset);
            row.limit(offset + size * 4);
            row = row.slice();
            this.buffer = row.slice().asIntBuffer();
            this.maxIndex = maxIndex;
        }

        @Override
        protected Matrix matrixLike(int rows, int columns) {
            throw new UnsupportedOperationException("Default operation");
        }

        @Override
        public void mergeUpdates(OrderedIntDoubleMapping updates) {
            throw new UnsupportedOperationException("Cannot mutate SparseBinaryVector");
        }

        @Override
        public boolean isDense() {
            return false;
        }

        @Override
        public boolean isSequentialAccess() {
            return true;
        }

        @Override
        public Iterator<Vector.Element> iterator() {
            return new AbstractIterator<Vector.Element>(){
                int i = 0;

                protected Vector.Element computeNext() {
                    if (this.i < SparseBinaryVector.this.maxIndex) {
                        return new Vector.Element(){
                            int index;
                            {
                                this.index = i++;
                            }

                            @Override
                            public double get() {
                                return SparseBinaryVector.this.getQuick(this.index);
                            }

                            @Override
                            public int index() {
                                return this.index;
                            }

                            @Override
                            public void set(double value) {
                                throw new UnsupportedOperationException("Default operation");
                            }
                        };
                    }
                    return (Vector.Element)this.endOfData();
                }
            };
        }

        @Override
        public Iterator<Vector.Element> iterateNonZero() {
            return new AbstractIterator<Vector.Element>(){
                int i = 0;

                protected Vector.Element computeNext() {
                    if (this.i < SparseBinaryVector.this.buffer.limit()) {
                        return new BinaryReadOnlyElement(SparseBinaryVector.this.buffer.get(this.i++));
                    }
                    return (Vector.Element)this.endOfData();
                }
            };
        }

        @Override
        public double getQuick(int index) {
            return FileBasedSparseBinaryMatrix.searchForIndex(this.buffer, index);
        }

        @Override
        public Vector like() {
            return new RandomAccessSparseVector(this.size());
        }

        @Override
        protected Vector createOptimizedCopy() {
            return new RandomAccessSparseVector(this.size()).assign(this);
        }

        @Override
        public void setQuick(int index, double value) {
            throw new UnsupportedOperationException("Read-only view");
        }

        @Override
        public void incrementQuick(int index, double increment) {
            throw new UnsupportedOperationException("Read-only view");
        }

        @Override
        public int getNumNondefaultElements() {
            return this.buffer.limit();
        }

        @Override
        public double getLookupCost() {
            return 1.0;
        }

        @Override
        public double getIteratorAdvanceCost() {
            return 1.0;
        }

        @Override
        public boolean isAddConstantTime() {
            throw new UnsupportedOperationException("Can't add binary value");
        }
    }
}

