/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.term;

import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.common.StringTuple;
import org.apache.mahout.math.function.ObjectLongProcedure;
import org.apache.mahout.math.map.OpenObjectLongHashMap;

public class TermCountMapper
extends Mapper<Text, StringTuple, Text, LongWritable> {
    protected void map(Text key, StringTuple value, final Mapper.Context context) throws IOException, InterruptedException {
        OpenObjectLongHashMap wordCount = new OpenObjectLongHashMap();
        for (String word : value.getEntries()) {
            if (wordCount.containsKey((Object)word)) {
                wordCount.put((Object)word, wordCount.get((Object)word) + 1L);
                continue;
            }
            wordCount.put((Object)word, 1L);
        }
        wordCount.forEachPair((ObjectLongProcedure)new ObjectLongProcedure<String>(){

            public boolean apply(String first, long second) {
                try {
                    context.write((Object)new Text(first), (Object)new LongWritable(second));
                }
                catch (IOException e) {
                    context.getCounter("Exception", "Output IO Exception").increment(1L);
                }
                catch (InterruptedException e) {
                    context.getCounter("Exception", "Interrupted Exception").increment(1L);
                }
                return true;
            }
        });
    }
}

