/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.fpm.pfpgrowth.convertors;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.mahout.common.Pair;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.FrequentPatternMaxHeap;
import org.apache.mahout.fpm.pfpgrowth.fpgrowth.Pattern;

public final class TopKPatternsOutputConverter<A extends Comparable<? super A>>
implements OutputCollector<Integer, FrequentPatternMaxHeap> {
    private final OutputCollector<A, List<Pair<List<A>, Long>>> collector;
    private final Map<Integer, A> reverseMapping;

    public TopKPatternsOutputConverter(OutputCollector<A, List<Pair<List<A>, Long>>> collector, Map<Integer, A> reverseMapping) {
        this.collector = collector;
        this.reverseMapping = reverseMapping;
    }

    public void collect(Integer key, FrequentPatternMaxHeap value) throws IOException {
        ArrayList perAttributePatterns = Lists.newArrayList();
        PriorityQueue<Pattern> t = value.getHeap();
        while (!t.isEmpty()) {
            Pattern itemSet = t.poll();
            ArrayList frequentPattern = Lists.newArrayList();
            for (int j = 0; j < itemSet.length(); ++j) {
                frequentPattern.add(this.reverseMapping.get(itemSet.getPattern()[j]));
            }
            Collections.sort(frequentPattern);
            Pair<ArrayList, Long> returnItemSet = new Pair<ArrayList, Long>(frequentPattern, itemSet.support());
            perAttributePatterns.add(returnItemSet);
        }
        Collections.reverse(perAttributePatterns);
        this.collector.collect(this.reverseMapping.get(key), (Object)perAttributePatterns);
    }
}

