/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown.postprocessor;

import java.io.IOException;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.clustering.topdown.postprocessor.ClusterCountReader;
import org.apache.mahout.clustering.topdown.postprocessor.ClusterOutputPostProcessor;
import org.apache.mahout.clustering.topdown.postprocessor.ClusterOutputPostProcessorMapper;
import org.apache.mahout.clustering.topdown.postprocessor.ClusterOutputPostProcessorReducer;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterator;
import org.apache.mahout.math.VectorWritable;

public final class ClusterOutputPostProcessorDriver
extends AbstractJob {
    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption((Option)DefaultOptionCreator.methodOption().create());
        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(this.getConf(), output);
        }
        boolean runSequential = this.getOption("method").equalsIgnoreCase("sequential");
        ClusterOutputPostProcessorDriver.run(input, output, runSequential);
        return 0;
    }

    private ClusterOutputPostProcessorDriver() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)new Configuration(), (Tool)new ClusterOutputPostProcessorDriver(), (String[])args);
    }

    public static void run(Path input, Path output, boolean runSequential) throws IOException, InterruptedException, ClassNotFoundException {
        if (runSequential) {
            ClusterOutputPostProcessorDriver.postProcessSeq(input, output);
        } else {
            Configuration conf = new Configuration();
            ClusterOutputPostProcessorDriver.postProcessMR(conf, input, output);
            ClusterOutputPostProcessorDriver.movePartFilesToRespectiveDirectories(conf, output);
        }
    }

    private static void postProcessSeq(Path input, Path output) throws IOException {
        ClusterOutputPostProcessor clusterOutputPostProcessor = new ClusterOutputPostProcessor(input, output, new Configuration());
        clusterOutputPostProcessor.process();
    }

    private static void postProcessMR(Configuration conf, Path input, Path output) throws IOException, InterruptedException, ClassNotFoundException {
        System.out.println("WARNING: If you are running in Hadoop local mode, please use the --sequential option, as the MapReduce option will not work properly");
        int numberOfClusters = ClusterCountReader.getNumberOfClusters(input, conf);
        conf.set("clusterOutputPath", input.toString());
        Job job = new Job(conf, "ClusterOutputPostProcessor Driver running over input: " + input);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(ClusterOutputPostProcessorMapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(VectorWritable.class);
        job.setReducerClass(ClusterOutputPostProcessorReducer.class);
        job.setOutputKeyClass(IntWritable.class);
        job.setOutputValueClass(VectorWritable.class);
        job.setNumReduceTasks(numberOfClusters);
        job.setJarByClass(ClusterOutputPostProcessorDriver.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(input, new Path("clusteredPoints")));
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        if (!job.waitForCompletion(true)) {
            throw new InterruptedException("ClusterOutputPostProcessor Job failed processing " + input);
        }
    }

    private static void movePartFilesToRespectiveDirectories(Configuration conf, Path output) throws IOException {
        FileSystem fileSystem = output.getFileSystem(conf);
        for (FileStatus fileStatus : fileSystem.listStatus(output, PathFilters.partFilter())) {
            SequenceFileIterator it = new SequenceFileIterator(fileStatus.getPath(), true, conf);
            if (it.hasNext()) {
                ClusterOutputPostProcessorDriver.renameFile((Writable)((Pair)it.next()).getFirst(), fileStatus, conf);
            }
            it.close();
        }
    }

    private static void renameFile(Writable key, FileStatus fileStatus, Configuration conf) throws IOException {
        Path path = fileStatus.getPath();
        FileSystem fileSystem = path.getFileSystem(conf);
        Path subDir = new Path(key.toString());
        Path renameTo = new Path(path.getParent(), subDir);
        fileSystem.mkdirs(renameTo);
        fileSystem.rename(path, renameTo);
    }
}

