/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import org.apache.mahout.clustering.GaussianAccumulator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.SquareRootFunction;

public class OnlineGaussianAccumulator
implements GaussianAccumulator {
    private double sumWeight;
    private Vector mean;
    private Vector s;
    private Vector variance;

    @Override
    public double getN() {
        return this.sumWeight;
    }

    @Override
    public Vector getMean() {
        return this.mean;
    }

    @Override
    public Vector getStd() {
        return this.variance.clone().assign((DoubleFunction)new SquareRootFunction());
    }

    @Override
    public void observe(Vector x, double weight) {
        Vector q;
        double temp = weight + this.sumWeight;
        if (this.mean == null) {
            this.mean = x.like();
            q = x.clone();
        } else {
            q = x.minus(this.mean);
        }
        Vector r = q.times(weight).divide(temp);
        this.s = this.s == null ? q.times(this.sumWeight).times(r) : this.s.plus(q.times(this.sumWeight).times(r));
        this.mean = this.mean.plus(r);
        this.sumWeight = temp;
        this.variance = this.s.divide(this.sumWeight - 1.0);
    }

    @Override
    public void compute() {
    }

    @Override
    public double getAverageStd() {
        if (this.sumWeight == 0.0) {
            return 0.0;
        }
        Vector std = this.getStd();
        return std.zSum() / (double)std.size();
    }

    @Override
    public Vector getVariance() {
        return this.variance;
    }
}

