/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.Model;
import org.apache.mahout.common.parameters.Parameter;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.SquareRootFunction;

public abstract class AbstractCluster
implements Cluster {
    private int id;
    private long numObservations;
    private long totalObservations;
    private Vector center;
    private Vector radius;
    private double s0;
    private Vector s1;
    private Vector s2;

    protected AbstractCluster() {
    }

    protected AbstractCluster(Vector point, int id2) {
        this.setNumObservations(0L);
        this.setTotalObservations(0L);
        this.setCenter(point.clone());
        this.setRadius(this.center.like());
        this.setS0(0.0);
        this.setS1(this.center.like());
        this.setS2(this.center.like());
        this.id = id2;
    }

    protected AbstractCluster(Vector center2, Vector radius2, int id2) {
        this.setNumObservations(0L);
        this.setTotalObservations(0L);
        this.setCenter((Vector)new RandomAccessSparseVector(center2));
        this.setRadius((Vector)new RandomAccessSparseVector(radius2));
        this.setS0(0.0);
        this.setS1(this.center.like());
        this.setS2(this.center.like());
        this.id = id2;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeLong(this.getNumObservations());
        out.writeLong(this.getTotalObservations());
        VectorWritable.writeVector(out, this.getCenter());
        VectorWritable.writeVector(out, this.getRadius());
        out.writeDouble(this.s0);
        VectorWritable.writeVector(out, this.s1);
        VectorWritable.writeVector(out, this.s2);
    }

    public void readFields(DataInput in) throws IOException {
        this.id = in.readInt();
        this.setNumObservations(in.readLong());
        this.setTotalObservations(in.readLong());
        this.setCenter(VectorWritable.readVector(in));
        this.setRadius(VectorWritable.readVector(in));
        this.setS0(in.readDouble());
        this.setS1(VectorWritable.readVector(in));
        this.setS2(VectorWritable.readVector(in));
    }

    @Override
    public void configure(Configuration job) {
    }

    @Override
    public Collection<Parameter<?>> getParameters() {
        return Collections.emptyList();
    }

    @Override
    public void createParameters(String prefix, Configuration jobConf) {
    }

    @Override
    public int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    @Override
    public long getNumObservations() {
        return this.numObservations;
    }

    protected void setNumObservations(long l) {
        this.numObservations = l;
    }

    @Override
    public long getTotalObservations() {
        return this.totalObservations;
    }

    protected void setTotalObservations(long totalPoints) {
        this.totalObservations = totalPoints;
    }

    @Override
    public Vector getCenter() {
        return this.center;
    }

    protected void setCenter(Vector center) {
        this.center = center;
    }

    @Override
    public Vector getRadius() {
        return this.radius;
    }

    protected void setRadius(Vector radius) {
        this.radius = radius;
    }

    protected double getS0() {
        return this.s0;
    }

    protected void setS0(double s0) {
        this.s0 = s0;
    }

    protected Vector getS1() {
        return this.s1;
    }

    protected void setS1(Vector s1) {
        this.s1 = s1;
    }

    protected Vector getS2() {
        return this.s2;
    }

    protected void setS2(Vector s2) {
        this.s2 = s2;
    }

    @Override
    public void observe(Model<VectorWritable> x) {
        AbstractCluster cl = (AbstractCluster)x;
        this.setS0(this.getS0() + cl.getS0());
        this.setS1(this.getS1().plus(cl.getS1()));
        this.setS2(this.getS2().plus(cl.getS2()));
    }

    @Override
    public void observe(VectorWritable x) {
        this.observe(x.get());
    }

    @Override
    public void observe(VectorWritable x, double weight) {
        this.observe(x.get(), weight);
    }

    @Override
    public void observe(Vector x, double weight) {
        if (weight == 1.0) {
            this.observe(x);
        } else {
            this.setS0(this.getS0() + weight);
            Vector weightedX = x.times(weight);
            if (this.getS1() == null) {
                this.setS1(weightedX);
            } else {
                this.getS1().assign(weightedX, Functions.PLUS);
            }
            Vector x2 = x.times(x).times(weight);
            if (this.getS2() == null) {
                this.setS2(x2);
            } else {
                this.getS2().assign(x2, Functions.PLUS);
            }
        }
    }

    @Override
    public void observe(Vector x) {
        this.setS0(this.getS0() + 1.0);
        if (this.getS1() == null) {
            this.setS1(x.clone());
        } else {
            this.getS1().assign(x, Functions.PLUS);
        }
        Vector x2 = x.times(x);
        if (this.getS2() == null) {
            this.setS2(x2);
        } else {
            this.getS2().assign(x2, Functions.PLUS);
        }
    }

    @Override
    public void computeParameters() {
        if (this.getS0() == 0.0) {
            return;
        }
        this.setNumObservations((long)this.getS0());
        this.setTotalObservations(this.getTotalObservations() + this.getNumObservations());
        this.setCenter(this.getS1().divide(this.getS0()));
        if (this.getS0() > 1.0) {
            this.setRadius(this.getS2().times(this.getS0()).minus(this.getS1().times(this.getS1())).assign((DoubleFunction)new SquareRootFunction()).divide(this.getS0()));
        }
        this.setS0(0.0);
        this.setS1(this.center.like());
        this.setS2(this.center.like());
    }

    @Override
    public String asFormatString(String[] bindings) {
        StringBuilder buf = new StringBuilder(50);
        buf.append(this.getIdentifier()).append("{n=").append(this.getNumObservations());
        if (this.getCenter() != null) {
            buf.append(" c=").append(AbstractCluster.formatVector(this.getCenter(), bindings));
        }
        if (this.getRadius() != null) {
            buf.append(" r=").append(AbstractCluster.formatVector(this.getRadius(), bindings));
        }
        buf.append('}');
        return buf.toString();
    }

    public abstract String getIdentifier();

    public Vector computeCentroid() {
        return this.getS0() == 0.0 ? this.getCenter() : this.getS1().divide(this.getS0());
    }

    public static String formatVector(Vector v, String[] bindings) {
        StringBuilder buffer = new StringBuilder();
        if (v instanceof NamedVector) {
            buffer.append(((NamedVector)v).getName()).append(" = ");
        }
        boolean hasBindings = bindings != null;
        boolean isSparse = !v.isDense() && v.getNumNondefaultElements() != v.size();
        Vector provider = v.isSequentialAccess() ? v : new SequentialAccessSparseVector(v);
        buffer.append('[');
        for (Vector.Element elem : provider.nonZeroes()) {
            if (hasBindings && bindings.length >= elem.index() + 1 && bindings[elem.index()] != null) {
                buffer.append(bindings[elem.index()]).append(':');
            } else if (hasBindings || isSparse) {
                buffer.append(elem.index()).append(':');
            }
            buffer.append(String.format(Locale.ENGLISH, "%.3f", elem.get())).append(", ");
        }
        if (buffer.length() > 1) {
            buffer.setLength(buffer.length() - 2);
        }
        buffer.append(']');
        return buffer.toString();
    }

    @Override
    public boolean isConverged() {
        return false;
    }
}

