/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.svd;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.recommender.svd.Factorization;
import org.apache.mahout.cf.taste.impl.recommender.svd.PersistenceStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePersistenceStrategy
implements PersistenceStrategy {
    private final File file;
    private static final Logger log = LoggerFactory.getLogger(FilePersistenceStrategy.class);

    public FilePersistenceStrategy(File file) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Factorization load() throws IOException {
        Factorization factorization;
        if (!this.file.exists()) {
            log.info("{} does not yet exist, no factorization found", (Object)this.file.getAbsolutePath());
            return null;
        }
        DataInputStream in = null;
        try {
            log.info("Reading factorization from {}...", (Object)this.file.getAbsolutePath());
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            factorization = FilePersistenceStrategy.readBinary(in);
        }
        catch (Throwable throwable) {
            Closeables.close(in, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)in, (boolean)true);
        return factorization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybePersist(Factorization factorization) throws IOException {
        DataOutputStream out = null;
        try {
            log.info("Writing factorization to {}...", (Object)this.file.getAbsolutePath());
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
            FilePersistenceStrategy.writeBinary(factorization, out);
        }
        catch (Throwable throwable) {
            Closeables.close(out, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)out, (boolean)false);
    }

    protected static void writeBinary(Factorization factorization, DataOutput out) throws IOException {
        int feature;
        out.writeInt(factorization.numFeatures());
        out.writeInt(factorization.numUsers());
        out.writeInt(factorization.numItems());
        for (Map.Entry<Long, Integer> mappingEntry : factorization.getUserIDMappings()) {
            long userID = mappingEntry.getKey();
            out.writeInt(mappingEntry.getValue());
            out.writeLong(userID);
            try {
                double[] userFeatures = factorization.getUserFeatures(userID);
                for (feature = 0; feature < factorization.numFeatures(); ++feature) {
                    out.writeDouble(userFeatures[feature]);
                }
            }
            catch (NoSuchUserException e) {
                throw new IOException("Unable to persist factorization", e);
            }
        }
        for (Map.Entry<Long, Integer> entry : factorization.getItemIDMappings()) {
            long itemID = entry.getKey();
            out.writeInt(entry.getValue());
            out.writeLong(itemID);
            try {
                double[] itemFeatures = factorization.getItemFeatures(itemID);
                for (feature = 0; feature < factorization.numFeatures(); ++feature) {
                    out.writeDouble(itemFeatures[feature]);
                }
            }
            catch (NoSuchItemException e) {
                throw new IOException("Unable to persist factorization", e);
            }
        }
    }

    public static Factorization readBinary(DataInput in) throws IOException {
        int numFeatures = in.readInt();
        int numUsers = in.readInt();
        int numItems = in.readInt();
        FastByIDMap<Integer> userIDMapping = new FastByIDMap<Integer>(numUsers);
        double[][] userFeatures = new double[numUsers][numFeatures];
        for (int n = 0; n < numUsers; ++n) {
            int userIndex = in.readInt();
            long userID = in.readLong();
            userIDMapping.put(userID, userIndex);
            for (int feature = 0; feature < numFeatures; ++feature) {
                userFeatures[userIndex][feature] = in.readDouble();
            }
        }
        FastByIDMap<Integer> itemIDMapping = new FastByIDMap<Integer>(numItems);
        double[][] itemFeatures = new double[numItems][numFeatures];
        for (int n = 0; n < numItems; ++n) {
            int itemIndex = in.readInt();
            long itemID = in.readLong();
            itemIDMapping.put(itemID, itemIndex);
            for (int feature = 0; feature < numFeatures; ++feature) {
                itemFeatures[itemIndex][feature] = in.readDouble();
            }
        }
        return new Factorization(userIDMapping, itemIDMapping, userFeatures, itemFeatures);
    }
}

