/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.PreferredItemsNeighborhoodCandidateItemsStrategy;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.CandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecommender
implements Recommender {
    private static final Logger log = LoggerFactory.getLogger(AbstractRecommender.class);
    private final DataModel dataModel;
    private final CandidateItemsStrategy candidateItemsStrategy;

    protected AbstractRecommender(DataModel dataModel, CandidateItemsStrategy candidateItemsStrategy) {
        this.dataModel = (DataModel)Preconditions.checkNotNull((Object)dataModel);
        this.candidateItemsStrategy = (CandidateItemsStrategy)Preconditions.checkNotNull((Object)candidateItemsStrategy);
    }

    protected AbstractRecommender(DataModel dataModel) {
        this(dataModel, AbstractRecommender.getDefaultCandidateItemsStrategy());
    }

    protected static CandidateItemsStrategy getDefaultCandidateItemsStrategy() {
        return new PreferredItemsNeighborhoodCandidateItemsStrategy();
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommend(userID, howMany, null);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        Preconditions.checkArgument((!Float.isNaN(value) ? 1 : 0) != 0, (Object)"NaN value");
        log.debug("Setting preference for user {}, item {}", (Object)userID, (Object)itemID);
        this.dataModel.setPreference(userID, itemID, value);
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        log.debug("Remove preference for user '{}', item '{}'", (Object)userID, (Object)itemID);
        this.dataModel.removePreference(userID, itemID);
    }

    @Override
    public DataModel getDataModel() {
        return this.dataModel;
    }

    protected FastIDSet getAllOtherItems(long userID, PreferenceArray preferencesFromUser) throws TasteException {
        return this.candidateItemsStrategy.getCandidateItems(userID, preferencesFromUser, this.dataModel);
    }
}

