/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.als.AlternatingLeastSquaresSolver;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

final class ALS {
    private ALS() {
    }

    static Vector readFirstRow(Path dir, Configuration conf) throws IOException {
        SequenceFileDirValueIterator iterator = new SequenceFileDirValueIterator(dir, PathType.LIST, PathFilters.partFilter(), null, true, conf);
        return iterator.hasNext() ? ((VectorWritable)((Object)iterator.next())).get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenIntObjectHashMap<Vector> readMatrixByRowsFromDistributedCache(int numEntities, Configuration conf) throws IOException {
        IntWritable rowIndex = new IntWritable();
        VectorWritable row = new VectorWritable();
        OpenIntObjectHashMap featureMatrix = numEntities > 0 ? new OpenIntObjectHashMap(numEntities) : new OpenIntObjectHashMap();
        Path[] cachedFiles = HadoopUtil.getCachedFiles(conf);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        for (Path cachedFile : cachedFiles) {
            SequenceFile.Reader reader = null;
            try {
                reader = new SequenceFile.Reader((FileSystem)localFs, cachedFile, conf);
                while (reader.next((Writable)rowIndex, (Writable)row)) {
                    featureMatrix.put(rowIndex.get(), (Object)row.get());
                }
            }
            catch (Throwable throwable) {
                Closeables.close(reader, (boolean)true);
                throw throwable;
            }
            Closeables.close((Closeable)reader, (boolean)true);
        }
        Preconditions.checkState((!featureMatrix.isEmpty() ? 1 : 0) != 0, (Object)"Feature matrix is empty");
        return featureMatrix;
    }

    public static OpenIntObjectHashMap<Vector> readMatrixByRows(Path dir, Configuration conf) {
        OpenIntObjectHashMap matrix = new OpenIntObjectHashMap();
        for (Pair pair : new SequenceFileDirIterable(dir, PathType.LIST, PathFilters.partFilter(), conf)) {
            int rowIndex = ((IntWritable)pair.getFirst()).get();
            Vector row = ((VectorWritable)((Object)pair.getSecond())).get();
            matrix.put(rowIndex, (Object)row);
        }
        return matrix;
    }

    public static Vector solveExplicit(VectorWritable ratingsWritable, OpenIntObjectHashMap<Vector> uOrM, double lambda, int numFeatures) {
        Vector ratings = ratingsWritable.get();
        ArrayList featureVectors = Lists.newArrayListWithCapacity((int)ratings.getNumNondefaultElements());
        for (Vector.Element e : ratings.nonZeroes()) {
            int index = e.index();
            featureVectors.add(uOrM.get(index));
        }
        return AlternatingLeastSquaresSolver.solve((Iterable)featureVectors, (Vector)ratings, (double)lambda, (int)numFeatures);
    }
}

