/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import com.google.common.primitives.Longs;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.VarIntWritable;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.map.OpenIntLongHashMap;

public final class TasteHadoopUtils {
    public static final int USER_ID_POS = 0;
    public static final int ITEM_ID_POS = 1;
    private static final Pattern PREFERENCE_TOKEN_DELIMITER = Pattern.compile("[\t,]");

    private TasteHadoopUtils() {
    }

    public static String[] splitPrefTokens(CharSequence line) {
        return PREFERENCE_TOKEN_DELIMITER.split(line);
    }

    public static int idToIndex(long id) {
        return Integer.MAX_VALUE & Longs.hashCode((long)id) % 0x7FFFFFFE;
    }

    public static int readID(String token, boolean usesLongIDs) {
        return usesLongIDs ? TasteHadoopUtils.idToIndex(Long.parseLong(token)) : Integer.parseInt(token);
    }

    public static OpenIntLongHashMap readIDIndexMap(String idIndexPathStr, Configuration conf) {
        OpenIntLongHashMap indexIDMap = new OpenIntLongHashMap();
        Path itemIDIndexPath = new Path(idIndexPathStr);
        for (Pair record : new SequenceFileDirIterable(itemIDIndexPath, PathType.LIST, PathFilters.partFilter(), null, true, conf)) {
            indexIDMap.put(((VarIntWritable)record.getFirst()).get(), ((VarLongWritable)record.getSecond()).get());
        }
        return indexIDMap;
    }
}

