/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_b88.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t39, t43, t44;
  double t46, t47, t48, t52, t56, tzk0;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = t3 * t3;
  t21 = params->beta * t20;
  t23 = POW_1_3(0.1e1 / M_PI);
  t24 = 0.1e1 / t23;
  t25 = M_CBRT4;
  t26 = t24 * t25;
  t27 = t21 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t35 = params->gamma * params->beta;
  t36 = sqrt(sigma[0]);
  t37 = t35 * t36;
  t39 = 0.1e1 / t18 / rho[0];
  t43 = log(t36 * t28 * t39 + sqrt(POW_2(t36 * t28 * t39) + 0.1e1));
  t44 = t28 * t39 * t43;
  t46 = t37 * t44 + 0.1e1;
  t47 = 0.1e1 / t46;
  t48 = t34 * t47;
  t52 = 0.1e1 + 0.2e1 / 0.9e1 * t27 * t30 * t48;
  t56 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t52);
  tzk0 = 0.2e1 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t39, t43, t44;
  double t46, t47, t48, t52, t56, tzk0;

  double t58, t62, t64, t65, t69, t70, t71, t75;
  double t77, t78, t80, t81, t82, t83, t86, t91;
  double t96, tvrho0, t99, t100, t104, t106, t107, t110;
  double t115, t119, tvsigma0;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = t3 * t3;
  t21 = params->beta * t20;
  t23 = POW_1_3(0.1e1 / M_PI);
  t24 = 0.1e1 / t23;
  t25 = M_CBRT4;
  t26 = t24 * t25;
  t27 = t21 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t35 = params->gamma * params->beta;
  t36 = sqrt(sigma[0]);
  t37 = t35 * t36;
  t39 = 0.1e1 / t18 / rho[0];
  t43 = log(t36 * t28 * t39 + sqrt(POW_2(t36 * t28 * t39) + 0.1e1));
  t44 = t28 * t39 * t43;
  t46 = t37 * t44 + 0.1e1;
  t47 = 0.1e1 / t46;
  t48 = t34 * t47;
  t52 = 0.1e1 + 0.2e1 / 0.9e1 * t27 * t30 * t48;
  t56 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t52);
  tzk0 = 0.2e1 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t58 = t17 / t32;
  t62 = t31 * rho[0];
  t64 = 0.1e1 / t32 / t62;
  t65 = t64 * t47;
  t69 = t46 * t46;
  t70 = 0.1e1 / t69;
  t71 = t34 * t70;
  t75 = t28 / t18 / t31 * t43;
  t77 = t35 * sigma[0];
  t78 = t29 * t64;
  t80 = t30 * t34 + 0.1e1;
  t81 = sqrt(t80);
  t82 = 0.1e1 / t81;
  t83 = t78 * t82;
  t86 = -0.4e1 / 0.3e1 * t37 * t75 - 0.4e1 / 0.3e1 * t77 * t83;
  t91 = -0.16e2 / 0.27e2 * t27 * t30 * t65 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t86;
  t96 = my_piecewise3(t2, 0, -t6 * t58 * t52 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t91);
  tvrho0 = 0.2e1 * rho[0] * t96 + 0.2e1 * t56;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t99 = t21 * t24;
  t100 = t25 * t29;
  t104 = t35 / t36;
  t106 = t29 * t34;
  t107 = t106 * t82;
  t110 = t104 * t44 / 0.2e1 + t35 * t107 / 0.2e1;
  t115 = -0.2e1 / 0.9e1 * t27 * t30 * t71 * t110 + 0.2e1 / 0.9e1 * t99 * t100 * t48;
  t119 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t115);
  tvsigma0 = 0.2e1 * rho[0] * t119;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t39, t43, t44;
  double t46, t47, t48, t52, t56, tzk0;

  double t58, t62, t64, t65, t69, t70, t71, t75;
  double t77, t78, t80, t81, t82, t83, t86, t91;
  double t96, tvrho0, t99, t100, t104, t106, t107, t110;
  double t115, t119, tvsigma0;

  double t124, t131, t133, t134, t138, t144, t145, t146;
  double t154, t157, t158, t161, t162, t165, t168, t169;
  double t172, t177, t182, tv2rho20, t191, t200, t201, t202;
  double t203, t210, t211, t213, t218, t223, t228, tv2rhosigma0;
  double t231, t235, t242, t245, t246, t249, t252, t253;
  double t256, t261, t265, tv2sigma20;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = t3 * t3;
  t21 = params->beta * t20;
  t23 = POW_1_3(0.1e1 / M_PI);
  t24 = 0.1e1 / t23;
  t25 = M_CBRT4;
  t26 = t24 * t25;
  t27 = t21 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t35 = params->gamma * params->beta;
  t36 = sqrt(sigma[0]);
  t37 = t35 * t36;
  t39 = 0.1e1 / t18 / rho[0];
  t43 = log(t36 * t28 * t39 + sqrt(POW_2(t36 * t28 * t39) + 0.1e1));
  t44 = t28 * t39 * t43;
  t46 = t37 * t44 + 0.1e1;
  t47 = 0.1e1 / t46;
  t48 = t34 * t47;
  t52 = 0.1e1 + 0.2e1 / 0.9e1 * t27 * t30 * t48;
  t56 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t52);
  tzk0 = 0.2e1 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t58 = t17 / t32;
  t62 = t31 * rho[0];
  t64 = 0.1e1 / t32 / t62;
  t65 = t64 * t47;
  t69 = t46 * t46;
  t70 = 0.1e1 / t69;
  t71 = t34 * t70;
  t75 = t28 / t18 / t31 * t43;
  t77 = t35 * sigma[0];
  t78 = t29 * t64;
  t80 = t30 * t34 + 0.1e1;
  t81 = sqrt(t80);
  t82 = 0.1e1 / t81;
  t83 = t78 * t82;
  t86 = -0.4e1 / 0.3e1 * t37 * t75 - 0.4e1 / 0.3e1 * t77 * t83;
  t91 = -0.16e2 / 0.27e2 * t27 * t30 * t65 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t86;
  t96 = my_piecewise3(t2, 0, -t6 * t58 * t52 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t91);
  tvrho0 = 0.2e1 * rho[0] * t96 + 0.2e1 * t56;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t99 = t21 * t24;
  t100 = t25 * t29;
  t104 = t35 / t36;
  t106 = t29 * t34;
  t107 = t106 * t82;
  t110 = t104 * t44 / 0.2e1 + t35 * t107 / 0.2e1;
  t115 = -0.2e1 / 0.9e1 * t27 * t30 * t71 * t110 + 0.2e1 / 0.9e1 * t99 * t100 * t48;
  t119 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t115);
  tvsigma0 = 0.2e1 * rho[0] * t119;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t124 = t17 / t32 / rho[0];
  t131 = t31 * t31;
  t133 = 0.1e1 / t32 / t131;
  t134 = t133 * t47;
  t138 = t64 * t70;
  t144 = 0.1e1 / t69 / t46;
  t145 = t34 * t144;
  t146 = t86 * t86;
  t154 = t28 / t18 / t62 * t43;
  t157 = t29 * t133;
  t158 = t157 * t82;
  t161 = sigma[0] * sigma[0];
  t162 = t35 * t161;
  t165 = 0.1e1 / t18 / t131 / t62;
  t168 = 0.1e1 / t81 / t80;
  t169 = t28 * t165 * t168;
  t172 = 0.28e2 / 0.9e1 * t37 * t154 + 0.2e2 / 0.3e1 * t77 * t158 - 0.32e2 / 0.9e1 * t162 * t169;
  t177 = 0.176e3 / 0.81e2 * t27 * t30 * t134 + 0.32e2 / 0.27e2 * t27 * t30 * t138 * t86 + 0.4e1 / 0.9e1 * t27 * t30 * t145 * t146 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t172;
  t182 = my_piecewise3(t2, 0, t6 * t124 * t52 / 0.12e2 - t6 * t58 * t91 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t177);
  tv2rho20 = 0.2e1 * rho[0] * t182 + 0.4e1 * t96;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t191 = t70 * t86;
  t200 = t21 * t26 * sigma[0];
  t201 = t144 * t110;
  t202 = t201 * t86;
  t203 = t106 * t202;
  t210 = t35 * t28;
  t211 = t131 * t31;
  t213 = 0.1e1 / t18 / t211;
  t218 = -0.2e1 / 0.3e1 * t104 * t75 - 0.2e1 * t35 * t83 + 0.4e1 / 0.3e1 * t210 * t213 * t168 * sigma[0];
  t223 = -0.16e2 / 0.27e2 * t99 * t100 * t65 - 0.2e1 / 0.9e1 * t27 * t106 * t191 + 0.16e2 / 0.27e2 * t27 * t30 * t138 * t110 + 0.4e1 / 0.9e1 * t200 * t203 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t218;
  t228 = my_piecewise3(t2, 0, -t6 * t58 * t115 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t223);
  tv2rhosigma0 = 0.2e1 * rho[0] * t228 + 0.2e1 * t119;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t231 = t70 * t110;
  t235 = t110 * t110;
  t242 = t35 / t36 / sigma[0];
  t245 = 0.1e1 / sigma[0];
  t246 = t35 * t245;
  t249 = t131 * rho[0];
  t252 = t28 / t18 / t249;
  t253 = t252 * t168;
  t256 = -t242 * t44 / 0.4e1 + t246 * t107 / 0.4e1 - t35 * t253 / 0.2e1;
  t261 = -0.4e1 / 0.9e1 * t27 * t106 * t231 + 0.4e1 / 0.9e1 * t27 * t30 * t145 * t235 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t256;
  t265 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t261);
  tv2sigma20 = 0.2e1 * rho[0] * t265;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t39, t43, t44;
  double t46, t47, t48, t52, t56, tzk0;

  double t58, t62, t64, t65, t69, t70, t71, t75;
  double t77, t78, t80, t81, t82, t83, t86, t91;
  double t96, tvrho0, t99, t100, t104, t106, t107, t110;
  double t115, t119, tvsigma0;

  double t124, t131, t133, t134, t138, t144, t145, t146;
  double t154, t157, t158, t161, t162, t165, t168, t169;
  double t172, t177, t182, tv2rho20, t191, t200, t201, t202;
  double t203, t210, t211, t213, t218, t223, t228, tv2rhosigma0;
  double t231, t235, t242, t245, t246, t249, t252, t253;
  double t256, t261, t265, tv2sigma20;

  double t268, t279, t280, t284, t289, t298, t299, t300;
  double t301, t306, t307, t308, t314, t318, t321, t323;
  double t328, t329, t330, t332, t334, t338, t343, t348;
  double tv3rho30, t364, t368, t376, t384, t385, t388, t389;
  double t390, t393, t394, t405, t407, t411, t416, t421;
  double tv3rho2sigma0, t432, t440, t441, t442, t445, t446, t453;
  double t454, t455, t463, t466, t468, t472, t477, t482;
  double tv3rhosigma20, t485, t489, t493, t498, t499, t504, t508;
  double t513, t517, t522, t526, tv3sigma30;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = t3 * t3;
  t21 = params->beta * t20;
  t23 = POW_1_3(0.1e1 / M_PI);
  t24 = 0.1e1 / t23;
  t25 = M_CBRT4;
  t26 = t24 * t25;
  t27 = t21 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t35 = params->gamma * params->beta;
  t36 = sqrt(sigma[0]);
  t37 = t35 * t36;
  t39 = 0.1e1 / t18 / rho[0];
  t43 = log(t36 * t28 * t39 + sqrt(POW_2(t36 * t28 * t39) + 0.1e1));
  t44 = t28 * t39 * t43;
  t46 = t37 * t44 + 0.1e1;
  t47 = 0.1e1 / t46;
  t48 = t34 * t47;
  t52 = 0.1e1 + 0.2e1 / 0.9e1 * t27 * t30 * t48;
  t56 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t52);
  tzk0 = 0.2e1 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t58 = t17 / t32;
  t62 = t31 * rho[0];
  t64 = 0.1e1 / t32 / t62;
  t65 = t64 * t47;
  t69 = t46 * t46;
  t70 = 0.1e1 / t69;
  t71 = t34 * t70;
  t75 = t28 / t18 / t31 * t43;
  t77 = t35 * sigma[0];
  t78 = t29 * t64;
  t80 = t30 * t34 + 0.1e1;
  t81 = sqrt(t80);
  t82 = 0.1e1 / t81;
  t83 = t78 * t82;
  t86 = -0.4e1 / 0.3e1 * t37 * t75 - 0.4e1 / 0.3e1 * t77 * t83;
  t91 = -0.16e2 / 0.27e2 * t27 * t30 * t65 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t86;
  t96 = my_piecewise3(t2, 0, -t6 * t58 * t52 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t91);
  tvrho0 = 0.2e1 * rho[0] * t96 + 0.2e1 * t56;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t99 = t21 * t24;
  t100 = t25 * t29;
  t104 = t35 / t36;
  t106 = t29 * t34;
  t107 = t106 * t82;
  t110 = t104 * t44 / 0.2e1 + t35 * t107 / 0.2e1;
  t115 = -0.2e1 / 0.9e1 * t27 * t30 * t71 * t110 + 0.2e1 / 0.9e1 * t99 * t100 * t48;
  t119 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t115);
  tvsigma0 = 0.2e1 * rho[0] * t119;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t124 = t17 / t32 / rho[0];
  t131 = t31 * t31;
  t133 = 0.1e1 / t32 / t131;
  t134 = t133 * t47;
  t138 = t64 * t70;
  t144 = 0.1e1 / t69 / t46;
  t145 = t34 * t144;
  t146 = t86 * t86;
  t154 = t28 / t18 / t62 * t43;
  t157 = t29 * t133;
  t158 = t157 * t82;
  t161 = sigma[0] * sigma[0];
  t162 = t35 * t161;
  t165 = 0.1e1 / t18 / t131 / t62;
  t168 = 0.1e1 / t81 / t80;
  t169 = t28 * t165 * t168;
  t172 = 0.28e2 / 0.9e1 * t37 * t154 + 0.2e2 / 0.3e1 * t77 * t158 - 0.32e2 / 0.9e1 * t162 * t169;
  t177 = 0.176e3 / 0.81e2 * t27 * t30 * t134 + 0.32e2 / 0.27e2 * t27 * t30 * t138 * t86 + 0.4e1 / 0.9e1 * t27 * t30 * t145 * t146 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t172;
  t182 = my_piecewise3(t2, 0, t6 * t124 * t52 / 0.12e2 - t6 * t58 * t91 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t177);
  tv2rho20 = 0.2e1 * rho[0] * t182 + 0.4e1 * t96;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t191 = t70 * t86;
  t200 = t21 * t26 * sigma[0];
  t201 = t144 * t110;
  t202 = t201 * t86;
  t203 = t106 * t202;
  t210 = t35 * t28;
  t211 = t131 * t31;
  t213 = 0.1e1 / t18 / t211;
  t218 = -0.2e1 / 0.3e1 * t104 * t75 - 0.2e1 * t35 * t83 + 0.4e1 / 0.3e1 * t210 * t213 * t168 * sigma[0];
  t223 = -0.16e2 / 0.27e2 * t99 * t100 * t65 - 0.2e1 / 0.9e1 * t27 * t106 * t191 + 0.16e2 / 0.27e2 * t27 * t30 * t138 * t110 + 0.4e1 / 0.9e1 * t200 * t203 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t218;
  t228 = my_piecewise3(t2, 0, -t6 * t58 * t115 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t223);
  tv2rhosigma0 = 0.2e1 * rho[0] * t228 + 0.2e1 * t119;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t231 = t70 * t110;
  t235 = t110 * t110;
  t242 = t35 / t36 / sigma[0];
  t245 = 0.1e1 / sigma[0];
  t246 = t35 * t245;
  t249 = t131 * rho[0];
  t252 = t28 / t18 / t249;
  t253 = t252 * t168;
  t256 = -t242 * t44 / 0.4e1 + t246 * t107 / 0.4e1 - t35 * t253 / 0.2e1;
  t261 = -0.4e1 / 0.9e1 * t27 * t106 * t231 + 0.4e1 / 0.9e1 * t27 * t30 * t145 * t235 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t256;
  t265 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t261);
  tv2sigma20 = 0.2e1 * rho[0] * t265;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t268 = t17 * t34;
  t279 = 0.1e1 / t32 / t249;
  t280 = t279 * t47;
  t284 = t133 * t70;
  t289 = t64 * t144;
  t298 = t69 * t69;
  t299 = 0.1e1 / t298;
  t300 = t34 * t299;
  t301 = t146 * t86;
  t306 = t144 * t86;
  t307 = t306 * t172;
  t308 = t106 * t307;
  t314 = t28 / t18 / t131 * t43;
  t318 = t29 * t279 * t82;
  t321 = t131 * t131;
  t323 = 0.1e1 / t18 / t321;
  t328 = t161 * sigma[0];
  t329 = t321 * t62;
  t330 = 0.1e1 / t329;
  t332 = t80 * t80;
  t334 = 0.1e1 / t81 / t332;
  t338 = -0.28e3 / 0.27e2 * t37 * t314 - 0.952e3 / 0.27e2 * t77 * t318 + 0.1184e4 / 0.27e2 * t162 * t28 * t323 * t168 - 0.256e3 / 0.9e1 * t35 * t328 * t330 * t334;
  t343 = -0.2464e4 / 0.243e3 * t27 * t30 * t280 - 0.176e3 / 0.27e2 * t27 * t30 * t284 * t86 - 0.32e2 / 0.9e1 * t27 * t30 * t289 * t146 + 0.16e2 / 0.9e1 * t27 * t30 * t138 * t172 - 0.4e1 / 0.3e1 * t27 * t30 * t300 * t301 + 0.4e1 / 0.3e1 * t200 * t308 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t338;
  t348 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t268 * t52 + t6 * t124 * t91 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t58 * t177 - 0.3e1 / 0.8e1 * t6 * t19 * t343);
  tv3rho30 = 0.2e1 * rho[0] * t348 + 0.6e1 * t182;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t364 = t144 * t146;
  t368 = t70 * t172;
  t376 = t78 * t202;
  t384 = t299 * t110 * t146;
  t385 = t106 * t384;
  t388 = t144 * t218;
  t389 = t388 * t86;
  t390 = t106 * t389;
  t393 = t201 * t172;
  t394 = t106 * t393;
  t405 = t321 * t31;
  t407 = 0.1e1 / t405 * t334;
  t411 = 0.14e2 / 0.9e1 * t104 * t154 + 0.74e2 / 0.9e1 * t35 * t158 - 0.124e3 / 0.9e1 * t210 * t165 * t168 * sigma[0] + 0.32e2 / 0.3e1 * t35 * t407 * t161;
  t416 = 0.176e3 / 0.81e2 * t99 * t100 * t134 + 0.32e2 / 0.27e2 * t27 * t78 * t191 + 0.4e1 / 0.9e1 * t27 * t106 * t364 - 0.2e1 / 0.9e1 * t27 * t106 * t368 - 0.176e3 / 0.81e2 * t27 * t30 * t284 * t110 - 0.64e2 / 0.27e2 * t200 * t376 + 0.32e2 / 0.27e2 * t27 * t30 * t138 * t218 - 0.4e1 / 0.3e1 * t200 * t385 + 0.8e1 / 0.9e1 * t200 * t390 + 0.4e1 / 0.9e1 * t200 * t394 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t411;
  t421 = my_piecewise3(t2, 0, t6 * t124 * t115 / 0.12e2 - t6 * t58 * t223 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t416);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t421 + 0.4e1 * t228;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t432 = t70 * t218;
  t440 = t299 * t235;
  t441 = t440 * t86;
  t442 = t106 * t441;
  t445 = t201 * t218;
  t446 = t106 * t445;
  t453 = t144 * t256;
  t454 = t453 * t86;
  t455 = t106 * t454;
  t463 = t28 * t213 * t168;
  t466 = t321 * rho[0];
  t468 = 0.1e1 / t466 * t334;
  t472 = t242 * t75 / 0.3e1 - t246 * t83 / 0.3e1 + 0.1e2 / 0.3e1 * t35 * t463 - 0.4e1 * t35 * t468 * sigma[0];
  t477 = 0.32e2 / 0.27e2 * t27 * t78 * t231 + 0.8e1 / 0.9e1 * t27 * t203 - 0.4e1 / 0.9e1 * t27 * t106 * t432 - 0.32e2 / 0.27e2 * t27 * t30 * t289 * t235 - 0.4e1 / 0.3e1 * t200 * t442 + 0.8e1 / 0.9e1 * t200 * t446 + 0.16e2 / 0.27e2 * t27 * t30 * t138 * t256 + 0.4e1 / 0.9e1 * t200 * t455 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t472;
  t482 = my_piecewise3(t2, 0, -t6 * t58 * t261 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t477);
  tv3rhosigma20 = 0.2e1 * rho[0] * t482 + 0.2e1 * t265;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t485 = t144 * t235;
  t489 = t70 * t256;
  t493 = t235 * t110;
  t498 = t201 * t256;
  t499 = t106 * t498;
  t504 = t35 / t36 / t161;
  t508 = t35 / t161;
  t513 = 0.1e1 / t321;
  t517 = 0.3e1 / 0.8e1 * t504 * t44 - 0.3e1 / 0.8e1 * t508 * t107 - t246 * t253 / 0.4e1 + 0.3e1 / 0.2e1 * t35 * t513 * t334;
  t522 = 0.4e1 / 0.3e1 * t27 * t106 * t485 - 0.2e1 / 0.3e1 * t27 * t106 * t489 - 0.4e1 / 0.3e1 * t27 * t30 * t300 * t493 + 0.4e1 / 0.3e1 * t200 * t499 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t517;
  t526 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t522);
  tv3sigma30 = 0.2e1 * rho[0] * t526;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t10, t11;
  double t13, t15, t17, t18, t19, t20, t21, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t32, t34, t35, t36, t37, t39, t43, t44;
  double t46, t47, t48, t52, t56, tzk0;

  double t58, t62, t64, t65, t69, t70, t71, t75;
  double t77, t78, t80, t81, t82, t83, t86, t91;
  double t96, tvrho0, t99, t100, t104, t106, t107, t110;
  double t115, t119, tvsigma0;

  double t124, t131, t133, t134, t138, t144, t145, t146;
  double t154, t157, t158, t161, t162, t165, t168, t169;
  double t172, t177, t182, tv2rho20, t191, t200, t201, t202;
  double t203, t210, t211, t213, t218, t223, t228, tv2rhosigma0;
  double t231, t235, t242, t245, t246, t249, t252, t253;
  double t256, t261, t265, tv2sigma20;

  double t268, t279, t280, t284, t289, t298, t299, t300;
  double t301, t306, t307, t308, t314, t318, t321, t323;
  double t328, t329, t330, t332, t334, t338, t343, t348;
  double tv3rho30, t364, t368, t376, t384, t385, t388, t389;
  double t390, t393, t394, t405, t407, t411, t416, t421;
  double tv3rho2sigma0, t432, t440, t441, t442, t445, t446, t453;
  double t454, t455, t463, t466, t468, t472, t477, t482;
  double tv3rhosigma20, t485, t489, t493, t498, t499, t504, t508;
  double t513, t517, t522, t526, tv3sigma30;

  double t543, t548, t553, t562, t575, t576, t577, t587;
  double t609, t615, t622, t632, t637, tv4rho40, t739, t740;
  double t751, t757, tv4rho3sigma0, t821, t832, t864, t870, tv4rho2sigma20;
  double t950, t955, tv4rhosigma30, t968, t977, t1016, tv4sigma40;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = 0.1e1 <= p->zeta_threshold;
  t8 = p->zeta_threshold - 0.1e1;
  t10 = my_piecewise5(t7, t8, t7, -t8, 0);
  t11 = 0.1e1 + t10;
  t13 = POW_1_3(p->zeta_threshold);
  t15 = POW_1_3(t11);
  t17 = my_piecewise3(t11 <= p->zeta_threshold, t13 * p->zeta_threshold, t15 * t11);
  t18 = POW_1_3(rho[0]);
  t19 = t17 * t18;
  t20 = t3 * t3;
  t21 = params->beta * t20;
  t23 = POW_1_3(0.1e1 / M_PI);
  t24 = 0.1e1 / t23;
  t25 = M_CBRT4;
  t26 = t24 * t25;
  t27 = t21 * t26;
  t28 = M_CBRT2;
  t29 = t28 * t28;
  t30 = sigma[0] * t29;
  t31 = rho[0] * rho[0];
  t32 = t18 * t18;
  t34 = 0.1e1 / t32 / t31;
  t35 = params->gamma * params->beta;
  t36 = sqrt(sigma[0]);
  t37 = t35 * t36;
  t39 = 0.1e1 / t18 / rho[0];
  t43 = log(t36 * t28 * t39 + sqrt(POW_2(t36 * t28 * t39) + 0.1e1));
  t44 = t28 * t39 * t43;
  t46 = t37 * t44 + 0.1e1;
  t47 = 0.1e1 / t46;
  t48 = t34 * t47;
  t52 = 0.1e1 + 0.2e1 / 0.9e1 * t27 * t30 * t48;
  t56 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t52);
  tzk0 = 0.2e1 * t56;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t58 = t17 / t32;
  t62 = t31 * rho[0];
  t64 = 0.1e1 / t32 / t62;
  t65 = t64 * t47;
  t69 = t46 * t46;
  t70 = 0.1e1 / t69;
  t71 = t34 * t70;
  t75 = t28 / t18 / t31 * t43;
  t77 = t35 * sigma[0];
  t78 = t29 * t64;
  t80 = t30 * t34 + 0.1e1;
  t81 = sqrt(t80);
  t82 = 0.1e1 / t81;
  t83 = t78 * t82;
  t86 = -0.4e1 / 0.3e1 * t37 * t75 - 0.4e1 / 0.3e1 * t77 * t83;
  t91 = -0.16e2 / 0.27e2 * t27 * t30 * t65 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t86;
  t96 = my_piecewise3(t2, 0, -t6 * t58 * t52 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t91);
  tvrho0 = 0.2e1 * rho[0] * t96 + 0.2e1 * t56;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t99 = t21 * t24;
  t100 = t25 * t29;
  t104 = t35 / t36;
  t106 = t29 * t34;
  t107 = t106 * t82;
  t110 = t104 * t44 / 0.2e1 + t35 * t107 / 0.2e1;
  t115 = -0.2e1 / 0.9e1 * t27 * t30 * t71 * t110 + 0.2e1 / 0.9e1 * t99 * t100 * t48;
  t119 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t115);
  tvsigma0 = 0.2e1 * rho[0] * t119;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t124 = t17 / t32 / rho[0];
  t131 = t31 * t31;
  t133 = 0.1e1 / t32 / t131;
  t134 = t133 * t47;
  t138 = t64 * t70;
  t144 = 0.1e1 / t69 / t46;
  t145 = t34 * t144;
  t146 = t86 * t86;
  t154 = t28 / t18 / t62 * t43;
  t157 = t29 * t133;
  t158 = t157 * t82;
  t161 = sigma[0] * sigma[0];
  t162 = t35 * t161;
  t165 = 0.1e1 / t18 / t131 / t62;
  t168 = 0.1e1 / t81 / t80;
  t169 = t28 * t165 * t168;
  t172 = 0.28e2 / 0.9e1 * t37 * t154 + 0.2e2 / 0.3e1 * t77 * t158 - 0.32e2 / 0.9e1 * t162 * t169;
  t177 = 0.176e3 / 0.81e2 * t27 * t30 * t134 + 0.32e2 / 0.27e2 * t27 * t30 * t138 * t86 + 0.4e1 / 0.9e1 * t27 * t30 * t145 * t146 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t172;
  t182 = my_piecewise3(t2, 0, t6 * t124 * t52 / 0.12e2 - t6 * t58 * t91 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t177);
  tv2rho20 = 0.2e1 * rho[0] * t182 + 0.4e1 * t96;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t191 = t70 * t86;
  t200 = t21 * t26 * sigma[0];
  t201 = t144 * t110;
  t202 = t201 * t86;
  t203 = t106 * t202;
  t210 = t35 * t28;
  t211 = t131 * t31;
  t213 = 0.1e1 / t18 / t211;
  t218 = -0.2e1 / 0.3e1 * t104 * t75 - 0.2e1 * t35 * t83 + 0.4e1 / 0.3e1 * t210 * t213 * t168 * sigma[0];
  t223 = -0.16e2 / 0.27e2 * t99 * t100 * t65 - 0.2e1 / 0.9e1 * t27 * t106 * t191 + 0.16e2 / 0.27e2 * t27 * t30 * t138 * t110 + 0.4e1 / 0.9e1 * t200 * t203 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t218;
  t228 = my_piecewise3(t2, 0, -t6 * t58 * t115 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t223);
  tv2rhosigma0 = 0.2e1 * rho[0] * t228 + 0.2e1 * t119;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t231 = t70 * t110;
  t235 = t110 * t110;
  t242 = t35 / t36 / sigma[0];
  t245 = 0.1e1 / sigma[0];
  t246 = t35 * t245;
  t249 = t131 * rho[0];
  t252 = t28 / t18 / t249;
  t253 = t252 * t168;
  t256 = -t242 * t44 / 0.4e1 + t246 * t107 / 0.4e1 - t35 * t253 / 0.2e1;
  t261 = -0.4e1 / 0.9e1 * t27 * t106 * t231 + 0.4e1 / 0.9e1 * t27 * t30 * t145 * t235 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t256;
  t265 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t261);
  tv2sigma20 = 0.2e1 * rho[0] * t265;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t268 = t17 * t34;
  t279 = 0.1e1 / t32 / t249;
  t280 = t279 * t47;
  t284 = t133 * t70;
  t289 = t64 * t144;
  t298 = t69 * t69;
  t299 = 0.1e1 / t298;
  t300 = t34 * t299;
  t301 = t146 * t86;
  t306 = t144 * t86;
  t307 = t306 * t172;
  t308 = t106 * t307;
  t314 = t28 / t18 / t131 * t43;
  t318 = t29 * t279 * t82;
  t321 = t131 * t131;
  t323 = 0.1e1 / t18 / t321;
  t328 = t161 * sigma[0];
  t329 = t321 * t62;
  t330 = 0.1e1 / t329;
  t332 = t80 * t80;
  t334 = 0.1e1 / t81 / t332;
  t338 = -0.28e3 / 0.27e2 * t37 * t314 - 0.952e3 / 0.27e2 * t77 * t318 + 0.1184e4 / 0.27e2 * t162 * t28 * t323 * t168 - 0.256e3 / 0.9e1 * t35 * t328 * t330 * t334;
  t343 = -0.2464e4 / 0.243e3 * t27 * t30 * t280 - 0.176e3 / 0.27e2 * t27 * t30 * t284 * t86 - 0.32e2 / 0.9e1 * t27 * t30 * t289 * t146 + 0.16e2 / 0.9e1 * t27 * t30 * t138 * t172 - 0.4e1 / 0.3e1 * t27 * t30 * t300 * t301 + 0.4e1 / 0.3e1 * t200 * t308 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t338;
  t348 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t268 * t52 + t6 * t124 * t91 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t58 * t177 - 0.3e1 / 0.8e1 * t6 * t19 * t343);
  tv3rho30 = 0.2e1 * rho[0] * t348 + 0.6e1 * t182;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t364 = t144 * t146;
  t368 = t70 * t172;
  t376 = t78 * t202;
  t384 = t299 * t110 * t146;
  t385 = t106 * t384;
  t388 = t144 * t218;
  t389 = t388 * t86;
  t390 = t106 * t389;
  t393 = t201 * t172;
  t394 = t106 * t393;
  t405 = t321 * t31;
  t407 = 0.1e1 / t405 * t334;
  t411 = 0.14e2 / 0.9e1 * t104 * t154 + 0.74e2 / 0.9e1 * t35 * t158 - 0.124e3 / 0.9e1 * t210 * t165 * t168 * sigma[0] + 0.32e2 / 0.3e1 * t35 * t407 * t161;
  t416 = 0.176e3 / 0.81e2 * t99 * t100 * t134 + 0.32e2 / 0.27e2 * t27 * t78 * t191 + 0.4e1 / 0.9e1 * t27 * t106 * t364 - 0.2e1 / 0.9e1 * t27 * t106 * t368 - 0.176e3 / 0.81e2 * t27 * t30 * t284 * t110 - 0.64e2 / 0.27e2 * t200 * t376 + 0.32e2 / 0.27e2 * t27 * t30 * t138 * t218 - 0.4e1 / 0.3e1 * t200 * t385 + 0.8e1 / 0.9e1 * t200 * t390 + 0.4e1 / 0.9e1 * t200 * t394 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t411;
  t421 = my_piecewise3(t2, 0, t6 * t124 * t115 / 0.12e2 - t6 * t58 * t223 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * t416);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t421 + 0.4e1 * t228;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t432 = t70 * t218;
  t440 = t299 * t235;
  t441 = t440 * t86;
  t442 = t106 * t441;
  t445 = t201 * t218;
  t446 = t106 * t445;
  t453 = t144 * t256;
  t454 = t453 * t86;
  t455 = t106 * t454;
  t463 = t28 * t213 * t168;
  t466 = t321 * rho[0];
  t468 = 0.1e1 / t466 * t334;
  t472 = t242 * t75 / 0.3e1 - t246 * t83 / 0.3e1 + 0.1e2 / 0.3e1 * t35 * t463 - 0.4e1 * t35 * t468 * sigma[0];
  t477 = 0.32e2 / 0.27e2 * t27 * t78 * t231 + 0.8e1 / 0.9e1 * t27 * t203 - 0.4e1 / 0.9e1 * t27 * t106 * t432 - 0.32e2 / 0.27e2 * t27 * t30 * t289 * t235 - 0.4e1 / 0.3e1 * t200 * t442 + 0.8e1 / 0.9e1 * t200 * t446 + 0.16e2 / 0.27e2 * t27 * t30 * t138 * t256 + 0.4e1 / 0.9e1 * t200 * t455 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t472;
  t482 = my_piecewise3(t2, 0, -t6 * t58 * t261 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t477);
  tv3rhosigma20 = 0.2e1 * rho[0] * t482 + 0.2e1 * t265;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t485 = t144 * t235;
  t489 = t70 * t256;
  t493 = t235 * t110;
  t498 = t201 * t256;
  t499 = t106 * t498;
  t504 = t35 / t36 / t161;
  t508 = t35 / t161;
  t513 = 0.1e1 / t321;
  t517 = 0.3e1 / 0.8e1 * t504 * t44 - 0.3e1 / 0.8e1 * t508 * t107 - t246 * t253 / 0.4e1 + 0.3e1 / 0.2e1 * t35 * t513 * t334;
  t522 = 0.4e1 / 0.3e1 * t27 * t106 * t485 - 0.2e1 / 0.3e1 * t27 * t106 * t489 - 0.4e1 / 0.3e1 * t27 * t30 * t300 * t493 + 0.4e1 / 0.3e1 * t200 * t499 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * t517;
  t526 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t522);
  tv3sigma30 = 0.2e1 * rho[0] * t526;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t543 = 0.1e1 / t32 / t211;
  t548 = t279 * t70;
  t553 = t133 * t144;
  t562 = t64 * t299;
  t575 = 0.1e1 / t298 / t46;
  t576 = t34 * t575;
  t577 = t146 * t146;
  t587 = t172 * t172;
  t609 = t321 * t131;
  t615 = t161 * t161;
  t622 = 0.1e1 / t81 / t332 / t80;
  t632 = 0.41888e5 / 0.729e3 * t27 * t30 * t543 * t47 + 0.9856e4 / 0.243e3 * t27 * t30 * t548 * t86 + 0.704e3 / 0.27e2 * t27 * t30 * t553 * t146 - 0.352e3 / 0.27e2 * t27 * t30 * t284 * t172 + 0.128e3 / 0.9e1 * t27 * t30 * t562 * t301 - 0.128e3 / 0.9e1 * t200 * t78 * t307 + 0.64e2 / 0.27e2 * t27 * t30 * t138 * t338 + 0.16e2 / 0.3e1 * t27 * t30 * t576 * t577 - 0.8e1 * t200 * t106 * t299 * t146 * t172 + 0.4e1 / 0.3e1 * t27 * t30 * t145 * t587 + 0.16e2 / 0.9e1 * t200 * t106 * t306 * t338 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * (0.364e4 / 0.81e2 * t37 * t252 * t43 + 0.5768e4 / 0.27e2 * t77 * t29 * t543 * t82 - 0.37216e5 / 0.81e2 * t162 * t28 / t18 / t466 * t168 + 0.1792e5 / 0.27e2 * t35 * t328 / t609 * t334 - 0.512e4 / 0.27e2 * t35 * t615 / t32 / t321 / t211 * t622 * t29);
  t637 = my_piecewise3(t2, 0, 0.1e2 / 0.27e2 * t6 * t17 * t64 * t52 - 0.5e1 / 0.9e1 * t6 * t268 * t91 + t6 * t124 * t177 / 0.2e1 - t6 * t58 * t343 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t19 * t632);
  tv4rho40 = 0.2e1 * rho[0] * t637 + 0.8e1 * t348;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t739 = t106 * t299;
  t740 = t110 * t86;
  t751 = 0.2464e4 / 0.243e3 * t27 * t30 * t548 * t110 + 0.352e3 / 0.27e2 * t200 * t157 * t202 - 0.64e2 / 0.9e1 * t200 * t78 * t389 - 0.32e2 / 0.9e1 * t200 * t78 * t393 - 0.4e1 * t200 * t106 * t299 * t218 * t146 + 0.4e1 / 0.3e1 * t200 * t106 * t144 * t411 * t86 + 0.4e1 / 0.3e1 * t200 * t106 * t388 * t172 + 0.16e2 / 0.3e1 * t200 * t106 * t575 * t110 * t301 - 0.4e1 * t200 * t739 * t740 * t172 + 0.32e2 / 0.3e1 * t200 * t78 * t384 - 0.32e2 / 0.9e1 * t27 * t78 * t364;
  t757 = my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t268 * t115 + t6 * t124 * t223 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t58 * t416 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.4e1 / 0.3e1 * t27 * t106 * t299 * t301 + 0.4e1 / 0.3e1 * t27 * t308 - 0.176e3 / 0.27e2 * t27 * t30 * t284 * t218 + 0.16e2 / 0.9e1 * t27 * t30 * t138 * t411 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * (-0.14e3 / 0.27e2 * t104 * t314 - 0.364e3 / 0.9e1 * t35 * t318 + 0.332e4 / 0.27e2 * t210 * t323 * t168 * sigma[0] - 0.1952e4 / 0.9e1 * t35 * t330 * t334 * t161 + 0.64e3 / 0.9e1 * t35 / t32 / t321 / t249 * t622 * t328 * t29) - 0.2464e4 / 0.243e3 * t99 * t100 * t280 - 0.176e3 / 0.27e2 * t27 * t157 * t191 + 0.16e2 / 0.9e1 * t27 * t78 * t368 - 0.2e1 / 0.9e1 * t27 * t106 * t70 * t338 + 0.4e1 / 0.9e1 * t200 * t106 * t201 * t338 + t751));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t757 + 0.6e1 * t421;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t821 = -0.128e3 / 0.27e2 * t27 * t376 + 0.16e2 / 0.9e1 * t27 * t390 + 0.8e1 / 0.9e1 * t27 * t394 + 0.32e2 / 0.27e2 * t27 * t30 * t138 * t472 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * (-0.7e1 / 0.9e1 * t242 * t154 + 0.7e1 / 0.9e1 * t246 * t158 - 0.22e2 * t35 * t169 + 0.188e3 / 0.3e1 * t35 * t407 * sigma[0] - 0.8e2 / 0.3e1 * t35 / t32 / t609 * t622 * t161 * t29) - 0.352e3 / 0.81e2 * t27 * t157 * t231 + 0.64e2 / 0.27e2 * t27 * t78 * t432 - 0.4e1 / 0.9e1 * t27 * t106 * t70 * t411 + 0.8e1 / 0.9e1 * t200 * t106 * t144 * t472 * t86 + 0.4e1 / 0.9e1 * t200 * t106 * t453 * t172 + 0.352e3 / 0.81e2 * t27 * t30 * t553 * t235;
  t832 = t218 * t218;
  t864 = 0.64e2 / 0.9e1 * t200 * t78 * t441 - 0.128e3 / 0.27e2 * t200 * t78 * t445 - 0.4e1 / 0.3e1 * t200 * t106 * t440 * t172 + 0.8e1 / 0.9e1 * t27 * t30 * t145 * t832 + 0.8e1 / 0.9e1 * t200 * t106 * t201 * t411 - 0.176e3 / 0.81e2 * t27 * t30 * t284 * t256 - 0.64e2 / 0.27e2 * t200 * t78 * t454 - 0.8e1 / 0.3e1 * t27 * t385 - 0.4e1 / 0.3e1 * t200 * t106 * t299 * t256 * t146 + 0.16e2 / 0.3e1 * t200 * t106 * t575 * t235 * t146 - 0.16e2 / 0.3e1 * t200 * t739 * t740 * t218;
  t870 = my_piecewise3(t2, 0, t6 * t124 * t261 / 0.12e2 - t6 * t58 * t477 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t821 + t864));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t870 + 0.4e1 * t482;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t950 = -0.32e2 / 0.9e1 * t27 * t78 * t485 - 0.4e1 * t27 * t442 + 0.8e1 / 0.3e1 * t27 * t446 + 0.16e2 / 0.9e1 * t27 * t78 * t489 + 0.4e1 / 0.3e1 * t27 * t455 - 0.2e1 / 0.3e1 * t27 * t106 * t70 * t472 + 0.32e2 / 0.9e1 * t27 * t30 * t562 * t493 + 0.16e2 / 0.3e1 * t200 * t106 * t575 * t493 * t86 - 0.4e1 * t200 * t106 * t440 * t218 - 0.32e2 / 0.9e1 * t200 * t78 * t498 - 0.4e1 * t200 * t739 * t110 * t256 * t86 + 0.4e1 / 0.3e1 * t200 * t106 * t388 * t256 + 0.4e1 / 0.3e1 * t200 * t106 * t201 * t472 + 0.16e2 / 0.27e2 * t27 * t30 * t138 * t517 + 0.4e1 / 0.9e1 * t200 * t106 * t144 * t517 * t86 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * (-t504 * t75 / 0.2e1 + t508 * t83 / 0.2e1 + t246 * t463 / 0.3e1 - 0.14e2 * t35 * t468 + 0.1e2 * t35 / t32 / t329 * t622 * sigma[0] * t29);
  t955 = my_piecewise3(t2, 0, -t6 * t58 * t522 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * t950);
  tv4rhosigma30 = 0.2e1 * rho[0] * t955 + 0.2e1 * t526;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t968 = t235 * t235;
  t977 = t256 * t256;
  t1016 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (-0.16e2 / 0.3e1 * t27 * t106 * t299 * t493 + 0.16e2 / 0.3e1 * t27 * t499 - 0.8e1 / 0.9e1 * t27 * t106 * t70 * t517 + 0.16e2 / 0.3e1 * t27 * t30 * t576 * t968 - 0.8e1 * t200 * t106 * t440 * t256 + 0.4e1 / 0.3e1 * t27 * t30 * t145 * t977 + 0.16e2 / 0.9e1 * t200 * t106 * t201 * t517 - 0.2e1 / 0.9e1 * t27 * t30 * t71 * (-0.15e2 / 0.16e2 * t35 / t36 / t328 * t44 + 0.15e2 / 0.16e2 * t35 / t328 * t107 + 0.5e1 / 0.8e1 * t508 * t253 + 0.3e1 / 0.4e1 * t35 * t245 * t513 * t334 - 0.15e2 / 0.4e1 * t35 / t32 / t405 * t622 * t29)));
  tv4sigma40 = 0.2e1 * rho[0] * t1016;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t42, t44, t45, t46, t49, t50, t55, t59;
  double t60, t61, t63, t64, t65, t66, t68, t69;
  double t70, t71, t72, t73, t75, t76, t78, t79;
  double t80, t83, t84, t89, t93, tzk0;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = t2 * t2;
  t29 = params->beta * t28;
  t31 = POW_1_3(0.1e1 / M_PI);
  t32 = 0.1e1 / t31;
  t33 = t29 * t32;
  t34 = M_CBRT4;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = params->gamma * params->beta;
  t42 = sqrt(sigma[0]);
  t44 = 0.1e1 / t37 / rho[0];
  t45 = t42 * t44;
  t46 = log(t45 + sqrt(t45 * t45 + 0.1e1));
  t49 = t41 * t45 * t46 + 0.1e1;
  t50 = 0.1e1 / t49;
  t55 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t35 * t40 * t50;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = t34 * sigma[2];
  t71 = rho[1] * rho[1];
  t72 = POW_1_3(rho[1]);
  t73 = t72 * t72;
  t75 = 0.1e1 / t73 / t71;
  t76 = sqrt(sigma[2]);
  t78 = 0.1e1 / t72 / rho[1];
  t79 = t76 * t78;
  t80 = log(t79 + sqrt(t79 * t79 + 0.1e1));
  t83 = t41 * t79 * t80 + 0.1e1;
  t84 = 0.1e1 / t83;
  t89 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t70 * t75 * t84;
  t93 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t89);
  tzk0 = t59 + t93;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t42, t44, t45, t46, t49, t50, t55, t59;
  double t60, t61, t63, t64, t65, t66, t68, t69;
  double t70, t71, t72, t73, t75, t76, t78, t79;
  double t80, t83, t84, t89, t93, tzk0;

  double t94, t95, t96, t98, t101, t102, t106, t107;
  double t108, t111, t112, t114, t119, t120, t121, t122;
  double t123, t125, t129, t130, t131, t132, t136, t137;
  double t141, t146, t147, t149, t152, t153, t157, t160;
  double t162, tvrho0, t166, t169, t170, t175, t177, t180;
  double t181, t185, t187, t192, t193, t194, t196, t200;
  double t201, t202, t203, t207, t208, t212, t217, tvrho1;
  double t220, t223, t230, t231, t235, t239, tvsigma0, tvsigma1;
  double t240, t243, t250, t251, t255, t259, tvsigma2;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = t2 * t2;
  t29 = params->beta * t28;
  t31 = POW_1_3(0.1e1 / M_PI);
  t32 = 0.1e1 / t31;
  t33 = t29 * t32;
  t34 = M_CBRT4;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = params->gamma * params->beta;
  t42 = sqrt(sigma[0]);
  t44 = 0.1e1 / t37 / rho[0];
  t45 = t42 * t44;
  t46 = log(t45 + sqrt(t45 * t45 + 0.1e1));
  t49 = t41 * t45 * t46 + 0.1e1;
  t50 = 0.1e1 / t49;
  t55 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t35 * t40 * t50;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = t34 * sigma[2];
  t71 = rho[1] * rho[1];
  t72 = POW_1_3(rho[1]);
  t73 = t72 * t72;
  t75 = 0.1e1 / t73 / t71;
  t76 = sqrt(sigma[2]);
  t78 = 0.1e1 / t72 / rho[1];
  t79 = t76 * t78;
  t80 = log(t79 + sqrt(t79 * t79 + 0.1e1));
  t83 = t41 * t79 * t80 + 0.1e1;
  t84 = 0.1e1 / t83;
  t89 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t70 * t75 * t84;
  t93 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t89);
  tzk0 = t59 + t93;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t94 = t6 * t6;
  t95 = 0.1e1 / t94;
  t96 = t16 * t95;
  t98 = my_piecewise5(t10, 0, t14, 0, t7 - t96);
  t101 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t98);
  t102 = t101 * t26;
  t106 = t26 * t26;
  t107 = 0.1e1 / t106;
  t108 = t25 * t107;
  t111 = t5 * t108 * t55 / 0.8e1;
  t112 = t36 * rho[0];
  t114 = 0.1e1 / t38 / t112;
  t119 = t32 * t34;
  t120 = t29 * t119;
  t121 = sigma[0] * t40;
  t122 = t49 * t49;
  t123 = 0.1e1 / t122;
  t125 = 0.1e1 / t37 / t36;
  t129 = sigma[0] * t114;
  t130 = t121 + 0.1e1;
  t131 = sqrt(t130);
  t132 = 0.1e1 / t131;
  t136 = -0.4e1 / 0.3e1 * t41 * t42 * t125 * t46 - 0.4e1 / 0.3e1 * t41 * t129 * t132;
  t137 = t123 * t136;
  t141 = -0.16e2 / 0.27e2 * t33 * t35 * t114 * t50 - 0.2e1 / 0.9e1 * t120 * t121 * t137;
  t146 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t55 - t111 - 0.3e1 / 0.8e1 * t5 * t27 * t141);
  t147 = t61 * t95;
  t149 = my_piecewise5(t14, 0, t10, 0, -t7 - t147);
  t152 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t149);
  t153 = t152 * t26;
  t157 = t68 * t107;
  t160 = t5 * t157 * t89 / 0.8e1;
  t162 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t89 - t160);
  tvrho0 = t59 + t93 + t6 * (t146 + t162);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t166 = my_piecewise5(t10, 0, t14, 0, -t7 - t96);
  t169 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t166);
  t170 = t169 * t26;
  t175 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t55 - t111);
  t177 = my_piecewise5(t14, 0, t10, 0, t7 - t147);
  t180 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t177);
  t181 = t180 * t26;
  t185 = t71 * rho[1];
  t187 = 0.1e1 / t73 / t185;
  t192 = sigma[2] * t75;
  t193 = t83 * t83;
  t194 = 0.1e1 / t193;
  t196 = 0.1e1 / t72 / t71;
  t200 = sigma[2] * t187;
  t201 = t192 + 0.1e1;
  t202 = sqrt(t201);
  t203 = 0.1e1 / t202;
  t207 = -0.4e1 / 0.3e1 * t41 * t76 * t196 * t80 - 0.4e1 / 0.3e1 * t41 * t200 * t203;
  t208 = t194 * t207;
  t212 = -0.16e2 / 0.27e2 * t33 * t70 * t187 * t84 - 0.2e1 / 0.9e1 * t120 * t192 * t208;
  t217 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t89 - t160 - 0.3e1 / 0.8e1 * t5 * t69 * t212);
  tvrho1 = t59 + t93 + t6 * (t175 + t217);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t220 = t34 * t40;
  t223 = 0.1e1 / t42;
  t230 = t41 * t223 * t44 * t46 / 0.2e1 + t41 * t40 * t132 / 0.2e1;
  t231 = t123 * t230;
  t235 = -0.2e1 / 0.9e1 * t120 * t121 * t231 + 0.2e1 / 0.9e1 * t33 * t220 * t50;
  t239 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t235);
  tvsigma0 = t6 * t239;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t240 = t34 * t75;
  t243 = 0.1e1 / t76;
  t250 = t41 * t243 * t78 * t80 / 0.2e1 + t41 * t75 * t203 / 0.2e1;
  t251 = t194 * t250;
  t255 = -0.2e1 / 0.9e1 * t120 * t192 * t251 + 0.2e1 / 0.9e1 * t33 * t240 * t84;
  t259 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t255);
  tvsigma2 = t6 * t259;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t42, t44, t45, t46, t49, t50, t55, t59;
  double t60, t61, t63, t64, t65, t66, t68, t69;
  double t70, t71, t72, t73, t75, t76, t78, t79;
  double t80, t83, t84, t89, t93, tzk0;

  double t94, t95, t96, t98, t101, t102, t106, t107;
  double t108, t111, t112, t114, t119, t120, t121, t122;
  double t123, t125, t129, t130, t131, t132, t136, t137;
  double t141, t146, t147, t149, t152, t153, t157, t160;
  double t162, tvrho0, t166, t169, t170, t175, t177, t180;
  double t181, t185, t187, t192, t193, t194, t196, t200;
  double t201, t202, t203, t207, t208, t212, t217, tvrho1;
  double t220, t223, t230, t231, t235, t239, tvsigma0, tvsigma1;
  double t240, t243, t250, t251, t255, t259, tvsigma2;

  double t262, t263, t264, t267, t268, t269, t272, t276;
  double t277, t281, t283, t289, t290, t293, t295, t297;
  double t299, t308, t309, t310, t315, t320, t324, t327;
  double t330, t334, t335, t339, t344, t345, t346, t347;
  double t350, t353, t357, t358, t362, t364, t366, t369;
  double t371, tv2rho20, t374, t378, t382, t383, t387, t389;
  double t397, t398, t402, t406, t407, t411, t413, t420;
  double t423, tv2rho21, t428, t433, t437, t438, t444, t445;
  double t450, t454, t455, t464, t466, t475, t476, t477;
  double t482, t487, t491, t494, t497, t501, t502, t506;
  double t511, tv2rho22, t519, t520, t530, t531, t542, t544;
  double t545, t549, t550, t554, t559, tv2rhosigma0, tv2rhosigma1, t566;
  double t568, tv2rhosigma2, t574, tv2rhosigma3, tv2rhosigma4, t579, t589, t590;
  double t601, t603, t604, t608, t609, t613, t618, tv2rhosigma5;
  double t623, t624, t629, t633, t637, t639, t643, t644;
  double t648, t652, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t656;
  double t657, t662, t666, t670, t672, t676, t677, t681;
  double t685, tv2sigma25;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = t2 * t2;
  t29 = params->beta * t28;
  t31 = POW_1_3(0.1e1 / M_PI);
  t32 = 0.1e1 / t31;
  t33 = t29 * t32;
  t34 = M_CBRT4;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = params->gamma * params->beta;
  t42 = sqrt(sigma[0]);
  t44 = 0.1e1 / t37 / rho[0];
  t45 = t42 * t44;
  t46 = log(t45 + sqrt(t45 * t45 + 0.1e1));
  t49 = t41 * t45 * t46 + 0.1e1;
  t50 = 0.1e1 / t49;
  t55 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t35 * t40 * t50;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = t34 * sigma[2];
  t71 = rho[1] * rho[1];
  t72 = POW_1_3(rho[1]);
  t73 = t72 * t72;
  t75 = 0.1e1 / t73 / t71;
  t76 = sqrt(sigma[2]);
  t78 = 0.1e1 / t72 / rho[1];
  t79 = t76 * t78;
  t80 = log(t79 + sqrt(t79 * t79 + 0.1e1));
  t83 = t41 * t79 * t80 + 0.1e1;
  t84 = 0.1e1 / t83;
  t89 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t70 * t75 * t84;
  t93 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t89);
  tzk0 = t59 + t93;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t94 = t6 * t6;
  t95 = 0.1e1 / t94;
  t96 = t16 * t95;
  t98 = my_piecewise5(t10, 0, t14, 0, t7 - t96);
  t101 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t98);
  t102 = t101 * t26;
  t106 = t26 * t26;
  t107 = 0.1e1 / t106;
  t108 = t25 * t107;
  t111 = t5 * t108 * t55 / 0.8e1;
  t112 = t36 * rho[0];
  t114 = 0.1e1 / t38 / t112;
  t119 = t32 * t34;
  t120 = t29 * t119;
  t121 = sigma[0] * t40;
  t122 = t49 * t49;
  t123 = 0.1e1 / t122;
  t125 = 0.1e1 / t37 / t36;
  t129 = sigma[0] * t114;
  t130 = t121 + 0.1e1;
  t131 = sqrt(t130);
  t132 = 0.1e1 / t131;
  t136 = -0.4e1 / 0.3e1 * t41 * t42 * t125 * t46 - 0.4e1 / 0.3e1 * t41 * t129 * t132;
  t137 = t123 * t136;
  t141 = -0.16e2 / 0.27e2 * t33 * t35 * t114 * t50 - 0.2e1 / 0.9e1 * t120 * t121 * t137;
  t146 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t55 - t111 - 0.3e1 / 0.8e1 * t5 * t27 * t141);
  t147 = t61 * t95;
  t149 = my_piecewise5(t14, 0, t10, 0, -t7 - t147);
  t152 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t149);
  t153 = t152 * t26;
  t157 = t68 * t107;
  t160 = t5 * t157 * t89 / 0.8e1;
  t162 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t89 - t160);
  tvrho0 = t59 + t93 + t6 * (t146 + t162);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t166 = my_piecewise5(t10, 0, t14, 0, -t7 - t96);
  t169 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t166);
  t170 = t169 * t26;
  t175 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t55 - t111);
  t177 = my_piecewise5(t14, 0, t10, 0, t7 - t147);
  t180 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t177);
  t181 = t180 * t26;
  t185 = t71 * rho[1];
  t187 = 0.1e1 / t73 / t185;
  t192 = sigma[2] * t75;
  t193 = t83 * t83;
  t194 = 0.1e1 / t193;
  t196 = 0.1e1 / t72 / t71;
  t200 = sigma[2] * t187;
  t201 = t192 + 0.1e1;
  t202 = sqrt(t201);
  t203 = 0.1e1 / t202;
  t207 = -0.4e1 / 0.3e1 * t41 * t76 * t196 * t80 - 0.4e1 / 0.3e1 * t41 * t200 * t203;
  t208 = t194 * t207;
  t212 = -0.16e2 / 0.27e2 * t33 * t70 * t187 * t84 - 0.2e1 / 0.9e1 * t120 * t192 * t208;
  t217 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t89 - t160 - 0.3e1 / 0.8e1 * t5 * t69 * t212);
  tvrho1 = t59 + t93 + t6 * (t175 + t217);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t220 = t34 * t40;
  t223 = 0.1e1 / t42;
  t230 = t41 * t223 * t44 * t46 / 0.2e1 + t41 * t40 * t132 / 0.2e1;
  t231 = t123 * t230;
  t235 = -0.2e1 / 0.9e1 * t120 * t121 * t231 + 0.2e1 / 0.9e1 * t33 * t220 * t50;
  t239 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t235);
  tvsigma0 = t6 * t239;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t240 = t34 * t75;
  t243 = 0.1e1 / t76;
  t250 = t41 * t243 * t78 * t80 / 0.2e1 + t41 * t75 * t203 / 0.2e1;
  t251 = t194 * t250;
  t255 = -0.2e1 / 0.9e1 * t120 * t192 * t251 + 0.2e1 / 0.9e1 * t33 * t240 * t84;
  t259 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t255);
  tvsigma2 = t6 * t259;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t262 = t23 * t23;
  t263 = 0.1e1 / t262;
  t264 = t98 * t98;
  t267 = t94 * t6;
  t268 = 0.1e1 / t267;
  t269 = t16 * t268;
  t272 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t95 + 0.2e1 * t269);
  t276 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t263 * t264 + 0.4e1 / 0.3e1 * t23 * t272);
  t277 = t276 * t26;
  t281 = t101 * t107;
  t283 = t5 * t281 * t55;
  t289 = 0.1e1 / t106 / t6;
  t290 = t25 * t289;
  t293 = t5 * t290 * t55 / 0.12e2;
  t295 = t5 * t108 * t141;
  t297 = t36 * t36;
  t299 = 0.1e1 / t38 / t297;
  t308 = 0.1e1 / t122 / t49;
  t309 = t136 * t136;
  t310 = t308 * t309;
  t315 = 0.1e1 / t37 / t112;
  t320 = sigma[0] * t299;
  t324 = sigma[0] * sigma[0];
  t327 = 0.1e1 / t37 / t297 / t112;
  t330 = 0.1e1 / t131 / t130;
  t334 = 0.28e2 / 0.9e1 * t41 * t42 * t315 * t46 + 0.2e2 / 0.3e1 * t41 * t320 * t132 - 0.16e2 / 0.9e1 * t41 * t324 * t327 * t330;
  t335 = t123 * t334;
  t339 = 0.176e3 / 0.81e2 * t33 * t35 * t299 * t50 + 0.32e2 / 0.27e2 * t120 * t129 * t137 + 0.4e1 / 0.9e1 * t120 * t121 * t310 - 0.2e1 / 0.9e1 * t120 * t121 * t335;
  t344 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t55 - t283 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t102 * t141 + t293 - t295 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t339);
  t345 = t66 * t66;
  t346 = 0.1e1 / t345;
  t347 = t149 * t149;
  t350 = t61 * t268;
  t353 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t95 + 0.2e1 * t350);
  t357 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t346 * t347 + 0.4e1 / 0.3e1 * t66 * t353);
  t358 = t357 * t26;
  t362 = t152 * t107;
  t364 = t5 * t362 * t89;
  t366 = t68 * t289;
  t369 = t5 * t366 * t89 / 0.12e2;
  t371 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t358 * t89 - t364 / 0.4e1 + t369);
  tv2rho20 = 0.2e1 * t146 + 0.2e1 * t162 + t6 * (t344 + t371);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t374 = t263 * t166;
  t378 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t269);
  t382 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t374 * t98 + 0.4e1 / 0.3e1 * t23 * t378);
  t383 = t382 * t26;
  t387 = t169 * t107;
  t389 = t5 * t387 * t55;
  t397 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t383 * t55 - t389 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t170 * t141 - t283 / 0.8e1 + t293 - t295 / 0.8e1);
  t398 = t346 * t177;
  t402 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t350);
  t406 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t398 * t149 + 0.4e1 / 0.3e1 * t66 * t402);
  t407 = t406 * t26;
  t411 = t180 * t107;
  t413 = t5 * t411 * t89;
  t420 = t5 * t157 * t212;
  t423 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t407 * t89 - t413 / 0.8e1 - t364 / 0.8e1 + t369 - 0.3e1 / 0.8e1 * t5 * t153 * t212 - t420 / 0.8e1);
  tv2rho21 = t146 + t162 + t175 + t217 + t6 * (t397 + t423);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t428 = t166 * t166;
  t433 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t95 + 0.2e1 * t269);
  t437 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t263 * t428 + 0.4e1 / 0.3e1 * t23 * t433);
  t438 = t437 * t26;
  t444 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t438 * t55 - t389 / 0.4e1 + t293);
  t445 = t177 * t177;
  t450 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t95 + 0.2e1 * t350);
  t454 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t346 * t445 + 0.4e1 / 0.3e1 * t66 * t450);
  t455 = t454 * t26;
  t464 = t71 * t71;
  t466 = 0.1e1 / t73 / t464;
  t475 = 0.1e1 / t193 / t83;
  t476 = t207 * t207;
  t477 = t475 * t476;
  t482 = 0.1e1 / t72 / t185;
  t487 = sigma[2] * t466;
  t491 = sigma[2] * sigma[2];
  t494 = 0.1e1 / t72 / t464 / t185;
  t497 = 0.1e1 / t202 / t201;
  t501 = 0.28e2 / 0.9e1 * t41 * t76 * t482 * t80 + 0.2e2 / 0.3e1 * t41 * t487 * t203 - 0.16e2 / 0.9e1 * t41 * t491 * t494 * t497;
  t502 = t194 * t501;
  t506 = 0.176e3 / 0.81e2 * t33 * t70 * t466 * t84 + 0.32e2 / 0.27e2 * t120 * t200 * t208 + 0.4e1 / 0.9e1 * t120 * t192 * t477 - 0.2e1 / 0.9e1 * t120 * t192 * t502;
  t511 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t455 * t89 - t413 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t181 * t212 + t369 - t420 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t506);
  tv2rho22 = 0.2e1 * t175 + 0.2e1 * t217 + t6 * (t444 + t511);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t519 = t5 * t108 * t235 / 0.8e1;
  t520 = t34 * t114;
  t530 = t308 * t230;
  t531 = t530 * t136;
  t542 = t297 * t36;
  t544 = 0.1e1 / t37 / t542;
  t545 = t544 * t330;
  t549 = -0.2e1 / 0.3e1 * t41 * t223 * t125 * t46 - 0.2e1 * t41 * t114 * t132 + 0.2e1 / 0.3e1 * t41 * t545 * sigma[0];
  t550 = t123 * t549;
  t554 = -0.16e2 / 0.27e2 * t33 * t520 * t50 - 0.2e1 / 0.9e1 * t33 * t220 * t137 + 0.16e2 / 0.27e2 * t120 * t129 * t231 + 0.4e1 / 0.9e1 * t120 * t121 * t531 - 0.2e1 / 0.9e1 * t120 * t121 * t550;
  t559 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t235 - t519 - 0.3e1 / 0.8e1 * t5 * t27 * t554);
  tv2rhosigma0 = t6 * t559 + t239;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t566 = t5 * t157 * t255 / 0.8e1;
  t568 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t255 - t566);
  tv2rhosigma2 = t6 * t568 + t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t574 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t235 - t519);
  tv2rhosigma3 = t6 * t574 + t239;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t579 = t34 * t187;
  t589 = t475 * t250;
  t590 = t589 * t207;
  t601 = t464 * t71;
  t603 = 0.1e1 / t72 / t601;
  t604 = t603 * t497;
  t608 = -0.2e1 / 0.3e1 * t41 * t243 * t196 * t80 - 0.2e1 * t41 * t187 * t203 + 0.2e1 / 0.3e1 * t41 * t604 * sigma[2];
  t609 = t194 * t608;
  t613 = -0.16e2 / 0.27e2 * t33 * t579 * t84 - 0.2e1 / 0.9e1 * t33 * t240 * t208 + 0.16e2 / 0.27e2 * t120 * t200 * t251 + 0.4e1 / 0.9e1 * t120 * t192 * t590 - 0.2e1 / 0.9e1 * t120 * t192 * t609;
  t618 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t255 - t566 - 0.3e1 / 0.8e1 * t5 * t69 * t613);
  tv2rhosigma5 = t6 * t618 + t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t623 = t230 * t230;
  t624 = t308 * t623;
  t629 = 0.1e1 / t42 / sigma[0];
  t633 = 0.1e1 / sigma[0];
  t637 = t297 * rho[0];
  t639 = 0.1e1 / t37 / t637;
  t643 = t41 * t633 * t40 * t132 / 0.4e1 - t41 * t629 * t44 * t46 / 0.4e1 - t41 * t639 * t330 / 0.4e1;
  t644 = t123 * t643;
  t648 = -0.4e1 / 0.9e1 * t33 * t220 * t231 + 0.4e1 / 0.9e1 * t120 * t121 * t624 - 0.2e1 / 0.9e1 * t120 * t121 * t644;
  t652 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t648);
  tv2sigma20 = t6 * t652;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t656 = t250 * t250;
  t657 = t475 * t656;
  t662 = 0.1e1 / t76 / sigma[2];
  t666 = 0.1e1 / sigma[2];
  t670 = t464 * rho[1];
  t672 = 0.1e1 / t72 / t670;
  t676 = t41 * t666 * t75 * t203 / 0.4e1 - t41 * t662 * t78 * t80 / 0.4e1 - t41 * t672 * t497 / 0.4e1;
  t677 = t194 * t676;
  t681 = -0.4e1 / 0.9e1 * t33 * t240 * t251 + 0.4e1 / 0.9e1 * t120 * t192 * t657 - 0.2e1 / 0.9e1 * t120 * t192 * t677;
  t685 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t681);
  tv2sigma25 = t6 * t685;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t42, t44, t45, t46, t49, t50, t55, t59;
  double t60, t61, t63, t64, t65, t66, t68, t69;
  double t70, t71, t72, t73, t75, t76, t78, t79;
  double t80, t83, t84, t89, t93, tzk0;

  double t94, t95, t96, t98, t101, t102, t106, t107;
  double t108, t111, t112, t114, t119, t120, t121, t122;
  double t123, t125, t129, t130, t131, t132, t136, t137;
  double t141, t146, t147, t149, t152, t153, t157, t160;
  double t162, tvrho0, t166, t169, t170, t175, t177, t180;
  double t181, t185, t187, t192, t193, t194, t196, t200;
  double t201, t202, t203, t207, t208, t212, t217, tvrho1;
  double t220, t223, t230, t231, t235, t239, tvsigma0, tvsigma1;
  double t240, t243, t250, t251, t255, t259, tvsigma2;

  double t262, t263, t264, t267, t268, t269, t272, t276;
  double t277, t281, t283, t289, t290, t293, t295, t297;
  double t299, t308, t309, t310, t315, t320, t324, t327;
  double t330, t334, t335, t339, t344, t345, t346, t347;
  double t350, t353, t357, t358, t362, t364, t366, t369;
  double t371, tv2rho20, t374, t378, t382, t383, t387, t389;
  double t397, t398, t402, t406, t407, t411, t413, t420;
  double t423, tv2rho21, t428, t433, t437, t438, t444, t445;
  double t450, t454, t455, t464, t466, t475, t476, t477;
  double t482, t487, t491, t494, t497, t501, t502, t506;
  double t511, tv2rho22, t519, t520, t530, t531, t542, t544;
  double t545, t549, t550, t554, t559, tv2rhosigma0, tv2rhosigma1, t566;
  double t568, tv2rhosigma2, t574, tv2rhosigma3, tv2rhosigma4, t579, t589, t590;
  double t601, t603, t604, t608, t609, t613, t618, tv2rhosigma5;
  double t623, t624, t629, t633, t637, t639, t643, t644;
  double t648, t652, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t656;
  double t657, t662, t666, t670, t672, t676, t677, t681;
  double t685, tv2sigma25;

  double t689, t690, t693, t696, t697, t698, t701, t705;
  double t706, t710, t712, t717, t719, t722, t728, t729;
  double t732, t734, t737, t740, t754, t755, t756, t757;
  double t761, t762, t767, t772, t776, t778, t783, t784;
  double t785, t787, t789, t793, t794, t798, t803, t805;
  double t806, t809, t812, t815, t819, t820, t824, t826;
  double t828, t830, t832, t835, t837, tv3rho30, t840, t841;
  double t842, t845, t850, t851, t853, t857, t858, t862;
  double t865, t869, t871, t875, t884, t885, t886, t889;
  double t894, t896, t900, t901, t905, t908, t909, t911;
  double t920, t922, t925, tv3rho31, t928, t933, t937, t941;
  double t942, t946, t948, t957, t958, t963, t967, t971;
  double t972, t976, t978, t985, t993, t995, t996, tv3rho32;
  double t1001, t1008, t1012, t1013, t1020, t1021, t1028, t1032;
  double t1033, t1049, t1063, t1064, t1065, t1066, t1070, t1071;
  double t1076, t1081, t1085, t1087, t1092, t1093, t1094, t1096;
  double t1098, t1102, t1103, t1107, t1112, tv3rho33, t1120, t1127;
  double t1129, t1131, t1154, t1158, t1159, t1163, t1174, t1178;
  double t1180, t1184, t1185, t1189, t1194, tv3rho2sigma0, tv3rho2sigma1, t1201;
  double t1205, t1207, tv3rho2sigma2, t1213, t1221, tv3rho2sigma3, tv3rho2sigma4, t1227;
  double t1234, t1237, tv3rho2sigma5, t1245, tv3rho2sigma6, tv3rho2sigma7, t1256, t1279;
  double t1283, t1284, t1288, t1299, t1303, t1305, t1309, t1310;
  double t1314, t1319, tv3rho2sigma8, t1326, t1330, t1331, t1341, t1342;
  double t1346, t1353, t1354, t1368, t1370, t1373, t1374, t1378;
  double t1383, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1390, t1392;
  double tv3rhosigma25, t1398, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1406;
  double t1407, t1417, t1418, t1422, t1429, t1430, t1444, t1446;
  double t1449, t1450, t1454, t1459, tv3rhosigma211, t1467, t1468, t1472;
  double t1477, t1482, t1491, t1495, t1496, t1500, t1504, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t1511, t1512, t1516, t1521, t1526, t1535, t1539, t1540;
  double t1544, t1548, tv3sigma39;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = t2 * t2;
  t29 = params->beta * t28;
  t31 = POW_1_3(0.1e1 / M_PI);
  t32 = 0.1e1 / t31;
  t33 = t29 * t32;
  t34 = M_CBRT4;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = params->gamma * params->beta;
  t42 = sqrt(sigma[0]);
  t44 = 0.1e1 / t37 / rho[0];
  t45 = t42 * t44;
  t46 = log(t45 + sqrt(t45 * t45 + 0.1e1));
  t49 = t41 * t45 * t46 + 0.1e1;
  t50 = 0.1e1 / t49;
  t55 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t35 * t40 * t50;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = t34 * sigma[2];
  t71 = rho[1] * rho[1];
  t72 = POW_1_3(rho[1]);
  t73 = t72 * t72;
  t75 = 0.1e1 / t73 / t71;
  t76 = sqrt(sigma[2]);
  t78 = 0.1e1 / t72 / rho[1];
  t79 = t76 * t78;
  t80 = log(t79 + sqrt(t79 * t79 + 0.1e1));
  t83 = t41 * t79 * t80 + 0.1e1;
  t84 = 0.1e1 / t83;
  t89 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t70 * t75 * t84;
  t93 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t89);
  tzk0 = t59 + t93;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t94 = t6 * t6;
  t95 = 0.1e1 / t94;
  t96 = t16 * t95;
  t98 = my_piecewise5(t10, 0, t14, 0, t7 - t96);
  t101 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t98);
  t102 = t101 * t26;
  t106 = t26 * t26;
  t107 = 0.1e1 / t106;
  t108 = t25 * t107;
  t111 = t5 * t108 * t55 / 0.8e1;
  t112 = t36 * rho[0];
  t114 = 0.1e1 / t38 / t112;
  t119 = t32 * t34;
  t120 = t29 * t119;
  t121 = sigma[0] * t40;
  t122 = t49 * t49;
  t123 = 0.1e1 / t122;
  t125 = 0.1e1 / t37 / t36;
  t129 = sigma[0] * t114;
  t130 = t121 + 0.1e1;
  t131 = sqrt(t130);
  t132 = 0.1e1 / t131;
  t136 = -0.4e1 / 0.3e1 * t41 * t42 * t125 * t46 - 0.4e1 / 0.3e1 * t41 * t129 * t132;
  t137 = t123 * t136;
  t141 = -0.16e2 / 0.27e2 * t33 * t35 * t114 * t50 - 0.2e1 / 0.9e1 * t120 * t121 * t137;
  t146 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t55 - t111 - 0.3e1 / 0.8e1 * t5 * t27 * t141);
  t147 = t61 * t95;
  t149 = my_piecewise5(t14, 0, t10, 0, -t7 - t147);
  t152 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t149);
  t153 = t152 * t26;
  t157 = t68 * t107;
  t160 = t5 * t157 * t89 / 0.8e1;
  t162 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t89 - t160);
  tvrho0 = t59 + t93 + t6 * (t146 + t162);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t166 = my_piecewise5(t10, 0, t14, 0, -t7 - t96);
  t169 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t166);
  t170 = t169 * t26;
  t175 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t55 - t111);
  t177 = my_piecewise5(t14, 0, t10, 0, t7 - t147);
  t180 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t177);
  t181 = t180 * t26;
  t185 = t71 * rho[1];
  t187 = 0.1e1 / t73 / t185;
  t192 = sigma[2] * t75;
  t193 = t83 * t83;
  t194 = 0.1e1 / t193;
  t196 = 0.1e1 / t72 / t71;
  t200 = sigma[2] * t187;
  t201 = t192 + 0.1e1;
  t202 = sqrt(t201);
  t203 = 0.1e1 / t202;
  t207 = -0.4e1 / 0.3e1 * t41 * t76 * t196 * t80 - 0.4e1 / 0.3e1 * t41 * t200 * t203;
  t208 = t194 * t207;
  t212 = -0.16e2 / 0.27e2 * t33 * t70 * t187 * t84 - 0.2e1 / 0.9e1 * t120 * t192 * t208;
  t217 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t89 - t160 - 0.3e1 / 0.8e1 * t5 * t69 * t212);
  tvrho1 = t59 + t93 + t6 * (t175 + t217);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t220 = t34 * t40;
  t223 = 0.1e1 / t42;
  t230 = t41 * t223 * t44 * t46 / 0.2e1 + t41 * t40 * t132 / 0.2e1;
  t231 = t123 * t230;
  t235 = -0.2e1 / 0.9e1 * t120 * t121 * t231 + 0.2e1 / 0.9e1 * t33 * t220 * t50;
  t239 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t235);
  tvsigma0 = t6 * t239;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t240 = t34 * t75;
  t243 = 0.1e1 / t76;
  t250 = t41 * t243 * t78 * t80 / 0.2e1 + t41 * t75 * t203 / 0.2e1;
  t251 = t194 * t250;
  t255 = -0.2e1 / 0.9e1 * t120 * t192 * t251 + 0.2e1 / 0.9e1 * t33 * t240 * t84;
  t259 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t255);
  tvsigma2 = t6 * t259;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t262 = t23 * t23;
  t263 = 0.1e1 / t262;
  t264 = t98 * t98;
  t267 = t94 * t6;
  t268 = 0.1e1 / t267;
  t269 = t16 * t268;
  t272 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t95 + 0.2e1 * t269);
  t276 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t263 * t264 + 0.4e1 / 0.3e1 * t23 * t272);
  t277 = t276 * t26;
  t281 = t101 * t107;
  t283 = t5 * t281 * t55;
  t289 = 0.1e1 / t106 / t6;
  t290 = t25 * t289;
  t293 = t5 * t290 * t55 / 0.12e2;
  t295 = t5 * t108 * t141;
  t297 = t36 * t36;
  t299 = 0.1e1 / t38 / t297;
  t308 = 0.1e1 / t122 / t49;
  t309 = t136 * t136;
  t310 = t308 * t309;
  t315 = 0.1e1 / t37 / t112;
  t320 = sigma[0] * t299;
  t324 = sigma[0] * sigma[0];
  t327 = 0.1e1 / t37 / t297 / t112;
  t330 = 0.1e1 / t131 / t130;
  t334 = 0.28e2 / 0.9e1 * t41 * t42 * t315 * t46 + 0.2e2 / 0.3e1 * t41 * t320 * t132 - 0.16e2 / 0.9e1 * t41 * t324 * t327 * t330;
  t335 = t123 * t334;
  t339 = 0.176e3 / 0.81e2 * t33 * t35 * t299 * t50 + 0.32e2 / 0.27e2 * t120 * t129 * t137 + 0.4e1 / 0.9e1 * t120 * t121 * t310 - 0.2e1 / 0.9e1 * t120 * t121 * t335;
  t344 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t55 - t283 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t102 * t141 + t293 - t295 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t339);
  t345 = t66 * t66;
  t346 = 0.1e1 / t345;
  t347 = t149 * t149;
  t350 = t61 * t268;
  t353 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t95 + 0.2e1 * t350);
  t357 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t346 * t347 + 0.4e1 / 0.3e1 * t66 * t353);
  t358 = t357 * t26;
  t362 = t152 * t107;
  t364 = t5 * t362 * t89;
  t366 = t68 * t289;
  t369 = t5 * t366 * t89 / 0.12e2;
  t371 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t358 * t89 - t364 / 0.4e1 + t369);
  tv2rho20 = 0.2e1 * t146 + 0.2e1 * t162 + t6 * (t344 + t371);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t374 = t263 * t166;
  t378 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t269);
  t382 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t374 * t98 + 0.4e1 / 0.3e1 * t23 * t378);
  t383 = t382 * t26;
  t387 = t169 * t107;
  t389 = t5 * t387 * t55;
  t397 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t383 * t55 - t389 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t170 * t141 - t283 / 0.8e1 + t293 - t295 / 0.8e1);
  t398 = t346 * t177;
  t402 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t350);
  t406 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t398 * t149 + 0.4e1 / 0.3e1 * t66 * t402);
  t407 = t406 * t26;
  t411 = t180 * t107;
  t413 = t5 * t411 * t89;
  t420 = t5 * t157 * t212;
  t423 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t407 * t89 - t413 / 0.8e1 - t364 / 0.8e1 + t369 - 0.3e1 / 0.8e1 * t5 * t153 * t212 - t420 / 0.8e1);
  tv2rho21 = t146 + t162 + t175 + t217 + t6 * (t397 + t423);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t428 = t166 * t166;
  t433 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t95 + 0.2e1 * t269);
  t437 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t263 * t428 + 0.4e1 / 0.3e1 * t23 * t433);
  t438 = t437 * t26;
  t444 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t438 * t55 - t389 / 0.4e1 + t293);
  t445 = t177 * t177;
  t450 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t95 + 0.2e1 * t350);
  t454 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t346 * t445 + 0.4e1 / 0.3e1 * t66 * t450);
  t455 = t454 * t26;
  t464 = t71 * t71;
  t466 = 0.1e1 / t73 / t464;
  t475 = 0.1e1 / t193 / t83;
  t476 = t207 * t207;
  t477 = t475 * t476;
  t482 = 0.1e1 / t72 / t185;
  t487 = sigma[2] * t466;
  t491 = sigma[2] * sigma[2];
  t494 = 0.1e1 / t72 / t464 / t185;
  t497 = 0.1e1 / t202 / t201;
  t501 = 0.28e2 / 0.9e1 * t41 * t76 * t482 * t80 + 0.2e2 / 0.3e1 * t41 * t487 * t203 - 0.16e2 / 0.9e1 * t41 * t491 * t494 * t497;
  t502 = t194 * t501;
  t506 = 0.176e3 / 0.81e2 * t33 * t70 * t466 * t84 + 0.32e2 / 0.27e2 * t120 * t200 * t208 + 0.4e1 / 0.9e1 * t120 * t192 * t477 - 0.2e1 / 0.9e1 * t120 * t192 * t502;
  t511 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t455 * t89 - t413 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t181 * t212 + t369 - t420 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t506);
  tv2rho22 = 0.2e1 * t175 + 0.2e1 * t217 + t6 * (t444 + t511);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t519 = t5 * t108 * t235 / 0.8e1;
  t520 = t34 * t114;
  t530 = t308 * t230;
  t531 = t530 * t136;
  t542 = t297 * t36;
  t544 = 0.1e1 / t37 / t542;
  t545 = t544 * t330;
  t549 = -0.2e1 / 0.3e1 * t41 * t223 * t125 * t46 - 0.2e1 * t41 * t114 * t132 + 0.2e1 / 0.3e1 * t41 * t545 * sigma[0];
  t550 = t123 * t549;
  t554 = -0.16e2 / 0.27e2 * t33 * t520 * t50 - 0.2e1 / 0.9e1 * t33 * t220 * t137 + 0.16e2 / 0.27e2 * t120 * t129 * t231 + 0.4e1 / 0.9e1 * t120 * t121 * t531 - 0.2e1 / 0.9e1 * t120 * t121 * t550;
  t559 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t235 - t519 - 0.3e1 / 0.8e1 * t5 * t27 * t554);
  tv2rhosigma0 = t6 * t559 + t239;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t566 = t5 * t157 * t255 / 0.8e1;
  t568 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t255 - t566);
  tv2rhosigma2 = t6 * t568 + t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t574 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t235 - t519);
  tv2rhosigma3 = t6 * t574 + t239;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t579 = t34 * t187;
  t589 = t475 * t250;
  t590 = t589 * t207;
  t601 = t464 * t71;
  t603 = 0.1e1 / t72 / t601;
  t604 = t603 * t497;
  t608 = -0.2e1 / 0.3e1 * t41 * t243 * t196 * t80 - 0.2e1 * t41 * t187 * t203 + 0.2e1 / 0.3e1 * t41 * t604 * sigma[2];
  t609 = t194 * t608;
  t613 = -0.16e2 / 0.27e2 * t33 * t579 * t84 - 0.2e1 / 0.9e1 * t33 * t240 * t208 + 0.16e2 / 0.27e2 * t120 * t200 * t251 + 0.4e1 / 0.9e1 * t120 * t192 * t590 - 0.2e1 / 0.9e1 * t120 * t192 * t609;
  t618 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t255 - t566 - 0.3e1 / 0.8e1 * t5 * t69 * t613);
  tv2rhosigma5 = t6 * t618 + t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t623 = t230 * t230;
  t624 = t308 * t623;
  t629 = 0.1e1 / t42 / sigma[0];
  t633 = 0.1e1 / sigma[0];
  t637 = t297 * rho[0];
  t639 = 0.1e1 / t37 / t637;
  t643 = t41 * t633 * t40 * t132 / 0.4e1 - t41 * t629 * t44 * t46 / 0.4e1 - t41 * t639 * t330 / 0.4e1;
  t644 = t123 * t643;
  t648 = -0.4e1 / 0.9e1 * t33 * t220 * t231 + 0.4e1 / 0.9e1 * t120 * t121 * t624 - 0.2e1 / 0.9e1 * t120 * t121 * t644;
  t652 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t648);
  tv2sigma20 = t6 * t652;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t656 = t250 * t250;
  t657 = t475 * t656;
  t662 = 0.1e1 / t76 / sigma[2];
  t666 = 0.1e1 / sigma[2];
  t670 = t464 * rho[1];
  t672 = 0.1e1 / t72 / t670;
  t676 = t41 * t666 * t75 * t203 / 0.4e1 - t41 * t662 * t78 * t80 / 0.4e1 - t41 * t672 * t497 / 0.4e1;
  t677 = t194 * t676;
  t681 = -0.4e1 / 0.9e1 * t33 * t240 * t251 + 0.4e1 / 0.9e1 * t120 * t192 * t657 - 0.2e1 / 0.9e1 * t120 * t192 * t677;
  t685 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t681);
  tv2sigma25 = t6 * t685;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t689 = 0.1e1 / t262 / t19;
  t690 = t264 * t98;
  t693 = t263 * t98;
  t696 = t94 * t94;
  t697 = 0.1e1 / t696;
  t698 = t16 * t697;
  t701 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t268 - 0.6e1 * t698);
  t705 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t689 * t690 + 0.4e1 / 0.3e1 * t693 * t272 + 0.4e1 / 0.3e1 * t23 * t701);
  t706 = t705 * t26;
  t710 = t276 * t107;
  t712 = t5 * t710 * t55;
  t717 = t101 * t289;
  t719 = t5 * t717 * t55;
  t722 = t5 * t281 * t141;
  t728 = 0.1e1 / t106 / t94;
  t729 = t25 * t728;
  t732 = 0.5e1 / 0.36e2 * t5 * t729 * t55;
  t734 = t5 * t290 * t141;
  t737 = t5 * t108 * t339;
  t740 = 0.1e1 / t38 / t637;
  t754 = t122 * t122;
  t755 = 0.1e1 / t754;
  t756 = t309 * t136;
  t757 = t755 * t756;
  t761 = t308 * t136;
  t762 = t761 * t334;
  t767 = 0.1e1 / t37 / t297;
  t772 = sigma[0] * t740;
  t776 = t297 * t297;
  t778 = 0.1e1 / t37 / t776;
  t783 = t324 * sigma[0];
  t784 = t776 * t112;
  t785 = 0.1e1 / t784;
  t787 = t130 * t130;
  t789 = 0.1e1 / t131 / t787;
  t793 = -0.28e3 / 0.27e2 * t41 * t42 * t767 * t46 - 0.952e3 / 0.27e2 * t41 * t772 * t132 + 0.592e3 / 0.27e2 * t41 * t324 * t778 * t330 - 0.64e2 / 0.9e1 * t41 * t783 * t785 * t789;
  t794 = t123 * t793;
  t798 = -0.2464e4 / 0.243e3 * t33 * t35 * t740 * t50 - 0.176e3 / 0.27e2 * t120 * t320 * t137 - 0.32e2 / 0.9e1 * t120 * t129 * t310 + 0.16e2 / 0.9e1 * t120 * t129 * t335 - 0.4e1 / 0.3e1 * t120 * t121 * t757 + 0.4e1 / 0.3e1 * t120 * t121 * t762 - 0.2e1 / 0.9e1 * t120 * t121 * t794;
  t803 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t706 * t55 - 0.3e1 / 0.8e1 * t712 - 0.9e1 / 0.8e1 * t5 * t277 * t141 + t719 / 0.4e1 - 0.3e1 / 0.4e1 * t722 - 0.9e1 / 0.8e1 * t5 * t102 * t339 - t732 + t734 / 0.4e1 - 0.3e1 / 0.8e1 * t737 - 0.3e1 / 0.8e1 * t5 * t27 * t798);
  t805 = 0.1e1 / t345 / t64;
  t806 = t347 * t149;
  t809 = t346 * t149;
  t812 = t61 * t697;
  t815 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t268 - 0.6e1 * t812);
  t819 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t805 * t806 + 0.4e1 / 0.3e1 * t809 * t353 + 0.4e1 / 0.3e1 * t66 * t815);
  t820 = t819 * t26;
  t824 = t357 * t107;
  t826 = t5 * t824 * t89;
  t828 = t152 * t289;
  t830 = t5 * t828 * t89;
  t832 = t68 * t728;
  t835 = 0.5e1 / 0.36e2 * t5 * t832 * t89;
  t837 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t820 * t89 - 0.3e1 / 0.8e1 * t826 + t830 / 0.4e1 - t835);
  tv3rho30 = 0.3e1 * t344 + 0.3e1 * t371 + t6 * (t803 + t837);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t840 = 0.2e1 * t397;
  t841 = 0.2e1 * t423;
  t842 = t689 * t166;
  t845 = t263 * t378;
  t850 = 0.2e1 * t268;
  t851 = 0.6e1 * t698;
  t853 = my_piecewise5(t10, 0, t14, 0, t850 - t851);
  t857 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t842 * t264 + 0.8e1 / 0.9e1 * t845 * t98 + 0.4e1 / 0.9e1 * t374 * t272 + 0.4e1 / 0.3e1 * t23 * t853);
  t858 = t857 * t26;
  t862 = t382 * t107;
  t865 = t5 * t862 * t55 / 0.4e1;
  t869 = t169 * t289;
  t871 = t5 * t869 * t55;
  t875 = t5 * t387 * t141 / 0.4e1;
  t884 = -0.3e1 / 0.8e1 * t5 * t858 * t55 - t865 - 0.3e1 / 0.4e1 * t5 * t383 * t141 + t871 / 0.12e2 - t875 - 0.3e1 / 0.8e1 * t5 * t170 * t339 - t712 / 0.8e1 + t719 / 0.6e1 - t722 / 0.4e1 - t732 + t734 / 0.6e1 - t737 / 0.8e1;
  t885 = my_piecewise3(t1, 0, t884);
  t886 = t805 * t177;
  t889 = t346 * t402;
  t894 = 0.6e1 * t812;
  t896 = my_piecewise5(t14, 0, t10, 0, -t850 - t894);
  t900 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t886 * t347 + 0.8e1 / 0.9e1 * t889 * t149 + 0.4e1 / 0.9e1 * t398 * t353 + 0.4e1 / 0.3e1 * t66 * t896);
  t901 = t900 * t26;
  t905 = t406 * t107;
  t908 = t5 * t905 * t89 / 0.4e1;
  t909 = t180 * t289;
  t911 = t5 * t909 * t89;
  t920 = t5 * t362 * t212 / 0.4e1;
  t922 = t5 * t366 * t212;
  t925 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t901 * t89 - t908 + t911 / 0.12e2 - t826 / 0.8e1 + t830 / 0.6e1 - t835 - 0.3e1 / 0.8e1 * t5 * t358 * t212 - t920 + t922 / 0.12e2);
  tv3rho31 = t344 + t371 + t840 + t841 + t6 * (t885 + t925);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t928 = t689 * t428;
  t933 = t263 * t433;
  t937 = my_piecewise5(t10, 0, t14, 0, -t850 - t851);
  t941 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t928 * t98 + 0.8e1 / 0.9e1 * t374 * t378 + 0.4e1 / 0.9e1 * t933 * t98 + 0.4e1 / 0.3e1 * t23 * t937);
  t942 = t941 * t26;
  t946 = t437 * t107;
  t948 = t5 * t946 * t55;
  t957 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t942 * t55 - t948 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t438 * t141 - t865 + t871 / 0.6e1 - t875 + t719 / 0.12e2 - t732 + t734 / 0.12e2);
  t958 = t805 * t445;
  t963 = t346 * t450;
  t967 = my_piecewise5(t14, 0, t10, 0, t850 - t894);
  t971 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t958 * t149 + 0.8e1 / 0.9e1 * t398 * t402 + 0.4e1 / 0.9e1 * t963 * t149 + 0.4e1 / 0.3e1 * t66 * t967);
  t972 = t971 * t26;
  t976 = t454 * t107;
  t978 = t5 * t976 * t89;
  t985 = t5 * t411 * t212;
  t993 = t5 * t157 * t506;
  t995 = -0.3e1 / 0.8e1 * t5 * t972 * t89 - t978 / 0.8e1 - t908 + t911 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t407 * t212 - t985 / 0.4e1 + t830 / 0.12e2 - t835 - t920 + t922 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t153 * t506 - t993 / 0.8e1;
  t996 = my_piecewise3(t60, 0, t995);
  tv3rho32 = t840 + t841 + t444 + t511 + t6 * (t957 + t996);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1001 = t428 * t166;
  t1008 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t268 - 0.6e1 * t698);
  t1012 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t689 * t1001 + 0.4e1 / 0.3e1 * t374 * t433 + 0.4e1 / 0.3e1 * t23 * t1008);
  t1013 = t1012 * t26;
  t1020 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1013 * t55 - 0.3e1 / 0.8e1 * t948 + t871 / 0.4e1 - t732);
  t1021 = t445 * t177;
  t1028 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t268 - 0.6e1 * t812);
  t1032 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t805 * t1021 + 0.4e1 / 0.3e1 * t398 * t450 + 0.4e1 / 0.3e1 * t66 * t1028);
  t1033 = t1032 * t26;
  t1049 = 0.1e1 / t73 / t670;
  t1063 = t193 * t193;
  t1064 = 0.1e1 / t1063;
  t1065 = t476 * t207;
  t1066 = t1064 * t1065;
  t1070 = t475 * t207;
  t1071 = t1070 * t501;
  t1076 = 0.1e1 / t72 / t464;
  t1081 = sigma[2] * t1049;
  t1085 = t464 * t464;
  t1087 = 0.1e1 / t72 / t1085;
  t1092 = t491 * sigma[2];
  t1093 = t1085 * t185;
  t1094 = 0.1e1 / t1093;
  t1096 = t201 * t201;
  t1098 = 0.1e1 / t202 / t1096;
  t1102 = -0.28e3 / 0.27e2 * t41 * t76 * t1076 * t80 - 0.952e3 / 0.27e2 * t41 * t1081 * t203 + 0.592e3 / 0.27e2 * t41 * t491 * t1087 * t497 - 0.64e2 / 0.9e1 * t41 * t1092 * t1094 * t1098;
  t1103 = t194 * t1102;
  t1107 = -0.2464e4 / 0.243e3 * t33 * t70 * t1049 * t84 - 0.176e3 / 0.27e2 * t120 * t487 * t208 - 0.32e2 / 0.9e1 * t120 * t200 * t477 + 0.16e2 / 0.9e1 * t120 * t200 * t502 - 0.4e1 / 0.3e1 * t120 * t192 * t1066 + 0.4e1 / 0.3e1 * t120 * t192 * t1071 - 0.2e1 / 0.9e1 * t120 * t192 * t1103;
  t1112 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t1033 * t89 - 0.3e1 / 0.8e1 * t978 - 0.9e1 / 0.8e1 * t5 * t455 * t212 + t911 / 0.4e1 - 0.3e1 / 0.4e1 * t985 - 0.9e1 / 0.8e1 * t5 * t181 * t506 - t835 + t922 / 0.4e1 - 0.3e1 / 0.8e1 * t993 - 0.3e1 / 0.8e1 * t5 * t69 * t1107);
  tv3rho33 = 0.3e1 * t444 + 0.3e1 * t511 + t6 * (t1020 + t1112);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1120 = t5 * t281 * t235;
  t1127 = t5 * t290 * t235 / 0.12e2;
  t1129 = t5 * t108 * t554;
  t1131 = t34 * t299;
  t1154 = t755 * t230 * t309;
  t1158 = t308 * t549;
  t1159 = t1158 * t136;
  t1163 = t530 * t334;
  t1174 = t327 * t330;
  t1178 = t776 * t36;
  t1180 = 0.1e1 / t1178 * t789;
  t1184 = 0.14e2 / 0.9e1 * t41 * t223 * t315 * t46 + 0.74e2 / 0.9e1 * t41 * t299 * t132 - 0.62e2 / 0.9e1 * t41 * t1174 * sigma[0] + 0.8e1 / 0.3e1 * t41 * t1180 * t324;
  t1185 = t123 * t1184;
  t1189 = 0.176e3 / 0.81e2 * t33 * t1131 * t50 + 0.32e2 / 0.27e2 * t33 * t520 * t137 + 0.4e1 / 0.9e1 * t33 * t220 * t310 - 0.2e1 / 0.9e1 * t33 * t220 * t335 - 0.176e3 / 0.81e2 * t120 * t320 * t231 - 0.64e2 / 0.27e2 * t120 * t129 * t531 + 0.32e2 / 0.27e2 * t120 * t129 * t550 - 0.4e1 / 0.3e1 * t120 * t121 * t1154 + 0.8e1 / 0.9e1 * t120 * t121 * t1159 + 0.4e1 / 0.9e1 * t120 * t121 * t1163 - 0.2e1 / 0.9e1 * t120 * t121 * t1185;
  t1194 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t235 - t1120 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t102 * t554 + t1127 - t1129 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t1189);
  tv3rho2sigma0 = t6 * t1194 + 0.2e1 * t559;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1201 = t5 * t362 * t255;
  t1205 = t5 * t366 * t255 / 0.12e2;
  t1207 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t358 * t255 - t1201 / 0.4e1 + t1205);
  tv3rho2sigma2 = t6 * t1207 + 0.2e1 * t568;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1213 = t5 * t387 * t235;
  t1221 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t383 * t235 - t1213 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t170 * t554 - t1120 / 0.8e1 + t1127 - t1129 / 0.8e1);
  tv3rho2sigma3 = t6 * t1221 + t559 + t574;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1227 = t5 * t411 * t255;
  t1234 = t5 * t157 * t613;
  t1237 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t407 * t255 - t1227 / 0.8e1 - t1201 / 0.8e1 + t1205 - 0.3e1 / 0.8e1 * t5 * t153 * t613 - t1234 / 0.8e1);
  tv3rho2sigma5 = t6 * t1237 + t568 + t618;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1245 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t438 * t235 - t1213 / 0.4e1 + t1127);
  tv3rho2sigma6 = t6 * t1245 + 0.2e1 * t574;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1256 = t34 * t466;
  t1279 = t1064 * t250 * t476;
  t1283 = t475 * t608;
  t1284 = t1283 * t207;
  t1288 = t589 * t501;
  t1299 = t494 * t497;
  t1303 = t1085 * t71;
  t1305 = 0.1e1 / t1303 * t1098;
  t1309 = 0.14e2 / 0.9e1 * t41 * t243 * t482 * t80 + 0.74e2 / 0.9e1 * t41 * t466 * t203 - 0.62e2 / 0.9e1 * t41 * t1299 * sigma[2] + 0.8e1 / 0.3e1 * t41 * t1305 * t491;
  t1310 = t194 * t1309;
  t1314 = 0.176e3 / 0.81e2 * t33 * t1256 * t84 + 0.32e2 / 0.27e2 * t33 * t579 * t208 + 0.4e1 / 0.9e1 * t33 * t240 * t477 - 0.2e1 / 0.9e1 * t33 * t240 * t502 - 0.176e3 / 0.81e2 * t120 * t487 * t251 - 0.64e2 / 0.27e2 * t120 * t200 * t590 + 0.32e2 / 0.27e2 * t120 * t200 * t609 - 0.4e1 / 0.3e1 * t120 * t192 * t1279 + 0.8e1 / 0.9e1 * t120 * t192 * t1284 + 0.4e1 / 0.9e1 * t120 * t192 * t1288 - 0.2e1 / 0.9e1 * t120 * t192 * t1310;
  t1319 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t455 * t255 - t1227 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t181 * t613 + t1205 - t1234 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t1314);
  tv3rho2sigma8 = t6 * t1319 + 0.2e1 * t618;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1326 = t5 * t108 * t648 / 0.8e1;
  t1330 = t40 * t308;
  t1331 = t230 * t136;
  t1341 = t755 * t623;
  t1342 = t1341 * t136;
  t1346 = t530 * t549;
  t1353 = t308 * t643;
  t1354 = t1353 * t136;
  t1368 = t776 * rho[0];
  t1370 = 0.1e1 / t1368 * t789;
  t1373 = t41 * t629 * t125 * t46 / 0.3e1 - t41 * t633 * t114 * t132 / 0.3e1 + 0.5e1 / 0.3e1 * t41 * t545 - t41 * t1370 * sigma[0];
  t1374 = t123 * t1373;
  t1378 = 0.32e2 / 0.27e2 * t33 * t520 * t231 + 0.8e1 / 0.9e1 * t120 * t1330 * t1331 - 0.4e1 / 0.9e1 * t33 * t220 * t550 - 0.32e2 / 0.27e2 * t120 * t129 * t624 - 0.4e1 / 0.3e1 * t120 * t121 * t1342 + 0.8e1 / 0.9e1 * t120 * t121 * t1346 + 0.16e2 / 0.27e2 * t120 * t129 * t644 + 0.4e1 / 0.9e1 * t120 * t121 * t1354 - 0.2e1 / 0.9e1 * t120 * t121 * t1374;
  t1383 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t648 - t1326 - 0.3e1 / 0.8e1 * t5 * t27 * t1378);
  tv3rhosigma20 = t6 * t1383 + t652;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1390 = t5 * t157 * t681 / 0.8e1;
  t1392 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t681 - t1390);
  tv3rhosigma25 = t6 * t1392 + t685;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1398 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t648 - t1326);
  tv3rhosigma26 = t6 * t1398 + t652;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1406 = t75 * t475;
  t1407 = t250 * t207;
  t1417 = t1064 * t656;
  t1418 = t1417 * t207;
  t1422 = t589 * t608;
  t1429 = t475 * t676;
  t1430 = t1429 * t207;
  t1444 = t1085 * rho[1];
  t1446 = 0.1e1 / t1444 * t1098;
  t1449 = t41 * t662 * t196 * t80 / 0.3e1 - t41 * t666 * t187 * t203 / 0.3e1 + 0.5e1 / 0.3e1 * t41 * t604 - t41 * t1446 * sigma[2];
  t1450 = t194 * t1449;
  t1454 = 0.32e2 / 0.27e2 * t33 * t579 * t251 + 0.8e1 / 0.9e1 * t120 * t1406 * t1407 - 0.4e1 / 0.9e1 * t33 * t240 * t609 - 0.32e2 / 0.27e2 * t120 * t200 * t657 - 0.4e1 / 0.3e1 * t120 * t192 * t1418 + 0.8e1 / 0.9e1 * t120 * t192 * t1422 + 0.16e2 / 0.27e2 * t120 * t200 * t677 + 0.4e1 / 0.9e1 * t120 * t192 * t1430 - 0.2e1 / 0.9e1 * t120 * t192 * t1450;
  t1459 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t681 - t1390 - 0.3e1 / 0.8e1 * t5 * t69 * t1454);
  tv3rhosigma211 = t6 * t1459 + t685;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1467 = t623 * t230;
  t1468 = t755 * t1467;
  t1472 = t530 * t643;
  t1477 = 0.1e1 / t42 / t324;
  t1482 = 0.1e1 / t324;
  t1491 = 0.1e1 / t776;
  t1495 = 0.3e1 / 0.8e1 * t41 * t1477 * t44 * t46 - 0.3e1 / 0.8e1 * t41 * t1482 * t40 * t132 - t41 * t633 * t639 * t330 / 0.8e1 + 0.3e1 / 0.8e1 * t41 * t1491 * t789;
  t1496 = t123 * t1495;
  t1500 = 0.4e1 / 0.3e1 * t33 * t220 * t624 - 0.2e1 / 0.3e1 * t33 * t220 * t644 - 0.4e1 / 0.3e1 * t120 * t121 * t1468 + 0.4e1 / 0.3e1 * t120 * t121 * t1472 - 0.2e1 / 0.9e1 * t120 * t121 * t1496;
  t1504 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1500);
  tv3sigma30 = t6 * t1504;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1511 = t656 * t250;
  t1512 = t1064 * t1511;
  t1516 = t589 * t676;
  t1521 = 0.1e1 / t76 / t491;
  t1526 = 0.1e1 / t491;
  t1535 = 0.1e1 / t1085;
  t1539 = 0.3e1 / 0.8e1 * t41 * t1521 * t78 * t80 - 0.3e1 / 0.8e1 * t41 * t1526 * t75 * t203 - t41 * t666 * t672 * t497 / 0.8e1 + 0.3e1 / 0.8e1 * t41 * t1535 * t1098;
  t1540 = t194 * t1539;
  t1544 = 0.4e1 / 0.3e1 * t33 * t240 * t657 - 0.2e1 / 0.3e1 * t33 * t240 * t677 - 0.4e1 / 0.3e1 * t120 * t192 * t1512 + 0.4e1 / 0.3e1 * t120 * t192 * t1516 - 0.2e1 / 0.9e1 * t120 * t192 * t1540;
  t1548 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t1544);
  tv3sigma39 = t6 * t1548;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t5, t6, t7, t10, t11;
  double t14, t15, t16, t18, t19, t20, t21, t22;
  double t23, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t35, t36, t37, t38, t40, t41;
  double t42, t44, t45, t46, t49, t50, t55, t59;
  double t60, t61, t63, t64, t65, t66, t68, t69;
  double t70, t71, t72, t73, t75, t76, t78, t79;
  double t80, t83, t84, t89, t93, tzk0;

  double t94, t95, t96, t98, t101, t102, t106, t107;
  double t108, t111, t112, t114, t119, t120, t121, t122;
  double t123, t125, t129, t130, t131, t132, t136, t137;
  double t141, t146, t147, t149, t152, t153, t157, t160;
  double t162, tvrho0, t166, t169, t170, t175, t177, t180;
  double t181, t185, t187, t192, t193, t194, t196, t200;
  double t201, t202, t203, t207, t208, t212, t217, tvrho1;
  double t220, t223, t230, t231, t235, t239, tvsigma0, tvsigma1;
  double t240, t243, t250, t251, t255, t259, tvsigma2;

  double t262, t263, t264, t267, t268, t269, t272, t276;
  double t277, t281, t283, t289, t290, t293, t295, t297;
  double t299, t308, t309, t310, t315, t320, t324, t327;
  double t330, t334, t335, t339, t344, t345, t346, t347;
  double t350, t353, t357, t358, t362, t364, t366, t369;
  double t371, tv2rho20, t374, t378, t382, t383, t387, t389;
  double t397, t398, t402, t406, t407, t411, t413, t420;
  double t423, tv2rho21, t428, t433, t437, t438, t444, t445;
  double t450, t454, t455, t464, t466, t475, t476, t477;
  double t482, t487, t491, t494, t497, t501, t502, t506;
  double t511, tv2rho22, t519, t520, t530, t531, t542, t544;
  double t545, t549, t550, t554, t559, tv2rhosigma0, tv2rhosigma1, t566;
  double t568, tv2rhosigma2, t574, tv2rhosigma3, tv2rhosigma4, t579, t589, t590;
  double t601, t603, t604, t608, t609, t613, t618, tv2rhosigma5;
  double t623, t624, t629, t633, t637, t639, t643, t644;
  double t648, t652, tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t656;
  double t657, t662, t666, t670, t672, t676, t677, t681;
  double t685, tv2sigma25;

  double t689, t690, t693, t696, t697, t698, t701, t705;
  double t706, t710, t712, t717, t719, t722, t728, t729;
  double t732, t734, t737, t740, t754, t755, t756, t757;
  double t761, t762, t767, t772, t776, t778, t783, t784;
  double t785, t787, t789, t793, t794, t798, t803, t805;
  double t806, t809, t812, t815, t819, t820, t824, t826;
  double t828, t830, t832, t835, t837, tv3rho30, t840, t841;
  double t842, t845, t850, t851, t853, t857, t858, t862;
  double t865, t869, t871, t875, t884, t885, t886, t889;
  double t894, t896, t900, t901, t905, t908, t909, t911;
  double t920, t922, t925, tv3rho31, t928, t933, t937, t941;
  double t942, t946, t948, t957, t958, t963, t967, t971;
  double t972, t976, t978, t985, t993, t995, t996, tv3rho32;
  double t1001, t1008, t1012, t1013, t1020, t1021, t1028, t1032;
  double t1033, t1049, t1063, t1064, t1065, t1066, t1070, t1071;
  double t1076, t1081, t1085, t1087, t1092, t1093, t1094, t1096;
  double t1098, t1102, t1103, t1107, t1112, tv3rho33, t1120, t1127;
  double t1129, t1131, t1154, t1158, t1159, t1163, t1174, t1178;
  double t1180, t1184, t1185, t1189, t1194, tv3rho2sigma0, tv3rho2sigma1, t1201;
  double t1205, t1207, tv3rho2sigma2, t1213, t1221, tv3rho2sigma3, tv3rho2sigma4, t1227;
  double t1234, t1237, tv3rho2sigma5, t1245, tv3rho2sigma6, tv3rho2sigma7, t1256, t1279;
  double t1283, t1284, t1288, t1299, t1303, t1305, t1309, t1310;
  double t1314, t1319, tv3rho2sigma8, t1326, t1330, t1331, t1341, t1342;
  double t1346, t1353, t1354, t1368, t1370, t1373, t1374, t1378;
  double t1383, tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1390, t1392;
  double tv3rhosigma25, t1398, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1406;
  double t1407, t1417, t1418, t1422, t1429, t1430, t1444, t1446;
  double t1449, t1450, t1454, t1459, tv3rhosigma211, t1467, t1468, t1472;
  double t1477, t1482, t1491, t1495, t1496, t1500, t1504, tv3sigma30;
  double tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38;
  double t1511, t1512, t1516, t1521, t1526, t1535, t1539, t1540;
  double t1544, t1548, tv3sigma39;

  double t1551, t1553, t1554, t1560, t1566, t1567, t1570, t1574;
  double t1583, t1589, t1591, t1597, t1600, t1603, t1606, t1630;
  double t1631, t1641, t1664, t1670, t1677, t1686, t1692, t1696;
  double t1700, t1703, t1707, t1708, t1709, t1710, t1712, t1713;
  double t1719, t1724, t1727, t1731, t1738, t1742, t1746, t1751;
  double t1753, tv4rho40, t1777, t1778, t1780, t1784, t1793, t1799;
  double t1800, t1802, t1812, t1816, t1817, t1820, t1825, t1826;
  double t1843, t1845, t1849, t1856, t1860, t1861, t1864, t1873;
  double t1876, t1877, t1879, t1881, t1882, tv4rho41, t1897, t1910;
  double t1914, t1923, t1936, t1940, t1947, t1948, t1957, t1970;
  double t1974, t1981, t1985, t1994, t1997, t2008, t2011, t2013;
  double t2014, tv4rho42, t2035, t2039, t2046, t2057, t2058, t2075;
  double t2079, t2086, t2094, t2103, t2113, t2115, t2116, tv4rho43;
  double t2121, t2126, t2133, t2137, t2146, t2147, t2152, t2159;
  double t2163, t2178, t2202, t2203, t2213, t2236, t2242, t2249;
  double t2258, t2270, t2271, tv4rho44, t2279, t2285, t2288, t2295;
  double t2297, t2300, t2385, t2386, t2404, t2410, tv4rho3sigma0, tv4rho3sigma1;
  double t2417, t2420, t2424, t2426, tv4rho3sigma2, t2428, t2434, t2439;
  double t2443, t2452, t2453, tv4rho3sigma3, tv4rho3sigma4, t2455, t2461, t2463;
  double t2472, t2474, t2477, tv4rho3sigma5, t2483, t2492, tv4rho3sigma6, tv4rho3sigma7;
  double t2498, t2505, t2513, t2515, t2516, tv4rho3sigma8, t2525, tv4rho3sigma9;
  double tv4rho3sigma10, t2625, t2626, t2644, t2650, tv4rho3sigma11, t2657, t2664;
  double t2666, t2685, t2709, t2772, t2778, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22;
  double tv4rho2sigma23, tv4rho2sigma24, t2785, t2789, t2791, tv4rho2sigma25, t2797, t2805;
  double tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t2811, t2818, t2821;
  double tv4rho2sigma211, t2829, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t2875;
  double t2880, t2944, t2950, tv4rho2sigma217, t2957, t2994, t3040, t3045;
  double tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37;
  double tv4rhosigma38, t3052, t3054, tv4rhosigma39, t3060, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312;
  double tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t3101, t3147;
  double t3152, tv4rhosigma319, t3163, t3172, t3214, tv4sigma40, tv4sigma41, tv4sigma42;
  double tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49, tv4sigma410;
  double tv4sigma411, tv4sigma412, tv4sigma413, t3224, t3233, t3275, tv4sigma414;

  gga_x_b88_params *params;

  assert(p->params != NULL);
  params = (gga_x_b88_params * )(p->params);

  t1 = rho[0] <= p->dens_threshold;
  t2 = M_CBRT3;
  t3 = M_CBRTPI;
  t5 = t2 / t3;
  t6 = rho[0] + rho[1];
  t7 = 0.1e1 / t6;
  t10 = 0.2e1 * rho[0] * t7 <= p->zeta_threshold;
  t11 = p->zeta_threshold - 0.1e1;
  t14 = 0.2e1 * rho[1] * t7 <= p->zeta_threshold;
  t15 = -t11;
  t16 = rho[0] - rho[1];
  t18 = my_piecewise5(t10, t11, t14, t15, t16 * t7);
  t19 = 0.1e1 + t18;
  t20 = t19 <= p->zeta_threshold;
  t21 = POW_1_3(p->zeta_threshold);
  t22 = t21 * p->zeta_threshold;
  t23 = POW_1_3(t19);
  t25 = my_piecewise3(t20, t22, t23 * t19);
  t26 = POW_1_3(t6);
  t27 = t25 * t26;
  t28 = t2 * t2;
  t29 = params->beta * t28;
  t31 = POW_1_3(0.1e1 / M_PI);
  t32 = 0.1e1 / t31;
  t33 = t29 * t32;
  t34 = M_CBRT4;
  t35 = t34 * sigma[0];
  t36 = rho[0] * rho[0];
  t37 = POW_1_3(rho[0]);
  t38 = t37 * t37;
  t40 = 0.1e1 / t38 / t36;
  t41 = params->gamma * params->beta;
  t42 = sqrt(sigma[0]);
  t44 = 0.1e1 / t37 / rho[0];
  t45 = t42 * t44;
  t46 = log(t45 + sqrt(t45 * t45 + 0.1e1));
  t49 = t41 * t45 * t46 + 0.1e1;
  t50 = 0.1e1 / t49;
  t55 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t35 * t40 * t50;
  t59 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t55);
  t60 = rho[1] <= p->dens_threshold;
  t61 = -t16;
  t63 = my_piecewise5(t14, t11, t10, t15, t61 * t7);
  t64 = 0.1e1 + t63;
  t65 = t64 <= p->zeta_threshold;
  t66 = POW_1_3(t64);
  t68 = my_piecewise3(t65, t22, t66 * t64);
  t69 = t68 * t26;
  t70 = t34 * sigma[2];
  t71 = rho[1] * rho[1];
  t72 = POW_1_3(rho[1]);
  t73 = t72 * t72;
  t75 = 0.1e1 / t73 / t71;
  t76 = sqrt(sigma[2]);
  t78 = 0.1e1 / t72 / rho[1];
  t79 = t76 * t78;
  t80 = log(t79 + sqrt(t79 * t79 + 0.1e1));
  t83 = t41 * t79 * t80 + 0.1e1;
  t84 = 0.1e1 / t83;
  t89 = 0.1e1 + 0.2e1 / 0.9e1 * t33 * t70 * t75 * t84;
  t93 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t89);
  tzk0 = t59 + t93;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t94 = t6 * t6;
  t95 = 0.1e1 / t94;
  t96 = t16 * t95;
  t98 = my_piecewise5(t10, 0, t14, 0, t7 - t96);
  t101 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t98);
  t102 = t101 * t26;
  t106 = t26 * t26;
  t107 = 0.1e1 / t106;
  t108 = t25 * t107;
  t111 = t5 * t108 * t55 / 0.8e1;
  t112 = t36 * rho[0];
  t114 = 0.1e1 / t38 / t112;
  t119 = t32 * t34;
  t120 = t29 * t119;
  t121 = sigma[0] * t40;
  t122 = t49 * t49;
  t123 = 0.1e1 / t122;
  t125 = 0.1e1 / t37 / t36;
  t129 = sigma[0] * t114;
  t130 = t121 + 0.1e1;
  t131 = sqrt(t130);
  t132 = 0.1e1 / t131;
  t136 = -0.4e1 / 0.3e1 * t41 * t42 * t125 * t46 - 0.4e1 / 0.3e1 * t41 * t129 * t132;
  t137 = t123 * t136;
  t141 = -0.16e2 / 0.27e2 * t33 * t35 * t114 * t50 - 0.2e1 / 0.9e1 * t120 * t121 * t137;
  t146 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t55 - t111 - 0.3e1 / 0.8e1 * t5 * t27 * t141);
  t147 = t61 * t95;
  t149 = my_piecewise5(t14, 0, t10, 0, -t7 - t147);
  t152 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t149);
  t153 = t152 * t26;
  t157 = t68 * t107;
  t160 = t5 * t157 * t89 / 0.8e1;
  t162 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t89 - t160);
  tvrho0 = t59 + t93 + t6 * (t146 + t162);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t166 = my_piecewise5(t10, 0, t14, 0, -t7 - t96);
  t169 = my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t166);
  t170 = t169 * t26;
  t175 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t55 - t111);
  t177 = my_piecewise5(t14, 0, t10, 0, t7 - t147);
  t180 = my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t177);
  t181 = t180 * t26;
  t185 = t71 * rho[1];
  t187 = 0.1e1 / t73 / t185;
  t192 = sigma[2] * t75;
  t193 = t83 * t83;
  t194 = 0.1e1 / t193;
  t196 = 0.1e1 / t72 / t71;
  t200 = sigma[2] * t187;
  t201 = t192 + 0.1e1;
  t202 = sqrt(t201);
  t203 = 0.1e1 / t202;
  t207 = -0.4e1 / 0.3e1 * t41 * t76 * t196 * t80 - 0.4e1 / 0.3e1 * t41 * t200 * t203;
  t208 = t194 * t207;
  t212 = -0.16e2 / 0.27e2 * t33 * t70 * t187 * t84 - 0.2e1 / 0.9e1 * t120 * t192 * t208;
  t217 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t89 - t160 - 0.3e1 / 0.8e1 * t5 * t69 * t212);
  tvrho1 = t59 + t93 + t6 * (t175 + t217);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t220 = t34 * t40;
  t223 = 0.1e1 / t42;
  t230 = t41 * t223 * t44 * t46 / 0.2e1 + t41 * t40 * t132 / 0.2e1;
  t231 = t123 * t230;
  t235 = -0.2e1 / 0.9e1 * t120 * t121 * t231 + 0.2e1 / 0.9e1 * t33 * t220 * t50;
  t239 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t235);
  tvsigma0 = t6 * t239;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t240 = t34 * t75;
  t243 = 0.1e1 / t76;
  t250 = t41 * t243 * t78 * t80 / 0.2e1 + t41 * t75 * t203 / 0.2e1;
  t251 = t194 * t250;
  t255 = -0.2e1 / 0.9e1 * t120 * t192 * t251 + 0.2e1 / 0.9e1 * t33 * t240 * t84;
  t259 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t255);
  tvsigma2 = t6 * t259;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t262 = t23 * t23;
  t263 = 0.1e1 / t262;
  t264 = t98 * t98;
  t267 = t94 * t6;
  t268 = 0.1e1 / t267;
  t269 = t16 * t268;
  t272 = my_piecewise5(t10, 0, t14, 0, -0.2e1 * t95 + 0.2e1 * t269);
  t276 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t263 * t264 + 0.4e1 / 0.3e1 * t23 * t272);
  t277 = t276 * t26;
  t281 = t101 * t107;
  t283 = t5 * t281 * t55;
  t289 = 0.1e1 / t106 / t6;
  t290 = t25 * t289;
  t293 = t5 * t290 * t55 / 0.12e2;
  t295 = t5 * t108 * t141;
  t297 = t36 * t36;
  t299 = 0.1e1 / t38 / t297;
  t308 = 0.1e1 / t122 / t49;
  t309 = t136 * t136;
  t310 = t308 * t309;
  t315 = 0.1e1 / t37 / t112;
  t320 = sigma[0] * t299;
  t324 = sigma[0] * sigma[0];
  t327 = 0.1e1 / t37 / t297 / t112;
  t330 = 0.1e1 / t131 / t130;
  t334 = 0.28e2 / 0.9e1 * t41 * t42 * t315 * t46 + 0.2e2 / 0.3e1 * t41 * t320 * t132 - 0.16e2 / 0.9e1 * t41 * t324 * t327 * t330;
  t335 = t123 * t334;
  t339 = 0.176e3 / 0.81e2 * t33 * t35 * t299 * t50 + 0.32e2 / 0.27e2 * t120 * t129 * t137 + 0.4e1 / 0.9e1 * t120 * t121 * t310 - 0.2e1 / 0.9e1 * t120 * t121 * t335;
  t344 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t55 - t283 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t102 * t141 + t293 - t295 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t339);
  t345 = t66 * t66;
  t346 = 0.1e1 / t345;
  t347 = t149 * t149;
  t350 = t61 * t268;
  t353 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t95 + 0.2e1 * t350);
  t357 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t346 * t347 + 0.4e1 / 0.3e1 * t66 * t353);
  t358 = t357 * t26;
  t362 = t152 * t107;
  t364 = t5 * t362 * t89;
  t366 = t68 * t289;
  t369 = t5 * t366 * t89 / 0.12e2;
  t371 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t358 * t89 - t364 / 0.4e1 + t369);
  tv2rho20 = 0.2e1 * t146 + 0.2e1 * t162 + t6 * (t344 + t371);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t374 = t263 * t166;
  t378 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t269);
  t382 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t374 * t98 + 0.4e1 / 0.3e1 * t23 * t378);
  t383 = t382 * t26;
  t387 = t169 * t107;
  t389 = t5 * t387 * t55;
  t397 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t383 * t55 - t389 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t170 * t141 - t283 / 0.8e1 + t293 - t295 / 0.8e1);
  t398 = t346 * t177;
  t402 = my_piecewise5(t14, 0, t10, 0, 0.2e1 * t350);
  t406 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t398 * t149 + 0.4e1 / 0.3e1 * t66 * t402);
  t407 = t406 * t26;
  t411 = t180 * t107;
  t413 = t5 * t411 * t89;
  t420 = t5 * t157 * t212;
  t423 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t407 * t89 - t413 / 0.8e1 - t364 / 0.8e1 + t369 - 0.3e1 / 0.8e1 * t5 * t153 * t212 - t420 / 0.8e1);
  tv2rho21 = t146 + t162 + t175 + t217 + t6 * (t397 + t423);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t428 = t166 * t166;
  t433 = my_piecewise5(t10, 0, t14, 0, 0.2e1 * t95 + 0.2e1 * t269);
  t437 = my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t263 * t428 + 0.4e1 / 0.3e1 * t23 * t433);
  t438 = t437 * t26;
  t444 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t438 * t55 - t389 / 0.4e1 + t293);
  t445 = t177 * t177;
  t450 = my_piecewise5(t14, 0, t10, 0, -0.2e1 * t95 + 0.2e1 * t350);
  t454 = my_piecewise3(t65, 0, 0.4e1 / 0.9e1 * t346 * t445 + 0.4e1 / 0.3e1 * t66 * t450);
  t455 = t454 * t26;
  t464 = t71 * t71;
  t466 = 0.1e1 / t73 / t464;
  t475 = 0.1e1 / t193 / t83;
  t476 = t207 * t207;
  t477 = t475 * t476;
  t482 = 0.1e1 / t72 / t185;
  t487 = sigma[2] * t466;
  t491 = sigma[2] * sigma[2];
  t494 = 0.1e1 / t72 / t464 / t185;
  t497 = 0.1e1 / t202 / t201;
  t501 = 0.28e2 / 0.9e1 * t41 * t76 * t482 * t80 + 0.2e2 / 0.3e1 * t41 * t487 * t203 - 0.16e2 / 0.9e1 * t41 * t491 * t494 * t497;
  t502 = t194 * t501;
  t506 = 0.176e3 / 0.81e2 * t33 * t70 * t466 * t84 + 0.32e2 / 0.27e2 * t120 * t200 * t208 + 0.4e1 / 0.9e1 * t120 * t192 * t477 - 0.2e1 / 0.9e1 * t120 * t192 * t502;
  t511 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t455 * t89 - t413 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t181 * t212 + t369 - t420 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t506);
  tv2rho22 = 0.2e1 * t175 + 0.2e1 * t217 + t6 * (t444 + t511);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t519 = t5 * t108 * t235 / 0.8e1;
  t520 = t34 * t114;
  t530 = t308 * t230;
  t531 = t530 * t136;
  t542 = t297 * t36;
  t544 = 0.1e1 / t37 / t542;
  t545 = t544 * t330;
  t549 = -0.2e1 / 0.3e1 * t41 * t223 * t125 * t46 - 0.2e1 * t41 * t114 * t132 + 0.2e1 / 0.3e1 * t41 * t545 * sigma[0];
  t550 = t123 * t549;
  t554 = -0.16e2 / 0.27e2 * t33 * t520 * t50 - 0.2e1 / 0.9e1 * t33 * t220 * t137 + 0.16e2 / 0.27e2 * t120 * t129 * t231 + 0.4e1 / 0.9e1 * t120 * t121 * t531 - 0.2e1 / 0.9e1 * t120 * t121 * t550;
  t559 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t235 - t519 - 0.3e1 / 0.8e1 * t5 * t27 * t554);
  tv2rhosigma0 = t6 * t559 + t239;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t566 = t5 * t157 * t255 / 0.8e1;
  t568 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t255 - t566);
  tv2rhosigma2 = t6 * t568 + t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t574 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t235 - t519);
  tv2rhosigma3 = t6 * t574 + t239;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t579 = t34 * t187;
  t589 = t475 * t250;
  t590 = t589 * t207;
  t601 = t464 * t71;
  t603 = 0.1e1 / t72 / t601;
  t604 = t603 * t497;
  t608 = -0.2e1 / 0.3e1 * t41 * t243 * t196 * t80 - 0.2e1 * t41 * t187 * t203 + 0.2e1 / 0.3e1 * t41 * t604 * sigma[2];
  t609 = t194 * t608;
  t613 = -0.16e2 / 0.27e2 * t33 * t579 * t84 - 0.2e1 / 0.9e1 * t33 * t240 * t208 + 0.16e2 / 0.27e2 * t120 * t200 * t251 + 0.4e1 / 0.9e1 * t120 * t192 * t590 - 0.2e1 / 0.9e1 * t120 * t192 * t609;
  t618 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t255 - t566 - 0.3e1 / 0.8e1 * t5 * t69 * t613);
  tv2rhosigma5 = t6 * t618 + t259;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t623 = t230 * t230;
  t624 = t308 * t623;
  t629 = 0.1e1 / t42 / sigma[0];
  t633 = 0.1e1 / sigma[0];
  t637 = t297 * rho[0];
  t639 = 0.1e1 / t37 / t637;
  t643 = t41 * t633 * t40 * t132 / 0.4e1 - t41 * t629 * t44 * t46 / 0.4e1 - t41 * t639 * t330 / 0.4e1;
  t644 = t123 * t643;
  t648 = -0.4e1 / 0.9e1 * t33 * t220 * t231 + 0.4e1 / 0.9e1 * t120 * t121 * t624 - 0.2e1 / 0.9e1 * t120 * t121 * t644;
  t652 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t648);
  tv2sigma20 = t6 * t652;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t656 = t250 * t250;
  t657 = t475 * t656;
  t662 = 0.1e1 / t76 / sigma[2];
  t666 = 0.1e1 / sigma[2];
  t670 = t464 * rho[1];
  t672 = 0.1e1 / t72 / t670;
  t676 = t41 * t666 * t75 * t203 / 0.4e1 - t41 * t662 * t78 * t80 / 0.4e1 - t41 * t672 * t497 / 0.4e1;
  t677 = t194 * t676;
  t681 = -0.4e1 / 0.9e1 * t33 * t240 * t251 + 0.4e1 / 0.9e1 * t120 * t192 * t657 - 0.2e1 / 0.9e1 * t120 * t192 * t677;
  t685 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t681);
  tv2sigma25 = t6 * t685;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t689 = 0.1e1 / t262 / t19;
  t690 = t264 * t98;
  t693 = t263 * t98;
  t696 = t94 * t94;
  t697 = 0.1e1 / t696;
  t698 = t16 * t697;
  t701 = my_piecewise5(t10, 0, t14, 0, 0.6e1 * t268 - 0.6e1 * t698);
  t705 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t689 * t690 + 0.4e1 / 0.3e1 * t693 * t272 + 0.4e1 / 0.3e1 * t23 * t701);
  t706 = t705 * t26;
  t710 = t276 * t107;
  t712 = t5 * t710 * t55;
  t717 = t101 * t289;
  t719 = t5 * t717 * t55;
  t722 = t5 * t281 * t141;
  t728 = 0.1e1 / t106 / t94;
  t729 = t25 * t728;
  t732 = 0.5e1 / 0.36e2 * t5 * t729 * t55;
  t734 = t5 * t290 * t141;
  t737 = t5 * t108 * t339;
  t740 = 0.1e1 / t38 / t637;
  t754 = t122 * t122;
  t755 = 0.1e1 / t754;
  t756 = t309 * t136;
  t757 = t755 * t756;
  t761 = t308 * t136;
  t762 = t761 * t334;
  t767 = 0.1e1 / t37 / t297;
  t772 = sigma[0] * t740;
  t776 = t297 * t297;
  t778 = 0.1e1 / t37 / t776;
  t783 = t324 * sigma[0];
  t784 = t776 * t112;
  t785 = 0.1e1 / t784;
  t787 = t130 * t130;
  t789 = 0.1e1 / t131 / t787;
  t793 = -0.28e3 / 0.27e2 * t41 * t42 * t767 * t46 - 0.952e3 / 0.27e2 * t41 * t772 * t132 + 0.592e3 / 0.27e2 * t41 * t324 * t778 * t330 - 0.64e2 / 0.9e1 * t41 * t783 * t785 * t789;
  t794 = t123 * t793;
  t798 = -0.2464e4 / 0.243e3 * t33 * t35 * t740 * t50 - 0.176e3 / 0.27e2 * t120 * t320 * t137 - 0.32e2 / 0.9e1 * t120 * t129 * t310 + 0.16e2 / 0.9e1 * t120 * t129 * t335 - 0.4e1 / 0.3e1 * t120 * t121 * t757 + 0.4e1 / 0.3e1 * t120 * t121 * t762 - 0.2e1 / 0.9e1 * t120 * t121 * t794;
  t803 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t706 * t55 - 0.3e1 / 0.8e1 * t712 - 0.9e1 / 0.8e1 * t5 * t277 * t141 + t719 / 0.4e1 - 0.3e1 / 0.4e1 * t722 - 0.9e1 / 0.8e1 * t5 * t102 * t339 - t732 + t734 / 0.4e1 - 0.3e1 / 0.8e1 * t737 - 0.3e1 / 0.8e1 * t5 * t27 * t798);
  t805 = 0.1e1 / t345 / t64;
  t806 = t347 * t149;
  t809 = t346 * t149;
  t812 = t61 * t697;
  t815 = my_piecewise5(t14, 0, t10, 0, -0.6e1 * t268 - 0.6e1 * t812);
  t819 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t805 * t806 + 0.4e1 / 0.3e1 * t809 * t353 + 0.4e1 / 0.3e1 * t66 * t815);
  t820 = t819 * t26;
  t824 = t357 * t107;
  t826 = t5 * t824 * t89;
  t828 = t152 * t289;
  t830 = t5 * t828 * t89;
  t832 = t68 * t728;
  t835 = 0.5e1 / 0.36e2 * t5 * t832 * t89;
  t837 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t820 * t89 - 0.3e1 / 0.8e1 * t826 + t830 / 0.4e1 - t835);
  tv3rho30 = 0.3e1 * t344 + 0.3e1 * t371 + t6 * (t803 + t837);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t840 = 0.2e1 * t397;
  t841 = 0.2e1 * t423;
  t842 = t689 * t166;
  t845 = t263 * t378;
  t850 = 0.2e1 * t268;
  t851 = 0.6e1 * t698;
  t853 = my_piecewise5(t10, 0, t14, 0, t850 - t851);
  t857 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t842 * t264 + 0.8e1 / 0.9e1 * t845 * t98 + 0.4e1 / 0.9e1 * t374 * t272 + 0.4e1 / 0.3e1 * t23 * t853);
  t858 = t857 * t26;
  t862 = t382 * t107;
  t865 = t5 * t862 * t55 / 0.4e1;
  t869 = t169 * t289;
  t871 = t5 * t869 * t55;
  t875 = t5 * t387 * t141 / 0.4e1;
  t884 = -0.3e1 / 0.8e1 * t5 * t858 * t55 - t865 - 0.3e1 / 0.4e1 * t5 * t383 * t141 + t871 / 0.12e2 - t875 - 0.3e1 / 0.8e1 * t5 * t170 * t339 - t712 / 0.8e1 + t719 / 0.6e1 - t722 / 0.4e1 - t732 + t734 / 0.6e1 - t737 / 0.8e1;
  t885 = my_piecewise3(t1, 0, t884);
  t886 = t805 * t177;
  t889 = t346 * t402;
  t894 = 0.6e1 * t812;
  t896 = my_piecewise5(t14, 0, t10, 0, -t850 - t894);
  t900 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t886 * t347 + 0.8e1 / 0.9e1 * t889 * t149 + 0.4e1 / 0.9e1 * t398 * t353 + 0.4e1 / 0.3e1 * t66 * t896);
  t901 = t900 * t26;
  t905 = t406 * t107;
  t908 = t5 * t905 * t89 / 0.4e1;
  t909 = t180 * t289;
  t911 = t5 * t909 * t89;
  t920 = t5 * t362 * t212 / 0.4e1;
  t922 = t5 * t366 * t212;
  t925 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t901 * t89 - t908 + t911 / 0.12e2 - t826 / 0.8e1 + t830 / 0.6e1 - t835 - 0.3e1 / 0.8e1 * t5 * t358 * t212 - t920 + t922 / 0.12e2);
  tv3rho31 = t344 + t371 + t840 + t841 + t6 * (t885 + t925);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t928 = t689 * t428;
  t933 = t263 * t433;
  t937 = my_piecewise5(t10, 0, t14, 0, -t850 - t851);
  t941 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t928 * t98 + 0.8e1 / 0.9e1 * t374 * t378 + 0.4e1 / 0.9e1 * t933 * t98 + 0.4e1 / 0.3e1 * t23 * t937);
  t942 = t941 * t26;
  t946 = t437 * t107;
  t948 = t5 * t946 * t55;
  t957 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t942 * t55 - t948 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t438 * t141 - t865 + t871 / 0.6e1 - t875 + t719 / 0.12e2 - t732 + t734 / 0.12e2);
  t958 = t805 * t445;
  t963 = t346 * t450;
  t967 = my_piecewise5(t14, 0, t10, 0, t850 - t894);
  t971 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t958 * t149 + 0.8e1 / 0.9e1 * t398 * t402 + 0.4e1 / 0.9e1 * t963 * t149 + 0.4e1 / 0.3e1 * t66 * t967);
  t972 = t971 * t26;
  t976 = t454 * t107;
  t978 = t5 * t976 * t89;
  t985 = t5 * t411 * t212;
  t993 = t5 * t157 * t506;
  t995 = -0.3e1 / 0.8e1 * t5 * t972 * t89 - t978 / 0.8e1 - t908 + t911 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t407 * t212 - t985 / 0.4e1 + t830 / 0.12e2 - t835 - t920 + t922 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t153 * t506 - t993 / 0.8e1;
  t996 = my_piecewise3(t60, 0, t995);
  tv3rho32 = t840 + t841 + t444 + t511 + t6 * (t957 + t996);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1001 = t428 * t166;
  t1008 = my_piecewise5(t10, 0, t14, 0, -0.6e1 * t268 - 0.6e1 * t698);
  t1012 = my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t689 * t1001 + 0.4e1 / 0.3e1 * t374 * t433 + 0.4e1 / 0.3e1 * t23 * t1008);
  t1013 = t1012 * t26;
  t1020 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1013 * t55 - 0.3e1 / 0.8e1 * t948 + t871 / 0.4e1 - t732);
  t1021 = t445 * t177;
  t1028 = my_piecewise5(t14, 0, t10, 0, 0.6e1 * t268 - 0.6e1 * t812);
  t1032 = my_piecewise3(t65, 0, -0.8e1 / 0.27e2 * t805 * t1021 + 0.4e1 / 0.3e1 * t398 * t450 + 0.4e1 / 0.3e1 * t66 * t1028);
  t1033 = t1032 * t26;
  t1049 = 0.1e1 / t73 / t670;
  t1063 = t193 * t193;
  t1064 = 0.1e1 / t1063;
  t1065 = t476 * t207;
  t1066 = t1064 * t1065;
  t1070 = t475 * t207;
  t1071 = t1070 * t501;
  t1076 = 0.1e1 / t72 / t464;
  t1081 = sigma[2] * t1049;
  t1085 = t464 * t464;
  t1087 = 0.1e1 / t72 / t1085;
  t1092 = t491 * sigma[2];
  t1093 = t1085 * t185;
  t1094 = 0.1e1 / t1093;
  t1096 = t201 * t201;
  t1098 = 0.1e1 / t202 / t1096;
  t1102 = -0.28e3 / 0.27e2 * t41 * t76 * t1076 * t80 - 0.952e3 / 0.27e2 * t41 * t1081 * t203 + 0.592e3 / 0.27e2 * t41 * t491 * t1087 * t497 - 0.64e2 / 0.9e1 * t41 * t1092 * t1094 * t1098;
  t1103 = t194 * t1102;
  t1107 = -0.2464e4 / 0.243e3 * t33 * t70 * t1049 * t84 - 0.176e3 / 0.27e2 * t120 * t487 * t208 - 0.32e2 / 0.9e1 * t120 * t200 * t477 + 0.16e2 / 0.9e1 * t120 * t200 * t502 - 0.4e1 / 0.3e1 * t120 * t192 * t1066 + 0.4e1 / 0.3e1 * t120 * t192 * t1071 - 0.2e1 / 0.9e1 * t120 * t192 * t1103;
  t1112 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t1033 * t89 - 0.3e1 / 0.8e1 * t978 - 0.9e1 / 0.8e1 * t5 * t455 * t212 + t911 / 0.4e1 - 0.3e1 / 0.4e1 * t985 - 0.9e1 / 0.8e1 * t5 * t181 * t506 - t835 + t922 / 0.4e1 - 0.3e1 / 0.8e1 * t993 - 0.3e1 / 0.8e1 * t5 * t69 * t1107);
  tv3rho33 = 0.3e1 * t444 + 0.3e1 * t511 + t6 * (t1020 + t1112);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t1120 = t5 * t281 * t235;
  t1127 = t5 * t290 * t235 / 0.12e2;
  t1129 = t5 * t108 * t554;
  t1131 = t34 * t299;
  t1154 = t755 * t230 * t309;
  t1158 = t308 * t549;
  t1159 = t1158 * t136;
  t1163 = t530 * t334;
  t1174 = t327 * t330;
  t1178 = t776 * t36;
  t1180 = 0.1e1 / t1178 * t789;
  t1184 = 0.14e2 / 0.9e1 * t41 * t223 * t315 * t46 + 0.74e2 / 0.9e1 * t41 * t299 * t132 - 0.62e2 / 0.9e1 * t41 * t1174 * sigma[0] + 0.8e1 / 0.3e1 * t41 * t1180 * t324;
  t1185 = t123 * t1184;
  t1189 = 0.176e3 / 0.81e2 * t33 * t1131 * t50 + 0.32e2 / 0.27e2 * t33 * t520 * t137 + 0.4e1 / 0.9e1 * t33 * t220 * t310 - 0.2e1 / 0.9e1 * t33 * t220 * t335 - 0.176e3 / 0.81e2 * t120 * t320 * t231 - 0.64e2 / 0.27e2 * t120 * t129 * t531 + 0.32e2 / 0.27e2 * t120 * t129 * t550 - 0.4e1 / 0.3e1 * t120 * t121 * t1154 + 0.8e1 / 0.9e1 * t120 * t121 * t1159 + 0.4e1 / 0.9e1 * t120 * t121 * t1163 - 0.2e1 / 0.9e1 * t120 * t121 * t1185;
  t1194 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t235 - t1120 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t102 * t554 + t1127 - t1129 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * t1189);
  tv3rho2sigma0 = t6 * t1194 + 0.2e1 * t559;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t1201 = t5 * t362 * t255;
  t1205 = t5 * t366 * t255 / 0.12e2;
  t1207 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t358 * t255 - t1201 / 0.4e1 + t1205);
  tv3rho2sigma2 = t6 * t1207 + 0.2e1 * t568;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t1213 = t5 * t387 * t235;
  t1221 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t383 * t235 - t1213 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t170 * t554 - t1120 / 0.8e1 + t1127 - t1129 / 0.8e1);
  tv3rho2sigma3 = t6 * t1221 + t559 + t574;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1227 = t5 * t411 * t255;
  t1234 = t5 * t157 * t613;
  t1237 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t407 * t255 - t1227 / 0.8e1 - t1201 / 0.8e1 + t1205 - 0.3e1 / 0.8e1 * t5 * t153 * t613 - t1234 / 0.8e1);
  tv3rho2sigma5 = t6 * t1237 + t568 + t618;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1245 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t438 * t235 - t1213 / 0.4e1 + t1127);
  tv3rho2sigma6 = t6 * t1245 + 0.2e1 * t574;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1256 = t34 * t466;
  t1279 = t1064 * t250 * t476;
  t1283 = t475 * t608;
  t1284 = t1283 * t207;
  t1288 = t589 * t501;
  t1299 = t494 * t497;
  t1303 = t1085 * t71;
  t1305 = 0.1e1 / t1303 * t1098;
  t1309 = 0.14e2 / 0.9e1 * t41 * t243 * t482 * t80 + 0.74e2 / 0.9e1 * t41 * t466 * t203 - 0.62e2 / 0.9e1 * t41 * t1299 * sigma[2] + 0.8e1 / 0.3e1 * t41 * t1305 * t491;
  t1310 = t194 * t1309;
  t1314 = 0.176e3 / 0.81e2 * t33 * t1256 * t84 + 0.32e2 / 0.27e2 * t33 * t579 * t208 + 0.4e1 / 0.9e1 * t33 * t240 * t477 - 0.2e1 / 0.9e1 * t33 * t240 * t502 - 0.176e3 / 0.81e2 * t120 * t487 * t251 - 0.64e2 / 0.27e2 * t120 * t200 * t590 + 0.32e2 / 0.27e2 * t120 * t200 * t609 - 0.4e1 / 0.3e1 * t120 * t192 * t1279 + 0.8e1 / 0.9e1 * t120 * t192 * t1284 + 0.4e1 / 0.9e1 * t120 * t192 * t1288 - 0.2e1 / 0.9e1 * t120 * t192 * t1310;
  t1319 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t455 * t255 - t1227 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t181 * t613 + t1205 - t1234 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * t1314);
  tv3rho2sigma8 = t6 * t1319 + 0.2e1 * t618;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1326 = t5 * t108 * t648 / 0.8e1;
  t1330 = t40 * t308;
  t1331 = t230 * t136;
  t1341 = t755 * t623;
  t1342 = t1341 * t136;
  t1346 = t530 * t549;
  t1353 = t308 * t643;
  t1354 = t1353 * t136;
  t1368 = t776 * rho[0];
  t1370 = 0.1e1 / t1368 * t789;
  t1373 = t41 * t629 * t125 * t46 / 0.3e1 - t41 * t633 * t114 * t132 / 0.3e1 + 0.5e1 / 0.3e1 * t41 * t545 - t41 * t1370 * sigma[0];
  t1374 = t123 * t1373;
  t1378 = 0.32e2 / 0.27e2 * t33 * t520 * t231 + 0.8e1 / 0.9e1 * t120 * t1330 * t1331 - 0.4e1 / 0.9e1 * t33 * t220 * t550 - 0.32e2 / 0.27e2 * t120 * t129 * t624 - 0.4e1 / 0.3e1 * t120 * t121 * t1342 + 0.8e1 / 0.9e1 * t120 * t121 * t1346 + 0.16e2 / 0.27e2 * t120 * t129 * t644 + 0.4e1 / 0.9e1 * t120 * t121 * t1354 - 0.2e1 / 0.9e1 * t120 * t121 * t1374;
  t1383 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t648 - t1326 - 0.3e1 / 0.8e1 * t5 * t27 * t1378);
  tv3rhosigma20 = t6 * t1383 + t652;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1390 = t5 * t157 * t681 / 0.8e1;
  t1392 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t681 - t1390);
  tv3rhosigma25 = t6 * t1392 + t685;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1398 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t648 - t1326);
  tv3rhosigma26 = t6 * t1398 + t652;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1406 = t75 * t475;
  t1407 = t250 * t207;
  t1417 = t1064 * t656;
  t1418 = t1417 * t207;
  t1422 = t589 * t608;
  t1429 = t475 * t676;
  t1430 = t1429 * t207;
  t1444 = t1085 * rho[1];
  t1446 = 0.1e1 / t1444 * t1098;
  t1449 = t41 * t662 * t196 * t80 / 0.3e1 - t41 * t666 * t187 * t203 / 0.3e1 + 0.5e1 / 0.3e1 * t41 * t604 - t41 * t1446 * sigma[2];
  t1450 = t194 * t1449;
  t1454 = 0.32e2 / 0.27e2 * t33 * t579 * t251 + 0.8e1 / 0.9e1 * t120 * t1406 * t1407 - 0.4e1 / 0.9e1 * t33 * t240 * t609 - 0.32e2 / 0.27e2 * t120 * t200 * t657 - 0.4e1 / 0.3e1 * t120 * t192 * t1418 + 0.8e1 / 0.9e1 * t120 * t192 * t1422 + 0.16e2 / 0.27e2 * t120 * t200 * t677 + 0.4e1 / 0.9e1 * t120 * t192 * t1430 - 0.2e1 / 0.9e1 * t120 * t192 * t1450;
  t1459 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t681 - t1390 - 0.3e1 / 0.8e1 * t5 * t69 * t1454);
  tv3rhosigma211 = t6 * t1459 + t685;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1467 = t623 * t230;
  t1468 = t755 * t1467;
  t1472 = t530 * t643;
  t1477 = 0.1e1 / t42 / t324;
  t1482 = 0.1e1 / t324;
  t1491 = 0.1e1 / t776;
  t1495 = 0.3e1 / 0.8e1 * t41 * t1477 * t44 * t46 - 0.3e1 / 0.8e1 * t41 * t1482 * t40 * t132 - t41 * t633 * t639 * t330 / 0.8e1 + 0.3e1 / 0.8e1 * t41 * t1491 * t789;
  t1496 = t123 * t1495;
  t1500 = 0.4e1 / 0.3e1 * t33 * t220 * t624 - 0.2e1 / 0.3e1 * t33 * t220 * t644 - 0.4e1 / 0.3e1 * t120 * t121 * t1468 + 0.4e1 / 0.3e1 * t120 * t121 * t1472 - 0.2e1 / 0.9e1 * t120 * t121 * t1496;
  t1504 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t1500);
  tv3sigma30 = t6 * t1504;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1511 = t656 * t250;
  t1512 = t1064 * t1511;
  t1516 = t589 * t676;
  t1521 = 0.1e1 / t76 / t491;
  t1526 = 0.1e1 / t491;
  t1535 = 0.1e1 / t1085;
  t1539 = 0.3e1 / 0.8e1 * t41 * t1521 * t78 * t80 - 0.3e1 / 0.8e1 * t41 * t1526 * t75 * t203 - t41 * t666 * t672 * t497 / 0.8e1 + 0.3e1 / 0.8e1 * t41 * t1535 * t1098;
  t1540 = t194 * t1539;
  t1544 = 0.4e1 / 0.3e1 * t33 * t240 * t657 - 0.2e1 / 0.3e1 * t33 * t240 * t677 - 0.4e1 / 0.3e1 * t120 * t192 * t1512 + 0.4e1 / 0.3e1 * t120 * t192 * t1516 - 0.2e1 / 0.9e1 * t120 * t192 * t1540;
  t1548 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * t1544);
  tv3sigma39 = t6 * t1548;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1551 = t19 * t19;
  t1553 = 0.1e1 / t262 / t1551;
  t1554 = t264 * t264;
  t1560 = t272 * t272;
  t1566 = 0.1e1 / t696 / t6;
  t1567 = t16 * t1566;
  t1570 = my_piecewise5(t10, 0, t14, 0, -0.24e2 * t697 + 0.24e2 * t1567);
  t1574 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1553 * t1554 - 0.16e2 / 0.9e1 * t689 * t264 * t272 + 0.4e1 / 0.3e1 * t263 * t1560 + 0.16e2 / 0.9e1 * t693 * t701 + 0.4e1 / 0.3e1 * t23 * t1570);
  t1583 = t5 * t710 * t141;
  t1589 = t5 * t717 * t141;
  t1591 = t5 * t281 * t339;
  t1597 = t5 * t729 * t141;
  t1600 = t5 * t290 * t339;
  t1603 = t5 * t108 * t798;
  t1606 = 0.1e1 / t38 / t542;
  t1630 = 0.1e1 / t754 / t49;
  t1631 = t309 * t309;
  t1641 = t334 * t334;
  t1664 = t776 * t297;
  t1670 = t324 * t324;
  t1677 = 0.1e1 / t131 / t787 / t130;
  t1686 = 0.41888e5 / 0.729e3 * t33 * t35 * t1606 * t50 + 0.9856e4 / 0.243e3 * t120 * t772 * t137 + 0.704e3 / 0.27e2 * t120 * t320 * t310 - 0.352e3 / 0.27e2 * t120 * t320 * t335 + 0.128e3 / 0.9e1 * t120 * t129 * t757 - 0.128e3 / 0.9e1 * t120 * t129 * t762 + 0.64e2 / 0.27e2 * t120 * t129 * t794 + 0.16e2 / 0.3e1 * t120 * t121 * t1630 * t1631 - 0.8e1 * t120 * t121 * t755 * t309 * t334 + 0.4e1 / 0.3e1 * t120 * t121 * t308 * t1641 + 0.16e2 / 0.9e1 * t120 * t121 * t761 * t793 - 0.2e1 / 0.9e1 * t120 * t121 * t123 * (0.364e4 / 0.81e2 * t41 * t42 * t639 * t46 + 0.5768e4 / 0.27e2 * t41 * sigma[0] * t1606 * t132 - 0.18608e5 / 0.81e2 * t41 * t324 / t37 / t1368 * t330 + 0.448e4 / 0.27e2 * t41 * t783 / t1664 * t789 - 0.128e4 / 0.27e2 * t41 * t1670 / t38 / t776 / t542 * t1677);
  t1692 = t5 * t705 * t107 * t55;
  t1696 = t5 * t276 * t289 * t55;
  t1700 = t5 * t101 * t728 * t55;
  t1703 = 0.1e1 / t106 / t267;
  t1707 = 0.1e2 / 0.27e2 * t5 * t25 * t1703 * t55;
  t1708 = -0.3e1 / 0.8e1 * t5 * t1574 * t26 * t55 - 0.3e1 / 0.2e1 * t5 * t706 * t141 - 0.3e1 / 0.2e1 * t1583 - 0.9e1 / 0.4e1 * t5 * t277 * t339 + t1589 - 0.3e1 / 0.2e1 * t1591 - 0.3e1 / 0.2e1 * t5 * t102 * t798 - 0.5e1 / 0.9e1 * t1597 + t1600 / 0.2e1 - t1603 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t27 * t1686 - t1692 / 0.2e1 + t1696 / 0.2e1 - 0.5e1 / 0.9e1 * t1700 + t1707;
  t1709 = my_piecewise3(t1, 0, t1708);
  t1710 = t64 * t64;
  t1712 = 0.1e1 / t345 / t1710;
  t1713 = t347 * t347;
  t1719 = t353 * t353;
  t1724 = t61 * t1566;
  t1727 = my_piecewise5(t14, 0, t10, 0, 0.24e2 * t697 + 0.24e2 * t1724);
  t1731 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1712 * t1713 - 0.16e2 / 0.9e1 * t805 * t347 * t353 + 0.4e1 / 0.3e1 * t346 * t1719 + 0.16e2 / 0.9e1 * t809 * t815 + 0.4e1 / 0.3e1 * t66 * t1727);
  t1738 = t5 * t819 * t107 * t89;
  t1742 = t5 * t357 * t289 * t89;
  t1746 = t5 * t152 * t728 * t89;
  t1751 = 0.1e2 / 0.27e2 * t5 * t68 * t1703 * t89;
  t1753 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t1731 * t26 * t89 - t1738 / 0.2e1 + t1742 / 0.2e1 - 0.5e1 / 0.9e1 * t1746 + t1751);
  tv4rho40 = 0.4e1 * t803 + 0.4e1 * t837 + t6 * (t1709 + t1753);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1777 = 0.12e2 * t697;
  t1778 = 0.24e2 * t1567;
  t1780 = my_piecewise5(t10, 0, t14, 0, -t1777 + t1778);
  t1784 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1553 * t166 * t690 - 0.8e1 / 0.9e1 * t689 * t378 * t264 - 0.8e1 / 0.9e1 * t842 * t98 * t272 + 0.4e1 / 0.3e1 * t263 * t853 * t98 + 0.4e1 / 0.3e1 * t845 * t272 + 0.4e1 / 0.9e1 * t374 * t701 + 0.4e1 / 0.3e1 * t23 * t1780);
  t1793 = t5 * t862 * t141;
  t1799 = t5 * t869 * t141;
  t1800 = t1799 / 0.4e1;
  t1802 = t5 * t387 * t339;
  t1812 = t5 * t857 * t107 * t55;
  t1816 = t5 * t382 * t289 * t55;
  t1817 = t1816 / 0.4e1;
  t1820 = t5 * t169 * t728 * t55;
  t1825 = -0.3e1 / 0.8e1 * t5 * t170 * t798 - 0.3e1 / 0.8e1 * t5 * t1784 * t26 * t55 - 0.9e1 / 0.8e1 * t5 * t858 * t141 - 0.3e1 / 0.4e1 * t1793 - 0.9e1 / 0.8e1 * t5 * t383 * t339 + t1800 - 0.3e1 / 0.8e1 * t1802 - 0.3e1 / 0.8e1 * t1583 + t1589 / 0.2e1 - 0.3e1 / 0.8e1 * t1591 - 0.5e1 / 0.12e2 * t1597 + t1600 / 0.4e1 - t1603 / 0.8e1 - 0.3e1 / 0.8e1 * t1812 + t1817 - 0.5e1 / 0.36e2 * t1820 - t1692 / 0.8e1 + t1696 / 0.4e1 - 0.5e1 / 0.12e2 * t1700 + t1707;
  t1826 = my_piecewise3(t1, 0, t1825);
  t1843 = 0.24e2 * t1724;
  t1845 = my_piecewise5(t14, 0, t10, 0, t1777 + t1843);
  t1849 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1712 * t177 * t806 - 0.8e1 / 0.9e1 * t805 * t402 * t347 - 0.8e1 / 0.9e1 * t886 * t149 * t353 + 0.4e1 / 0.3e1 * t346 * t896 * t149 + 0.4e1 / 0.3e1 * t889 * t353 + 0.4e1 / 0.9e1 * t398 * t815 + 0.4e1 / 0.3e1 * t66 * t1845);
  t1856 = t5 * t900 * t107 * t89;
  t1860 = t5 * t406 * t289 * t89;
  t1861 = t1860 / 0.4e1;
  t1864 = t5 * t180 * t728 * t89;
  t1873 = t5 * t824 * t212;
  t1876 = t5 * t828 * t212;
  t1877 = t1876 / 0.4e1;
  t1879 = t5 * t832 * t212;
  t1881 = -0.3e1 / 0.8e1 * t5 * t1849 * t26 * t89 - 0.3e1 / 0.8e1 * t1856 + t1861 - 0.5e1 / 0.36e2 * t1864 - t1738 / 0.8e1 + t1742 / 0.4e1 - 0.5e1 / 0.12e2 * t1746 + t1751 - 0.3e1 / 0.8e1 * t5 * t820 * t212 - 0.3e1 / 0.8e1 * t1873 + t1877 - 0.5e1 / 0.36e2 * t1879;
  t1882 = my_piecewise3(t60, 0, t1881);
  tv4rho41 = t803 + t837 + 0.3e1 * t885 + 0.3e1 * t925 + t6 * (t1826 + t1882);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1897 = t378 * t378;
  t1910 = my_piecewise5(t10, 0, t14, 0, t1778);
  t1914 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1553 * t428 * t264 - 0.32e2 / 0.27e2 * t842 * t98 * t378 - 0.8e1 / 0.27e2 * t928 * t272 + 0.8e1 / 0.9e1 * t263 * t1897 + 0.8e1 / 0.9e1 * t374 * t853 - 0.8e1 / 0.27e2 * t689 * t433 * t264 + 0.8e1 / 0.9e1 * t263 * t937 * t98 + 0.4e1 / 0.9e1 * t933 * t272 + 0.4e1 / 0.3e1 * t23 * t1910);
  t1923 = t5 * t946 * t141;
  t1936 = t5 * t941 * t107 * t55;
  t1940 = t5 * t437 * t289 * t55;
  t1947 = -0.3e1 / 0.8e1 * t5 * t1914 * t26 * t55 - 0.3e1 / 0.4e1 * t5 * t942 * t141 - t1923 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t438 * t339 - t1793 / 0.2e1 + t1799 / 0.3e1 - t1802 / 0.4e1 + t1589 / 0.6e1 - 0.5e1 / 0.18e2 * t1597 + t1600 / 0.12e2 - t1936 / 0.4e1 + t1940 / 0.12e2 - t1812 / 0.4e1 + t1816 / 0.3e1 - 0.5e1 / 0.18e2 * t1820 + t1696 / 0.12e2 - 0.5e1 / 0.18e2 * t1700 + t1707;
  t1948 = my_piecewise3(t1, 0, t1947);
  t1957 = t402 * t402;
  t1970 = my_piecewise5(t14, 0, t10, 0, t1843);
  t1974 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1712 * t445 * t347 - 0.32e2 / 0.27e2 * t886 * t149 * t402 - 0.8e1 / 0.27e2 * t958 * t353 + 0.8e1 / 0.9e1 * t346 * t1957 + 0.8e1 / 0.9e1 * t398 * t896 - 0.8e1 / 0.27e2 * t805 * t450 * t347 + 0.8e1 / 0.9e1 * t346 * t967 * t149 + 0.4e1 / 0.9e1 * t963 * t353 + 0.4e1 / 0.3e1 * t66 * t1970);
  t1981 = t5 * t971 * t107 * t89;
  t1985 = t5 * t454 * t289 * t89;
  t1994 = t5 * t905 * t212;
  t1997 = t5 * t909 * t212;
  t2008 = t5 * t362 * t506;
  t2011 = t5 * t366 * t506;
  t2013 = -0.3e1 / 0.8e1 * t5 * t1974 * t26 * t89 - t1981 / 0.4e1 + t1985 / 0.12e2 - t1856 / 0.4e1 + t1860 / 0.3e1 - 0.5e1 / 0.18e2 * t1864 - 0.3e1 / 0.4e1 * t5 * t901 * t212 - t1994 / 0.2e1 + t1997 / 0.6e1 + t1742 / 0.12e2 - 0.5e1 / 0.18e2 * t1746 + t1751 - t1873 / 0.4e1 + t1876 / 0.3e1 - 0.5e1 / 0.18e2 * t1879 - 0.3e1 / 0.8e1 * t5 * t358 * t506 - t2008 / 0.4e1 + t2011 / 0.12e2;
  t2014 = my_piecewise3(t60, 0, t2013);
  tv4rho42 = 0.2e1 * t885 + 0.2e1 * t925 + 0.2e1 * t957 + 0.2e1 * t996 + t6 * (t1948 + t2014);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t2035 = my_piecewise5(t10, 0, t14, 0, t1777 + t1778);
  t2039 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1553 * t1001 * t98 - 0.8e1 / 0.9e1 * t928 * t378 - 0.8e1 / 0.9e1 * t842 * t433 * t98 + 0.4e1 / 0.3e1 * t845 * t433 + 0.4e1 / 0.3e1 * t374 * t937 + 0.4e1 / 0.9e1 * t263 * t1008 * t98 + 0.4e1 / 0.3e1 * t23 * t2035);
  t2046 = t5 * t1012 * t107 * t55;
  t2057 = -0.3e1 / 0.8e1 * t5 * t2039 * t26 * t55 - t2046 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t1013 * t141 - 0.3e1 / 0.8e1 * t1936 + t1940 / 0.4e1 - 0.3e1 / 0.8e1 * t1923 + t1817 - 0.5e1 / 0.12e2 * t1820 + t1800 - 0.5e1 / 0.36e2 * t1700 + t1707 - 0.5e1 / 0.36e2 * t1597;
  t2058 = my_piecewise3(t1, 0, t2057);
  t2075 = my_piecewise5(t14, 0, t10, 0, -t1777 + t1843);
  t2079 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1712 * t1021 * t149 - 0.8e1 / 0.9e1 * t958 * t402 - 0.8e1 / 0.9e1 * t886 * t450 * t149 + 0.4e1 / 0.3e1 * t889 * t450 + 0.4e1 / 0.3e1 * t398 * t967 + 0.4e1 / 0.9e1 * t346 * t1028 * t149 + 0.4e1 / 0.3e1 * t66 * t2075);
  t2086 = t5 * t1032 * t107 * t89;
  t2094 = t5 * t976 * t212;
  t2103 = t5 * t411 * t506;
  t2113 = t5 * t157 * t1107;
  t2115 = -0.3e1 / 0.8e1 * t5 * t2079 * t26 * t89 - t2086 / 0.8e1 - 0.3e1 / 0.8e1 * t1981 + t1985 / 0.4e1 - 0.9e1 / 0.8e1 * t5 * t972 * t212 - 0.3e1 / 0.8e1 * t2094 + t1861 - 0.5e1 / 0.12e2 * t1864 - 0.3e1 / 0.4e1 * t1994 + t1997 / 0.2e1 - 0.9e1 / 0.8e1 * t5 * t407 * t506 - 0.3e1 / 0.8e1 * t2103 - 0.5e1 / 0.36e2 * t1746 + t1751 + t1877 - 0.5e1 / 0.12e2 * t1879 - 0.3e1 / 0.8e1 * t2008 + t2011 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t153 * t1107 - t2113 / 0.8e1;
  t2116 = my_piecewise3(t60, 0, t2115);
  tv4rho43 = 0.3e1 * t957 + 0.3e1 * t996 + t1020 + t1112 + t6 * (t2058 + t2116);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t2121 = t428 * t428;
  t2126 = t433 * t433;
  t2133 = my_piecewise5(t10, 0, t14, 0, 0.24e2 * t697 + 0.24e2 * t1567);
  t2137 = my_piecewise3(t20, 0, 0.4e2 / 0.81e2 * t1553 * t2121 - 0.16e2 / 0.9e1 * t928 * t433 + 0.4e1 / 0.3e1 * t263 * t2126 + 0.16e2 / 0.9e1 * t374 * t1008 + 0.4e1 / 0.3e1 * t23 * t2133);
  t2146 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t2137 * t26 * t55 - t2046 / 0.2e1 + t1940 / 0.2e1 - 0.5e1 / 0.9e1 * t1820 + t1707);
  t2147 = t445 * t445;
  t2152 = t450 * t450;
  t2159 = my_piecewise5(t14, 0, t10, 0, -0.24e2 * t697 + 0.24e2 * t1724);
  t2163 = my_piecewise3(t65, 0, 0.4e2 / 0.81e2 * t1712 * t2147 - 0.16e2 / 0.9e1 * t958 * t450 + 0.4e1 / 0.3e1 * t346 * t2152 + 0.16e2 / 0.9e1 * t398 * t1028 + 0.4e1 / 0.3e1 * t66 * t2159);
  t2178 = 0.1e1 / t73 / t601;
  t2202 = 0.1e1 / t1063 / t83;
  t2203 = t476 * t476;
  t2213 = t501 * t501;
  t2236 = t1085 * t464;
  t2242 = t491 * t491;
  t2249 = 0.1e1 / t202 / t1096 / t201;
  t2258 = 0.41888e5 / 0.729e3 * t33 * t70 * t2178 * t84 + 0.9856e4 / 0.243e3 * t120 * t1081 * t208 + 0.704e3 / 0.27e2 * t120 * t487 * t477 - 0.352e3 / 0.27e2 * t120 * t487 * t502 + 0.128e3 / 0.9e1 * t120 * t200 * t1066 - 0.128e3 / 0.9e1 * t120 * t200 * t1071 + 0.64e2 / 0.27e2 * t120 * t200 * t1103 + 0.16e2 / 0.3e1 * t120 * t192 * t2202 * t2203 - 0.8e1 * t120 * t192 * t1064 * t476 * t501 + 0.4e1 / 0.3e1 * t120 * t192 * t475 * t2213 + 0.16e2 / 0.9e1 * t120 * t192 * t1070 * t1102 - 0.2e1 / 0.9e1 * t120 * t192 * t194 * (0.364e4 / 0.81e2 * t41 * t76 * t672 * t80 + 0.5768e4 / 0.27e2 * t41 * sigma[2] * t2178 * t203 - 0.18608e5 / 0.81e2 * t41 * t491 / t72 / t1444 * t497 + 0.448e4 / 0.27e2 * t41 * t1092 / t2236 * t1098 - 0.128e4 / 0.27e2 * t41 * t2242 / t73 / t1085 / t601 * t2249);
  t2270 = -0.3e1 / 0.8e1 * t5 * t2163 * t26 * t89 - 0.3e1 / 0.2e1 * t5 * t1033 * t212 - 0.9e1 / 0.4e1 * t5 * t455 * t506 - 0.3e1 / 0.2e1 * t5 * t181 * t1107 - 0.3e1 / 0.8e1 * t5 * t69 * t2258 - t2086 / 0.2e1 - 0.3e1 / 0.2e1 * t2094 - 0.3e1 / 0.2e1 * t2103 - t2113 / 0.2e1 + t1985 / 0.2e1 + t1997 + t2011 / 0.2e1 - 0.5e1 / 0.9e1 * t1864 - 0.5e1 / 0.9e1 * t1879 + t1751;
  t2271 = my_piecewise3(t60, 0, t2270);
  tv4rho44 = 0.4e1 * t1020 + 0.4e1 * t1112 + t6 * (t2146 + t2271);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t2279 = t5 * t710 * t235;
  t2285 = t5 * t717 * t235;
  t2288 = t5 * t281 * t554;
  t2295 = 0.5e1 / 0.36e2 * t5 * t729 * t235;
  t2297 = t5 * t290 * t554;
  t2300 = t5 * t108 * t1189;
  t2385 = t29 * t119 * sigma[0];
  t2386 = t40 * t755;
  t2404 = -0.176e3 / 0.27e2 * t120 * t320 * t550 + 0.16e2 / 0.9e1 * t120 * t129 * t1185 - 0.2e1 / 0.9e1 * t120 * t121 * t123 * (-0.14e3 / 0.27e2 * t41 * t223 * t767 * t46 - 0.364e3 / 0.9e1 * t41 * t740 * t132 + 0.166e4 / 0.27e2 * t41 * t778 * t330 * sigma[0] - 0.488e3 / 0.9e1 * t41 * t785 * t789 * t324 + 0.16e3 / 0.9e1 * t41 / t38 / t776 / t637 * t1677 * t783) - 0.32e2 / 0.9e1 * t33 * t520 * t310 + 0.32e2 / 0.3e1 * t120 * t129 * t1154 + 0.16e2 / 0.3e1 * t120 * t121 * t1630 * t230 * t756 - 0.4e1 * t2385 * t2386 * t1331 * t334 - 0.2464e4 / 0.243e3 * t33 * t34 * t740 * t50 - 0.176e3 / 0.27e2 * t33 * t1131 * t137 + 0.16e2 / 0.9e1 * t33 * t520 * t335 - 0.2e1 / 0.9e1 * t33 * t220 * t794;
  t2410 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t706 * t235 - 0.3e1 / 0.8e1 * t2279 - 0.9e1 / 0.8e1 * t5 * t277 * t554 + t2285 / 0.4e1 - 0.3e1 / 0.4e1 * t2288 - 0.9e1 / 0.8e1 * t5 * t102 * t1189 - t2295 + t2297 / 0.4e1 - 0.3e1 / 0.8e1 * t2300 - 0.3e1 / 0.8e1 * t5 * t27 * (0.4e1 / 0.9e1 * t120 * t121 * t530 * t793 + 0.2464e4 / 0.243e3 * t120 * t772 * t231 + 0.352e3 / 0.27e2 * t120 * t320 * t531 - 0.64e2 / 0.9e1 * t120 * t129 * t1159 - 0.32e2 / 0.9e1 * t120 * t129 * t1163 - 0.4e1 * t120 * t121 * t755 * t549 * t309 + 0.4e1 / 0.3e1 * t120 * t121 * t308 * t1184 * t136 + 0.4e1 / 0.3e1 * t120 * t121 * t1158 * t334 - 0.4e1 / 0.3e1 * t33 * t220 * t757 + 0.4e1 / 0.3e1 * t120 * t1330 * t136 * t334 + t2404));
  tv4rho3sigma0 = t6 * t2410 + 0.3e1 * t1194;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t2417 = t5 * t824 * t255;
  t2420 = t5 * t828 * t255;
  t2424 = 0.5e1 / 0.36e2 * t5 * t832 * t255;
  t2426 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t820 * t255 - 0.3e1 / 0.8e1 * t2417 + t2420 / 0.4e1 - t2424);
  tv4rho3sigma2 = t6 * t2426 + 0.3e1 * t1207;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t2428 = 0.2e1 * t1221;
  t2434 = t5 * t862 * t235 / 0.4e1;
  t2439 = t5 * t869 * t235;
  t2443 = t5 * t387 * t554 / 0.4e1;
  t2452 = -0.3e1 / 0.8e1 * t5 * t858 * t235 - t2434 - 0.3e1 / 0.4e1 * t5 * t383 * t554 + t2439 / 0.12e2 - t2443 - 0.3e1 / 0.8e1 * t5 * t170 * t1189 - t2279 / 0.8e1 + t2285 / 0.6e1 - t2288 / 0.4e1 - t2295 + t2297 / 0.6e1 - t2300 / 0.8e1;
  t2453 = my_piecewise3(t1, 0, t2452);
  tv4rho3sigma3 = t6 * t2453 + t1194 + t2428;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t2455 = 0.2e1 * t1237;
  t2461 = t5 * t905 * t255 / 0.4e1;
  t2463 = t5 * t909 * t255;
  t2472 = t5 * t362 * t613 / 0.4e1;
  t2474 = t5 * t366 * t613;
  t2477 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t901 * t255 - t2461 + t2463 / 0.12e2 - t2417 / 0.8e1 + t2420 / 0.6e1 - t2424 - 0.3e1 / 0.8e1 * t5 * t358 * t613 - t2472 + t2474 / 0.12e2);
  tv4rho3sigma5 = t6 * t2477 + t1207 + t2455;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2483 = t5 * t946 * t235;
  t2492 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t942 * t235 - t2483 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t438 * t554 - t2434 + t2439 / 0.6e1 - t2443 + t2285 / 0.12e2 - t2295 + t2297 / 0.12e2);
  tv4rho3sigma6 = t6 * t2492 + t1245 + t2428;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t2498 = t5 * t976 * t255;
  t2505 = t5 * t411 * t613;
  t2513 = t5 * t157 * t1314;
  t2515 = -0.3e1 / 0.8e1 * t5 * t972 * t255 - t2498 / 0.8e1 - t2461 + t2463 / 0.6e1 - 0.3e1 / 0.4e1 * t5 * t407 * t613 - t2505 / 0.4e1 + t2420 / 0.12e2 - t2424 - t2472 + t2474 / 0.6e1 - 0.3e1 / 0.8e1 * t5 * t153 * t1314 - t2513 / 0.8e1;
  t2516 = my_piecewise3(t60, 0, t2515);
  tv4rho3sigma8 = t6 * t2516 + t1319 + t2455;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2525 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1013 * t235 - 0.3e1 / 0.8e1 * t2483 + t2439 / 0.4e1 - t2295);
  tv4rho3sigma9 = t6 * t2525 + 0.3e1 * t1245;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2625 = t29 * t119 * sigma[2];
  t2626 = t75 * t1064;
  t2644 = -0.32e2 / 0.9e1 * t33 * t579 * t477 - 0.4e1 / 0.3e1 * t33 * t240 * t1066 + 0.4e1 / 0.3e1 * t120 * t1406 * t207 * t501 - 0.176e3 / 0.27e2 * t120 * t487 * t609 + 0.32e2 / 0.3e1 * t120 * t200 * t1279 + 0.16e2 / 0.3e1 * t120 * t192 * t2202 * t250 * t1065 - 0.4e1 * t2625 * t2626 * t1407 * t501 - 0.2e1 / 0.9e1 * t33 * t240 * t1103 - 0.2464e4 / 0.243e3 * t33 * t34 * t1049 * t84 - 0.176e3 / 0.27e2 * t33 * t1256 * t208 + 0.16e2 / 0.9e1 * t33 * t579 * t502;
  t2650 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t1033 * t255 - 0.3e1 / 0.8e1 * t2498 - 0.9e1 / 0.8e1 * t5 * t455 * t613 + t2463 / 0.4e1 - 0.3e1 / 0.4e1 * t2505 - 0.9e1 / 0.8e1 * t5 * t181 * t1314 - t2424 + t2474 / 0.4e1 - 0.3e1 / 0.8e1 * t2513 - 0.3e1 / 0.8e1 * t5 * t69 * (0.4e1 / 0.3e1 * t120 * t192 * t475 * t1309 * t207 + 0.4e1 / 0.3e1 * t120 * t192 * t1283 * t501 + 0.4e1 / 0.9e1 * t120 * t192 * t589 * t1102 + 0.2464e4 / 0.243e3 * t120 * t1081 * t251 + 0.352e3 / 0.27e2 * t120 * t487 * t590 - 0.64e2 / 0.9e1 * t120 * t200 * t1284 - 0.32e2 / 0.9e1 * t120 * t200 * t1288 - 0.4e1 * t120 * t192 * t1064 * t608 * t476 + 0.16e2 / 0.9e1 * t120 * t200 * t1310 - 0.2e1 / 0.9e1 * t120 * t192 * t194 * (-0.14e3 / 0.27e2 * t41 * t243 * t1076 * t80 - 0.364e3 / 0.9e1 * t41 * t1049 * t203 + 0.166e4 / 0.27e2 * t41 * t1087 * t497 * sigma[2] - 0.488e3 / 0.9e1 * t41 * t1094 * t1098 * t491 + 0.16e3 / 0.9e1 * t41 / t73 / t1085 / t670 * t2249 * t1092) + t2644));
  tv4rho3sigma11 = t6 * t2650 + 0.3e1 * t1319;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2657 = t5 * t281 * t648;
  t2664 = t5 * t290 * t648 / 0.12e2;
  t2666 = t5 * t108 * t1378;
  t2685 = t549 * t549;
  t2709 = 0.4e1 / 0.9e1 * t120 * t121 * t1353 * t334 + 0.352e3 / 0.81e2 * t120 * t320 * t624 + 0.64e2 / 0.9e1 * t120 * t129 * t1342 - 0.128e3 / 0.27e2 * t120 * t129 * t1346 - 0.4e1 / 0.3e1 * t120 * t121 * t1341 * t334 + 0.8e1 / 0.9e1 * t120 * t121 * t308 * t2685 + 0.8e1 / 0.9e1 * t120 * t121 * t530 * t1184 - 0.176e3 / 0.81e2 * t120 * t320 * t644 - 0.64e2 / 0.27e2 * t120 * t129 * t1354 + 0.8e1 / 0.9e1 * t120 * t121 * t308 * t1373 * t136 - 0.8e1 / 0.3e1 * t120 * t2386 * t230 * t309;
  t2772 = 0.32e2 / 0.27e2 * t120 * t129 * t1374 - 0.2e1 / 0.9e1 * t120 * t121 * t123 * (-0.7e1 / 0.9e1 * t41 * t629 * t315 * t46 + 0.7e1 / 0.9e1 * t41 * t633 * t299 * t132 - 0.11e2 * t41 * t1174 + 0.47e2 / 0.3e1 * t41 * t1180 * sigma[0] - 0.2e2 / 0.3e1 * t41 / t38 / t1664 * t1677 * t324) - 0.352e3 / 0.81e2 * t33 * t1131 * t231 - 0.128e3 / 0.27e2 * t120 * t114 * t308 * t1331 + 0.16e2 / 0.9e1 * t120 * t1330 * t549 * t136 + 0.8e1 / 0.9e1 * t120 * t1330 * t230 * t334 - 0.4e1 / 0.3e1 * t120 * t121 * t755 * t643 * t309 + 0.16e2 / 0.3e1 * t120 * t121 * t1630 * t623 * t309 - 0.16e2 / 0.3e1 * t2385 * t2386 * t1331 * t549 + 0.64e2 / 0.27e2 * t33 * t520 * t550 - 0.4e1 / 0.9e1 * t33 * t220 * t1185;
  t2778 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t277 * t648 - t2657 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t102 * t1378 + t2664 - t2666 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t27 * (t2709 + t2772));
  tv4rho2sigma20 = t6 * t2778 + 0.2e1 * t1383;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2785 = t5 * t362 * t681;
  t2789 = t5 * t366 * t681 / 0.12e2;
  t2791 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t358 * t681 - t2785 / 0.4e1 + t2789);
  tv4rho2sigma25 = t6 * t2791 + 0.2e1 * t1392;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2797 = t5 * t387 * t648;
  t2805 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t383 * t648 - t2797 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t170 * t1378 - t2657 / 0.8e1 + t2664 - t2666 / 0.8e1);
  tv4rho2sigma26 = t6 * t2805 + t1383 + t1398;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2811 = t5 * t411 * t681;
  t2818 = t5 * t157 * t1454;
  t2821 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t407 * t681 - t2811 / 0.8e1 - t2785 / 0.8e1 + t2789 - 0.3e1 / 0.8e1 * t5 * t153 * t1454 - t2818 / 0.8e1);
  tv4rho2sigma211 = t6 * t2821 + t1392 + t1459;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2829 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t438 * t648 - t2797 / 0.4e1 + t2664);
  tv4rho2sigma212 = t6 * t2829 + 0.2e1 * t1398;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2875 = t608 * t608;
  t2880 = -0.4e1 / 0.9e1 * t33 * t240 * t1310 + 0.64e2 / 0.27e2 * t33 * t579 * t609 - 0.64e2 / 0.27e2 * t120 * t200 * t1430 + 0.8e1 / 0.9e1 * t120 * t192 * t475 * t1449 * t207 + 0.4e1 / 0.9e1 * t120 * t192 * t1429 * t501 - 0.8e1 / 0.3e1 * t120 * t2626 * t250 * t476 + 0.352e3 / 0.81e2 * t120 * t487 * t657 + 0.64e2 / 0.9e1 * t120 * t200 * t1418 - 0.128e3 / 0.27e2 * t120 * t200 * t1422 - 0.4e1 / 0.3e1 * t120 * t192 * t1417 * t501 + 0.8e1 / 0.9e1 * t120 * t192 * t475 * t2875;
  t2944 = 0.8e1 / 0.9e1 * t120 * t192 * t589 * t1309 - 0.176e3 / 0.81e2 * t120 * t487 * t677 - 0.352e3 / 0.81e2 * t33 * t1256 * t251 - 0.128e3 / 0.27e2 * t120 * t187 * t475 * t1407 + 0.16e2 / 0.9e1 * t120 * t1406 * t608 * t207 + 0.8e1 / 0.9e1 * t120 * t1406 * t250 * t501 + 0.32e2 / 0.27e2 * t120 * t200 * t1450 - 0.2e1 / 0.9e1 * t120 * t192 * t194 * (-0.7e1 / 0.9e1 * t41 * t662 * t482 * t80 + 0.7e1 / 0.9e1 * t41 * t666 * t466 * t203 - 0.11e2 * t41 * t1299 + 0.47e2 / 0.3e1 * t41 * t1305 * sigma[2] - 0.2e2 / 0.3e1 * t41 / t73 / t2236 * t2249 * t491) + 0.16e2 / 0.3e1 * t120 * t192 * t2202 * t656 * t476 - 0.16e2 / 0.3e1 * t2625 * t2626 * t1407 * t608 - 0.4e1 / 0.3e1 * t120 * t192 * t1064 * t676 * t476;
  t2950 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t455 * t681 - t2811 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t181 * t1454 + t2789 - t2818 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t69 * (t2880 + t2944));
  tv4rho2sigma217 = t6 * t2950 + 0.2e1 * t1459;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2957 = t5 * t108 * t1500 / 0.8e1;
  t2994 = t230 * t643;
  t3040 = -0.32e2 / 0.9e1 * t33 * t520 * t624 - 0.4e1 * t120 * t2386 * t623 * t136 + 0.8e1 / 0.3e1 * t120 * t1330 * t230 * t549 + 0.16e2 / 0.9e1 * t33 * t520 * t644 + 0.4e1 / 0.3e1 * t120 * t1330 * t643 * t136 - 0.2e1 / 0.3e1 * t33 * t220 * t1374 + 0.32e2 / 0.9e1 * t120 * t129 * t1468 + 0.16e2 / 0.3e1 * t120 * t121 * t1630 * t1467 * t136 - 0.4e1 * t120 * t121 * t1341 * t549 - 0.32e2 / 0.9e1 * t120 * t129 * t1472 - 0.4e1 * t2385 * t2386 * t2994 * t136 + 0.4e1 / 0.3e1 * t120 * t121 * t1158 * t643 + 0.4e1 / 0.3e1 * t120 * t121 * t530 * t1373 + 0.16e2 / 0.27e2 * t120 * t129 * t1496 + 0.4e1 / 0.9e1 * t120 * t121 * t308 * t1495 * t136 - 0.2e1 / 0.9e1 * t120 * t121 * t123 * (-t41 * t1477 * t125 * t46 / 0.2e1 + t41 * t1482 * t114 * t132 / 0.2e1 + t41 * t633 * t544 * t330 / 0.6e1 - 0.7e1 / 0.2e1 * t41 * t1370 + 0.5e1 / 0.2e1 * t41 / t38 / t784 * t1677 * sigma[0]);
  t3045 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t102 * t1500 - t2957 - 0.3e1 / 0.8e1 * t5 * t27 * t3040);
  tv4rhosigma30 = t6 * t3045 + t1504;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t3052 = t5 * t157 * t1544 / 0.8e1;
  t3054 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t153 * t1544 - t3052);
  tv4rhosigma39 = t6 * t3054 + t1548;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t3060 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t170 * t1500 - t2957);
  tv4rhosigma310 = t6 * t3060 + t1504;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t3101 = t250 * t676;
  t3147 = -0.32e2 / 0.9e1 * t33 * t579 * t657 - 0.4e1 * t120 * t2626 * t656 * t207 + 0.8e1 / 0.3e1 * t120 * t1406 * t250 * t608 + 0.16e2 / 0.9e1 * t33 * t579 * t677 + 0.4e1 / 0.3e1 * t120 * t1406 * t676 * t207 - 0.2e1 / 0.3e1 * t33 * t240 * t1450 + 0.32e2 / 0.9e1 * t120 * t200 * t1512 + 0.16e2 / 0.3e1 * t120 * t192 * t2202 * t1511 * t207 - 0.4e1 * t120 * t192 * t1417 * t608 - 0.32e2 / 0.9e1 * t120 * t200 * t1516 - 0.4e1 * t2625 * t2626 * t3101 * t207 + 0.4e1 / 0.3e1 * t120 * t192 * t1283 * t676 + 0.4e1 / 0.3e1 * t120 * t192 * t589 * t1449 + 0.16e2 / 0.27e2 * t120 * t200 * t1540 + 0.4e1 / 0.9e1 * t120 * t192 * t475 * t1539 * t207 - 0.2e1 / 0.9e1 * t120 * t192 * t194 * (-t41 * t1521 * t196 * t80 / 0.2e1 + t41 * t1526 * t187 * t203 / 0.2e1 + t41 * t666 * t603 * t497 / 0.6e1 - 0.7e1 / 0.2e1 * t41 * t1446 + 0.5e1 / 0.2e1 * t41 / t73 / t1093 * t2249 * sigma[2]);
  t3152 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t181 * t1544 - t3052 - 0.3e1 / 0.8e1 * t5 * t69 * t3147);
  tv4rhosigma319 = t6 * t3152 + t1548;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t3163 = t623 * t623;
  t3172 = t643 * t643;
  t3214 = my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (-0.16e2 / 0.3e1 * t33 * t220 * t1468 + 0.16e2 / 0.3e1 * t120 * t1330 * t2994 - 0.8e1 / 0.9e1 * t33 * t220 * t1496 + 0.16e2 / 0.3e1 * t120 * t121 * t1630 * t3163 - 0.8e1 * t120 * t121 * t1341 * t643 + 0.4e1 / 0.3e1 * t120 * t121 * t308 * t3172 + 0.16e2 / 0.9e1 * t120 * t121 * t530 * t1495 - 0.2e1 / 0.9e1 * t120 * t121 * t123 * (-0.15e2 / 0.16e2 * t41 / t42 / t783 * t44 * t46 + 0.15e2 / 0.16e2 * t41 / t783 * t40 * t132 + 0.5e1 / 0.16e2 * t41 * t1482 * t639 * t330 + 0.3e1 / 0.16e2 * t41 * t633 * t1491 * t789 - 0.15e2 / 0.16e2 * t41 / t38 / t1178 * t1677)));
  tv4sigma40 = t6 * t3214;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t3224 = t656 * t656;
  t3233 = t676 * t676;
  t3275 = my_piecewise3(t60, 0, -0.3e1 / 0.8e1 * t5 * t69 * (-0.16e2 / 0.3e1 * t33 * t240 * t1512 + 0.16e2 / 0.3e1 * t120 * t1406 * t3101 - 0.8e1 / 0.9e1 * t33 * t240 * t1540 + 0.16e2 / 0.3e1 * t120 * t192 * t2202 * t3224 - 0.8e1 * t120 * t192 * t1417 * t676 + 0.4e1 / 0.3e1 * t120 * t192 * t475 * t3233 + 0.16e2 / 0.9e1 * t120 * t192 * t589 * t1539 - 0.2e1 / 0.9e1 * t120 * t192 * t194 * (-0.15e2 / 0.16e2 * t41 / t76 / t1092 * t78 * t80 + 0.15e2 / 0.16e2 * t41 / t1092 * t75 * t203 + 0.5e1 / 0.16e2 * t41 * t1526 * t672 * t497 + 0.3e1 / 0.16e2 * t41 * t666 * t1535 * t1098 - 0.15e2 / 0.16e2 * t41 / t73 / t1303 * t2249)));
  tv4sigma414 = t6 * t3275;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

