/********************************************************************************
  libvideogfx.hh  /  Dirk Farin, dirk.farin@gmx.de

    This is a meta include file which includes every other include file.
 ********************************************************************************
    LibVideoGfx - video processing library
    Copyright (C) 2002  Dirk Farin

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ********************************************************************************/

#ifndef LIBVIDEOGFX_LIBVIDEOGFX_HH
#define LIBVIDEOGFX_LIBVIDEOGFX_HH

#include <libvideogfx/types.hh>
//#include <libvideogfx/error.hh>
#include <libvideogfx/arch/cpu.hh>
#include <libvideogfx/containers/array.hh>
#include <libvideogfx/containers/array2.hh>
#include <libvideogfx/containers/symmatrix.hh>
#include <libvideogfx/containers/dynarray.hh>
#include <libvideogfx/containers/heap.hh>
#include <libvideogfx/containers/queue.hh>
#include <libvideogfx/graphics/color/colorspace.hh>
#include <libvideogfx/graphics/color/img2raw.hh>
#include <libvideogfx/graphics/datatypes/bitmap.hh>
#include <libvideogfx/graphics/datatypes/image.hh>
#include <libvideogfx/graphics/datatypes/primitives.hh>
#include <libvideogfx/graphics/draw/draw.hh>
#include <libvideogfx/graphics/draw/blit.hh>
#include <libvideogfx/graphics/draw/format.hh>
#include <libvideogfx/graphics/draw/pixelops.hh>
#include <libvideogfx/graphics/draw/scale.hh>
#include <libvideogfx/graphics/geometry/matrix.hh>
#include <libvideogfx/graphics/geometry/transform.hh>
#include <libvideogfx/graphics/fileio/jpeg.hh>
#include <libvideogfx/graphics/fileio/png.hh>
#include <libvideogfx/graphics/fileio/mpeg.hh>
#include <libvideogfx/graphics/fileio/ppm.hh>
#include <libvideogfx/graphics/fileio/raw.hh>
#include <libvideogfx/graphics/fileio/uyvy.hh>
#include <libvideogfx/graphics/fileio/yuv.hh>
#include <libvideogfx/graphics/fileio/yuv4mpeg.hh>
#include <libvideogfx/graphics/fileio/yuv_vqeg.hh>
#include <libvideogfx/graphics/fileio/mplayer.hh>
#include <libvideogfx/graphics/fileio/imagesink.hh>
#include <libvideogfx/graphics/fileio/unified_reader.hh>
#include <libvideogfx/graphics/fileio/unified_writer.hh>
#include <libvideogfx/graphics/filters/linear.hh>
#include <libvideogfx/graphics/filters/median.hh>
#include <libvideogfx/graphics/filters/binomial.hh>
#include <libvideogfx/graphics/filters/scale.hh>
#include <libvideogfx/graphics/measure/snr.hh>
#include <libvideogfx/graphics/visualize/regions.hh>
#include <libvideogfx/audio/fileio/audiosink.hh>
#include <libvideogfx/audio/fileio/timedsink.hh>
#include <libvideogfx/utility/bitmanip.hh>
//#include <libvideogfx/utility/smartpointer.hh>
#include <libvideogfx/utility/math.hh>
#include <libvideogfx/utility/refcntr.hh>
#include <libvideogfx/utility/bitstream/bitbuffer.hh>
#include <libvideogfx/utility/bitstream/bitreader.hh>
#include <libvideogfx/utility/bitstream/bitreader_fast.hh>
#include <libvideogfx/utility/bitstream/inputstream.hh>
#include <libvideogfx/utility/bitstream/inputstream_istr.hh>

#include <libvideogfx/x11/dispimg.hh>
#include <libvideogfx/x11/imgwin.hh>
#include <libvideogfx/x11/server.hh>
#include <libvideogfx/x11/draw_x11.hh>
#include <libvideogfx/audio/fileio/audiosink_linux.hh>

#endif
