/***
 * @file AngularMatrixLookup.h
 * @brief Prebuilt lookup table to find cartesian coordinates of end effector based on leg angles
 * @author Kyle Machulis (kyle@nonpolynomial.com)
 * @copyright (c) 2007-2009 Nonpolynomial Labs/Kyle Machulis
 * @license BSD License
 *
 * Project info at http://libnifalcon.nonpolynomial.com/
 *
 */

#ifndef ANGULARMATRIXLOOKUP_H
#define ANGULARMATRIXLOOKUP_H

namespace libnifalcon {
	const static float stamper_lookup_matrix[16][16][16][3] =
	{
		{{{0.f,0.f,0.071875f},
		  {0.003125f,0.003125f,0.075f},
		  {0.009375f,0.00625f,0.075f},
		  {0.0125f,0.0125f,0.075f},
		  {0.015625f,0.015625f,0.078125f},
		  {0.021875f,0.01875f,0.078125f},
		  {0.028125f,0.021875f,0.078125f},
		  {0.034375f,0.028125f,0.078125f},
		  {0.040625f,0.034375f,0.075f},
		  {0.04375f,0.040625f,0.075f},
		  {0.05f,0.046875f,0.071875f},
		  {0.05625f,0.053125f,0.06875f},
		  {0.0625f,0.059375f,0.0625f},
		  {0.06875f,0.0625f,0.053125f},
		  {0.071875f,0.065625f,0.05f},
		  {0.f,0.f,0.f}},
		 {{-0.003125f,0.f,0.075f},
		  {0.f,0.00625f,0.075f},
		  {0.003125f,0.009375f,0.078125f},
		  {0.009375f,0.0125f,0.078125f},
		  {0.0125f,0.015625f,0.08125f},
		  {0.01875f,0.01875f,0.08125f},
		  {0.025f,0.025f,0.08125f},
		  {0.028125f,0.03125f,0.08125f},
		  {0.034375f,0.0375f,0.08125f},
		  {0.040625f,0.04375f,0.078125f},
		  {0.046875f,0.05f,0.075f},
		  {0.053125f,0.05625f,0.06875f},
		  {0.059375f,0.0625f,0.0625f},
		  {0.065625f,0.065625f,0.059375f},
		  {0.071875f,0.06875f,0.05f},
		  {0.f,0.f,0.f}},
		 {{-0.00625f,0.003125f,0.075f},
		  {-0.003125f,0.00625f,0.078125f},
		  {0.f,0.0125f,0.078125f},
		  {0.00625f,0.0125f,0.08125f},
		  {0.009375f,0.01875f,0.08125f},
		  {0.0125f,0.025f,0.08125f},
		  {0.01875f,0.028125f,0.084375f},
		  {0.025f,0.034375f,0.084375f},
		  {0.03125f,0.040625f,0.08125f},
		  {0.0375f,0.046875f,0.078125f},
		  {0.04375f,0.053125f,0.075f},
		  {0.053125f,0.05625f,0.071875f},
		  {0.059375f,0.0625f,0.065625f},
		  {0.065625f,0.06875f,0.059375f},
		  {0.071875f,0.071875f,0.05f},
		  {0.f,0.f,0.f}},
		 {{-0.0125f,0.003125f,0.078125f},
		  {-0.009375f,0.009375f,0.078125f},
		  {-0.00625f,0.0125f,0.08125f},
		  {-0.003125f,0.015625f,0.084375f},
		  {0.003125f,0.021875f,0.084375f},
		  {0.009375f,0.025f,0.084375f},
		  {0.0125f,0.03125f,0.0875f},
		  {0.01875f,0.0375f,0.0875f},
		  {0.025f,0.04375f,0.084375f},
		  {0.034375f,0.046875f,0.084375f},
		  {0.040625f,0.053125f,0.08125f},
		  {0.046875f,0.059375f,0.078125f},
		  {0.05625f,0.065625f,0.06875f},
		  {0.0625f,0.071875f,0.0625f},
		  {0.06875f,0.075f,0.053125f},
		  {0.071875f,0.075f,0.05f}},
		 {{-0.015625f,0.00625f,0.078125f},
		  {-0.0125f,0.009375f,0.08125f},
		  {-0.009375f,0.015625f,0.08125f},
		  {-0.00625f,0.01875f,0.084375f},
		  {0.f,0.021875f,0.0875f},
		  {0.003125f,0.028125f,0.0875f},
		  {0.009375f,0.034375f,0.0875f},
		  {0.015625f,0.0375f,0.090625f},
		  {0.021875f,0.04375f,0.0875f},
		  {0.028125f,0.05f,0.0875f},
		  {0.034375f,0.059375f,0.08125f},
		  {0.04375f,0.0625f,0.08125f},
		  {0.05f,0.06875f,0.075f},
		  {0.059375f,0.071875f,0.065625f},
		  {0.065625f,0.078125f,0.05625f},
		  {0.071875f,0.078125f,0.05f}},
		 {{-0.021875f,0.009375f,0.078125f},
		  {-0.01875f,0.0125f,0.08125f},
		  {-0.015625f,0.015625f,0.084375f},
		  {-0.0125f,0.021875f,0.084375f},
		  {-0.009375f,0.025f,0.090625f},
		  {-0.003125f,0.03125f,0.0875f},
		  {0.003125f,0.034375f,0.090625f},
		  {0.009375f,0.040625f,0.09375f},
		  {0.015625f,0.046875f,0.090625f},
		  {0.021875f,0.053125f,0.090625f},
		  {0.03125f,0.059375f,0.0875f},
		  {0.0375f,0.065625f,0.084375f},
		  {0.046875f,0.071875f,0.078125f},
		  {0.05625f,0.075f,0.06875f},
		  {0.065625f,0.078125f,0.059375f},
		  {0.071875f,0.08125f,0.05f}},
		 {{-0.028125f,0.0125f,0.078125f},
		  {-0.025f,0.015625f,0.08125f},
		  {-0.021875f,0.01875f,0.084375f},
		  {-0.01875f,0.021875f,0.0875f},
		  {-0.015625f,0.028125f,0.090625f},
		  {-0.009375f,0.03125f,0.090625f},
		  {-0.003125f,0.0375f,0.09375f},
		  {0.003125f,0.04375f,0.09375f},
		  {0.009375f,0.05f,0.09375f},
		  {0.01875f,0.05625f,0.090625f},
		  {0.025f,0.0625f,0.090625f},
		  {0.034375f,0.06875f,0.084375f},
		  {0.04375f,0.071875f,0.08125f},
		  {0.053125f,0.078125f,0.071875f},
		  {0.0625f,0.08125f,0.0625f},
		  {0.065625f,0.08125f,0.059375f}},
		 {{-0.0375f,0.0125f,0.078125f},
		  {-0.034375f,0.01875f,0.08125f},
		  {-0.03125f,0.021875f,0.084375f},
		  {-0.025f,0.025f,0.0875f},
		  {-0.021875f,0.03125f,0.0875f},
		  {-0.015625f,0.034375f,0.09375f},
		  {-0.0125f,0.040625f,0.09375f},
		  {-0.00625f,0.046875f,0.09375f},
		  {0.003125f,0.053125f,0.09375f},
		  {0.009375f,0.059375f,0.09375f},
		  {0.01875f,0.065625f,0.090625f},
		  {0.028125f,0.06875f,0.090625f},
		  {0.0375f,0.075f,0.084375f},
		  {0.046875f,0.08125f,0.078125f},
		  {0.059375f,0.084375f,0.065625f},
		  {0.06875f,0.084375f,0.053125f}},
		 {{-0.04375f,0.015625f,0.078125f},
		  {-0.040625f,0.01875f,0.08125f},
		  {-0.0375f,0.021875f,0.084375f},
		  {-0.034375f,0.028125f,0.0875f},
		  {-0.03125f,0.034375f,0.0875f},
		  {-0.025f,0.0375f,0.09375f},
		  {-0.01875f,0.04375f,0.09375f},
		  {-0.0125f,0.05f,0.09375f},
		  {-0.00625f,0.05625f,0.09375f},
		  {0.003125f,0.059375f,0.096875f},
		  {0.0125f,0.065625f,0.096875f},
		  {0.021875f,0.071875f,0.09375f},
		  {0.034375f,0.078125f,0.084375f},
		  {0.04375f,0.084375f,0.075f},
		  {0.05625f,0.084375f,0.06875f},
		  {0.f,0.f,0.f}},
		 {{-0.05f,0.015625f,0.078125f},
		  {-0.05f,0.021875f,0.078125f},
		  {-0.046875f,0.028125f,0.08125f},
		  {-0.04375f,0.03125f,0.084375f},
		  {-0.040625f,0.034375f,0.090625f},
		  {-0.034375f,0.040625f,0.090625f},
		  {-0.028125f,0.04375f,0.096875f},
		  {-0.021875f,0.053125f,0.09375f},
		  {-0.015625f,0.05625f,0.1f},
		  {-0.00625f,0.0625f,0.1f},
		  {0.003125f,0.06875f,0.096875f},
		  {0.015625f,0.075f,0.09375f},
		  {0.025f,0.08125f,0.090625f},
		  {0.040625f,0.084375f,0.08125f},
		  {0.05625f,0.0875f,0.065625f},
		  {0.06875f,0.0875f,0.053125f}},
		 {{-0.059375f,0.01875f,0.075f},
		  {-0.05625f,0.021875f,0.078125f},
		  {-0.053125f,0.028125f,0.08125f},
		  {-0.053125f,0.034375f,0.08125f},
		  {-0.05f,0.0375f,0.084375f},
		  {-0.04375f,0.04375f,0.0875f},
		  {-0.0375f,0.046875f,0.09375f},
		  {-0.03125f,0.053125f,0.09375f},
		  {-0.025f,0.059375f,0.096875f},
		  {-0.015625f,0.065625f,0.096875f},
		  {-0.00625f,0.071875f,0.096875f},
		  {0.00625f,0.078125f,0.09375f},
		  {0.01875f,0.08125f,0.09375f},
		  {0.034375f,0.0875f,0.084375f},
		  {0.046875f,0.0875f,0.078125f},
		  {0.065625f,0.090625f,0.05625f}},
		 {{-0.06875f,0.021875f,0.06875f},
		  {-0.065625f,0.025f,0.075f},
		  {-0.0625f,0.028125f,0.078125f},
		  {-0.059375f,0.034375f,0.08125f},
		  {-0.05625f,0.0375f,0.084375f},
		  {-0.053125f,0.04375f,0.0875f},
		  {-0.046875f,0.046875f,0.09375f},
		  {-0.040625f,0.053125f,0.096875f},
		  {-0.034375f,0.059375f,0.096875f},
		  {-0.025f,0.065625f,0.1f},
		  {-0.015625f,0.071875f,0.1f},
		  {-0.003125f,0.078125f,0.1f},
		  {0.009375f,0.084375f,0.096875f},
		  {0.025f,0.090625f,0.0875f},
		  {0.046875f,0.090625f,0.075f},
		  {0.059375f,0.09375f,0.0625f}},
		 {{-0.075f,0.025f,0.065625f},
		  {-0.075f,0.028125f,0.06875f},
		  {-0.071875f,0.03125f,0.071875f},
		  {-0.06875f,0.034375f,0.078125f},
		  {-0.065625f,0.040625f,0.078125f},
		  {-0.0625f,0.04375f,0.084375f},
		  {-0.059375f,0.05f,0.084375f},
		  {-0.053125f,0.05625f,0.0875f},
		  {-0.046875f,0.059375f,0.096875f},
		  {-0.0375f,0.065625f,0.1f},
		  {-0.028125f,0.071875f,0.1f},
		  {-0.01875f,0.078125f,0.1f},
		  {-0.003125f,0.0875f,0.09375f},
		  {0.021875f,0.090625f,0.090625f},
		  {0.05f,0.090625f,0.071875f},
		  {0.053125f,0.096875f,0.06875f}},
		 {{-0.084375f,0.025f,0.059375f},
		  {-0.08125f,0.03125f,0.0625f},
		  {-0.08125f,0.034375f,0.065625f},
		  {-0.078125f,0.0375f,0.06875f},
		  {-0.078125f,0.040625f,0.071875f},
		  {-0.075f,0.04375f,0.078125f},
		  {-0.06875f,0.05f,0.08125f},
		  {-0.065625f,0.053125f,0.0875f},
		  {-0.059375f,0.059375f,0.090625f},
		  {-0.053125f,0.065625f,0.09375f},
		  {-0.04375f,0.071875f,0.096875f},
		  {-0.03125f,0.078125f,0.1f},
		  {-0.01875f,0.084375f,0.1f},
		  {0.009375f,0.09375f,0.090625f},
		  {0.04375f,0.09375f,0.075f},
		  {0.046875f,0.1f,0.075f}},
		 {{-0.090625f,0.028125f,0.05f},
		  {-0.090625f,0.03125f,0.05625f},
		  {-0.090625f,0.034375f,0.05625f},
		  {-0.0875f,0.0375f,0.0625f},
		  {-0.0875f,0.040625f,0.065625f},
		  {-0.084375f,0.04375f,0.06875f},
		  {-0.08125f,0.05f,0.071875f},
		  {-0.078125f,0.053125f,0.078125f},
		  {-0.075f,0.05625f,0.08125f},
		  {-0.06875f,0.0625f,0.0875f},
		  {-0.0625f,0.06875f,0.090625f},
		  {-0.05f,0.075f,0.096875f},
		  {-0.034375f,0.084375f,0.096875f},
		  {-0.009375f,0.09375f,0.09375f},
		  {0.040625f,0.09375f,0.08125f},
		  {0.04375f,0.1f,0.078125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.096875f,0.0375f,0.053125f},
		  {-0.096875f,0.040625f,0.053125f},
		  {-0.09375f,0.04375f,0.059375f},
		  {-0.09375f,0.046875f,0.059375f},
		  {-0.090625f,0.05f,0.065625f},
		  {-0.090625f,0.053125f,0.065625f},
		  {-0.0875f,0.05625f,0.071875f},
		  {-0.08125f,0.0625f,0.075f},
		  {-0.075f,0.06875f,0.078125f},
		  {-0.065625f,0.075f,0.0875f},
		  {-0.040625f,0.0875f,0.096875f},
		  {0.0375f,0.09375f,0.08125f},
		  {0.0375f,0.1f,0.08125f}}},
		{{{0.f,-0.003125f,0.075f},
		  {0.00625f,0.f,0.075f},
		  {0.009375f,0.003125f,0.078125f},
		  {0.015625f,0.00625f,0.078125f},
		  {0.01875f,0.0125f,0.078125f},
		  {0.021875f,0.015625f,0.08125f},
		  {0.028125f,0.021875f,0.08125f},
		  {0.034375f,0.025f,0.08125f},
		  {0.040625f,0.03125f,0.08125f},
		  {0.046875f,0.0375f,0.078125f},
		  {0.053125f,0.04375f,0.075f},
		  {0.059375f,0.05f,0.06875f},
		  {0.065625f,0.05625f,0.065625f},
		  {0.071875f,0.059375f,0.05625f},
		  {0.075f,0.065625f,0.05f},
		  {0.f,0.f,0.f}},
		 {{-0.003125f,-0.003125f,0.075f},
		  {0.003125f,0.f,0.078125f},
		  {0.00625f,0.00625f,0.078125f},
		  {0.009375f,0.009375f,0.08125f},
		  {0.015625f,0.0125f,0.08125f},
		  {0.01875f,0.01875f,0.084375f},
		  {0.025f,0.021875f,0.084375f},
		  {0.03125f,0.028125f,0.084375f},
		  {0.0375f,0.034375f,0.08125f},
		  {0.04375f,0.040625f,0.078125f},
		  {0.05f,0.046875f,0.075f},
		  {0.05625f,0.053125f,0.071875f},
		  {0.0625f,0.059375f,0.06875f},
		  {0.06875f,0.065625f,0.059375f},
		  {0.075f,0.06875f,0.05f},
		  {0.f,0.f,0.f}},
		 {{-0.00625f,-0.003125f,0.078125f},
		  {-0.003125f,0.003125f,0.078125f},
		  {0.003125f,0.00625f,0.08125f},
		  {0.00625f,0.009375f,0.084375f},
		  {0.009375f,0.015625f,0.084375f},
		  {0.015625f,0.021875f,0.084375f},
		  {0.021875f,0.021875f,0.0875f},
		  {0.028125f,0.028125f,0.0875f},
		  {0.034375f,0.034375f,0.0875f},
		  {0.040625f,0.040625f,0.084375f},
		  {0.046875f,0.046875f,0.08125f},
		  {0.053125f,0.053125f,0.078125f},
		  {0.059375f,0.0625f,0.06875f},
		  {0.06875f,0.065625f,0.0625f},
		  {0.071875f,0.071875f,0.05625f},
		  {0.075f,0.071875f,0.05f}},
		 {{-0.0125f,0.f,0.078125f},
		  {-0.00625f,0.003125f,0.08125f},
		  {-0.003125f,0.00625f,0.084375f},
		  {0.f,0.0125f,0.084375f},
		  {0.00625f,0.015625f,0.0875f},
		  {0.009375f,0.021875f,0.090625f},
		  {0.015625f,0.028125f,0.0875f},
		  {0.021875f,0.034375f,0.0875f},
		  {0.028125f,0.040625f,0.0875f},
		  {0.034375f,0.04375f,0.090625f},
		  {0.04375f,0.05f,0.084375f},
		  {0.05f,0.05625f,0.08125f},
		  {0.05625f,0.0625f,0.075f},
		  {0.065625f,0.06875f,0.065625f},
		  {0.06875f,0.075f,0.05625f},
		  {0.075f,0.075f,0.05f}},
		 {{-0.015625f,0.f,0.08125f},
		  {-0.0125f,0.003125f,0.084375f},
		  {-0.009375f,0.009375f,0.084375f},
		  {-0.00625f,0.015625f,0.0875f},
		  {0.f,0.01875f,0.090625f},
		  {0.00625f,0.021875f,0.09375f},
		  {0.009375f,0.03125f,0.090625f},
		  {0.015625f,0.034375f,0.09375f},
		  {0.021875f,0.04375f,0.090625f},
		  {0.03125f,0.046875f,0.090625f},
		  {0.0375f,0.053125f,0.090625f},
		  {0.046875f,0.059375f,0.084375f},
		  {0.053125f,0.065625f,0.08125f},
		  {0.059375f,0.071875f,0.071875f},
		  {0.06875f,0.075f,0.0625f},
		  {0.075f,0.078125f,0.05f}},
		 {{-0.021875f,0.003125f,0.08125f},
		  {-0.01875f,0.00625f,0.084375f},
		  {-0.015625f,0.0125f,0.0875f},
		  {-0.0125f,0.015625f,0.090625f},
		  {-0.00625f,0.021875f,0.090625f},
		  {-0.003125f,0.028125f,0.09375f},
		  {0.003125f,0.034375f,0.09375f},
		  {0.009375f,0.0375f,0.096875f},
		  {0.015625f,0.04375f,0.096875f},
		  {0.025f,0.05f,0.09375f},
		  {0.03125f,0.05625f,0.09375f},
		  {0.040625f,0.0625f,0.0875f},
		  {0.05f,0.06875f,0.08125f},
		  {0.059375f,0.071875f,0.075f},
		  {0.065625f,0.078125f,0.065625f},
		  {0.075f,0.08125f,0.05f}},
		 {{-0.028125f,0.00625f,0.08125f},
		  {-0.025f,0.009375f,0.084375f},
		  {-0.021875f,0.015625f,0.0875f},
		  {-0.01875f,0.01875f,0.090625f},
		  {-0.015625f,0.025f,0.09375f},
		  {-0.009375f,0.03125f,0.09375f},
		  {-0.003125f,0.034375f,0.096875f},
		  {0.003125f,0.040625f,0.096875f},
		  {0.0125f,0.046875f,0.096875f},
		  {0.01875f,0.053125f,0.096875f},
		  {0.028125f,0.05625f,0.096875f},
		  {0.034375f,0.065625f,0.09375f},
		  {0.04375f,0.071875f,0.0875f},
		  {0.05625f,0.075f,0.078125f},
		  {0.0625f,0.08125f,0.065625f},
		  {0.071875f,0.08125f,0.05625f}},
		 {{-0.0375f,0.009375f,0.08125f},
		  {-0.034375f,0.0125f,0.084375f},
		  {-0.03125f,0.01875f,0.0875f},
		  {-0.025f,0.021875f,0.090625f},
		  {-0.021875f,0.025f,0.09375f},
		  {-0.015625f,0.03125f,0.096875f},
		  {-0.0125f,0.0375f,0.1f},
		  {-0.003125f,0.040625f,0.103125f},
		  {0.003125f,0.05f,0.1f},
		  {0.0125f,0.053125f,0.103125f},
		  {0.021875f,0.059375f,0.1f},
		  {0.03125f,0.06875f,0.090625f},
		  {0.040625f,0.071875f,0.090625f},
		  {0.05f,0.078125f,0.084375f},
		  {0.0625f,0.08125f,0.06875f},
		  {0.06875f,0.084375f,0.05625f}},
		 {{-0.04375f,0.009375f,0.08125f},
		  {-0.040625f,0.015625f,0.084375f},
		  {-0.0375f,0.01875f,0.0875f},
		  {-0.034375f,0.025f,0.090625f},
		  {-0.03125f,0.028125f,0.09375f},
		  {-0.025f,0.034375f,0.096875f},
		  {-0.01875f,0.0375f,0.103125f},
		  {-0.0125f,0.046875f,0.1f},
		  {-0.00625f,0.053125f,0.1f},
		  {0.003125f,0.059375f,0.1f},
		  {0.0125f,0.0625f,0.103125f},
		  {0.021875f,0.06875f,0.1f},
		  {0.034375f,0.075f,0.09375f},
		  {0.046875f,0.08125f,0.08125f},
		  {0.059375f,0.084375f,0.071875f},
		  {0.071875f,0.084375f,0.05625f}},
		 {{-0.053125f,0.015625f,0.078125f},
		  {-0.05f,0.015625f,0.084375f},
		  {-0.046875f,0.021875f,0.0875f},
		  {-0.04375f,0.025f,0.090625f},
		  {-0.0375f,0.03125f,0.09375f},
		  {-0.034375f,0.034375f,0.1f},
		  {-0.028125f,0.040625f,0.1f},
		  {-0.021875f,0.046875f,0.103125f},
		  {-0.015625f,0.053125f,0.103125f},
		  {-0.00625f,0.059375f,0.10625f},
		  {0.003125f,0.065625f,0.103125f},
		  {0.015625f,0.071875f,0.1f},
		  {0.028125f,0.078125f,0.09375f},
		  {0.040625f,0.084375f,0.084375f},
		  {0.053125f,0.084375f,0.08125f},
		  {0.06875f,0.0875f,0.059375f}},
		 {{-0.059375f,0.015625f,0.078125f},
		  {-0.059375f,0.01875f,0.08125f},
		  {-0.053125f,0.025f,0.084375f},
		  {-0.053125f,0.028125f,0.0875f},
		  {-0.046875f,0.034375f,0.090625f},
		  {-0.04375f,0.0375f,0.096875f},
		  {-0.0375f,0.04375f,0.096875f},
		  {-0.03125f,0.05f,0.1f},
		  {-0.025f,0.05625f,0.103125f},
		  {-0.015625f,0.0625f,0.103125f},
		  {-0.00625f,0.06875f,0.103125f},
		  {0.00625f,0.075f,0.1f},
		  {0.01875f,0.08125f,0.096875f},
		  {0.034375f,0.084375f,0.09375f},
		  {0.053125f,0.0875f,0.078125f},
		  {0.065625f,0.090625f,0.0625f}},
		 {{-0.06875f,0.01875f,0.071875f},
		  {-0.065625f,0.021875f,0.078125f},
		  {-0.065625f,0.025f,0.08125f},
		  {-0.059375f,0.03125f,0.084375f},
		  {-0.05625f,0.034375f,0.090625f},
		  {-0.053125f,0.040625f,0.090625f},
		  {-0.046875f,0.04375f,0.1f},
		  {-0.04375f,0.053125f,0.096875f},
		  {-0.034375f,0.05625f,0.103125f},
		  {-0.025f,0.0625f,0.10625f},
		  {-0.015625f,0.06875f,0.10625f},
		  {-0.003125f,0.075f,0.10625f},
		  {0.0125f,0.08125f,0.103125f},
		  {0.028125f,0.0875f,0.09375f},
		  {0.04375f,0.090625f,0.08125f},
		  {0.0625f,0.090625f,0.06875f}},
		 {{-0.075f,0.021875f,0.06875f},
		  {-0.075f,0.025f,0.071875f},
		  {-0.071875f,0.028125f,0.078125f},
		  {-0.071875f,0.034375f,0.078125f},
		  {-0.065625f,0.0375f,0.084375f},
		  {-0.0625f,0.040625f,0.090625f},
		  {-0.059375f,0.046875f,0.090625f},
		  {-0.053125f,0.053125f,0.09375f},
		  {-0.046875f,0.05625f,0.103125f},
		  {-0.0375f,0.0625f,0.10625f},
		  {-0.028125f,0.06875f,0.109375f},
		  {-0.015625f,0.078125f,0.103125f},
		  {-0.003125f,0.084375f,0.103125f},
		  {0.01875f,0.0875f,0.103125f},
		  {0.046875f,0.090625f,0.08125f},
		  {0.05625f,0.09375f,0.075f}},
		 {{-0.084375f,0.021875f,0.065625f},
		  {-0.084375f,0.025f,0.065625f},
		  {-0.08125f,0.03125f,0.06875f},
		  {-0.08125f,0.034375f,0.071875f},
		  {-0.078125f,0.0375f,0.078125f},
		  {-0.075f,0.040625f,0.084375f},
		  {-0.071875f,0.046875f,0.0875f},
		  {-0.065625f,0.05f,0.09375f},
		  {-0.059375f,0.05625f,0.096875f},
		  {-0.053125f,0.0625f,0.1f},
		  {-0.04375f,0.06875f,0.103125f},
		  {-0.03125f,0.075f,0.109375f},
		  {-0.015625f,0.084375f,0.103125f},
		  {0.009375f,0.090625f,0.1f},
		  {0.03125f,0.09375f,0.090625f},
		  {0.053125f,0.096875f,0.078125f}},
		 {{-0.09375f,0.025f,0.053125f},
		  {-0.09375f,0.028125f,0.05625f},
		  {-0.090625f,0.03125f,0.0625f},
		  {-0.090625f,0.034375f,0.065625f},
		  {-0.0875f,0.0375f,0.071875f},
		  {-0.084375f,0.04375f,0.071875f},
		  {-0.08125f,0.046875f,0.078125f},
		  {-0.078125f,0.05f,0.084375f},
		  {-0.075f,0.05625f,0.084375f},
		  {-0.06875f,0.059375f,0.09375f},
		  {-0.059375f,0.06875f,0.09375f},
		  {-0.05f,0.075f,0.1f},
		  {-0.03125f,0.08125f,0.109375f},
		  {-0.0125f,0.090625f,0.103125f},
		  {0.034375f,0.09375f,0.090625f},
		  {0.05f,0.096875f,0.08125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,0.03125f,0.05f},
		  {-0.1f,0.034375f,0.053125f},
		  {-0.096875f,0.0375f,0.059375f},
		  {-0.096875f,0.040625f,0.0625f},
		  {-0.09375f,0.04375f,0.06875f},
		  {-0.09375f,0.046875f,0.06875f},
		  {-0.0875f,0.053125f,0.075f},
		  {-0.084375f,0.05625f,0.08125f},
		  {-0.08125f,0.059375f,0.084375f},
		  {-0.071875f,0.06875f,0.0875f},
		  {-0.0625f,0.075f,0.096875f},
		  {-0.040625f,0.084375f,0.10625f},
		  {0.01875f,0.096875f,0.09375f},
		  {0.040625f,0.1f,0.08125f}}},
		{{{0.003125f,-0.00625f,0.075f},
		  {0.00625f,-0.00625f,0.078125f},
		  {0.009375f,0.f,0.078125f},
		  {0.015625f,0.f,0.08125f},
		  {0.021875f,0.00625f,0.08125f},
		  {0.025f,0.0125f,0.08125f},
		  {0.03125f,0.015625f,0.084375f},
		  {0.0375f,0.021875f,0.08125f},
		  {0.04375f,0.025f,0.08125f},
		  {0.05f,0.03125f,0.08125f},
		  {0.05625f,0.0375f,0.078125f},
		  {0.0625f,0.04375f,0.071875f},
		  {0.065625f,0.053125f,0.06875f},
		  {0.071875f,0.059375f,0.0625f},
		  {0.078125f,0.065625f,0.053125f},
		  {0.f,0.f,0.f}},
		 {{0.f,-0.009375f,0.078125f},
		  {0.003125f,-0.003125f,0.078125f},
		  {0.00625f,0.f,0.08125f},
		  {0.009375f,0.00625f,0.084375f},
		  {0.015625f,0.009375f,0.084375f},
		  {0.021875f,0.009375f,0.0875f},
		  {0.028125f,0.015625f,0.0875f},
		  {0.034375f,0.021875f,0.0875f},
		  {0.0375f,0.03125f,0.0875f},
		  {0.046875f,0.034375f,0.084375f},
		  {0.053125f,0.040625f,0.08125f},
		  {0.059375f,0.046875f,0.078125f},
		  {0.065625f,0.053125f,0.071875f},
		  {0.06875f,0.0625f,0.065625f},
		  {0.075f,0.06875f,0.053125f},
		  {0.078125f,0.06875f,0.053125f}},
		 {{-0.00625f,-0.00625f,0.078125f},
		  {0.f,-0.003125f,0.08125f},
		  {0.003125f,0.f,0.084375f},
		  {0.00625f,0.00625f,0.084375f},
		  {0.0125f,0.009375f,0.0875f},
		  {0.01875f,0.0125f,0.090625f},
		  {0.021875f,0.01875f,0.09375f},
		  {0.028125f,0.025f,0.090625f},
		  {0.034375f,0.03125f,0.090625f},
		  {0.040625f,0.0375f,0.090625f},
		  {0.05f,0.04375f,0.084375f},
		  {0.05625f,0.05f,0.08125f},
		  {0.0625f,0.05625f,0.075f},
		  {0.06875f,0.0625f,0.06875f},
		  {0.075f,0.06875f,0.059375f},
		  {0.078125f,0.071875f,0.053125f}},
		 {{-0.009375f,-0.00625f,0.08125f},
		  {-0.00625f,-0.003125f,0.084375f},
		  {-0.003125f,0.003125f,0.0875f},
		  {0.f,0.00625f,0.090625f},
		  {0.00625f,0.0125f,0.090625f},
		  {0.0125f,0.01875f,0.090625f},
		  {0.01875f,0.021875f,0.09375f},
		  {0.025f,0.028125f,0.09375f},
		  {0.03125f,0.03125f,0.09375f},
		  {0.0375f,0.040625f,0.090625f},
		  {0.04375f,0.046875f,0.090625f},
		  {0.053125f,0.053125f,0.084375f},
		  {0.059375f,0.059375f,0.08125f},
		  {0.065625f,0.065625f,0.075f},
		  {0.071875f,0.071875f,0.065625f},
		  {0.078125f,0.075f,0.053125f}},
		 {{-0.015625f,-0.003125f,0.08125f},
		  {-0.0125f,0.f,0.084375f},
		  {-0.009375f,0.00625f,0.0875f},
		  {-0.003125f,0.009375f,0.090625f},
		  {0.f,0.0125f,0.09375f},
		  {0.00625f,0.01875f,0.096875f},
		  {0.0125f,0.025f,0.096875f},
		  {0.01875f,0.03125f,0.096875f},
		  {0.025f,0.0375f,0.096875f},
		  {0.034375f,0.040625f,0.096875f},
		  {0.040625f,0.05f,0.090625f},
		  {0.046875f,0.05625f,0.090625f},
		  {0.05625f,0.0625f,0.084375f},
		  {0.0625f,0.06875f,0.078125f},
		  {0.06875f,0.075f,0.065625f},
		  {0.078125f,0.078125f,0.05f}},
		 {{-0.021875f,-0.003125f,0.084375f},
		  {-0.01875f,0.003125f,0.0875f},
		  {-0.015625f,0.00625f,0.090625f},
		  {-0.009375f,0.009375f,0.09375f},
		  {-0.00625f,0.015625f,0.096875f},
		  {0.f,0.021875f,0.096875f},
		  {0.00625f,0.025f,0.1f},
		  {0.0125f,0.03125f,0.103125f},
		  {0.01875f,0.040625f,0.1f},
		  {0.028125f,0.04375f,0.1f},
		  {0.034375f,0.053125f,0.096875f},
		  {0.04375f,0.059375f,0.090625f},
		  {0.05f,0.065625f,0.090625f},
		  {0.059375f,0.071875f,0.08125f},
		  {0.06875f,0.075f,0.06875f},
		  {0.075f,0.078125f,0.059375f}},
		 {{-0.028125f,0.003125f,0.084375f},
		  {-0.025f,0.00625f,0.0875f},
		  {-0.021875f,0.009375f,0.090625f},
		  {-0.01875f,0.015625f,0.09375f},
		  {-0.0125f,0.01875f,0.096875f},
		  {-0.009375f,0.025f,0.1f},
		  {0.f,0.028125f,0.103125f},
		  {0.003125f,0.0375f,0.103125f},
		  {0.0125f,0.040625f,0.10625f},
		  {0.01875f,0.05f,0.103125f},
		  {0.028125f,0.05625f,0.1f},
		  {0.0375f,0.0625f,0.09375f},
		  {0.046875f,0.06875f,0.0875f},
		  {0.05625f,0.071875f,0.084375f},
		  {0.065625f,0.078125f,0.075f},
		  {0.075f,0.08125f,0.05625f}},
		 {{-0.0375f,0.00625f,0.084375f},
		  {-0.034375f,0.009375f,0.0875f},
		  {-0.028125f,0.009375f,0.09375f},
		  {-0.025f,0.015625f,0.096875f},
		  {-0.021875f,0.021875f,0.096875f},
		  {-0.015625f,0.028125f,0.1f},
		  {-0.009375f,0.03125f,0.10625f},
		  {-0.003125f,0.0375f,0.10625f},
		  {0.00625f,0.040625f,0.109375f},
		  {0.0125f,0.05f,0.10625f},
		  {0.021875f,0.05625f,0.10625f},
		  {0.03125f,0.0625f,0.103125f},
		  {0.040625f,0.071875f,0.09375f},
		  {0.053125f,0.075f,0.0875f},
		  {0.0625f,0.08125f,0.078125f},
		  {0.06875f,0.08125f,0.06875f}},
		 {{-0.04375f,0.00625f,0.084375f},
		  {-0.040625f,0.009375f,0.0875f},
		  {-0.0375f,0.015625f,0.090625f},
		  {-0.034375f,0.01875f,0.096875f},
		  {-0.028125f,0.021875f,0.1f},
		  {-0.025f,0.028125f,0.103125f},
		  {-0.01875f,0.034375f,0.10625f},
		  {-0.0125f,0.040625f,0.10625f},
		  {-0.003125f,0.046875f,0.109375f},
		  {0.003125f,0.053125f,0.109375f},
		  {0.0125f,0.059375f,0.109375f},
		  {0.025f,0.065625f,0.10625f},
		  {0.034375f,0.071875f,0.103125f},
		  {0.046875f,0.078125f,0.09375f},
		  {0.059375f,0.084375f,0.075f},
		  {0.06875f,0.084375f,0.06875f}},
		 {{-0.053125f,0.009375f,0.08125f},
		  {-0.05f,0.0125f,0.0875f},
		  {-0.046875f,0.015625f,0.090625f},
		  {-0.04375f,0.021875f,0.09375f},
		  {-0.0375f,0.025f,0.1f},
		  {-0.03125f,0.03125f,0.103125f},
		  {-0.028125f,0.0375f,0.10625f},
		  {-0.021875f,0.04375f,0.10625f},
		  {-0.0125f,0.05f,0.109375f},
		  {-0.003125f,0.05625f,0.109375f},
		  {0.00625f,0.0625f,0.109375f},
		  {0.015625f,0.06875f,0.10625f},
		  {0.028125f,0.075f,0.103125f},
		  {0.040625f,0.08125f,0.09375f},
		  {0.05625f,0.084375f,0.084375f},
		  {0.071875f,0.084375f,0.0625f}},
		 {{-0.059375f,0.009375f,0.08125f},
		  {-0.05625f,0.0125f,0.0875f},
		  {-0.05625f,0.021875f,0.0875f},
		  {-0.053125f,0.025f,0.090625f},
		  {-0.046875f,0.028125f,0.096875f},
		  {-0.04375f,0.034375f,0.1f},
		  {-0.0375f,0.040625f,0.103125f},
		  {-0.03125f,0.046875f,0.10625f},
		  {-0.021875f,0.05f,0.1125f},
		  {-0.015625f,0.059375f,0.109375f},
		  {-0.003125f,0.065625f,0.109375f},
		  {0.00625f,0.071875f,0.109375f},
		  {0.021875f,0.078125f,0.103125f},
		  {0.034375f,0.08125f,0.103125f},
		  {0.053125f,0.0875f,0.08125f},
		  {0.06875f,0.0875f,0.06875f}},
		 {{-0.06875f,0.0125f,0.078125f},
		  {-0.065625f,0.01875f,0.08125f},
		  {-0.065625f,0.021875f,0.084375f},
		  {-0.0625f,0.025f,0.090625f},
		  {-0.05625f,0.03125f,0.09375f},
		  {-0.053125f,0.0375f,0.096875f},
		  {-0.046875f,0.040625f,0.103125f},
		  {-0.040625f,0.046875f,0.10625f},
		  {-0.034375f,0.053125f,0.109375f},
		  {-0.025f,0.05625f,0.115625f},
		  {-0.015625f,0.065625f,0.1125f},
		  {-0.003125f,0.071875f,0.1125f},
		  {0.009375f,0.078125f,0.1125f},
		  {0.028125f,0.084375f,0.103125f},
		  {0.046875f,0.0875f,0.09375f},
		  {0.065625f,0.0875f,0.071875f}},
		 {{-0.078125f,0.015625f,0.071875f},
		  {-0.075f,0.021875f,0.075f},
		  {-0.071875f,0.025f,0.08125f},
		  {-0.071875f,0.028125f,0.084375f},
		  {-0.06875f,0.034375f,0.0875f},
		  {-0.065625f,0.0375f,0.09375f},
		  {-0.059375f,0.04375f,0.096875f},
		  {-0.053125f,0.046875f,0.103125f},
		  {-0.046875f,0.053125f,0.10625f},
		  {-0.0375f,0.059375f,0.1125f},
		  {-0.028125f,0.065625f,0.1125f},
		  {-0.015625f,0.071875f,0.115625f},
		  {0.f,0.08125f,0.109375f},
		  {0.015625f,0.0875f,0.10625f},
		  {0.040625f,0.090625f,0.09375f},
		  {0.0625f,0.0875f,0.078125f}},
		 {{-0.0875f,0.021875f,0.0625f},
		  {-0.084375f,0.025f,0.06875f},
		  {-0.084375f,0.028125f,0.071875f},
		  {-0.08125f,0.03125f,0.078125f},
		  {-0.078125f,0.034375f,0.084375f},
		  {-0.075f,0.0375f,0.090625f},
		  {-0.071875f,0.04375f,0.090625f},
		  {-0.065625f,0.046875f,0.1f},
		  {-0.059375f,0.053125f,0.103125f},
		  {-0.05f,0.059375f,0.109375f},
		  {-0.040625f,0.065625f,0.1125f},
		  {-0.03125f,0.071875f,0.115625f},
		  {-0.0125f,0.08125f,0.1125f},
		  {0.00625f,0.0875f,0.109375f},
		  {0.034375f,0.090625f,0.103125f},
		  {0.059375f,0.090625f,0.08125f}},
		 {{-0.09375f,0.025f,0.05625f},
		  {-0.09375f,0.025f,0.0625f},
		  {-0.090625f,0.028125f,0.06875f},
		  {-0.090625f,0.03125f,0.071875f},
		  {-0.0875f,0.034375f,0.078125f},
		  {-0.084375f,0.040625f,0.078125f},
		  {-0.084375f,0.04375f,0.08125f},
		  {-0.078125f,0.046875f,0.09375f},
		  {-0.071875f,0.053125f,0.096875f},
		  {-0.065625f,0.059375f,0.1f},
		  {-0.059375f,0.065625f,0.103125f},
		  {-0.046875f,0.071875f,0.109375f},
		  {-0.03125f,0.078125f,0.115625f},
		  {-0.009375f,0.0875f,0.1125f},
		  {0.03125f,0.09375f,0.096875f},
		  {0.f,0.f,0.f}},
		 {{0.f,0.f,0.f},
		  {-0.1f,0.028125f,0.053125f},
		  {-0.1f,0.03125f,0.053125f},
		  {-0.1f,0.034375f,0.05625f},
		  {-0.096875f,0.0375f,0.0625f},
		  {-0.096875f,0.0375f,0.06875f},
		  {-0.09375f,0.04375f,0.071875f},
		  {-0.090625f,0.046875f,0.078125f},
		  {-0.0875f,0.05f,0.084375f},
		  {-0.084375f,0.053125f,0.090625f},
		  {-0.078125f,0.059375f,0.096875f},
		  {-0.06875f,0.065625f,0.103125f},
		  {-0.05625f,0.075f,0.10625f},
		  {-0.034375f,0.084375f,0.1125f},
		  {0.025f,0.09375f,0.103125f},
		  {0.021875f,0.09375f,0.10625f}}},
		{{{0.003125f,-0.0125f,0.078125f},
		  {0.009375f,-0.009375f,0.078125f},
		  {0.0125f,-0.00625f,0.08125f},
		  {0.015625f,-0.003125f,0.084375f},
		  {0.021875f,0.f,0.084375f},
		  {0.028125f,0.00625f,0.084375f},
		  {0.03125f,0.0125f,0.0875f},
		  {0.040625f,0.015625f,0.084375f},
		  {0.04375f,0.025f,0.084375f},
		  {0.05f,0.028125f,0.084375f},
		  {0.05625f,0.0375f,0.08125f},
		  {0.065625f,0.040625f,0.075f},
		  {0.06875f,0.05f,0.071875f},
		  {0.075f,0.05625f,0.065625f},
		  {0.08125f,0.0625f,0.053125f},
		  {0.08125f,0.065625f,0.05f}},
		 {{0.f,-0.0125f,0.078125f},
		  {0.00625f,-0.0125f,0.08125f},
		  {0.009375f,-0.00625f,0.084375f},
		  {0.0125f,0.f,0.084375f},
		  {0.01875f,0.003125f,0.0875f},
		  {0.021875f,0.00625f,0.090625f},
		  {0.028125f,0.0125f,0.090625f},
		  {0.034375f,0.01875f,0.090625f},
		  {0.040625f,0.025f,0.090625f},
		  {0.05f,0.028125f,0.0875f},
		  {0.053125f,0.0375f,0.0875f},
		  {0.059375f,0.046875f,0.08125f},
		  {0.06875f,0.05f,0.075f},
		  {0.071875f,0.059375f,0.06875f},
		  {0.078125f,0.065625f,0.059375f},
		  {0.08125f,0.06875f,0.053125f}},
		 {{-0.003125f,-0.0125f,0.08125f},
		  {0.f,-0.009375f,0.084375f},
		  {0.003125f,-0.003125f,0.084375f},
		  {0.009375f,0.f,0.0875f},
		  {0.015625f,0.003125f,0.090625f},
		  {0.01875f,0.009375f,0.090625f},
		  {0.025f,0.0125f,0.09375f},
		  {0.03125f,0.01875f,0.09375f},
		  {0.0375f,0.028125f,0.090625f},
		  {0.04375f,0.034375f,0.090625f},
		  {0.05f,0.040625f,0.090625f},
		  {0.05625f,0.05f,0.084375f},
		  {0.065625f,0.053125f,0.08125f},
		  {0.071875f,0.059375f,0.071875f},
		  {0.075f,0.06875f,0.0625f},
		  {0.08125f,0.071875f,0.053125f}},
		 {{-0.009375f,-0.009375f,0.08125f},
		  {-0.00625f,-0.00625f,0.084375f},
		  {-0.003125f,-0.003125f,0.090625f},
		  {0.003125f,0.003125f,0.090625f},
		  {0.009375f,0.00625f,0.09375f},
		  {0.0125f,0.0125f,0.096875f},
		  {0.01875f,0.01875f,0.096875f},
		  {0.025f,0.025f,0.096875f},
		  {0.03125f,0.03125f,0.096875f},
		  {0.040625f,0.034375f,0.096875f},
		  {0.046875f,0.04375f,0.090625f},
		  {0.05625f,0.046875f,0.090625f},
		  {0.0625f,0.05625f,0.08125f},
		  {0.06875f,0.0625f,0.078125f},
		  {0.075f,0.06875f,0.065625f},
		  {0.08125f,0.075f,0.05f}},
		 {{-0.015625f,-0.00625f,0.084375f},
		  {-0.0125f,-0.003125f,0.0875f},
		  {-0.00625f,0.f,0.090625f},
		  {-0.003125f,0.00625f,0.09375f},
		  {0.003125f,0.00625f,0.096875f},
		  {0.00625f,0.0125f,0.1f},
		  {0.0125f,0.021875f,0.1f},
		  {0.021875f,0.021875f,0.103125f},
		  {0.028125f,0.028125f,0.103125f},
		  {0.034375f,0.0375f,0.1f},
		  {0.040625f,0.046875f,0.096875f},
		  {0.05f,0.053125f,0.090625f},
		  {0.05625f,0.059375f,0.090625f},
		  {0.065625f,0.065625f,0.08125f},
		  {0.071875f,0.071875f,0.071875f},
		  {0.078125f,0.078125f,0.053125f}},
		 {{-0.021875f,-0.00625f,0.084375f},
		  {-0.01875f,-0.003125f,0.090625f},
		  {-0.0125f,0.f,0.09375f},
		  {-0.009375f,0.00625f,0.096875f},
		  {-0.003125f,0.009375f,0.1f},
		  {0.f,0.015625f,0.103125f},
		  {0.009375f,0.01875f,0.10625f},
		  {0.0125f,0.028125f,0.10625f},
		  {0.021875f,0.03125f,0.10625f},
		  {0.028125f,0.040625f,0.10625f},
		  {0.0375f,0.046875f,0.103125f},
		  {0.04375f,0.05625f,0.096875f},
		  {0.053125f,0.0625f,0.090625f},
		  {0.0625f,0.06875f,0.08125f},
		  {0.06875f,0.075f,0.075f},
		  {0.078125f,0.078125f,0.059375f}},
		 {{-0.028125f,-0.003125f,0.0875f},
		  {-0.025f,0.f,0.090625f},
		  {-0.01875f,0.f,0.096875f},
		  {-0.015625f,0.00625f,0.1f},
		  {-0.0125f,0.0125f,0.103125f},
		  {-0.00625f,0.01875f,0.103125f},
		  {0.f,0.025f,0.10625f},
		  {0.00625f,0.03125f,0.10625f},
		  {0.0125f,0.0375f,0.109375f},
		  {0.021875f,0.04375f,0.109375f},
		  {0.03125f,0.05f,0.10625f},
		  {0.040625f,0.05625f,0.103125f},
		  {0.046875f,0.065625f,0.096875f},
		  {0.059375f,0.06875f,0.090625f},
		  {0.06875f,0.075f,0.078125f},
		  {0.075f,0.08125f,0.0625f}},
		 {{-0.034375f,-0.003125f,0.0875f},
		  {-0.03125f,0.003125f,0.090625f},
		  {-0.028125f,0.003125f,0.096875f},
		  {-0.025f,0.009375f,0.1f},
		  {-0.01875f,0.015625f,0.103125f},
		  {-0.015625f,0.021875f,0.10625f},
		  {-0.009375f,0.028125f,0.109375f},
		  {0.f,0.034375f,0.109375f},
		  {0.00625f,0.0375f,0.1125f},
		  {0.0125f,0.046875f,0.1125f},
		  {0.025f,0.053125f,0.109375f},
		  {0.03125f,0.059375f,0.109375f},
		  {0.04375f,0.065625f,0.103125f},
		  {0.053125f,0.071875f,0.096875f},
		  {0.065625f,0.078125f,0.08125f},
		  {0.075f,0.08125f,0.065625f}},
		 {{-0.04375f,0.f,0.0875f},
		  {-0.040625f,0.00625f,0.090625f},
		  {-0.0375f,0.009375f,0.09375f},
		  {-0.03125f,0.009375f,0.103125f},
		  {-0.028125f,0.01875f,0.103125f},
		  {-0.021875f,0.025f,0.10625f},
		  {-0.015625f,0.028125f,0.1125f},
		  {-0.009375f,0.03125f,0.115625f},
		  {-0.003125f,0.04375f,0.1125f},
		  {0.00625f,0.05f,0.1125f},
		  {0.015625f,0.05625f,0.1125f},
		  {0.025f,0.0625f,0.109375f},
		  {0.0375f,0.06875f,0.10625f},
		  {0.046875f,0.075f,0.1f},
		  {0.059375f,0.08125f,0.0875f},
		  {0.06875f,0.08125f,0.078125f}},
		 {{-0.053125f,0.003125f,0.084375f},
		  {-0.05f,0.00625f,0.090625f},
		  {-0.046875f,0.0125f,0.09375f},
		  {-0.040625f,0.015625f,0.1f},
		  {-0.0375f,0.021875f,0.103125f},
		  {-0.03125f,0.028125f,0.10625f},
		  {-0.025f,0.03125f,0.1125f},
		  {-0.021875f,0.040625f,0.1125f},
		  {-0.0125f,0.04375f,0.115625f},
		  {-0.003125f,0.05f,0.11875f},
		  {0.00625f,0.05625f,0.11875f},
		  {0.015625f,0.065625f,0.1125f},
		  {0.028125f,0.071875f,0.109375f},
		  {0.04375f,0.075f,0.10625f},
		  {0.05625f,0.08125f,0.09375f},
		  {0.071875f,0.084375f,0.06875f}},
		 {{-0.059375f,0.00625f,0.084375f},
		  {-0.059375f,0.0125f,0.0875f},
		  {-0.05625f,0.0125f,0.09375f},
		  {-0.05f,0.015625f,0.1f},
		  {-0.046875f,0.021875f,0.103125f},
		  {-0.04375f,0.028125f,0.10625f},
		  {-0.0375f,0.034375f,0.109375f},
		  {-0.03125f,0.040625f,0.1125f},
		  {-0.021875f,0.046875f,0.115625f},
		  {-0.0125f,0.053125f,0.11875f},
		  {-0.003125f,0.059375f,0.11875f},
		  {0.009375f,0.065625f,0.11875f},
		  {0.021875f,0.071875f,0.115625f},
		  {0.034375f,0.078125f,0.109375f},
		  {0.05f,0.084375f,0.096875f},
		  {0.071875f,0.084375f,0.071875f}},
		 {{-0.06875f,0.009375f,0.08125f},
		  {-0.065625f,0.009375f,0.0875f},
		  {-0.065625f,0.015625f,0.090625f},
		  {-0.0625f,0.021875f,0.09375f},
		  {-0.05625f,0.025f,0.1f},
		  {-0.053125f,0.03125f,0.103125f},
		  {-0.046875f,0.034375f,0.109375f},
		  {-0.040625f,0.040625f,0.115625f},
		  {-0.03125f,0.046875f,0.11875f},
		  {-0.025f,0.053125f,0.121875f},
		  {-0.015625f,0.0625f,0.11875f},
		  {-0.003125f,0.06875f,0.11875f},
		  {0.0125f,0.071875f,0.121875f},
		  {0.025f,0.08125f,0.1125f},
		  {0.046875f,0.084375f,0.103125f},
		  {0.06875f,0.0875f,0.075f}},
		 {{-0.078125f,0.0125f,0.075f},
		  {-0.075f,0.015625f,0.08125f},
		  {-0.075f,0.01875f,0.084375f},
		  {-0.071875f,0.025f,0.0875f},
		  {-0.06875f,0.028125f,0.09375f},
		  {-0.0625f,0.034375f,0.1f},
		  {-0.059375f,0.0375f,0.10625f},
		  {-0.053125f,0.04375f,0.109375f},
		  {-0.04375f,0.046875f,0.11875f},
		  {-0.0375f,0.05625f,0.115625f},
		  {-0.025f,0.059375f,0.125f},
		  {-0.015625f,0.06875f,0.121875f},
		  {0.f,0.075f,0.121875f},
		  {0.015625f,0.08125f,0.11875f},
		  {0.040625f,0.0875f,0.103125f},
		  {0.065625f,0.0875f,0.078125f}},
		 {{-0.0875f,0.015625f,0.06875f},
		  {-0.084375f,0.01875f,0.075f},
		  {-0.084375f,0.021875f,0.078125f},
		  {-0.08125f,0.025f,0.084375f},
		  {-0.078125f,0.03125f,0.0875f},
		  {-0.075f,0.034375f,0.09375f},
		  {-0.071875f,0.040625f,0.096875f},
		  {-0.065625f,0.04375f,0.10625f},
		  {-0.059375f,0.05f,0.109375f},
		  {-0.05f,0.053125f,0.11875f},
		  {-0.040625f,0.0625f,0.11875f},
		  {-0.028125f,0.06875f,0.121875f},
		  {-0.01875f,0.075f,0.121875f},
		  {0.003125f,0.08125f,0.121875f},
		  {0.03125f,0.090625f,0.10625f},
		  {0.0625f,0.090625f,0.08125f}},
		 {{-0.09375f,0.01875f,0.0625f},
		  {-0.09375f,0.021875f,0.065625f},
		  {-0.09375f,0.025f,0.06875f},
		  {-0.090625f,0.028125f,0.075f},
		  {-0.090625f,0.03125f,0.08125f},
		  {-0.084375f,0.034375f,0.090625f},
		  {-0.084375f,0.040625f,0.0875f},
		  {-0.078125f,0.04375f,0.1f},
		  {-0.071875f,0.05f,0.103125f},
		  {-0.065625f,0.05625f,0.10625f},
		  {-0.05625f,0.0625f,0.1125f},
		  {-0.046875f,0.06875f,0.115625f},
		  {-0.03125f,0.075f,0.121875f},
		  {-0.009375f,0.08125f,0.125f},
		  {0.025f,0.090625f,0.109375f},
		  {0.034375f,0.090625f,0.10625f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,0.028125f,0.059375f},
		  {-0.1f,0.03125f,0.0625f},
		  {-0.1f,0.034375f,0.065625f},
		  {-0.096875f,0.0375f,0.071875f},
		  {-0.09375f,0.040625f,0.078125f},
		  {-0.090625f,0.04375f,0.0875f},
		  {-0.0875f,0.046875f,0.09375f},
		  {-0.084375f,0.053125f,0.09375f},
		  {-0.078125f,0.05625f,0.103125f},
		  {-0.06875f,0.0625f,0.109375f},
		  {-0.05625f,0.071875f,0.1125f},
		  {-0.034375f,0.08125f,0.11875f},
		  {0.00625f,0.090625f,0.11875f},
		  {0.0375f,0.090625f,0.10625f}}},
		{{{0.00625f,-0.01875f,0.078125f},
		  {0.009375f,-0.015625f,0.08125f},
		  {0.015625f,-0.0125f,0.08125f},
		  {0.01875f,-0.009375f,0.084375f},
		  {0.025f,-0.003125f,0.084375f},
		  {0.03125f,-0.003125f,0.0875f},
		  {0.034375f,0.00625f,0.0875f},
		  {0.040625f,0.0125f,0.0875f},
		  {0.046875f,0.015625f,0.090625f},
		  {0.053125f,0.025f,0.084375f},
		  {0.059375f,0.03125f,0.084375f},
		  {0.065625f,0.0375f,0.08125f},
		  {0.071875f,0.046875f,0.071875f},
		  {0.078125f,0.053125f,0.065625f},
		  {0.08125f,0.0625f,0.05625f},
		  {0.084375f,0.065625f,0.05f}},
		 {{0.f,-0.015625f,0.08125f},
		  {0.003125f,-0.0125f,0.084375f},
		  {0.009375f,-0.009375f,0.084375f},
		  {0.015625f,-0.009375f,0.0875f},
		  {0.01875f,-0.003125f,0.090625f},
		  {0.025f,0.003125f,0.090625f},
		  {0.03125f,0.009375f,0.090625f},
		  {0.0375f,0.0125f,0.09375f},
		  {0.04375f,0.01875f,0.090625f},
		  {0.05f,0.025f,0.090625f},
		  {0.05625f,0.034375f,0.0875f},
		  {0.0625f,0.040625f,0.0875f},
		  {0.06875f,0.05f,0.078125f},
		  {0.075f,0.05625f,0.071875f},
		  {0.08125f,0.0625f,0.0625f},
		  {0.084375f,0.06875f,0.05f}},
		 {{-0.003125f,-0.015625f,0.08125f},
		  {0.f,-0.0125f,0.084375f},
		  {0.00625f,-0.009375f,0.0875f},
		  {0.009375f,-0.003125f,0.090625f},
		  {0.015625f,-0.003125f,0.09375f},
		  {0.021875f,0.f,0.096875f},
		  {0.028125f,0.00625f,0.096875f},
		  {0.034375f,0.0125f,0.096875f},
		  {0.040625f,0.01875f,0.096875f},
		  {0.046875f,0.028125f,0.09375f},
		  {0.053125f,0.034375f,0.09375f},
		  {0.059375f,0.04375f,0.0875f},
		  {0.065625f,0.05f,0.0875f},
		  {0.075f,0.05625f,0.075f},
		  {0.078125f,0.065625f,0.065625f},
		  {0.084375f,0.071875f,0.05f}},
		 {{-0.009375f,-0.015625f,0.084375f},
		  {-0.003125f,-0.0125f,0.0875f},
		  {0.f,-0.00625f,0.090625f},
		  {0.003125f,-0.003125f,0.09375f},
		  {0.009375f,0.f,0.096875f},
		  {0.015625f,0.003125f,0.1f},
		  {0.021875f,0.0125f,0.1f},
		  {0.028125f,0.01875f,0.1f},
		  {0.034375f,0.025f,0.1f},
		  {0.040625f,0.03125f,0.1f},
		  {0.05f,0.0375f,0.096875f},
		  {0.05625f,0.04375f,0.096875f},
		  {0.0625f,0.053125f,0.090625f},
		  {0.071875f,0.059375f,0.078125f},
		  {0.078125f,0.065625f,0.06875f},
		  {0.08125f,0.075f,0.05625f}},
		 {{-0.0125f,-0.015625f,0.0875f},
		  {-0.009375f,-0.0125f,0.090625f},
		  {-0.00625f,-0.00625f,0.09375f},
		  {0.f,-0.003125f,0.096875f},
		  {0.003125f,0.003125f,0.1f},
		  {0.009375f,0.00625f,0.103125f},
		  {0.015625f,0.015625f,0.103125f},
		  {0.021875f,0.01875f,0.10625f},
		  {0.028125f,0.025f,0.10625f},
		  {0.0375f,0.03125f,0.10625f},
		  {0.04375f,0.040625f,0.103125f},
		  {0.05f,0.046875f,0.103125f},
		  {0.059375f,0.05625f,0.090625f},
		  {0.065625f,0.0625f,0.090625f},
		  {0.075f,0.06875f,0.075f},
		  {0.08125f,0.075f,0.059375f}},
		 {{-0.021875f,-0.0125f,0.0875f},
		  {-0.015625f,-0.0125f,0.09375f},
		  {-0.0125f,-0.00625f,0.096875f},
		  {-0.009375f,0.f,0.1f},
		  {-0.003125f,0.00625f,0.103125f},
		  {0.003125f,0.009375f,0.10625f},
		  {0.009375f,0.0125f,0.109375f},
		  {0.015625f,0.021875f,0.109375f},
		  {0.025f,0.025f,0.1125f},
		  {0.03125f,0.034375f,0.109375f},
		  {0.0375f,0.04375f,0.10625f},
		  {0.046875f,0.05f,0.103125f},
		  {0.05625f,0.05625f,0.1f},
		  {0.0625f,0.065625f,0.090625f},
		  {0.071875f,0.071875f,0.08125f},
		  {0.078125f,0.078125f,0.0625f}},
		 {{-0.028125f,-0.009375f,0.0875f},
		  {-0.025f,-0.00625f,0.09375f},
		  {-0.01875f,-0.00625f,0.1f},
		  {-0.015625f,0.f,0.103125f},
		  {-0.009375f,0.00625f,0.10625f},
		  {-0.00625f,0.0125f,0.109375f},
		  {0.003125f,0.015625f,0.1125f},
		  {0.009375f,0.025f,0.1125f},
		  {0.015625f,0.03125f,0.1125f},
		  {0.025f,0.034375f,0.115625f},
		  {0.03125f,0.04375f,0.115625f},
		  {0.040625f,0.053125f,0.109375f},
		  {0.05f,0.059375f,0.103125f},
		  {0.059375f,0.065625f,0.1f},
		  {0.06875f,0.075f,0.08125f},
		  {0.078125f,0.078125f,0.06875f}},
		 {{-0.034375f,-0.009375f,0.090625f},
		  {-0.03125f,-0.003125f,0.09375f},
		  {-0.028125f,0.f,0.1f},
		  {-0.021875f,0.f,0.10625f},
		  {-0.01875f,0.009375f,0.10625f},
		  {-0.0125f,0.015625f,0.109375f},
		  {-0.00625f,0.021875f,0.1125f},
		  {0.f,0.028125f,0.115625f},
		  {0.009375f,0.03125f,0.11875f},
		  {0.015625f,0.040625f,0.11875f},
		  {0.025f,0.046875f,0.115625f},
		  {0.034375f,0.053125f,0.115625f},
		  {0.04375f,0.0625f,0.109375f},
		  {0.053125f,0.06875f,0.103125f},
		  {0.065625f,0.075f,0.090625f},
		  {0.075f,0.08125f,0.071875f}},
		 {{-0.04375f,-0.00625f,0.090625f},
		  {-0.040625f,0.f,0.09375f},
		  {-0.0375f,0.003125f,0.1f},
		  {-0.03125f,0.003125f,0.10625f},
		  {-0.028125f,0.0125f,0.109375f},
		  {-0.021875f,0.01875f,0.1125f},
		  {-0.015625f,0.021875f,0.115625f},
		  {-0.009375f,0.028125f,0.11875f},
		  {0.f,0.0375f,0.11875f},
		  {0.00625f,0.04375f,0.121875f},
		  {0.015625f,0.05f,0.121875f},
		  {0.028125f,0.05625f,0.11875f},
		  {0.0375f,0.0625f,0.115625f},
		  {0.05f,0.071875f,0.103125f},
		  {0.0625f,0.078125f,0.090625f},
		  {0.075f,0.08125f,0.075f}},
		 {{-0.05f,-0.00625f,0.090625f},
		  {-0.046875f,0.003125f,0.09375f},
		  {-0.04375f,0.003125f,0.1f},
		  {-0.040625f,0.009375f,0.103125f},
		  {-0.0375f,0.0125f,0.109375f},
		  {-0.03125f,0.021875f,0.1125f},
		  {-0.025f,0.028125f,0.115625f},
		  {-0.01875f,0.034375f,0.11875f},
		  {-0.0125f,0.040625f,0.121875f},
		  {0.f,0.04375f,0.125f},
		  {0.00625f,0.053125f,0.121875f},
		  {0.01875f,0.059375f,0.121875f},
		  {0.03125f,0.0625f,0.121875f},
		  {0.04375f,0.071875f,0.1125f},
		  {0.05625f,0.078125f,0.103125f},
		  {0.06875f,0.08125f,0.0875f}},
		 {{-0.059375f,0.f,0.0875f},
		  {-0.05625f,0.003125f,0.09375f},
		  {-0.053125f,0.009375f,0.096875f},
		  {-0.05f,0.0125f,0.103125f},
		  {-0.046875f,0.01875f,0.10625f},
		  {-0.040625f,0.021875f,0.1125f},
		  {-0.034375f,0.025f,0.11875f},
		  {-0.028125f,0.03125f,0.121875f},
		  {-0.021875f,0.040625f,0.121875f},
		  {-0.0125f,0.046875f,0.125f},
		  {-0.003125f,0.053125f,0.128125f},
		  {0.009375f,0.059375f,0.128125f},
		  {0.021875f,0.065625f,0.125f},
		  {0.034375f,0.075f,0.115625f},
		  {0.05f,0.08125f,0.103125f},
		  {0.071875f,0.084375f,0.075f}},
		 {{-0.06875f,0.003125f,0.084375f},
		  {-0.065625f,0.00625f,0.090625f},
		  {-0.0625f,0.009375f,0.096875f},
		  {-0.059375f,0.0125f,0.103125f},
		  {-0.05625f,0.01875f,0.10625f},
		  {-0.053125f,0.025f,0.109375f},
		  {-0.046875f,0.03125f,0.115625f},
		  {-0.040625f,0.0375f,0.11875f},
		  {-0.03125f,0.04375f,0.121875f},
		  {-0.025f,0.05f,0.125f},
		  {-0.0125f,0.053125f,0.13125f},
		  {0.f,0.0625f,0.128125f},
		  {0.009375f,0.06875f,0.128125f},
		  {0.028125f,0.075f,0.121875f},
		  {0.04375f,0.084375f,0.10625f},
		  {0.071875f,0.084375f,0.078125f}},
		 {{-0.078125f,0.009375f,0.078125f},
		  {-0.075f,0.0125f,0.084375f},
		  {-0.075f,0.015625f,0.0875f},
		  {-0.071875f,0.01875f,0.09375f},
		  {-0.06875f,0.021875f,0.1f},
		  {-0.0625f,0.028125f,0.10625f},
		  {-0.059375f,0.034375f,0.109375f},
		  {-0.05f,0.0375f,0.11875f},
		  {-0.04375f,0.04375f,0.121875f},
		  {-0.0375f,0.05f,0.125f},
		  {-0.028125f,0.05625f,0.128125f},
		  {-0.0125f,0.0625f,0.13125f},
		  {0.f,0.06875f,0.13125f},
		  {0.015625f,0.075f,0.128125f},
		  {0.0375f,0.084375f,0.1125f},
		  {0.05f,0.084375f,0.109375f}},
		 {{-0.0875f,0.0125f,0.071875f},
		  {-0.084375f,0.015625f,0.078125f},
		  {-0.084375f,0.01875f,0.08125f},
		  {-0.08125f,0.021875f,0.0875f},
		  {-0.078125f,0.025f,0.096875f},
		  {-0.075f,0.03125f,0.1f},
		  {-0.071875f,0.0375f,0.103125f},
		  {-0.0625f,0.040625f,0.1125f},
		  {-0.059375f,0.046875f,0.115625f},
		  {-0.05f,0.05f,0.121875f},
		  {-0.040625f,0.05625f,0.128125f},
		  {-0.028125f,0.0625f,0.13125f},
		  {-0.015625f,0.071875f,0.128125f},
		  {0.00625f,0.078125f,0.128125f},
		  {0.025f,0.084375f,0.121875f},
		  {0.05625f,0.0875f,0.096875f}},
		 {{-0.096875f,0.015625f,0.0625f},
		  {-0.09375f,0.01875f,0.06875f},
		  {-0.09375f,0.021875f,0.075f},
		  {-0.090625f,0.025f,0.08125f},
		  {-0.090625f,0.028125f,0.084375f},
		  {-0.0875f,0.034375f,0.0875f},
		  {-0.08125f,0.0375f,0.096875f},
		  {-0.078125f,0.040625f,0.103125f},
		  {-0.071875f,0.046875f,0.109375f},
		  {-0.065625f,0.053125f,0.1125f},
		  {-0.053125f,0.05625f,0.125f},
		  {-0.04375f,0.0625f,0.128125f},
		  {-0.03125f,0.071875f,0.128125f},
		  {-0.0125f,0.075f,0.134375f},
		  {0.015625f,0.0875f,0.121875f},
		  {0.0375f,0.0875f,0.115625f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,0.028125f,0.06875f},
		  {-0.1f,0.03125f,0.071875f},
		  {-0.096875f,0.034375f,0.078125f},
		  {-0.096875f,0.0375f,0.08125f},
		  {-0.090625f,0.040625f,0.09375f},
		  {-0.0875f,0.04375f,0.1f},
		  {-0.08125f,0.05f,0.103125f},
		  {-0.075f,0.05625f,0.109375f},
		  {-0.065625f,0.0625f,0.115625f},
		  {-0.05f,0.06875f,0.125f},
		  {-0.03125f,0.075f,0.13125f},
		  {0.003125f,0.0875f,0.125f},
		  {0.025f,0.0875f,0.121875f}}},
		{{{0.009375f,-0.025f,0.078125f},
		  {0.0125f,-0.021875f,0.08125f},
		  {0.015625f,-0.01875f,0.084375f},
		  {0.021875f,-0.0125f,0.084375f},
		  {0.025f,-0.009375f,0.0875f},
		  {0.03125f,-0.00625f,0.0875f},
		  {0.0375f,-0.003125f,0.090625f},
		  {0.04375f,0.003125f,0.090625f},
		  {0.05f,0.0125f,0.0875f},
		  {0.05625f,0.015625f,0.090625f},
		  {0.0625f,0.025f,0.084375f},
		  {0.06875f,0.03125f,0.084375f},
		  {0.075f,0.040625f,0.075f},
		  {0.08125f,0.046875f,0.06875f},
		  {0.084375f,0.059375f,0.059375f},
		  {0.084375f,0.0625f,0.05625f}},
		 {{0.003125f,-0.021875f,0.08125f},
		  {0.009375f,-0.025f,0.084375f},
		  {0.0125f,-0.01875f,0.0875f},
		  {0.015625f,-0.015625f,0.090625f},
		  {0.021875f,-0.009375f,0.090625f},
		  {0.028125f,-0.00625f,0.09375f},
		  {0.034375f,0.f,0.09375f},
		  {0.040625f,0.003125f,0.096875f},
		  {0.046875f,0.0125f,0.09375f},
		  {0.053125f,0.01875f,0.09375f},
		  {0.059375f,0.025f,0.09375f},
		  {0.065625f,0.034375f,0.0875f},
		  {0.071875f,0.04375f,0.08125f},
		  {0.078125f,0.05f,0.075f},
		  {0.084375f,0.059375f,0.0625f},
		  {0.084375f,0.06875f,0.053125f}},
		 {{-0.003125f,-0.021875f,0.084375f},
		  {0.003125f,-0.021875f,0.0875f},
		  {0.00625f,-0.015625f,0.090625f},
		  {0.0125f,-0.015625f,0.09375f},
		  {0.01875f,-0.0125f,0.096875f},
		  {0.021875f,-0.003125f,0.096875f},
		  {0.028125f,0.003125f,0.1f},
		  {0.034375f,0.009375f,0.1f},
		  {0.04375f,0.0125f,0.1f},
		  {0.05f,0.01875f,0.1f},
		  {0.05625f,0.028125f,0.096875f},
		  {0.0625f,0.0375f,0.09375f},
		  {0.06875f,0.046875f,0.0875f},
		  {0.075f,0.053125f,0.084375f},
		  {0.08125f,0.0625f,0.071875f},
		  {0.084375f,0.071875f,0.053125f}},
		 {{-0.00625f,-0.025f,0.0875f},
		  {-0.003125f,-0.01875f,0.090625f},
		  {0.003125f,-0.01875f,0.09375f},
		  {0.00625f,-0.0125f,0.096875f},
		  {0.0125f,-0.009375f,0.1f},
		  {0.01875f,-0.00625f,0.103125f},
		  {0.021875f,0.00625f,0.103125f},
		  {0.03125f,0.00625f,0.10625f},
		  {0.0375f,0.01875f,0.103125f},
		  {0.04375f,0.025f,0.103125f},
		  {0.053125f,0.028125f,0.103125f},
		  {0.059375f,0.0375f,0.1f},
		  {0.065625f,0.046875f,0.09375f},
		  {0.071875f,0.05625f,0.0875f},
		  {0.078125f,0.065625f,0.075f},
		  {0.084375f,0.071875f,0.059375f}},
		 {{-0.0125f,-0.01875f,0.0875f},
		  {-0.009375f,-0.01875f,0.09375f},
		  {-0.003125f,-0.015625f,0.096875f},
		  {0.f,-0.009375f,0.1f},
		  {0.00625f,-0.00625f,0.103125f},
		  {0.0125f,0.f,0.10625f},
		  {0.01875f,0.003125f,0.109375f},
		  {0.025f,0.0125f,0.109375f},
		  {0.03125f,0.01875f,0.109375f},
		  {0.0375f,0.028125f,0.109375f},
		  {0.046875f,0.034375f,0.10625f},
		  {0.053125f,0.04375f,0.103125f},
		  {0.0625f,0.05f,0.096875f},
		  {0.06875f,0.059375f,0.090625f},
		  {0.078125f,0.065625f,0.078125f},
		  {0.08125f,0.075f,0.0625f}},
		 {{-0.01875f,-0.01875f,0.090625f},
		  {-0.015625f,-0.015625f,0.09375f},
		  {-0.009375f,-0.015625f,0.1f},
		  {-0.00625f,-0.009375f,0.103125f},
		  {0.f,-0.003125f,0.10625f},
		  {0.003125f,0.003125f,0.109375f},
		  {0.009375f,0.009375f,0.1125f},
		  {0.01875f,0.0125f,0.115625f},
		  {0.025f,0.01875f,0.115625f},
		  {0.03125f,0.028125f,0.115625f},
		  {0.040625f,0.0375f,0.1125f},
		  {0.05f,0.04375f,0.109375f},
		  {0.05625f,0.053125f,0.103125f},
		  {0.065625f,0.059375f,0.096875f},
		  {0.075f,0.06875f,0.08125f},
		  {0.08125f,0.075f,0.06875f}},
		 {{-0.028125f,-0.015625f,0.090625f},
		  {-0.021875f,-0.015625f,0.096875f},
		  {-0.01875f,-0.009375f,0.1f},
		  {-0.0125f,-0.009375f,0.10625f},
		  {-0.009375f,0.f,0.109375f},
		  {-0.003125f,0.00625f,0.1125f},
		  {0.003125f,0.0125f,0.115625f},
		  {0.009375f,0.015625f,0.11875f},
		  {0.01875f,0.01875f,0.121875f},
		  {0.025f,0.03125f,0.11875f},
		  {0.034375f,0.040625f,0.115625f},
		  {0.040625f,0.046875f,0.115625f},
		  {0.05f,0.05625f,0.109375f},
		  {0.0625f,0.0625f,0.1f},
		  {0.071875f,0.06875f,0.090625f},
		  {0.078125f,0.078125f,0.075f}},
		 {{-0.034375f,-0.015625f,0.09375f},
		  {-0.03125f,-0.009375f,0.096875f},
		  {-0.025f,-0.009375f,0.103125f},
		  {-0.021875f,-0.003125f,0.10625f},
		  {-0.015625f,0.f,0.1125f},
		  {-0.0125f,0.009375f,0.115625f},
		  {-0.003125f,0.009375f,0.121875f},
		  {0.003125f,0.01875f,0.121875f},
		  {0.009375f,0.028125f,0.121875f},
		  {0.01875f,0.03125f,0.125f},
		  {0.028125f,0.0375f,0.125f},
		  {0.034375f,0.05f,0.11875f},
		  {0.046875f,0.053125f,0.11875f},
		  {0.05625f,0.0625f,0.109375f},
		  {0.065625f,0.071875f,0.096875f},
		  {0.078125f,0.078125f,0.078125f}},
		 {{-0.040625f,-0.0125f,0.09375f},
		  {-0.0375f,-0.0125f,0.1f},
		  {-0.034375f,-0.003125f,0.103125f},
		  {-0.03125f,0.f,0.109375f},
		  {-0.025f,0.00625f,0.1125f},
		  {-0.021875f,0.009375f,0.11875f},
		  {-0.0125f,0.015625f,0.121875f},
		  {-0.00625f,0.021875f,0.125f},
		  {0.f,0.03125f,0.125f},
		  {0.009375f,0.034375f,0.128125f},
		  {0.01875f,0.040625f,0.128125f},
		  {0.028125f,0.05f,0.125f},
		  {0.0375f,0.059375f,0.11875f},
		  {0.05f,0.065625f,0.1125f},
		  {0.0625f,0.075f,0.096875f},
		  {0.075f,0.08125f,0.078125f}},
		 {{-0.05f,-0.009375f,0.090625f},
		  {-0.046875f,-0.00625f,0.096875f},
		  {-0.04375f,0.f,0.103125f},
		  {-0.040625f,0.003125f,0.109375f},
		  {-0.034375f,0.009375f,0.1125f},
		  {-0.03125f,0.0125f,0.11875f},
		  {-0.021875f,0.015625f,0.125f},
		  {-0.015625f,0.021875f,0.128125f},
		  {-0.009375f,0.03125f,0.128125f},
		  {0.f,0.040625f,0.128125f},
		  {0.009375f,0.04375f,0.13125f},
		  {0.01875f,0.053125f,0.128125f},
		  {0.028125f,0.0625f,0.125f},
		  {0.04375f,0.065625f,0.121875f},
		  {0.05625f,0.075f,0.109375f},
		  {0.071875f,0.08125f,0.0875f}},
		 {{-0.059375f,-0.00625f,0.090625f},
		  {-0.05625f,-0.003125f,0.096875f},
		  {-0.053125f,0.003125f,0.1f},
		  {-0.05f,0.00625f,0.10625f},
		  {-0.04375f,0.0125f,0.1125f},
		  {-0.040625f,0.015625f,0.11875f},
		  {-0.034375f,0.021875f,0.121875f},
		  {-0.028125f,0.028125f,0.125f},
		  {-0.01875f,0.03125f,0.13125f},
		  {-0.0125f,0.040625f,0.13125f},
		  {0.f,0.05f,0.13125f},
		  {0.009375f,0.05625f,0.13125f},
		  {0.01875f,0.0625f,0.13125f},
		  {0.034375f,0.071875f,0.121875f},
		  {0.05f,0.075f,0.115625f},
		  {0.065625f,0.08125f,0.1f}},
		 {{-0.06875f,-0.003125f,0.0875f},
		  {-0.065625f,0.f,0.09375f},
		  {-0.0625f,0.003125f,0.1f},
		  {-0.059375f,0.00625f,0.10625f},
		  {-0.05625f,0.015625f,0.109375f},
		  {-0.05f,0.015625f,0.11875f},
		  {-0.046875f,0.025f,0.11875f},
		  {-0.0375f,0.03125f,0.125f},
		  {-0.03125f,0.0375f,0.128125f},
		  {-0.021875f,0.04375f,0.13125f},
		  {-0.0125f,0.05f,0.134375f},
		  {-0.003125f,0.05625f,0.134375f},
		  {0.0125f,0.065625f,0.13125f},
		  {0.025f,0.071875f,0.128125f},
		  {0.04375f,0.078125f,0.11875f},
		  {0.06875f,0.084375f,0.0875f}},
		 {{-0.078125f,0.003125f,0.08125f},
		  {-0.075f,0.00625f,0.0875f},
		  {-0.075f,0.009375f,0.09375f},
		  {-0.071875f,0.0125f,0.1f},
		  {-0.065625f,0.01875f,0.10625f},
		  {-0.0625f,0.021875f,0.1125f},
		  {-0.05625f,0.025f,0.11875f},
		  {-0.05f,0.034375f,0.121875f},
		  {-0.04375f,0.0375f,0.128125f},
		  {-0.0375f,0.04375f,0.13125f},
		  {-0.028125f,0.05f,0.134375f},
		  {-0.015625f,0.059375f,0.134375f},
		  {-0.003125f,0.065625f,0.134375f},
		  {0.015625f,0.06875f,0.1375f},
		  {0.034375f,0.08125f,0.121875f},
		  {0.0625f,0.084375f,0.1f}},
		 {{-0.0875f,0.009375f,0.075f},
		  {-0.0875f,0.0125f,0.078125f},
		  {-0.084375f,0.0125f,0.0875f},
		  {-0.08125f,0.015625f,0.09375f},
		  {-0.078125f,0.021875f,0.1f},
		  {-0.075f,0.025f,0.10625f},
		  {-0.06875f,0.028125f,0.115625f},
		  {-0.0625f,0.034375f,0.11875f},
		  {-0.05625f,0.0375f,0.128125f},
		  {-0.05f,0.046875f,0.128125f},
		  {-0.040625f,0.053125f,0.13125f},
		  {-0.028125f,0.059375f,0.134375f},
		  {-0.0125f,0.065625f,0.1375f},
		  {0.003125f,0.071875f,0.1375f},
		  {0.021875f,0.08125f,0.128125f},
		  {0.05625f,0.084375f,0.109375f}},
		 {{-0.096875f,0.0125f,0.065625f},
		  {-0.09375f,0.015625f,0.071875f},
		  {-0.09375f,0.01875f,0.078125f},
		  {-0.090625f,0.021875f,0.084375f},
		  {-0.090625f,0.025f,0.090625f},
		  {-0.0875f,0.028125f,0.096875f},
		  {-0.08125f,0.03125f,0.10625f},
		  {-0.075f,0.034375f,0.115625f},
		  {-0.071875f,0.040625f,0.11875f},
		  {-0.0625f,0.04375f,0.128125f},
		  {-0.053125f,0.053125f,0.128125f},
		  {-0.040625f,0.059375f,0.134375f},
		  {-0.028125f,0.065625f,0.1375f},
		  {-0.015625f,0.071875f,0.1375f},
		  {0.015625f,0.08125f,0.13125f},
		  {0.040625f,0.084375f,0.121875f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,0.028125f,0.078125f},
		  {-0.096875f,0.03125f,0.084375f},
		  {-0.09375f,0.034375f,0.090625f},
		  {-0.090625f,0.0375f,0.1f},
		  {-0.084375f,0.040625f,0.109375f},
		  {-0.08125f,0.046875f,0.109375f},
		  {-0.06875f,0.05f,0.125f},
		  {-0.0625f,0.05625f,0.128125f},
		  {-0.04375f,0.0625f,0.1375f},
		  {-0.028125f,0.071875f,0.1375f},
		  {0.f,0.08125f,0.134375f},
		  {0.028125f,0.084375f,0.128125f}}},
		{{{0.009375f,-0.03125f,0.078125f},
		  {0.0125f,-0.028125f,0.08125f},
		  {0.01875f,-0.028125f,0.084375f},
		  {0.021875f,-0.021875f,0.0875f},
		  {0.028125f,-0.015625f,0.0875f},
		  {0.034375f,-0.015625f,0.090625f},
		  {0.040625f,-0.009375f,0.090625f},
		  {0.04375f,0.f,0.09375f},
		  {0.05f,0.00625f,0.09375f},
		  {0.05625f,0.0125f,0.09375f},
		  {0.0625f,0.021875f,0.090625f},
		  {0.071875f,0.025f,0.084375f},
		  {0.075f,0.0375f,0.08125f},
		  {0.08125f,0.046875f,0.075f},
		  {0.084375f,0.05625f,0.0625f},
		  {0.0875f,0.065625f,0.05f}},
		 {{0.00625f,-0.03125f,0.08125f},
		  {0.009375f,-0.028125f,0.084375f},
		  {0.015625f,-0.028125f,0.0875f},
		  {0.01875f,-0.021875f,0.090625f},
		  {0.021875f,-0.015625f,0.09375f},
		  {0.028125f,-0.0125f,0.096875f},
		  {0.034375f,-0.00625f,0.096875f},
		  {0.040625f,0.f,0.096875f},
		  {0.046875f,0.00625f,0.1f},
		  {0.05625f,0.009375f,0.096875f},
		  {0.0625f,0.01875f,0.09375f},
		  {0.06875f,0.028125f,0.090625f},
		  {0.075f,0.0375f,0.084375f},
		  {0.078125f,0.05f,0.078125f},
		  {0.084375f,0.05625f,0.071875f},
		  {0.0875f,0.06875f,0.05f}},
		 {{0.f,-0.028125f,0.084375f},
		  {0.00625f,-0.028125f,0.0875f},
		  {0.009375f,-0.021875f,0.090625f},
		  {0.015625f,-0.025f,0.09375f},
		  {0.01875f,-0.015625f,0.096875f},
		  {0.025f,-0.0125f,0.1f},
		  {0.03125f,-0.003125f,0.1f},
		  {0.0375f,0.f,0.103125f},
		  {0.04375f,0.00625f,0.103125f},
		  {0.05f,0.015625f,0.103125f},
		  {0.05625f,0.025f,0.1f},
		  {0.065625f,0.028125f,0.096875f},
		  {0.071875f,0.0375f,0.09375f},
		  {0.078125f,0.05f,0.08125f},
		  {0.08125f,0.059375f,0.075f},
		  {0.0875f,0.06875f,0.05625f}},
		 {{-0.00625f,-0.028125f,0.0875f},
		  {0.f,-0.025f,0.090625f},
		  {0.003125f,-0.021875f,0.09375f},
		  {0.00625f,-0.01875f,0.1f},
		  {0.0125f,-0.0125f,0.1f},
		  {0.01875f,-0.009375f,0.103125f},
		  {0.025f,-0.003125f,0.10625f},
		  {0.03125f,0.003125f,0.109375f},
		  {0.040625f,0.00625f,0.109375f},
		  {0.046875f,0.0125f,0.109375f},
		  {0.053125f,0.025f,0.10625f},
		  {0.059375f,0.034375f,0.103125f},
		  {0.06875f,0.040625f,0.096875f},
		  {0.075f,0.05f,0.09375f},
		  {0.08125f,0.059375f,0.08125f},
		  {0.084375f,0.071875f,0.0625f}},
		 {{-0.0125f,-0.028125f,0.090625f},
		  {-0.00625f,-0.025f,0.09375f},
		  {-0.003125f,-0.021875f,0.096875f},
		  {0.003125f,-0.021875f,0.103125f},
		  {0.009375f,-0.015625f,0.10625f},
		  {0.015625f,-0.0125f,0.109375f},
		  {0.021875f,-0.00625f,0.1125f},
		  {0.025f,0.00625f,0.1125f},
		  {0.034375f,0.00625f,0.115625f},
		  {0.040625f,0.01875f,0.1125f},
		  {0.05f,0.025f,0.1125f},
		  {0.05625f,0.0375f,0.10625f},
		  {0.0625f,0.046875f,0.103125f},
		  {0.06875f,0.05625f,0.096875f},
		  {0.078125f,0.0625f,0.0875f},
		  {0.084375f,0.071875f,0.06875f}},
		 {{-0.01875f,-0.025f,0.090625f},
		  {-0.0125f,-0.025f,0.096875f},
		  {-0.009375f,-0.01875f,0.1f},
		  {-0.003125f,-0.01875f,0.10625f},
		  {0.f,-0.009375f,0.109375f},
		  {0.00625f,-0.003125f,0.1125f},
		  {0.0125f,0.f,0.115625f},
		  {0.01875f,0.00625f,0.11875f},
		  {0.028125f,0.009375f,0.121875f},
		  {0.034375f,0.021875f,0.11875f},
		  {0.040625f,0.03125f,0.11875f},
		  {0.05f,0.0375f,0.115625f},
		  {0.059375f,0.046875f,0.109375f},
		  {0.06875f,0.053125f,0.103125f},
		  {0.075f,0.065625f,0.090625f},
		  {0.08125f,0.075f,0.071875f}},
		 {{-0.025f,-0.021875f,0.09375f},
		  {-0.021875f,-0.021875f,0.1f},
		  {-0.015625f,-0.015625f,0.103125f},
		  {-0.0125f,-0.0125f,0.10625f},
		  {-0.00625f,-0.009375f,0.1125f},
		  {-0.003125f,-0.003125f,0.11875f},
		  {0.00625f,0.f,0.121875f},
		  {0.0125f,0.009375f,0.121875f},
		  {0.01875f,0.015625f,0.125f},
		  {0.028125f,0.021875f,0.125f},
		  {0.0375f,0.028125f,0.125f},
		  {0.04375f,0.040625f,0.11875f},
		  {0.053125f,0.046875f,0.11875f},
		  {0.0625f,0.05625f,0.109375f},
		  {0.071875f,0.065625f,0.096875f},
		  {0.08125f,0.075f,0.078125f}},
		 {{-0.03125f,-0.025f,0.09375f},
		  {-0.028125f,-0.01875f,0.1f},
		  {-0.025f,-0.015625f,0.10625f},
		  {-0.01875f,-0.015625f,0.1125f},
		  {-0.015625f,-0.00625f,0.115625f},
		  {-0.009375f,0.f,0.11875f},
		  {-0.003125f,0.00625f,0.121875f},
		  {0.003125f,0.0125f,0.125f},
		  {0.0125f,0.01875f,0.128125f},
		  {0.021875f,0.021875f,0.13125f},
		  {0.028125f,0.034375f,0.128125f},
		  {0.0375f,0.04375f,0.125f},
		  {0.046875f,0.05f,0.121875f},
		  {0.05625f,0.059375f,0.115625f},
		  {0.065625f,0.06875f,0.103125f},
		  {0.078125f,0.075f,0.0875f}},
		 {{-0.040625f,-0.01875f,0.09375f},
		  {-0.0375f,-0.015625f,0.1f},
		  {-0.034375f,-0.009375f,0.10625f},
		  {-0.028125f,-0.009375f,0.1125f},
		  {-0.021875f,-0.00625f,0.11875f},
		  {-0.01875f,0.003125f,0.121875f},
		  {-0.0125f,0.009375f,0.125f},
		  {-0.00625f,0.015625f,0.128125f},
		  {0.003125f,0.021875f,0.13125f},
		  {0.009375f,0.028125f,0.134375f},
		  {0.01875f,0.0375f,0.13125f},
		  {0.028125f,0.04375f,0.13125f},
		  {0.0375f,0.053125f,0.128125f},
		  {0.05f,0.0625f,0.11875f},
		  {0.0625f,0.06875f,0.109375f},
		  {0.075f,0.078125f,0.0875f}},
		 {{-0.05f,-0.015625f,0.09375f},
		  {-0.046875f,-0.0125f,0.1f},
		  {-0.04375f,-0.00625f,0.10625f},
		  {-0.0375f,-0.00625f,0.1125f},
		  {-0.034375f,0.f,0.11875f},
		  {-0.028125f,0.00625f,0.121875f},
		  {-0.021875f,0.009375f,0.128125f},
		  {-0.0125f,0.0125f,0.134375f},
		  {-0.00625f,0.01875f,0.1375f},
		  {0.f,0.03125f,0.1375f},
		  {0.0125f,0.0375f,0.1375f},
		  {0.021875f,0.04375f,0.1375f},
		  {0.03125f,0.053125f,0.134375f},
		  {0.04375f,0.0625f,0.125f},
		  {0.05625f,0.06875f,0.11875f},
		  {0.071875f,0.078125f,0.096875f}},
		 {{-0.059375f,-0.0125f,0.09375f},
		  {-0.05625f,-0.009375f,0.1f},
		  {-0.053125f,-0.00625f,0.10625f},
		  {-0.05f,0.f,0.109375f},
		  {-0.04375f,0.003125f,0.11875f},
		  {-0.0375f,0.00625f,0.125f},
		  {-0.03125f,0.009375f,0.13125f},
		  {-0.025f,0.021875f,0.13125f},
		  {-0.01875f,0.028125f,0.134375f},
		  {-0.009375f,0.034375f,0.1375f},
		  {0.f,0.040625f,0.140625f},
		  {0.0125f,0.046875f,0.140625f},
		  {0.021875f,0.05625f,0.1375f},
		  {0.034375f,0.0625f,0.134375f},
		  {0.05f,0.071875f,0.121875f},
		  {0.06875f,0.08125f,0.096875f}},
		 {{-0.065625f,-0.0125f,0.09375f},
		  {-0.065625f,-0.003125f,0.096875f},
		  {-0.0625f,0.f,0.103125f},
		  {-0.059375f,0.003125f,0.109375f},
		  {-0.053125f,0.003125f,0.11875f},
		  {-0.05f,0.0125f,0.121875f},
		  {-0.040625f,0.0125f,0.13125f},
		  {-0.0375f,0.025f,0.13125f},
		  {-0.028125f,0.028125f,0.1375f},
		  {-0.01875f,0.03125f,0.14375f},
		  {-0.009375f,0.040625f,0.14375f},
		  {0.f,0.046875f,0.14375f},
		  {0.009375f,0.05625f,0.140625f},
		  {0.021875f,0.065625f,0.1375f},
		  {0.0375f,0.075f,0.128125f},
		  {0.0625f,0.08125f,0.10625f}},
		 {{-0.078125f,-0.003125f,0.084375f},
		  {-0.075f,0.f,0.090625f},
		  {-0.071875f,0.003125f,0.1f},
		  {-0.06875f,0.00625f,0.10625f},
		  {-0.065625f,0.009375f,0.1125f},
		  {-0.059375f,0.0125f,0.121875f},
		  {-0.05625f,0.021875f,0.121875f},
		  {-0.046875f,0.021875f,0.134375f},
		  {-0.040625f,0.028125f,0.1375f},
		  {-0.034375f,0.0375f,0.1375f},
		  {-0.025f,0.046875f,0.140625f},
		  {-0.0125f,0.05f,0.14375f},
		  {-0.003125f,0.059375f,0.14375f},
		  {0.015625f,0.065625f,0.140625f},
		  {0.028125f,0.075f,0.134375f},
		  {0.05625f,0.08125f,0.115625f}},
		 {{-0.0875f,0.003125f,0.078125f},
		  {-0.084375f,0.003125f,0.0875f},
		  {-0.084375f,0.009375f,0.090625f},
		  {-0.08125f,0.0125f,0.096875f},
		  {-0.078125f,0.015625f,0.10625f},
		  {-0.071875f,0.015625f,0.115625f},
		  {-0.06875f,0.025f,0.11875f},
		  {-0.0625f,0.028125f,0.125f},
		  {-0.053125f,0.03125f,0.134375f},
		  {-0.046875f,0.040625f,0.134375f},
		  {-0.034375f,0.04375f,0.14375f},
		  {-0.025f,0.05f,0.146875f},
		  {-0.0125f,0.053125f,0.15f},
		  {0.f,0.065625f,0.14375f},
		  {0.021875f,0.075f,0.1375f},
		  {0.05f,0.08125f,0.121875f}},
		 {{-0.096875f,0.009375f,0.06875f},
		  {-0.096875f,0.0125f,0.075f},
		  {-0.09375f,0.015625f,0.08125f},
		  {-0.090625f,0.015625f,0.090625f},
		  {-0.0875f,0.015625f,0.1f},
		  {-0.084375f,0.025f,0.103125f},
		  {-0.078125f,0.025f,0.115625f},
		  {-0.075f,0.03125f,0.11875f},
		  {-0.06875f,0.034375f,0.125f},
		  {-0.0625f,0.040625f,0.13125f},
		  {-0.05f,0.046875f,0.1375f},
		  {-0.040625f,0.053125f,0.140625f},
		  {-0.028125f,0.059375f,0.14375f},
		  {-0.009375f,0.065625f,0.146875f},
		  {0.0125f,0.075f,0.140625f},
		  {0.040625f,0.08125f,0.128125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,0.025f,0.08125f},
		  {-0.096875f,0.028125f,0.090625f},
		  {-0.09375f,0.03125f,0.096875f},
		  {-0.090625f,0.034375f,0.103125f},
		  {-0.084375f,0.0375f,0.1125f},
		  {-0.075f,0.04375f,0.121875f},
		  {-0.065625f,0.04375f,0.134375f},
		  {-0.059375f,0.053125f,0.134375f},
		  {-0.04375f,0.05625f,0.14375f},
		  {-0.03125f,0.065625f,0.14375f},
		  {-0.003125f,0.071875f,0.146875f},
		  {0.021875f,0.075f,0.14375f}}},
		{{{0.0125f,-0.0375f,0.078125f},
		  {0.015625f,-0.034375f,0.08125f},
		  {0.01875f,-0.03125f,0.084375f},
		  {0.025f,-0.03125f,0.0875f},
		  {0.03125f,-0.03125f,0.0875f},
		  {0.034375f,-0.01875f,0.090625f},
		  {0.040625f,-0.015625f,0.09375f},
		  {0.046875f,-0.009375f,0.09375f},
		  {0.053125f,-0.003125f,0.09375f},
		  {0.059375f,0.003125f,0.09375f},
		  {0.065625f,0.0125f,0.09375f},
		  {0.071875f,0.021875f,0.0875f},
		  {0.078125f,0.03125f,0.084375f},
		  {0.084375f,0.040625f,0.075f},
		  {0.0875f,0.053125f,0.065625f},
		  {0.0875f,0.05625f,0.0625f}},
		 {{0.00625f,-0.0375f,0.08125f},
		  {0.0125f,-0.0375f,0.084375f},
		  {0.015625f,-0.03125f,0.0875f},
		  {0.021875f,-0.03125f,0.090625f},
		  {0.025f,-0.021875f,0.09375f},
		  {0.03125f,-0.021875f,0.096875f},
		  {0.0375f,-0.0125f,0.096875f},
		  {0.04375f,-0.009375f,0.1f},
		  {0.05f,-0.003125f,0.1f},
		  {0.05625f,0.00625f,0.1f},
		  {0.0625f,0.015625f,0.096875f},
		  {0.06875f,0.025f,0.09375f},
		  {0.075f,0.034375f,0.090625f},
		  {0.08125f,0.04375f,0.084375f},
		  {0.0875f,0.053125f,0.071875f},
		  {0.0875f,0.0625f,0.0625f}},
		 {{0.003125f,-0.0375f,0.084375f},
		  {0.00625f,-0.034375f,0.0875f},
		  {0.009375f,-0.03125f,0.090625f},
		  {0.015625f,-0.028125f,0.09375f},
		  {0.01875f,-0.021875f,0.1f},
		  {0.025f,-0.01875f,0.103125f},
		  {0.034375f,-0.015625f,0.103125f},
		  {0.0375f,-0.00625f,0.10625f},
		  {0.046875f,-0.003125f,0.10625f},
		  {0.053125f,0.003125f,0.10625f},
		  {0.059375f,0.015625f,0.103125f},
		  {0.065625f,0.025f,0.103125f},
		  {0.071875f,0.034375f,0.1f},
		  {0.078125f,0.046875f,0.0875f},
		  {0.084375f,0.05625f,0.078125f},
		  {0.0875f,0.06875f,0.059375f}},
		 {{-0.003125f,-0.034375f,0.0875f},
		  {0.f,-0.034375f,0.090625f},
		  {0.003125f,-0.028125f,0.096875f},
		  {0.009375f,-0.025f,0.1f},
		  {0.015625f,-0.021875f,0.103125f},
		  {0.021875f,-0.01875f,0.10625f},
		  {0.028125f,-0.015625f,0.109375f},
		  {0.034375f,-0.003125f,0.109375f},
		  {0.040625f,0.f,0.1125f},
		  {0.05f,0.003125f,0.1125f},
		  {0.05625f,0.0125f,0.1125f},
		  {0.0625f,0.028125f,0.10625f},
		  {0.06875f,0.0375f,0.103125f},
		  {0.075f,0.046875f,0.096875f},
		  {0.08125f,0.059375f,0.084375f},
		  {0.0875f,0.06875f,0.06875f}},
		 {{-0.009375f,-0.034375f,0.090625f},
		  {-0.003125f,-0.0375f,0.09375f},
		  {0.f,-0.034375f,0.1f},
		  {0.00625f,-0.028125f,0.103125f},
		  {0.009375f,-0.01875f,0.10625f},
		  {0.015625f,-0.01875f,0.1125f},
		  {0.021875f,-0.009375f,0.1125f},
		  {0.028125f,-0.003125f,0.115625f},
		  {0.034375f,0.003125f,0.11875f},
		  {0.04375f,0.00625f,0.11875f},
		  {0.05f,0.01875f,0.115625f},
		  {0.05625f,0.028125f,0.115625f},
		  {0.065625f,0.0375f,0.109375f},
		  {0.075f,0.04375f,0.103125f},
		  {0.08125f,0.05625f,0.090625f},
		  {0.084375f,0.071875f,0.071875f}},
		 {{-0.015625f,-0.034375f,0.090625f},
		  {-0.0125f,-0.03125f,0.096875f},
		  {-0.00625f,-0.03125f,0.103125f},
		  {-0.003125f,-0.021875f,0.10625f},
		  {0.003125f,-0.021875f,0.1125f},
		  {0.009375f,-0.015625f,0.115625f},
		  {0.015625f,-0.009375f,0.11875f},
		  {0.021875f,-0.003125f,0.121875f},
		  {0.028125f,0.00625f,0.121875f},
		  {0.0375f,0.009375f,0.125f},
		  {0.04375f,0.021875f,0.121875f},
		  {0.053125f,0.03125f,0.11875f},
		  {0.059375f,0.040625f,0.115625f},
		  {0.06875f,0.05f,0.10625f},
		  {0.075f,0.0625f,0.096875f},
		  {0.084375f,0.071875f,0.075f}},
		 {{-0.021875f,-0.034375f,0.09375f},
		  {-0.01875f,-0.028125f,0.1f},
		  {-0.015625f,-0.025f,0.10625f},
		  {-0.009375f,-0.021875f,0.109375f},
		  {-0.003125f,-0.01875f,0.115625f},
		  {0.f,-0.009375f,0.11875f},
		  {0.00625f,-0.00625f,0.125f},
		  {0.0125f,0.003125f,0.125f},
		  {0.021875f,0.00625f,0.128125f},
		  {0.03125f,0.009375f,0.13125f},
		  {0.0375f,0.025f,0.128125f},
		  {0.046875f,0.028125f,0.128125f},
		  {0.053125f,0.04375f,0.121875f},
		  {0.0625f,0.05f,0.11875f},
		  {0.071875f,0.0625f,0.103125f},
		  {0.08125f,0.071875f,0.0875f}},
		 {{-0.028125f,-0.034375f,0.096875f},
		  {-0.025f,-0.03125f,0.103125f},
		  {-0.021875f,-0.028125f,0.109375f},
		  {-0.01875f,-0.01875f,0.1125f},
		  {-0.0125f,-0.015625f,0.11875f},
		  {-0.009375f,-0.00625f,0.121875f},
		  {0.f,-0.00625f,0.128125f},
		  {0.00625f,0.f,0.13125f},
		  {0.015625f,0.00625f,0.134375f},
		  {0.021875f,0.015625f,0.134375f},
		  {0.028125f,0.028125f,0.134375f},
		  {0.0375f,0.0375f,0.13125f},
		  {0.046875f,0.04375f,0.128125f},
		  {0.05625f,0.053125f,0.121875f},
		  {0.06875f,0.0625f,0.109375f},
		  {0.078125f,0.071875f,0.096875f}},
		 {{-0.0375f,-0.028125f,0.096875f},
		  {-0.034375f,-0.021875f,0.103125f},
		  {-0.03125f,-0.01875f,0.109375f},
		  {-0.025f,-0.021875f,0.115625f},
		  {-0.021875f,-0.015625f,0.121875f},
		  {-0.015625f,-0.00625f,0.125f},
		  {-0.009375f,-0.003125f,0.13125f},
		  {-0.003125f,0.00625f,0.134375f},
		  {0.003125f,0.0125f,0.1375f},
		  {0.0125f,0.021875f,0.1375f},
		  {0.021875f,0.025f,0.140625f},
		  {0.03125f,0.03125f,0.140625f},
		  {0.040625f,0.04375f,0.134375f},
		  {0.05f,0.053125f,0.128125f},
		  {0.0625f,0.065625f,0.115625f},
		  {0.075f,0.075f,0.096875f}},
		 {{-0.046875f,-0.021875f,0.096875f},
		  {-0.04375f,-0.01875f,0.103125f},
		  {-0.040625f,-0.015625f,0.109375f},
		  {-0.0375f,-0.0125f,0.115625f},
		  {-0.03125f,-0.009375f,0.121875f},
		  {-0.025f,-0.00625f,0.128125f},
		  {-0.01875f,-0.003125f,0.134375f},
		  {-0.0125f,0.00625f,0.1375f},
		  {-0.00625f,0.015625f,0.140625f},
		  {0.003125f,0.025f,0.140625f},
		  {0.0125f,0.028125f,0.14375f},
		  {0.021875f,0.040625f,0.140625f},
		  {0.03125f,0.046875f,0.140625f},
		  {0.040625f,0.05625f,0.134375f},
		  {0.053125f,0.065625f,0.125f},
		  {0.06875f,0.075f,0.10625f}},
		 {{-0.05625f,-0.01875f,0.096875f},
		  {-0.053125f,-0.015625f,0.103125f},
		  {-0.05f,-0.0125f,0.109375f},
		  {-0.046875f,-0.009375f,0.115625f},
		  {-0.040625f,-0.003125f,0.121875f},
		  {-0.0375f,0.f,0.128125f},
		  {-0.03125f,0.00625f,0.13125f},
		  {-0.021875f,0.00625f,0.140625f},
		  {-0.015625f,0.01875f,0.140625f},
		  {-0.00625f,0.021875f,0.146875f},
		  {0.003125f,0.03125f,0.146875f},
		  {0.0125f,0.034375f,0.15f},
		  {0.021875f,0.05f,0.14375f},
		  {0.034375f,0.05625f,0.140625f},
		  {0.046875f,0.065625f,0.13125f},
		  {0.0625f,0.075f,0.115625f}},
		 {{-0.065625f,-0.015625f,0.09375f},
		  {-0.065625f,-0.009375f,0.1f},
		  {-0.059375f,-0.0125f,0.109375f},
		  {-0.05625f,-0.009375f,0.115625f},
		  {-0.053125f,0.f,0.11875f},
		  {-0.046875f,0.003125f,0.128125f},
		  {-0.040625f,0.00625f,0.134375f},
		  {-0.034375f,0.015625f,0.1375f},
		  {-0.028125f,0.021875f,0.140625f},
		  {-0.01875f,0.025f,0.146875f},
		  {-0.009375f,0.03125f,0.15f},
		  {0.003125f,0.040625f,0.15f},
		  {0.0125f,0.05f,0.146875f},
		  {0.021875f,0.059375f,0.14375f},
		  {0.040625f,0.065625f,0.1375f},
		  {0.05625f,0.071875f,0.128125f}},
		 {{-0.078125f,-0.009375f,0.0875f},
		  {-0.075f,-0.00625f,0.096875f},
		  {-0.071875f,-0.003125f,0.103125f},
		  {-0.06875f,0.f,0.109375f},
		  {-0.0625f,0.003125f,0.11875f},
		  {-0.059375f,0.009375f,0.121875f},
		  {-0.053125f,0.0125f,0.13125f},
		  {-0.046875f,0.015625f,0.1375f},
		  {-0.0375f,0.021875f,0.14375f},
		  {-0.03125f,0.03125f,0.14375f},
		  {-0.021875f,0.034375f,0.15f},
		  {-0.009375f,0.040625f,0.153125f},
		  {0.f,0.046875f,0.153125f},
		  {0.015625f,0.053125f,0.153125f},
		  {0.028125f,0.065625f,0.14375f},
		  {0.046875f,0.075f,0.13125f}},
		 {{-0.0875f,-0.003125f,0.08125f},
		  {-0.084375f,0.f,0.090625f},
		  {-0.08125f,0.f,0.1f},
		  {-0.078125f,0.003125f,0.10625f},
		  {-0.075f,0.00625f,0.1125f},
		  {-0.071875f,0.0125f,0.11875f},
		  {-0.065625f,0.01875f,0.125f},
		  {-0.059375f,0.021875f,0.13125f},
		  {-0.05f,0.025f,0.140625f},
		  {-0.04375f,0.03125f,0.14375f},
		  {-0.034375f,0.034375f,0.15f},
		  {-0.025f,0.04375f,0.15f},
		  {-0.009375f,0.046875f,0.15625f},
		  {0.003125f,0.053125f,0.15625f},
		  {0.0125f,0.065625f,0.15f},
		  {0.0375f,0.075f,0.1375f}},
		 {{-0.096875f,0.00625f,0.071875f},
		  {-0.09375f,0.00625f,0.08125f},
		  {-0.09375f,0.009375f,0.0875f},
		  {-0.090625f,0.0125f,0.09375f},
		  {-0.0875f,0.0125f,0.103125f},
		  {-0.084375f,0.01875f,0.109375f},
		  {-0.078125f,0.021875f,0.11875f},
		  {-0.071875f,0.021875f,0.128125f},
		  {-0.065625f,0.03125f,0.13125f},
		  {-0.05625f,0.034375f,0.140625f},
		  {-0.046875f,0.0375f,0.146875f},
		  {-0.0375f,0.04375f,0.15f},
		  {-0.025f,0.046875f,0.15625f},
		  {-0.009375f,0.059375f,0.153125f},
		  {0.003125f,0.059375f,0.15625f},
		  {0.03125f,0.075f,0.140625f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,0.021875f,0.0875f},
		  {-0.096875f,0.021875f,0.096875f},
		  {-0.09375f,0.025f,0.10625f},
		  {-0.0875f,0.028125f,0.115625f},
		  {-0.08125f,0.03125f,0.125f},
		  {-0.071875f,0.0375f,0.13125f},
		  {-0.065625f,0.040625f,0.1375f},
		  {-0.053125f,0.04375f,0.146875f},
		  {-0.040625f,0.046875f,0.153125f},
		  {-0.028125f,0.05625f,0.153125f},
		  {-0.003125f,0.065625f,0.153125f},
		  {0.025f,0.075f,0.14375f}}},
		{{{0.0125f,-0.04375f,0.078125f},
		  {0.015625f,-0.04375f,0.08125f},
		  {0.021875f,-0.04375f,0.08125f},
		  {0.025f,-0.0375f,0.0875f},
		  {0.03125f,-0.034375f,0.0875f},
		  {0.0375f,-0.028125f,0.090625f},
		  {0.040625f,-0.025f,0.096875f},
		  {0.05f,-0.021875f,0.09375f},
		  {0.05625f,-0.0125f,0.09375f},
		  {0.0625f,-0.00625f,0.09375f},
		  {0.06875f,0.f,0.09375f},
		  {0.075f,0.0125f,0.090625f},
		  {0.08125f,0.021875f,0.0875f},
		  {0.084375f,0.0375f,0.08125f},
		  {0.090625f,0.046875f,0.06875f},
		  {0.090625f,0.0625f,0.053125f}},
		 {{0.009375f,-0.05f,0.078125f},
		  {0.0125f,-0.040625f,0.084375f},
		  {0.015625f,-0.040625f,0.0875f},
		  {0.021875f,-0.034375f,0.090625f},
		  {0.028125f,-0.034375f,0.09375f},
		  {0.03125f,-0.028125f,0.096875f},
		  {0.0375f,-0.021875f,0.1f},
		  {0.046875f,-0.021875f,0.1f},
		  {0.05f,-0.009375f,0.103125f},
		  {0.059375f,-0.003125f,0.1f},
		  {0.065625f,0.003125f,0.1f},
		  {0.071875f,0.015625f,0.096875f},
		  {0.078125f,0.025f,0.09375f},
		  {0.084375f,0.0375f,0.084375f},
		  {0.0875f,0.05f,0.078125f},
		  {0.090625f,0.0625f,0.0625f}},
		 {{0.003125f,-0.04375f,0.084375f},
		  {0.009375f,-0.04375f,0.0875f},
		  {0.0125f,-0.0375f,0.090625f},
		  {0.01875f,-0.040625f,0.09375f},
		  {0.021875f,-0.03125f,0.1f},
		  {0.028125f,-0.028125f,0.103125f},
		  {0.034375f,-0.021875f,0.103125f},
		  {0.040625f,-0.015625f,0.10625f},
		  {0.046875f,-0.009375f,0.109375f},
		  {0.053125f,0.f,0.109375f},
		  {0.059375f,0.009375f,0.109375f},
		  {0.06875f,0.015625f,0.103125f},
		  {0.075f,0.025f,0.103125f},
		  {0.08125f,0.040625f,0.090625f},
		  {0.0875f,0.05f,0.08125f},
		  {0.0875f,0.059375f,0.075f}},
		 {{0.f,-0.05f,0.084375f},
		  {0.003125f,-0.040625f,0.090625f},
		  {0.00625f,-0.0375f,0.096875f},
		  {0.0125f,-0.034375f,0.1f},
		  {0.01875f,-0.03125f,0.103125f},
		  {0.025f,-0.028125f,0.10625f},
		  {0.03125f,-0.025f,0.109375f},
		  {0.0375f,-0.01875f,0.1125f},
		  {0.040625f,-0.00625f,0.115625f},
		  {0.05f,-0.003125f,0.115625f},
		  {0.05625f,0.009375f,0.1125f},
		  {0.065625f,0.0125f,0.1125f},
		  {0.071875f,0.028125f,0.10625f},
		  {0.078125f,0.040625f,0.1f},
		  {0.084375f,0.053125f,0.0875f},
		  {0.0875f,0.065625f,0.075f}},
		 {{-0.009375f,-0.040625f,0.090625f},
		  {-0.003125f,-0.040625f,0.09375f},
		  {0.f,-0.0375f,0.1f},
		  {0.00625f,-0.034375f,0.103125f},
		  {0.0125f,-0.0375f,0.10625f},
		  {0.01875f,-0.028125f,0.1125f},
		  {0.025f,-0.021875f,0.115625f},
		  {0.03125f,-0.015625f,0.11875f},
		  {0.0375f,-0.003125f,0.11875f},
		  {0.04375f,0.f,0.121875f},
		  {0.05f,0.0125f,0.121875f},
		  {0.059375f,0.01875f,0.11875f},
		  {0.06875f,0.025f,0.115625f},
		  {0.075f,0.040625f,0.10625f},
		  {0.08125f,0.053125f,0.096875f},
		  {0.0875f,0.065625f,0.08125f}},
		 {{-0.0125f,-0.046875f,0.090625f},
		  {-0.009375f,-0.0375f,0.096875f},
		  {-0.003125f,-0.040625f,0.103125f},
		  {0.f,-0.0375f,0.10625f},
		  {0.00625f,-0.028125f,0.1125f},
		  {0.009375f,-0.021875f,0.115625f},
		  {0.015625f,-0.015625f,0.121875f},
		  {0.021875f,-0.009375f,0.125f},
		  {0.03125f,-0.003125f,0.125f},
		  {0.0375f,0.003125f,0.128125f},
		  {0.046875f,0.00625f,0.128125f},
		  {0.053125f,0.021875f,0.125f},
		  {0.0625f,0.028125f,0.121875f},
		  {0.06875f,0.04375f,0.115625f},
		  {0.078125f,0.05625f,0.1f},
		  {0.084375f,0.06875f,0.084375f}},
		 {{-0.021875f,-0.040625f,0.09375f},
		  {-0.015625f,-0.040625f,0.1f},
		  {-0.009375f,-0.040625f,0.10625f},
		  {-0.009375f,-0.028125f,0.1125f},
		  {-0.003125f,-0.025f,0.115625f},
		  {0.003125f,-0.021875f,0.121875f},
		  {0.009375f,-0.0125f,0.125f},
		  {0.015625f,-0.00625f,0.128125f},
		  {0.021875f,0.f,0.13125f},
		  {0.03125f,0.003125f,0.134375f},
		  {0.040625f,0.009375f,0.134375f},
		  {0.046875f,0.025f,0.13125f},
		  {0.05625f,0.03125f,0.128125f},
		  {0.065625f,0.0375f,0.125f},
		  {0.071875f,0.05625f,0.1125f},
		  {0.08125f,0.06875f,0.09375f}},
		 {{-0.028125f,-0.0375f,0.096875f},
		  {-0.021875f,-0.040625f,0.103125f},
		  {-0.01875f,-0.034375f,0.109375f},
		  {-0.015625f,-0.03125f,0.115625f},
		  {-0.0125f,-0.021875f,0.11875f},
		  {-0.00625f,-0.015625f,0.125f},
		  {0.003125f,-0.01875f,0.13125f},
		  {0.009375f,-0.009375f,0.134375f},
		  {0.015625f,0.f,0.1375f},
		  {0.021875f,0.009375f,0.1375f},
		  {0.03125f,0.01875f,0.1375f},
		  {0.040625f,0.025f,0.1375f},
		  {0.05f,0.034375f,0.134375f},
		  {0.059375f,0.040625f,0.13125f},
		  {0.06875f,0.053125f,0.121875f},
		  {0.078125f,0.06875f,0.1f}},
		 {{-0.0375f,-0.034375f,0.096875f},
		  {-0.034375f,-0.03125f,0.103125f},
		  {-0.028125f,-0.034375f,0.1125f},
		  {-0.025f,-0.025f,0.115625f},
		  {-0.01875f,-0.028125f,0.121875f},
		  {-0.015625f,-0.0125f,0.128125f},
		  {-0.00625f,-0.0125f,0.134375f},
		  {0.f,-0.003125f,0.1375f},
		  {0.00625f,0.003125f,0.140625f},
		  {0.015625f,0.009375f,0.14375f},
		  {0.021875f,0.01875f,0.14375f},
		  {0.03125f,0.028125f,0.14375f},
		  {0.040625f,0.0375f,0.140625f},
		  {0.05f,0.046875f,0.134375f},
		  {0.059375f,0.05625f,0.128125f},
		  {0.075f,0.065625f,0.1125f}},
		 {{-0.04375f,-0.034375f,0.1f},
		  {-0.040625f,-0.03125f,0.10625f},
		  {-0.0375f,-0.025f,0.1125f},
		  {-0.034375f,-0.021875f,0.11875f},
		  {-0.028125f,-0.01875f,0.125f},
		  {-0.021875f,-0.015625f,0.13125f},
		  {-0.015625f,-0.0125f,0.1375f},
		  {-0.0125f,0.f,0.140625f},
		  {-0.003125f,0.00625f,0.14375f},
		  {0.00625f,0.0125f,0.146875f},
		  {0.0125f,0.021875f,0.146875f},
		  {0.025f,0.025f,0.15f},
		  {0.03125f,0.0375f,0.146875f},
		  {0.04375f,0.04375f,0.14375f},
		  {0.053125f,0.05625f,0.134375f},
		  {0.06875f,0.065625f,0.121875f}},
		 {{-0.053125f,-0.03125f,0.1f},
		  {-0.05f,-0.028125f,0.10625f},
		  {-0.046875f,-0.025f,0.1125f},
		  {-0.04375f,-0.015625f,0.11875f},
		  {-0.040625f,-0.0125f,0.125f},
		  {-0.034375f,-0.00625f,0.13125f},
		  {-0.028125f,-0.003125f,0.1375f},
		  {-0.01875f,0.f,0.14375f},
		  {-0.0125f,0.009375f,0.146875f},
		  {-0.00625f,0.015625f,0.15f},
		  {0.003125f,0.025f,0.15f},
		  {0.0125f,0.028125f,0.153125f},
		  {0.021875f,0.040625f,0.15f},
		  {0.034375f,0.04375f,0.15f},
		  {0.046875f,0.05625f,0.140625f},
		  {0.0625f,0.06875f,0.125f}},
		 {{-0.065625f,-0.021875f,0.096875f},
		  {-0.059375f,-0.025f,0.10625f},
		  {-0.059375f,-0.015625f,0.109375f},
		  {-0.05625f,-0.0125f,0.115625f},
		  {-0.05f,-0.009375f,0.125f},
		  {-0.046875f,-0.003125f,0.13125f},
		  {-0.040625f,0.f,0.1375f},
		  {-0.03125f,0.003125f,0.14375f},
		  {-0.025f,0.0125f,0.146875f},
		  {-0.015625f,0.021875f,0.15f},
		  {-0.00625f,0.021875f,0.15625f},
		  {0.003125f,0.03125f,0.15625f},
		  {0.0125f,0.04375f,0.153125f},
		  {0.025f,0.046875f,0.153125f},
		  {0.0375f,0.053125f,0.15f},
		  {0.053125f,0.06875f,0.134375f}},
		 {{-0.075f,-0.015625f,0.090625f},
		  {-0.071875f,-0.015625f,0.1f},
		  {-0.06875f,-0.015625f,0.109375f},
		  {-0.065625f,-0.009375f,0.115625f},
		  {-0.059375f,-0.009375f,0.125f},
		  {-0.05625f,0.003125f,0.128125f},
		  {-0.05f,0.003125f,0.1375f},
		  {-0.04375f,0.0125f,0.140625f},
		  {-0.0375f,0.015625f,0.146875f},
		  {-0.028125f,0.025f,0.15f},
		  {-0.01875f,0.03125f,0.153125f},
		  {-0.009375f,0.03125f,0.159375f},
		  {0.003125f,0.04375f,0.15625f},
		  {0.0125f,0.05f,0.15625f},
		  {0.028125f,0.059375f,0.15f},
		  {0.04375f,0.06875f,0.140625f}},
		 {{-0.084375f,-0.0125f,0.0875f},
		  {-0.084375f,-0.00625f,0.09375f},
		  {-0.08125f,-0.003125f,0.1f},
		  {-0.078125f,-0.003125f,0.109375f},
		  {-0.075f,0.003125f,0.115625f},
		  {-0.06875f,0.003125f,0.125f},
		  {-0.0625f,0.00625f,0.134375f},
		  {-0.05625f,0.009375f,0.140625f},
		  {-0.05f,0.01875f,0.14375f},
		  {-0.040625f,0.025f,0.15f},
		  {-0.03125f,0.028125f,0.15625f},
		  {-0.01875f,0.034375f,0.159375f},
		  {-0.009375f,0.0375f,0.1625f},
		  {0.f,0.05f,0.159375f},
		  {0.015625f,0.053125f,0.159375f},
		  {0.03125f,0.065625f,0.15f}},
		 {{-0.096875f,0.f,0.075f},
		  {-0.09375f,0.f,0.084375f},
		  {-0.09375f,0.00625f,0.090625f},
		  {-0.090625f,0.00625f,0.1f},
		  {-0.0875f,0.009375f,0.10625f},
		  {-0.08125f,0.009375f,0.11875f},
		  {-0.078125f,0.015625f,0.121875f},
		  {-0.06875f,0.015625f,0.134375f},
		  {-0.0625f,0.021875f,0.140625f},
		  {-0.05625f,0.028125f,0.14375f},
		  {-0.04375f,0.03125f,0.153125f},
		  {-0.034375f,0.0375f,0.15625f},
		  {-0.021875f,0.04375f,0.159375f},
		  {-0.009375f,0.046875f,0.1625f},
		  {0.00625f,0.05625f,0.159375f},
		  {0.025f,0.065625f,0.153125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.096875f,0.0125f,0.1f},
		  {-0.09375f,0.015625f,0.10625f},
		  {-0.090625f,0.021875f,0.1125f},
		  {-0.0875f,0.025f,0.11875f},
		  {-0.075f,0.025f,0.134375f},
		  {-0.06875f,0.028125f,0.140625f},
		  {-0.059375f,0.034375f,0.146875f},
		  {-0.046875f,0.034375f,0.15625f},
		  {-0.0375f,0.040625f,0.159375f},
		  {-0.021875f,0.046875f,0.1625f},
		  {-0.009375f,0.053125f,0.1625f},
		  {0.003125f,0.05625f,0.1625f}}},
		{{{0.015625f,-0.053125f,0.075f},
		  {0.01875f,-0.05f,0.078125f},
		  {0.021875f,-0.046875f,0.084375f},
		  {0.028125f,-0.04375f,0.084375f},
		  {0.03125f,-0.040625f,0.090625f},
		  {0.0375f,-0.0375f,0.090625f},
		  {0.04375f,-0.03125f,0.09375f},
		  {0.05f,-0.028125f,0.09375f},
		  {0.05625f,-0.021875f,0.096875f},
		  {0.0625f,-0.0125f,0.096875f},
		  {0.06875f,-0.003125f,0.096875f},
		  {0.075f,0.00625f,0.09375f},
		  {0.08125f,0.01875f,0.090625f},
		  {0.0875f,0.03125f,0.08125f},
		  {0.090625f,0.046875f,0.071875f},
		  {0.f,0.f,0.f}},
		 {{0.0125f,-0.05625f,0.078125f},
		  {0.015625f,-0.053125f,0.08125f},
		  {0.01875f,-0.05f,0.084375f},
		  {0.025f,-0.05f,0.0875f},
		  {0.028125f,-0.040625f,0.09375f},
		  {0.034375f,-0.0375f,0.096875f},
		  {0.040625f,-0.034375f,0.096875f},
		  {0.046875f,-0.025f,0.1f},
		  {0.053125f,-0.021875f,0.103125f},
		  {0.059375f,-0.009375f,0.103125f},
		  {0.065625f,-0.003125f,0.103125f},
		  {0.071875f,0.00625f,0.103125f},
		  {0.08125f,0.0125f,0.096875f},
		  {0.0875f,0.025f,0.090625f},
		  {0.090625f,0.046875f,0.075f},
		  {0.090625f,0.053125f,0.075f}},
		 {{0.00625f,-0.053125f,0.08125f},
		  {0.0125f,-0.05625f,0.084375f},
		  {0.0125f,-0.046875f,0.090625f},
		  {0.01875f,-0.04375f,0.09375f},
		  {0.025f,-0.040625f,0.096875f},
		  {0.03125f,-0.040625f,0.1f},
		  {0.0375f,-0.034375f,0.103125f},
		  {0.04375f,-0.028125f,0.10625f},
		  {0.046875f,-0.01875f,0.1125f},
		  {0.05625f,-0.0125f,0.109375f},
		  {0.0625f,0.f,0.109375f},
		  {0.06875f,0.009375f,0.109375f},
		  {0.075f,0.01875f,0.10625f},
		  {0.084375f,0.028125f,0.096875f},
		  {0.0875f,0.046875f,0.0875f},
		  {0.090625f,0.0625f,0.06875f}},
		 {{0.003125f,-0.05625f,0.084375f},
		  {0.00625f,-0.05625f,0.0875f},
		  {0.009375f,-0.046875f,0.09375f},
		  {0.015625f,-0.05f,0.096875f},
		  {0.01875f,-0.040625f,0.103125f},
		  {0.025f,-0.034375f,0.10625f},
		  {0.03125f,-0.028125f,0.109375f},
		  {0.0375f,-0.021875f,0.1125f},
		  {0.04375f,-0.015625f,0.115625f},
		  {0.05f,-0.009375f,0.11875f},
		  {0.059375f,-0.003125f,0.115625f},
		  {0.065625f,0.00625f,0.115625f},
		  {0.071875f,0.021875f,0.1125f},
		  {0.08125f,0.028125f,0.10625f},
		  {0.0875f,0.04375f,0.09375f},
		  {0.090625f,0.0625f,0.075f}},
		 {{-0.003125f,-0.05625f,0.0875f},
		  {0.f,-0.05f,0.09375f},
		  {0.00625f,-0.053125f,0.096875f},
		  {0.009375f,-0.04375f,0.103125f},
		  {0.0125f,-0.0375f,0.109375f},
		  {0.01875f,-0.034375f,0.1125f},
		  {0.025f,-0.028125f,0.115625f},
		  {0.03125f,-0.021875f,0.11875f},
		  {0.0375f,-0.015625f,0.121875f},
		  {0.046875f,-0.00625f,0.121875f},
		  {0.053125f,0.003125f,0.121875f},
		  {0.059375f,0.0125f,0.121875f},
		  {0.06875f,0.01875f,0.11875f},
		  {0.075f,0.034375f,0.1125f},
		  {0.084375f,0.04375f,0.103125f},
		  {0.0875f,0.0625f,0.0875f}},
		 {{-0.009375f,-0.05625f,0.090625f},
		  {-0.00625f,-0.05f,0.096875f},
		  {-0.003125f,-0.04375f,0.103125f},
		  {0.003125f,-0.046875f,0.10625f},
		  {0.009375f,-0.04375f,0.1125f},
		  {0.0125f,-0.034375f,0.11875f},
		  {0.01875f,-0.025f,0.121875f},
		  {0.025f,-0.01875f,0.125f},
		  {0.03125f,-0.0125f,0.128125f},
		  {0.040625f,-0.0125f,0.13125f},
		  {0.046875f,0.f,0.13125f},
		  {0.053125f,0.0125f,0.13125f},
		  {0.0625f,0.025f,0.125f},
		  {0.071875f,0.034375f,0.11875f},
		  {0.078125f,0.05f,0.109375f},
		  {0.0875f,0.0625f,0.090625f}},
		 {{-0.015625f,-0.053125f,0.09375f},
		  {-0.0125f,-0.05f,0.1f},
		  {-0.009375f,-0.04375f,0.10625f},
		  {-0.00625f,-0.0375f,0.1125f},
		  {0.f,-0.0375f,0.115625f},
		  {0.00625f,-0.028125f,0.121875f},
		  {0.0125f,-0.03125f,0.128125f},
		  {0.01875f,-0.021875f,0.13125f},
		  {0.025f,-0.0125f,0.134375f},
		  {0.03125f,-0.003125f,0.1375f},
		  {0.040625f,0.003125f,0.1375f},
		  {0.05f,0.00625f,0.1375f},
		  {0.05625f,0.025f,0.13125f},
		  {0.065625f,0.034375f,0.128125f},
		  {0.075f,0.05f,0.115625f},
		  {0.084375f,0.059375f,0.103125f}},
		 {{-0.021875f,-0.053125f,0.096875f},
		  {-0.01875f,-0.05f,0.103125f},
		  {-0.015625f,-0.04375f,0.109375f},
		  {-0.0125f,-0.0375f,0.115625f},
		  {-0.009375f,-0.03125f,0.121875f},
		  {-0.003125f,-0.028125f,0.125f},
		  {0.003125f,-0.021875f,0.13125f},
		  {0.009375f,-0.015625f,0.134375f},
		  {0.01875f,-0.015625f,0.140625f},
		  {0.025f,0.f,0.140625f},
		  {0.034375f,0.f,0.14375f},
		  {0.040625f,0.0125f,0.14375f},
		  {0.05f,0.025f,0.140625f},
		  {0.059375f,0.03125f,0.1375f},
		  {0.06875f,0.05f,0.125f},
		  {0.078125f,0.0625f,0.109375f}},
		 {{-0.034375f,-0.04375f,0.096875f},
		  {-0.03125f,-0.040625f,0.10625f},
		  {-0.025f,-0.040625f,0.1125f},
		  {-0.01875f,-0.040625f,0.11875f},
		  {-0.015625f,-0.03125f,0.125f},
		  {-0.009375f,-0.03125f,0.13125f},
		  {-0.00625f,-0.01875f,0.134375f},
		  {0.003125f,-0.015625f,0.140625f},
		  {0.009375f,-0.00625f,0.14375f},
		  {0.015625f,0.f,0.146875f},
		  {0.025f,0.003125f,0.15f},
		  {0.034375f,0.01875f,0.146875f},
		  {0.040625f,0.028125f,0.146875f},
		  {0.05f,0.0375f,0.14375f},
		  {0.0625f,0.046875f,0.134375f},
		  {0.071875f,0.059375f,0.121875f}},
		 {{-0.040625f,-0.04375f,0.1f},
		  {-0.0375f,-0.04375f,0.10625f},
		  {-0.034375f,-0.040625f,0.1125f},
		  {-0.03125f,-0.034375f,0.121875f},
		  {-0.025f,-0.03125f,0.128125f},
		  {-0.01875f,-0.028125f,0.134375f},
		  {-0.015625f,-0.015625f,0.1375f},
		  {-0.009375f,-0.009375f,0.14375f},
		  {0.f,-0.009375f,0.15f},
		  {0.00625f,0.00625f,0.15f},
		  {0.015625f,0.009375f,0.153125f},
		  {0.025f,0.01875f,0.153125f},
		  {0.034375f,0.03125f,0.15f},
		  {0.04375f,0.034375f,0.15f},
		  {0.053125f,0.05f,0.140625f},
		  {0.065625f,0.0625f,0.128125f}},
		 {{-0.053125f,-0.034375f,0.1f},
		  {-0.046875f,-0.040625f,0.10625f},
		  {-0.04375f,-0.034375f,0.115625f},
		  {-0.040625f,-0.028125f,0.121875f},
		  {-0.0375f,-0.021875f,0.128125f},
		  {-0.03125f,-0.015625f,0.134375f},
		  {-0.025f,-0.0125f,0.140625f},
		  {-0.01875f,-0.009375f,0.146875f},
		  {-0.0125f,0.003125f,0.15f},
		  {-0.003125f,0.009375f,0.153125f},
		  {0.00625f,0.0125f,0.15625f},
		  {0.015625f,0.015625f,0.159375f},
		  {0.021875f,0.03125f,0.15625f},
		  {0.034375f,0.040625f,0.153125f},
		  {0.046875f,0.05f,0.146875f},
		  {0.059375f,0.059375f,0.1375f}},
		 {{-0.0625f,-0.03125f,0.1f},
		  {-0.059375f,-0.028125f,0.10625f},
		  {-0.053125f,-0.03125f,0.115625f},
		  {-0.05f,-0.028125f,0.121875f},
		  {-0.046875f,-0.01875f,0.128125f},
		  {-0.04375f,-0.0125f,0.134375f},
		  {-0.0375f,-0.00625f,0.140625f},
		  {-0.03125f,-0.003125f,0.146875f},
		  {-0.021875f,0.f,0.153125f},
		  {-0.0125f,0.009375f,0.15625f},
		  {-0.00625f,0.015625f,0.159375f},
		  {0.00625f,0.01875f,0.1625f},
		  {0.0125f,0.034375f,0.159375f},
		  {0.025f,0.0375f,0.159375f},
		  {0.034375f,0.05f,0.153125f},
		  {0.053125f,0.0625f,0.140625f}},
		 {{-0.071875f,-0.025f,0.096875f},
		  {-0.071875f,-0.01875f,0.103125f},
		  {-0.065625f,-0.021875f,0.1125f},
		  {-0.0625f,-0.021875f,0.11875f},
		  {-0.059375f,-0.0125f,0.125f},
		  {-0.053125f,-0.009375f,0.134375f},
		  {-0.046875f,-0.003125f,0.140625f},
		  {-0.040625f,0.f,0.146875f},
		  {-0.034375f,0.009375f,0.15f},
		  {-0.025f,0.0125f,0.15625f},
		  {-0.01875f,0.021875f,0.159375f},
		  {-0.00625f,0.025f,0.1625f},
		  {0.003125f,0.034375f,0.1625f},
		  {0.0125f,0.040625f,0.1625f},
		  {0.025f,0.04375f,0.1625f},
		  {0.040625f,0.05625f,0.153125f}},
		 {{-0.084375f,-0.015625f,0.090625f},
		  {-0.08125f,-0.015625f,0.1f},
		  {-0.078125f,-0.015625f,0.10625f},
		  {-0.075f,-0.0125f,0.115625f},
		  {-0.071875f,-0.00625f,0.121875f},
		  {-0.065625f,-0.00625f,0.13125f},
		  {-0.059375f,0.f,0.1375f},
		  {-0.053125f,0.00625f,0.14375f},
		  {-0.04375f,0.00625f,0.153125f},
		  {-0.0375f,0.015625f,0.15625f},
		  {-0.03125f,0.021875f,0.159375f},
		  {-0.01875f,0.028125f,0.1625f},
		  {-0.009375f,0.03125f,0.165625f},
		  {0.f,0.040625f,0.165625f},
		  {0.015625f,0.04375f,0.165625f},
		  {0.028125f,0.05f,0.1625f}},
		 {{-0.09375f,-0.009375f,0.084375f},
		  {-0.09375f,-0.003125f,0.0875f},
		  {-0.090625f,-0.003125f,0.096875f},
		  {-0.0875f,0.f,0.10625f},
		  {-0.084375f,0.003125f,0.1125f},
		  {-0.078125f,0.f,0.125f},
		  {-0.071875f,0.003125f,0.134375f},
		  {-0.065625f,0.009375f,0.140625f},
		  {-0.059375f,0.0125f,0.146875f},
		  {-0.05f,0.01875f,0.153125f},
		  {-0.040625f,0.021875f,0.159375f},
		  {-0.03125f,0.028125f,0.1625f},
		  {-0.021875f,0.034375f,0.165625f},
		  {-0.00625f,0.0375f,0.16875f},
		  {0.003125f,0.046875f,0.165625f},
		  {0.01875f,0.05f,0.165625f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,0.009375f,0.090625f},
		  {-0.096875f,0.009375f,0.103125f},
		  {-0.09375f,0.0125f,0.109375f},
		  {-0.0875f,0.0125f,0.121875f},
		  {-0.08125f,0.015625f,0.13125f},
		  {-0.071875f,0.01875f,0.140625f},
		  {-0.065625f,0.021875f,0.146875f},
		  {-0.053125f,0.025f,0.15625f},
		  {-0.04375f,0.028125f,0.1625f},
		  {-0.03125f,0.034375f,0.165625f},
		  {-0.01875f,0.0375f,0.16875f},
		  {-0.00625f,0.05f,0.165625f},
		  {0.009375f,0.053125f,0.165625f}}},
		{{{0.015625f,-0.059375f,0.075f},
		  {0.021875f,-0.0625f,0.075f},
		  {0.025f,-0.059375f,0.078125f},
		  {0.03125f,-0.05625f,0.08125f},
		  {0.034375f,-0.053125f,0.084375f},
		  {0.040625f,-0.046875f,0.0875f},
		  {0.04375f,-0.040625f,0.09375f},
		  {0.05f,-0.0375f,0.09375f},
		  {0.05625f,-0.03125f,0.096875f},
		  {0.0625f,-0.025f,0.1f},
		  {0.06875f,-0.0125f,0.1f},
		  {0.075f,-0.003125f,0.1f},
		  {0.084375f,0.00625f,0.090625f},
		  {0.090625f,0.015625f,0.0875f},
		  {0.09375f,0.040625f,0.071875f},
		  {0.09375f,0.059375f,0.05625f}},
		 {{0.0125f,-0.0625f,0.075f},
		  {0.015625f,-0.059375f,0.08125f},
		  {0.021875f,-0.0625f,0.08125f},
		  {0.025f,-0.053125f,0.0875f},
		  {0.03125f,-0.05f,0.090625f},
		  {0.034375f,-0.046875f,0.096875f},
		  {0.040625f,-0.04375f,0.096875f},
		  {0.046875f,-0.0375f,0.1f},
		  {0.053125f,-0.028125f,0.103125f},
		  {0.059375f,-0.021875f,0.10625f},
		  {0.065625f,-0.0125f,0.10625f},
		  {0.075f,-0.0125f,0.103125f},
		  {0.08125f,0.00625f,0.1f},
		  {0.0875f,0.021875f,0.09375f},
		  {0.090625f,0.0375f,0.0875f},
		  {0.09375f,0.059375f,0.059375f}},
		 {{0.009375f,-0.065625f,0.078125f},
		  {0.0125f,-0.059375f,0.084375f},
		  {0.015625f,-0.05625f,0.0875f},
		  {0.021875f,-0.05625f,0.090625f},
		  {0.028125f,-0.05625f,0.09375f},
		  {0.03125f,-0.046875f,0.1f},
		  {0.0375f,-0.040625f,0.103125f},
		  {0.04375f,-0.034375f,0.10625f},
		  {0.05f,-0.028125f,0.109375f},
		  {0.05625f,-0.021875f,0.109375f},
		  {0.0625f,-0.0125f,0.1125f},
		  {0.071875f,-0.00625f,0.109375f},
		  {0.078125f,0.009375f,0.10625f},
		  {0.084375f,0.025f,0.1f},
		  {0.090625f,0.040625f,0.0875f},
		  {0.090625f,0.046875f,0.0875f}},
		 {{0.003125f,-0.059375f,0.084375f},
		  {0.009375f,-0.065625f,0.084375f},
		  {0.0125f,-0.059375f,0.090625f},
		  {0.015625f,-0.053125f,0.096875f},
		  {0.021875f,-0.053125f,0.1f},
		  {0.028125f,-0.053125f,0.103125f},
		  {0.03125f,-0.040625f,0.109375f},
		  {0.0375f,-0.034375f,0.1125f},
		  {0.04375f,-0.028125f,0.115625f},
		  {0.05f,-0.01875f,0.11875f},
		  {0.059375f,-0.0125f,0.11875f},
		  {0.065625f,0.f,0.11875f},
		  {0.075f,0.003125f,0.115625f},
		  {0.08125f,0.021875f,0.109375f},
		  {0.0875f,0.040625f,0.096875f},
		  {0.090625f,0.059375f,0.08125f}},
		 {{0.f,-0.065625f,0.084375f},
		  {0.003125f,-0.0625f,0.090625f},
		  {0.00625f,-0.05625f,0.096875f},
		  {0.0125f,-0.059375f,0.1f},
		  {0.015625f,-0.046875f,0.10625f},
		  {0.021875f,-0.05f,0.109375f},
		  {0.025f,-0.0375f,0.115625f},
		  {0.034375f,-0.03125f,0.11875f},
		  {0.040625f,-0.025f,0.121875f},
		  {0.046875f,-0.01875f,0.125f},
		  {0.053125f,-0.009375f,0.125f},
		  {0.0625f,-0.003125f,0.125f},
		  {0.06875f,0.0125f,0.121875f},
		  {0.078125f,0.01875f,0.11875f},
		  {0.084375f,0.040625f,0.10625f},
		  {0.090625f,0.059375f,0.084375f}},
		 {{-0.00625f,-0.065625f,0.0875f},
		  {-0.003125f,-0.0625f,0.09375f},
		  {0.f,-0.05625f,0.1f},
		  {0.00625f,-0.059375f,0.103125f},
		  {0.009375f,-0.046875f,0.1125f},
		  {0.015625f,-0.04375f,0.115625f},
		  {0.021875f,-0.046875f,0.11875f},
		  {0.028125f,-0.03125f,0.125f},
		  {0.034375f,-0.021875f,0.128125f},
		  {0.040625f,-0.015625f,0.13125f},
		  {0.046875f,-0.00625f,0.134375f},
		  {0.05625f,0.003125f,0.13125f},
		  {0.0625f,0.015625f,0.13125f},
		  {0.071875f,0.025f,0.125f},
		  {0.08125f,0.034375f,0.11875f},
		  {0.0875f,0.05625f,0.1f}},
		 {{-0.015625f,-0.05625f,0.09375f},
		  {-0.009375f,-0.0625f,0.096875f},
		  {-0.00625f,-0.05625f,0.103125f},
		  {0.f,-0.05625f,0.109375f},
		  {0.003125f,-0.046875f,0.115625f},
		  {0.009375f,-0.04375f,0.121875f},
		  {0.015625f,-0.04375f,0.125f},
		  {0.021875f,-0.034375f,0.13125f},
		  {0.028125f,-0.021875f,0.134375f},
		  {0.034375f,-0.0125f,0.1375f},
		  {0.040625f,-0.00625f,0.140625f},
		  {0.05f,-0.003125f,0.140625f},
		  {0.05625f,0.015625f,0.1375f},
		  {0.065625f,0.025f,0.134375f},
		  {0.075f,0.0375f,0.125f},
		  {0.08125f,0.05625f,0.1125f}},
		 {{-0.021875f,-0.059375f,0.09375f},
		  {-0.01875f,-0.053125f,0.103125f},
		  {-0.015625f,-0.05f,0.109375f},
		  {-0.009375f,-0.053125f,0.1125f},
		  {-0.00625f,-0.040625f,0.121875f},
		  {0.f,-0.040625f,0.125f},
		  {0.00625f,-0.034375f,0.13125f},
		  {0.0125f,-0.028125f,0.1375f},
		  {0.021875f,-0.028125f,0.140625f},
		  {0.028125f,-0.015625f,0.14375f},
		  {0.034375f,-0.009375f,0.146875f},
		  {0.040625f,0.00625f,0.146875f},
		  {0.05f,0.01875f,0.14375f},
		  {0.059375f,0.025f,0.140625f},
		  {0.06875f,0.040625f,0.13125f},
		  {0.078125f,0.05625f,0.11875f}},
		 {{-0.028125f,-0.059375f,0.096875f},
		  {-0.025f,-0.05625f,0.103125f},
		  {-0.021875f,-0.053125f,0.109375f},
		  {-0.01875f,-0.04375f,0.11875f},
		  {-0.0125f,-0.040625f,0.125f},
		  {-0.00625f,-0.040625f,0.13125f},
		  {-0.003125f,-0.03125f,0.1375f},
		  {0.003125f,-0.021875f,0.140625f},
		  {0.009375f,-0.015625f,0.146875f},
		  {0.01875f,-0.015625f,0.15f},
		  {0.025f,0.f,0.15f},
		  {0.034375f,0.003125f,0.153125f},
		  {0.040625f,0.01875f,0.15f},
		  {0.05f,0.028125f,0.146875f},
		  {0.059375f,0.0375f,0.14375f},
		  {0.071875f,0.05f,0.13125f}},
		 {{-0.0375f,-0.053125f,0.1f},
		  {-0.034375f,-0.053125f,0.10625f},
		  {-0.03125f,-0.05f,0.1125f},
		  {-0.028125f,-0.040625f,0.121875f},
		  {-0.021875f,-0.0375f,0.128125f},
		  {-0.015625f,-0.0375f,0.134375f},
		  {-0.009375f,-0.03125f,0.140625f},
		  {-0.00625f,-0.021875f,0.146875f},
		  {0.003125f,-0.015625f,0.15f},
		  {0.009375f,-0.00625f,0.153125f},
		  {0.015625f,0.003125f,0.15625f},
		  {0.025f,0.0125f,0.15625f},
		  {0.034375f,0.01875f,0.15625f},
		  {0.04375f,0.028125f,0.153125f},
		  {0.053125f,0.040625f,0.146875f},
		  {0.0625f,0.05f,0.140625f}},
		 {{-0.046875f,-0.05f,0.1f},
		  {-0.04375f,-0.046875f,0.109375f},
		  {-0.040625f,-0.04375f,0.115625f},
		  {-0.0375f,-0.040625f,0.121875f},
		  {-0.034375f,-0.03125f,0.128125f},
		  {-0.025f,-0.034375f,0.1375f},
		  {-0.021875f,-0.025f,0.14375f},
		  {-0.015625f,-0.021875f,0.15f},
		  {-0.009375f,-0.009375f,0.153125f},
		  {-0.003125f,-0.003125f,0.15625f},
		  {0.00625f,0.00625f,0.159375f},
		  {0.015625f,0.009375f,0.1625f},
		  {0.025f,0.015625f,0.1625f},
		  {0.034375f,0.028125f,0.159375f},
		  {0.04375f,0.0375f,0.15625f},
		  {0.05625f,0.05f,0.146875f}},
		 {{-0.05625f,-0.046875f,0.1f},
		  {-0.053125f,-0.04375f,0.109375f},
		  {-0.053125f,-0.034375f,0.115625f},
		  {-0.046875f,-0.0375f,0.125f},
		  {-0.04375f,-0.028125f,0.13125f},
		  {-0.0375f,-0.028125f,0.1375f},
		  {-0.034375f,-0.015625f,0.14375f},
		  {-0.028125f,-0.009375f,0.15f},
		  {-0.01875f,-0.009375f,0.15625f},
		  {-0.0125f,0.f,0.159375f},
		  {-0.003125f,0.00625f,0.1625f},
		  {0.00625f,0.009375f,0.165625f},
		  {0.015625f,0.01875f,0.165625f},
		  {0.025f,0.025f,0.165625f},
		  {0.034375f,0.040625f,0.159375f},
		  {0.046875f,0.05f,0.153125f}},
		 {{-0.06875f,-0.034375f,0.1f},
		  {-0.065625f,-0.0375f,0.10625f},
		  {-0.0625f,-0.03125f,0.115625f},
		  {-0.059375f,-0.028125f,0.121875f},
		  {-0.053125f,-0.028125f,0.13125f},
		  {-0.05f,-0.01875f,0.1375f},
		  {-0.04375f,-0.015625f,0.14375f},
		  {-0.0375f,-0.00625f,0.15f},
		  {-0.03125f,-0.003125f,0.15625f},
		  {-0.025f,0.00625f,0.159375f},
		  {-0.0125f,0.00625f,0.165625f},
		  {-0.00625f,0.01875f,0.165625f},
		  {0.003125f,0.021875f,0.16875f},
		  {0.015625f,0.034375f,0.165625f},
		  {0.025f,0.0375f,0.165625f},
		  {0.03125f,0.046875f,0.1625f}},
		 {{-0.08125f,-0.025f,0.09375f},
		  {-0.078125f,-0.025f,0.103125f},
		  {-0.075f,-0.025f,0.1125f},
		  {-0.071875f,-0.01875f,0.11875f},
		  {-0.065625f,-0.021875f,0.128125f},
		  {-0.0625f,-0.009375f,0.134375f},
		  {-0.05625f,-0.0125f,0.14375f},
		  {-0.05f,-0.00625f,0.15f},
		  {-0.040625f,0.f,0.15625f},
		  {-0.034375f,0.009375f,0.159375f},
		  {-0.025f,0.009375f,0.165625f},
		  {-0.015625f,0.015625f,0.16875f},
		  {-0.009375f,0.028125f,0.16875f},
		  {0.003125f,0.034375f,0.16875f},
		  {0.0125f,0.0375f,0.16875f},
		  {0.025f,0.046875f,0.165625f}},
		 {{-0.09375f,-0.0125f,0.084375f},
		  {-0.09375f,-0.009375f,0.090625f},
		  {-0.090625f,-0.009375f,0.1f},
		  {-0.084375f,-0.009375f,0.1125f},
		  {-0.08125f,-0.009375f,0.121875f},
		  {-0.078125f,-0.003125f,0.128125f},
		  {-0.071875f,0.f,0.134375f},
		  {-0.0625f,0.f,0.146875f},
		  {-0.05625f,0.009375f,0.15f},
		  {-0.046875f,0.009375f,0.159375f},
		  {-0.040625f,0.015625f,0.1625f},
		  {-0.028125f,0.025f,0.165625f},
		  {-0.01875f,0.028125f,0.16875f},
		  {-0.00625f,0.03125f,0.171875f},
		  {0.003125f,0.0375f,0.171875f},
		  {0.0125f,0.046875f,0.16875f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,0.00625f,0.09375f},
		  {-0.096875f,0.00625f,0.103125f},
		  {-0.090625f,0.003125f,0.11875f},
		  {-0.084375f,0.00625f,0.128125f},
		  {-0.075f,0.00625f,0.140625f},
		  {-0.06875f,0.009375f,0.146875f},
		  {-0.0625f,0.015625f,0.153125f},
		  {-0.053125f,0.01875f,0.159375f},
		  {-0.040625f,0.021875f,0.165625f},
		  {-0.03125f,0.028125f,0.16875f},
		  {-0.01875f,0.03125f,0.171875f},
		  {-0.009375f,0.0375f,0.171875f},
		  {0.f,0.040625f,0.171875f}}},
		{{{0.01875f,-0.06875f,0.06875f},
		  {0.021875f,-0.06875f,0.071875f},
		  {0.028125f,-0.071875f,0.071875f},
		  {0.03125f,-0.065625f,0.078125f},
		  {0.034375f,-0.059375f,0.084375f},
		  {0.040625f,-0.05625f,0.084375f},
		  {0.046875f,-0.053125f,0.0875f},
		  {0.05f,-0.046875f,0.09375f},
		  {0.05625f,-0.040625f,0.096875f},
		  {0.0625f,-0.034375f,0.096875f},
		  {0.06875f,-0.028125f,0.1f},
		  {0.075f,-0.01875f,0.1f},
		  {0.084375f,-0.003125f,0.09375f},
		  {0.090625f,0.0125f,0.090625f},
		  {0.09375f,0.03125f,0.084375f},
		  {0.096875f,0.053125f,0.065625f}},
		 {{0.015625f,-0.071875f,0.071875f},
		  {0.01875f,-0.06875f,0.075f},
		  {0.021875f,-0.065625f,0.08125f},
		  {0.028125f,-0.06875f,0.08125f},
		  {0.03125f,-0.059375f,0.0875f},
		  {0.0375f,-0.05625f,0.090625f},
		  {0.040625f,-0.053125f,0.096875f},
		  {0.046875f,-0.046875f,0.1f},
		  {0.053125f,-0.040625f,0.103125f},
		  {0.059375f,-0.034375f,0.10625f},
		  {0.065625f,-0.025f,0.10625f},
		  {0.075f,-0.015625f,0.103125f},
		  {0.08125f,-0.003125f,0.103125f},
		  {0.0875f,0.0125f,0.1f},
		  {0.09375f,0.034375f,0.084375f},
		  {0.09375f,0.059375f,0.065625f}},
		 {{0.0125f,-0.071875f,0.075f},
		  {0.015625f,-0.071875f,0.078125f},
		  {0.01875f,-0.065625f,0.084375f},
		  {0.021875f,-0.0625f,0.090625f},
		  {0.028125f,-0.059375f,0.09375f},
		  {0.034375f,-0.0625f,0.09375f},
		  {0.0375f,-0.05f,0.103125f},
		  {0.04375f,-0.046875f,0.10625f},
		  {0.05f,-0.040625f,0.109375f},
		  {0.05625f,-0.03125f,0.1125f},
		  {0.0625f,-0.025f,0.1125f},
		  {0.06875f,-0.0125f,0.115625f},
		  {0.078125f,-0.003125f,0.109375f},
		  {0.084375f,0.0125f,0.109375f},
		  {0.090625f,0.034375f,0.096875f},
		  {0.09375f,0.059375f,0.06875f}},
		 {{0.00625f,-0.071875f,0.078125f},
		  {0.009375f,-0.06875f,0.084375f},
		  {0.015625f,-0.06875f,0.0875f},
		  {0.01875f,-0.0625f,0.09375f},
		  {0.025f,-0.0625f,0.096875f},
		  {0.028125f,-0.05625f,0.103125f},
		  {0.034375f,-0.053125f,0.10625f},
		  {0.040625f,-0.05f,0.109375f},
		  {0.046875f,-0.04375f,0.1125f},
		  {0.053125f,-0.034375f,0.115625f},
		  {0.059375f,-0.021875f,0.11875f},
		  {0.065625f,-0.0125f,0.121875f},
		  {0.075f,-0.009375f,0.11875f},
		  {0.08125f,0.0125f,0.115625f},
		  {0.0875f,0.03125f,0.10625f},
		  {0.09375f,0.05f,0.0875f}},
		 {{0.f,-0.06875f,0.084375f},
		  {0.00625f,-0.075f,0.084375f},
		  {0.009375f,-0.065625f,0.09375f},
		  {0.0125f,-0.0625f,0.1f},
		  {0.01875f,-0.059375f,0.103125f},
		  {0.025f,-0.0625f,0.10625f},
		  {0.028125f,-0.05f,0.1125f},
		  {0.034375f,-0.04375f,0.11875f},
		  {0.040625f,-0.0375f,0.121875f},
		  {0.046875f,-0.03125f,0.125f},
		  {0.053125f,-0.021875f,0.128125f},
		  {0.059375f,-0.009375f,0.13125f},
		  {0.06875f,0.f,0.125f},
		  {0.078125f,0.0125f,0.121875f},
		  {0.084375f,0.028125f,0.115625f},
		  {0.090625f,0.053125f,0.096875f}},
		 {{-0.003125f,-0.075f,0.084375f},
		  {0.f,-0.071875f,0.090625f},
		  {0.003125f,-0.065625f,0.096875f},
		  {0.009375f,-0.06875f,0.1f},
		  {0.0125f,-0.05625f,0.109375f},
		  {0.01875f,-0.059375f,0.1125f},
		  {0.021875f,-0.05f,0.11875f},
		  {0.028125f,-0.040625f,0.125f},
		  {0.034375f,-0.034375f,0.128125f},
		  {0.040625f,-0.028125f,0.13125f},
		  {0.046875f,-0.01875f,0.134375f},
		  {0.05625f,-0.009375f,0.134375f},
		  {0.0625f,0.003125f,0.134375f},
		  {0.071875f,0.0125f,0.13125f},
		  {0.078125f,0.03125f,0.125f},
		  {0.0875f,0.05f,0.10625f}},
		 {{-0.009375f,-0.071875f,0.0875f},
		  {-0.00625f,-0.071875f,0.09375f},
		  {-0.003125f,-0.065625f,0.1f},
		  {0.003125f,-0.065625f,0.10625f},
		  {0.00625f,-0.059375f,0.1125f},
		  {0.0125f,-0.05625f,0.11875f},
		  {0.015625f,-0.046875f,0.125f},
		  {0.021875f,-0.040625f,0.13125f},
		  {0.028125f,-0.034375f,0.134375f},
		  {0.034375f,-0.025f,0.1375f},
		  {0.04375f,-0.025f,0.140625f},
		  {0.05f,-0.00625f,0.140625f},
		  {0.05625f,0.003125f,0.140625f},
		  {0.065625f,0.015625f,0.1375f},
		  {0.075f,0.028125f,0.13125f},
		  {0.08125f,0.046875f,0.121875f}},
		 {{-0.015625f,-0.071875f,0.090625f},
		  {-0.015625f,-0.0625f,0.1f},
		  {-0.009375f,-0.0625f,0.10625f},
		  {-0.00625f,-0.059375f,0.1125f},
		  {0.f,-0.0625f,0.115625f},
		  {0.003125f,-0.05f,0.125f},
		  {0.009375f,-0.04375f,0.13125f},
		  {0.015625f,-0.046875f,0.134375f},
		  {0.021875f,-0.03125f,0.140625f},
		  {0.028125f,-0.021875f,0.14375f},
		  {0.034375f,-0.015625f,0.146875f},
		  {0.040625f,-0.003125f,0.15f},
		  {0.05f,0.f,0.15f},
		  {0.059375f,0.009375f,0.146875f},
		  {0.06875f,0.03125f,0.1375f},
		  {0.078125f,0.040625f,0.13125f}},
		 {{-0.025f,-0.065625f,0.096875f},
		  {-0.021875f,-0.0625f,0.103125f},
		  {-0.01875f,-0.059375f,0.109375f},
		  {-0.0125f,-0.0625f,0.115625f},
		  {-0.009375f,-0.05625f,0.121875f},
		  {-0.003125f,-0.053125f,0.128125f},
		  {0.003125f,-0.05f,0.134375f},
		  {0.009375f,-0.04375f,0.140625f},
		  {0.0125f,-0.025f,0.146875f},
		  {0.021875f,-0.028125f,0.15f},
		  {0.028125f,-0.015625f,0.153125f},
		  {0.034375f,-0.003125f,0.153125f},
		  {0.04375f,0.009375f,0.153125f},
		  {0.05f,0.01875f,0.153125f},
		  {0.059375f,0.025f,0.15f},
		  {0.06875f,0.040625f,0.140625f}},
		 {{-0.03125f,-0.06875f,0.09375f},
		  {-0.028125f,-0.065625f,0.103125f},
		  {-0.025f,-0.0625f,0.1125f},
		  {-0.021875f,-0.059375f,0.11875f},
		  {-0.01875f,-0.046875f,0.128125f},
		  {-0.0125f,-0.046875f,0.134375f},
		  {-0.00625f,-0.04375f,0.140625f},
		  {-0.003125f,-0.03125f,0.146875f},
		  {0.00625f,-0.034375f,0.15f},
		  {0.009375f,-0.01875f,0.15625f},
		  {0.01875f,-0.015625f,0.159375f},
		  {0.025f,0.f,0.159375f},
		  {0.034375f,0.009375f,0.159375f},
		  {0.040625f,0.01875f,0.159375f},
		  {0.053125f,0.03125f,0.153125f},
		  {0.0625f,0.040625f,0.146875f}},
		 {{-0.040625f,-0.0625f,0.1f},
		  {-0.040625f,-0.05625f,0.10625f},
		  {-0.034375f,-0.05625f,0.115625f},
		  {-0.03125f,-0.053125f,0.121875f},
		  {-0.028125f,-0.046875f,0.13125f},
		  {-0.021875f,-0.04375f,0.1375f},
		  {-0.015625f,-0.040625f,0.14375f},
		  {-0.009375f,-0.034375f,0.15f},
		  {-0.00625f,-0.025f,0.15625f},
		  {0.003125f,-0.01875f,0.159375f},
		  {0.009375f,-0.009375f,0.1625f},
		  {0.015625f,-0.003125f,0.165625f},
		  {0.025f,0.00625f,0.165625f},
		  {0.034375f,0.021875f,0.1625f},
		  {0.04375f,0.03125f,0.159375f},
		  {0.053125f,0.0375f,0.15625f}},
		 {{-0.053125f,-0.05625f,0.1f},
		  {-0.05f,-0.053125f,0.109375f},
		  {-0.046875f,-0.05f,0.115625f},
		  {-0.040625f,-0.05f,0.125f},
		  {-0.0375f,-0.046875f,0.13125f},
		  {-0.034375f,-0.0375f,0.140625f},
		  {-0.028125f,-0.03125f,0.146875f},
		  {-0.021875f,-0.028125f,0.153125f},
		  {-0.015625f,-0.025f,0.15625f},
		  {-0.00625f,-0.015625f,0.1625f},
		  {0.f,-0.00625f,0.165625f},
		  {0.009375f,-0.003125f,0.16875f},
		  {0.015625f,0.009375f,0.16875f},
		  {0.021875f,0.021875f,0.16875f},
		  {0.03125f,0.028125f,0.165625f},
		  {0.040625f,0.0375f,0.1625f}},
		 {{-0.065625f,-0.04375f,0.1f},
		  {-0.0625f,-0.04375f,0.109375f},
		  {-0.059375f,-0.040625f,0.115625f},
		  {-0.05625f,-0.034375f,0.125f},
		  {-0.05f,-0.0375f,0.13125f},
		  {-0.04375f,-0.034375f,0.140625f},
		  {-0.040625f,-0.021875f,0.146875f},
		  {-0.034375f,-0.015625f,0.153125f},
		  {-0.025f,-0.015625f,0.159375f},
		  {-0.021875f,-0.003125f,0.1625f},
		  {-0.009375f,-0.00625f,0.16875f},
		  {-0.003125f,0.009375f,0.16875f},
		  {0.00625f,0.0125f,0.171875f},
		  {0.0125f,0.021875f,0.171875f},
		  {0.021875f,0.025f,0.171875f},
		  {0.03125f,0.034375f,0.16875f}},
		 {{-0.078125f,-0.034375f,0.096875f},
		  {-0.075f,-0.034375f,0.10625f},
		  {-0.071875f,-0.034375f,0.115625f},
		  {-0.06875f,-0.028125f,0.121875f},
		  {-0.0625f,-0.028125f,0.13125f},
		  {-0.059375f,-0.01875f,0.1375f},
		  {-0.05f,-0.021875f,0.146875f},
		  {-0.04375f,-0.01875f,0.153125f},
		  {-0.0375f,-0.009375f,0.159375f},
		  {-0.03125f,-0.00625f,0.165625f},
		  {-0.021875f,0.f,0.16875f},
		  {-0.0125f,0.00625f,0.171875f},
		  {-0.00625f,0.01875f,0.171875f},
		  {0.003125f,0.01875f,0.175f},
		  {0.0125f,0.025f,0.175f},
		  {0.021875f,0.034375f,0.171875f}},
		 {{-0.09375f,-0.015625f,0.0875f},
		  {-0.090625f,-0.015625f,0.096875f},
		  {-0.084375f,-0.021875f,0.109375f},
		  {-0.084375f,-0.015625f,0.115625f},
		  {-0.078125f,-0.015625f,0.125f},
		  {-0.071875f,-0.0125f,0.134375f},
		  {-0.065625f,-0.0125f,0.14375f},
		  {-0.059375f,-0.00625f,0.15f},
		  {-0.053125f,-0.003125f,0.15625f},
		  {-0.04375f,0.003125f,0.1625f},
		  {-0.034375f,0.003125f,0.16875f},
		  {-0.025f,0.009375f,0.171875f},
		  {-0.015625f,0.015625f,0.175f},
		  {-0.009375f,0.025f,0.175f},
		  {0.f,0.03125f,0.175f},
		  {0.009375f,0.03125f,0.175f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,-0.003125f,0.09375f},
		  {-0.096875f,-0.003125f,0.103125f},
		  {-0.09375f,-0.003125f,0.1125f},
		  {-0.084375f,-0.00625f,0.128125f},
		  {-0.08125f,-0.003125f,0.134375f},
		  {-0.075f,0.003125f,0.140625f},
		  {-0.065625f,0.00625f,0.15f},
		  {-0.05625f,0.00625f,0.159375f},
		  {-0.046875f,0.009375f,0.165625f},
		  {-0.0375f,0.015625f,0.16875f},
		  {-0.025f,0.015625f,0.175f},
		  {-0.015625f,0.025f,0.175f},
		  {-0.00625f,0.03125f,0.175f},
		  {0.f,0.034375f,0.175f}}},
		{{{0.01875f,-0.078125f,0.065625f},
		  {0.025f,-0.078125f,0.065625f},
		  {0.028125f,-0.078125f,0.06875f},
		  {0.03125f,-0.071875f,0.075f},
		  {0.0375f,-0.078125f,0.071875f},
		  {0.040625f,-0.06875f,0.08125f},
		  {0.04375f,-0.065625f,0.0875f},
		  {0.05f,-0.059375f,0.090625f},
		  {0.05625f,-0.05625f,0.090625f},
		  {0.0625f,-0.046875f,0.09375f},
		  {0.06875f,-0.040625f,0.096875f},
		  {0.075f,-0.03125f,0.1f},
		  {0.08125f,-0.01875f,0.1f},
		  {0.090625f,0.f,0.09375f},
		  {0.096875f,0.025f,0.08125f},
		  {0.1f,0.046875f,0.065625f}},
		 {{0.01875f,-0.084375f,0.0625f},
		  {0.021875f,-0.08125f,0.06875f},
		  {0.025f,-0.075f,0.075f},
		  {0.028125f,-0.071875f,0.08125f},
		  {0.034375f,-0.071875f,0.08125f},
		  {0.0375f,-0.06875f,0.0875f},
		  {0.040625f,-0.0625f,0.09375f},
		  {0.046875f,-0.059375f,0.096875f},
		  {0.053125f,-0.053125f,0.1f},
		  {0.059375f,-0.046875f,0.103125f},
		  {0.065625f,-0.0375f,0.10625f},
		  {0.071875f,-0.028125f,0.109375f},
		  {0.08125f,-0.01875f,0.103125f},
		  {0.0875f,-0.003125f,0.103125f},
		  {0.09375f,0.021875f,0.096875f},
		  {0.096875f,0.053125f,0.06875f}},
		 {{0.0125f,-0.078125f,0.071875f},
		  {0.015625f,-0.078125f,0.075f},
		  {0.021875f,-0.08125f,0.075f},
		  {0.025f,-0.071875f,0.084375f},
		  {0.028125f,-0.06875f,0.090625f},
		  {0.034375f,-0.065625f,0.09375f},
		  {0.0375f,-0.0625f,0.1f},
		  {0.04375f,-0.059375f,0.1f},
		  {0.05f,-0.053125f,0.10625f},
		  {0.05625f,-0.046875f,0.109375f},
		  {0.0625f,-0.0375f,0.1125f},
		  {0.06875f,-0.028125f,0.115625f},
		  {0.075f,-0.01875f,0.115625f},
		  {0.084375f,0.f,0.1125f},
		  {0.09375f,0.0125f,0.103125f},
		  {0.09375f,0.05625f,0.078125f}},
		 {{0.009375f,-0.078125f,0.075f},
		  {0.0125f,-0.078125f,0.078125f},
		  {0.015625f,-0.075f,0.084375f},
		  {0.021875f,-0.075f,0.0875f},
		  {0.025f,-0.06875f,0.09375f},
		  {0.03125f,-0.06875f,0.096875f},
		  {0.034375f,-0.0625f,0.103125f},
		  {0.040625f,-0.059375f,0.10625f},
		  {0.046875f,-0.05f,0.1125f},
		  {0.053125f,-0.04375f,0.115625f},
		  {0.059375f,-0.0375f,0.11875f},
		  {0.065625f,-0.025f,0.121875f},
		  {0.075f,-0.0125f,0.11875f},
		  {0.08125f,0.f,0.11875f},
		  {0.0875f,0.01875f,0.115625f},
		  {0.09375f,0.053125f,0.0875f}},
		 {{0.00625f,-0.084375f,0.075f},
		  {0.009375f,-0.08125f,0.08125f},
		  {0.0125f,-0.078125f,0.0875f},
		  {0.015625f,-0.071875f,0.09375f},
		  {0.021875f,-0.078125f,0.09375f},
		  {0.025f,-0.06875f,0.103125f},
		  {0.03125f,-0.06875f,0.10625f},
		  {0.034375f,-0.05625f,0.115625f},
		  {0.040625f,-0.05f,0.11875f},
		  {0.046875f,-0.040625f,0.125f},
		  {0.053125f,-0.034375f,0.128125f},
		  {0.059375f,-0.025f,0.13125f},
		  {0.06875f,-0.0125f,0.128125f},
		  {0.078125f,0.f,0.125f},
		  {0.084375f,0.015625f,0.121875f},
		  {0.090625f,0.04375f,0.10625f}},
		 {{0.f,-0.084375f,0.078125f},
		  {0.003125f,-0.078125f,0.0875f},
		  {0.00625f,-0.075f,0.09375f},
		  {0.009375f,-0.071875f,0.1f},
		  {0.015625f,-0.071875f,0.103125f},
		  {0.01875f,-0.0625f,0.1125f},
		  {0.025f,-0.059375f,0.115625f},
		  {0.03125f,-0.059375f,0.11875f},
		  {0.0375f,-0.05f,0.125f},
		  {0.04375f,-0.046875f,0.128125f},
		  {0.05f,-0.040625f,0.13125f},
		  {0.05625f,-0.025f,0.134375f},
		  {0.0625f,-0.009375f,0.1375f},
		  {0.071875f,0.f,0.134375f},
		  {0.078125f,0.01875f,0.13125f},
		  {0.0875f,0.040625f,0.115625f}},
		 {{-0.003125f,-0.084375f,0.08125f},
		  {-0.003125f,-0.078125f,0.090625f},
		  {0.003125f,-0.08125f,0.09375f},
		  {0.00625f,-0.078125f,0.1f},
		  {0.009375f,-0.06875f,0.109375f},
		  {0.015625f,-0.071875f,0.1125f},
		  {0.01875f,-0.059375f,0.121875f},
		  {0.025f,-0.059375f,0.125f},
		  {0.03125f,-0.05f,0.13125f},
		  {0.0375f,-0.05f,0.134375f},
		  {0.04375f,-0.028125f,0.140625f},
		  {0.05f,-0.034375f,0.140625f},
		  {0.05625f,-0.009375f,0.14375f},
		  {0.065625f,0.003125f,0.140625f},
		  {0.071875f,0.015625f,0.140625f},
		  {0.08125f,0.0375f,0.128125f}},
		 {{-0.0125f,-0.078125f,0.0875f},
		  {-0.009375f,-0.078125f,0.09375f},
		  {-0.00625f,-0.071875f,0.103125f},
		  {0.f,-0.075f,0.10625f},
		  {0.003125f,-0.071875f,0.1125f},
		  {0.00625f,-0.0625f,0.121875f},
		  {0.0125f,-0.05625f,0.128125f},
		  {0.01875f,-0.059375f,0.13125f},
		  {0.025f,-0.05f,0.1375f},
		  {0.028125f,-0.0375f,0.14375f},
		  {0.034375f,-0.028125f,0.146875f},
		  {0.040625f,-0.01875f,0.15f},
		  {0.05f,-0.009375f,0.15f},
		  {0.05625f,0.003125f,0.15f},
		  {0.065625f,0.015625f,0.146875f},
		  {0.075f,0.034375f,0.1375f}},
		 {{-0.01875f,-0.078125f,0.090625f},
		  {-0.015625f,-0.078125f,0.096875f},
		  {-0.009375f,-0.078125f,0.103125f},
		  {-0.009375f,-0.06875f,0.1125f},
		  {-0.003125f,-0.06875f,0.11875f},
		  {0.f,-0.065625f,0.125f},
		  {0.00625f,-0.0625f,0.13125f},
		  {0.0125f,-0.05625f,0.1375f},
		  {0.015625f,-0.04375f,0.14375f},
		  {0.021875f,-0.03125f,0.15f},
		  {0.028125f,-0.025f,0.153125f},
		  {0.034375f,-0.015625f,0.15625f},
		  {0.04375f,-0.00625f,0.15625f},
		  {0.05f,0.00625f,0.15625f},
		  {0.059375f,0.015625f,0.153125f},
		  {0.065625f,0.028125f,0.15f}},
		 {{-0.025f,-0.078125f,0.09375f},
		  {-0.025f,-0.071875f,0.103125f},
		  {-0.01875f,-0.075f,0.10625f},
		  {-0.015625f,-0.071875f,0.115625f},
		  {-0.0125f,-0.0625f,0.125f},
		  {-0.009375f,-0.059375f,0.13125f},
		  {-0.003125f,-0.05625f,0.1375f},
		  {0.003125f,-0.05f,0.14375f},
		  {0.00625f,-0.0375f,0.15f},
		  {0.0125f,-0.03125f,0.15625f},
		  {0.01875f,-0.01875f,0.159375f},
		  {0.025f,-0.009375f,0.1625f},
		  {0.034375f,-0.003125f,0.1625f},
		  {0.040625f,0.009375f,0.1625f},
		  {0.05f,0.01875f,0.159375f},
		  {0.059375f,0.025f,0.15625f}},
		 {{-0.034375f,-0.075f,0.096875f},
		  {-0.03125f,-0.075f,0.1f},
		  {-0.028125f,-0.06875f,0.1125f},
		  {-0.028125f,-0.059375f,0.121875f},
		  {-0.021875f,-0.0625f,0.128125f},
		  {-0.015625f,-0.059375f,0.134375f},
		  {-0.0125f,-0.053125f,0.140625f},
		  {-0.00625f,-0.05f,0.146875f},
		  {-0.003125f,-0.0375f,0.15625f},
		  {0.00625f,-0.03125f,0.159375f},
		  {0.0125f,-0.028125f,0.1625f},
		  {0.01875f,-0.009375f,0.165625f},
		  {0.025f,-0.00625f,0.16875f},
		  {0.03125f,0.00625f,0.16875f},
		  {0.040625f,0.01875f,0.165625f},
		  {0.05f,0.025f,0.1625f}},
		 {{-0.04375f,-0.06875f,0.1f},
		  {-0.040625f,-0.06875f,0.10625f},
		  {-0.0375f,-0.065625f,0.115625f},
		  {-0.0375f,-0.05625f,0.125f},
		  {-0.03125f,-0.05625f,0.13125f},
		  {-0.028125f,-0.053125f,0.1375f},
		  {-0.021875f,-0.046875f,0.146875f},
		  {-0.01875f,-0.03125f,0.153125f},
		  {-0.0125f,-0.03125f,0.159375f},
		  {-0.00625f,-0.021875f,0.1625f},
		  {0.f,-0.015625f,0.165625f},
		  {0.00625f,-0.00625f,0.16875f},
		  {0.015625f,0.f,0.171875f},
		  {0.025f,0.00625f,0.171875f},
		  {0.03125f,0.0125f,0.171875f},
		  {0.0375f,0.025f,0.16875f}},
		 {{-0.05625f,-0.0625f,0.1f},
		  {-0.053125f,-0.0625f,0.10625f},
		  {-0.05f,-0.059375f,0.115625f},
		  {-0.05f,-0.05f,0.125f},
		  {-0.04375f,-0.046875f,0.134375f},
		  {-0.0375f,-0.046875f,0.140625f},
		  {-0.034375f,-0.040625f,0.146875f},
		  {-0.028125f,-0.0375f,0.153125f},
		  {-0.021875f,-0.03125f,0.159375f},
		  {-0.015625f,-0.015625f,0.165625f},
		  {-0.009375f,-0.009375f,0.16875f},
		  {-0.003125f,0.f,0.171875f},
		  {0.00625f,0.f,0.175f},
		  {0.015625f,0.009375f,0.175f},
		  {0.021875f,0.015625f,0.175f},
		  {0.025f,0.021875f,0.175f}},
		 {{-0.071875f,-0.05f,0.1f},
		  {-0.06875f,-0.046875f,0.109375f},
		  {-0.065625f,-0.046875f,0.115625f},
		  {-0.059375f,-0.046875f,0.125f},
		  {-0.05625f,-0.040625f,0.134375f},
		  {-0.05f,-0.040625f,0.140625f},
		  {-0.04375f,-0.034375f,0.15f},
		  {-0.040625f,-0.025f,0.15625f},
		  {-0.034375f,-0.021875f,0.1625f},
		  {-0.028125f,-0.009375f,0.165625f},
		  {-0.015625f,-0.0125f,0.171875f},
		  {-0.009375f,-0.00625f,0.175f},
		  {-0.003125f,0.009375f,0.175f},
		  {0.00625f,0.00625f,0.178125f},
		  {0.0125f,0.0125f,0.178125f},
		  {0.015625f,0.01875f,0.178125f}},
		 {{-0.090625f,-0.025f,0.090625f},
		  {-0.0875f,-0.025f,0.1f},
		  {-0.08125f,-0.03125f,0.1125f},
		  {-0.078125f,-0.028125f,0.121875f},
		  {-0.071875f,-0.028125f,0.13125f},
		  {-0.06875f,-0.021875f,0.1375f},
		  {-0.059375f,-0.021875f,0.146875f},
		  {-0.053125f,-0.021875f,0.153125f},
		  {-0.046875f,-0.009375f,0.159375f},
		  {-0.0375f,-0.0125f,0.165625f},
		  {-0.028125f,-0.00625f,0.171875f},
		  {-0.021875f,0.f,0.175f},
		  {-0.015625f,0.00625f,0.178125f},
		  {-0.00625f,0.015625f,0.178125f},
		  {0.003125f,0.021875f,0.178125f},
		  {0.00625f,0.025f,0.178125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.1f,-0.00625f,0.09375f},
		  {-0.09375f,-0.0125f,0.109375f},
		  {-0.0875f,-0.0125f,0.121875f},
		  {-0.08125f,-0.015625f,0.13125f},
		  {-0.075f,-0.009375f,0.140625f},
		  {-0.071875f,-0.00625f,0.146875f},
		  {-0.059375f,-0.003125f,0.15625f},
		  {-0.046875f,-0.00625f,0.165625f},
		  {-0.040625f,0.003125f,0.16875f},
		  {-0.028125f,0.003125f,0.175f},
		  {-0.01875f,0.00625f,0.178125f},
		  {-0.015625f,0.015625f,0.178125f},
		  {-0.0125f,0.01875f,0.178125f},
		  {0.f,0.f,0.f}}},
		{{{0.021875f,-0.084375f,0.059375f},
		  {0.025f,-0.084375f,0.0625f},
		  {0.028125f,-0.084375f,0.065625f},
		  {0.03125f,-0.08125f,0.06875f},
		  {0.034375f,-0.08125f,0.071875f},
		  {0.040625f,-0.078125f,0.075f},
		  {0.04375f,-0.075f,0.08125f},
		  {0.05f,-0.071875f,0.08125f},
		  {0.053125f,-0.06875f,0.0875f},
		  {0.059375f,-0.0625f,0.090625f},
		  {0.065625f,-0.05625f,0.09375f},
		  {0.071875f,-0.046875f,0.096875f},
		  {0.08125f,-0.0375f,0.09375f},
		  {0.0875f,-0.021875f,0.1f},
		  {0.096875f,0.009375f,0.09375f},
		  {0.1f,0.04375f,0.071875f}},
		 {{0.01875f,-0.0875f,0.059375f},
		  {0.021875f,-0.084375f,0.065625f},
		  {0.025f,-0.084375f,0.06875f},
		  {0.028125f,-0.08125f,0.075f},
		  {0.034375f,-0.08125f,0.075f},
		  {0.0375f,-0.078125f,0.08125f},
		  {0.040625f,-0.075f,0.0875f},
		  {0.046875f,-0.071875f,0.0875f},
		  {0.05f,-0.065625f,0.096875f},
		  {0.05625f,-0.0625f,0.1f},
		  {0.0625f,-0.05625f,0.103125f},
		  {0.06875f,-0.046875f,0.10625f},
		  {0.078125f,-0.0375f,0.103125f},
		  {0.084375f,-0.01875f,0.109375f},
		  {0.09375f,0.00625f,0.103125f},
		  {0.1f,0.04375f,0.075f}},
		 {{0.015625f,-0.090625f,0.0625f},
		  {0.01875f,-0.0875f,0.06875f},
		  {0.021875f,-0.084375f,0.071875f},
		  {0.025f,-0.084375f,0.078125f},
		  {0.03125f,-0.084375f,0.078125f},
		  {0.034375f,-0.078125f,0.0875f},
		  {0.0375f,-0.075f,0.09375f},
		  {0.04375f,-0.071875f,0.09375f},
		  {0.05f,-0.06875f,0.096875f},
		  {0.053125f,-0.059375f,0.10625f},
		  {0.059375f,-0.053125f,0.109375f},
		  {0.06875f,-0.04375f,0.109375f},
		  {0.075f,-0.034375f,0.1125f},
		  {0.08125f,-0.015625f,0.11875f},
		  {0.090625f,0.00625f,0.1125f},
		  {0.096875f,0.05f,0.078125f}},
		 {{0.0125f,-0.090625f,0.065625f},
		  {0.015625f,-0.0875f,0.071875f},
		  {0.01875f,-0.084375f,0.078125f},
		  {0.021875f,-0.08125f,0.084375f},
		  {0.028125f,-0.0875f,0.08125f},
		  {0.03125f,-0.078125f,0.090625f},
		  {0.034375f,-0.075f,0.096875f},
		  {0.040625f,-0.06875f,0.103125f},
		  {0.04375f,-0.0625f,0.1125f},
		  {0.05f,-0.059375f,0.1125f},
		  {0.05625f,-0.05f,0.11875f},
		  {0.0625f,-0.04375f,0.121875f},
		  {0.071875f,-0.034375f,0.11875f},
		  {0.078125f,-0.01875f,0.121875f},
		  {0.0875f,0.00625f,0.11875f},
		  {0.09375f,0.040625f,0.103125f}},
		 {{0.009375f,-0.090625f,0.06875f},
		  {0.0125f,-0.090625f,0.071875f},
		  {0.015625f,-0.090625f,0.078125f},
		  {0.01875f,-0.0875f,0.084375f},
		  {0.021875f,-0.08125f,0.09375f},
		  {0.025f,-0.078125f,0.1f},
		  {0.03125f,-0.075f,0.103125f},
		  {0.0375f,-0.071875f,0.10625f},
		  {0.040625f,-0.0625f,0.115625f},
		  {0.046875f,-0.059375f,0.11875f},
		  {0.053125f,-0.05f,0.121875f},
		  {0.059375f,-0.040625f,0.128125f},
		  {0.065625f,-0.028125f,0.13125f},
		  {0.075f,-0.015625f,0.128125f},
		  {0.084375f,0.003125f,0.125f},
		  {0.09375f,0.0375f,0.10625f}},
		 {{0.00625f,-0.09375f,0.06875f},
		  {0.00625f,-0.0875f,0.08125f},
		  {0.0125f,-0.090625f,0.08125f},
		  {0.015625f,-0.090625f,0.084375f},
		  {0.01875f,-0.0875f,0.09375f},
		  {0.021875f,-0.078125f,0.103125f},
		  {0.028125f,-0.078125f,0.10625f},
		  {0.03125f,-0.06875f,0.115625f},
		  {0.0375f,-0.065625f,0.11875f},
		  {0.04375f,-0.05625f,0.125f},
		  {0.046875f,-0.046875f,0.13125f},
		  {0.053125f,-0.0375f,0.1375f},
		  {0.0625f,-0.025f,0.1375f},
		  {0.06875f,-0.015625f,0.1375f},
		  {0.078125f,0.003125f,0.134375f},
		  {0.0875f,0.025f,0.125f}},
		 {{0.f,-0.09375f,0.075f},
		  {0.003125f,-0.090625f,0.08125f},
		  {0.00625f,-0.090625f,0.0875f},
		  {0.009375f,-0.0875f,0.09375f},
		  {0.0125f,-0.08125f,0.103125f},
		  {0.015625f,-0.075f,0.109375f},
		  {0.021875f,-0.078125f,0.1125f},
		  {0.025f,-0.065625f,0.125f},
		  {0.03125f,-0.059375f,0.128125f},
		  {0.0375f,-0.059375f,0.13125f},
		  {0.04375f,-0.04375f,0.1375f},
		  {0.05f,-0.0375f,0.140625f},
		  {0.05625f,-0.025f,0.14375f},
		  {0.0625f,-0.015625f,0.14375f},
		  {0.06875f,-0.003125f,0.14375f},
		  {0.08125f,0.025f,0.134375f}},
		 {{-0.003125f,-0.09375f,0.075f},
		  {-0.003125f,-0.0875f,0.0875f},
		  {0.f,-0.0875f,0.09375f},
		  {0.003125f,-0.084375f,0.1f},
		  {0.00625f,-0.078125f,0.109375f},
		  {0.0125f,-0.08125f,0.1125f},
		  {0.015625f,-0.071875f,0.121875f},
		  {0.021875f,-0.071875f,0.125f},
		  {0.025f,-0.059375f,0.134375f},
		  {0.03125f,-0.05f,0.140625f},
		  {0.0375f,-0.046875f,0.14375f},
		  {0.04375f,-0.040625f,0.146875f},
		  {0.05f,-0.021875f,0.15f},
		  {0.053125f,-0.0125f,0.153125f},
		  {0.065625f,0.f,0.15f},
		  {0.075f,0.01875f,0.14375f}},
		 {{-0.0125f,-0.0875f,0.084375f},
		  {-0.009375f,-0.0875f,0.090625f},
		  {-0.00625f,-0.0875f,0.096875f},
		  {-0.003125f,-0.084375f,0.103125f},
		  {0.003125f,-0.084375f,0.109375f},
		  {0.00625f,-0.078125f,0.11875f},
		  {0.009375f,-0.075f,0.125f},
		  {0.0125f,-0.0625f,0.134375f},
		  {0.01875f,-0.059375f,0.140625f},
		  {0.025f,-0.05625f,0.14375f},
		  {0.03125f,-0.046875f,0.15f},
		  {0.0375f,-0.040625f,0.153125f},
		  {0.040625f,-0.015625f,0.159375f},
		  {0.046875f,-0.009375f,0.159375f},
		  {0.053125f,0.003125f,0.159375f},
		  {0.065625f,0.015625f,0.153125f}},
		 {{-0.015625f,-0.090625f,0.084375f},
		  {-0.015625f,-0.0875f,0.09375f},
		  {-0.0125f,-0.084375f,0.103125f},
		  {-0.009375f,-0.084375f,0.10625f},
		  {-0.00625f,-0.078125f,0.11875f},
		  {-0.003125f,-0.075f,0.125f},
		  {0.003125f,-0.071875f,0.13125f},
		  {0.00625f,-0.0625f,0.140625f},
		  {0.009375f,-0.053125f,0.146875f},
		  {0.015625f,-0.04375f,0.153125f},
		  {0.021875f,-0.040625f,0.15625f},
		  {0.028125f,-0.034375f,0.159375f},
		  {0.034375f,-0.015625f,0.1625f},
		  {0.0375f,-0.00625f,0.165625f},
		  {0.05f,0.00625f,0.1625f},
		  {0.053125f,0.015625f,0.1625f}},
		 {{-0.025f,-0.0875f,0.090625f},
		  {-0.021875f,-0.0875f,0.09375f},
		  {-0.021875f,-0.08125f,0.10625f},
		  {-0.01875f,-0.078125f,0.115625f},
		  {-0.015625f,-0.071875f,0.125f},
		  {-0.0125f,-0.06875f,0.13125f},
		  {-0.009375f,-0.059375f,0.140625f},
		  {-0.003125f,-0.05625f,0.146875f},
		  {0.003125f,-0.05625f,0.15f},
		  {0.00625f,-0.0375f,0.159375f},
		  {0.0125f,-0.03125f,0.1625f},
		  {0.01875f,-0.021875f,0.165625f},
		  {0.025f,-0.0125f,0.16875f},
		  {0.034375f,-0.003125f,0.16875f},
		  {0.040625f,0.003125f,0.16875f},
		  {0.04375f,0.0125f,0.16875f}},
		 {{-0.034375f,-0.084375f,0.090625f},
		  {-0.03125f,-0.08125f,0.103125f},
		  {-0.03125f,-0.078125f,0.109375f},
		  {-0.028125f,-0.075f,0.11875f},
		  {-0.025f,-0.06875f,0.128125f},
		  {-0.021875f,-0.0625f,0.1375f},
		  {-0.015625f,-0.059375f,0.14375f},
		  {-0.0125f,-0.053125f,0.15f},
		  {-0.00625f,-0.046875f,0.15625f},
		  {0.f,-0.0375f,0.1625f},
		  {0.003125f,-0.03125f,0.165625f},
		  {0.009375f,-0.025f,0.16875f},
		  {0.015625f,-0.009375f,0.171875f},
		  {0.021875f,-0.00625f,0.175f},
		  {0.028125f,0.003125f,0.175f},
		  {0.03125f,0.009375f,0.175f}},
		 {{-0.046875f,-0.078125f,0.09375f},
		  {-0.04375f,-0.075f,0.10625f},
		  {-0.040625f,-0.071875f,0.115625f},
		  {-0.040625f,-0.065625f,0.125f},
		  {-0.0375f,-0.0625f,0.13125f},
		  {-0.034375f,-0.053125f,0.140625f},
		  {-0.028125f,-0.053125f,0.146875f},
		  {-0.021875f,-0.05f,0.153125f},
		  {-0.015625f,-0.04375f,0.159375f},
		  {-0.009375f,-0.034375f,0.165625f},
		  {-0.00625f,-0.028125f,0.16875f},
		  {0.f,-0.021875f,0.171875f},
		  {0.00625f,-0.00625f,0.175f},
		  {0.0125f,-0.003125f,0.178125f},
		  {0.01875f,0.003125f,0.178125f},
		  {0.021875f,0.009375f,0.178125f}},
		 {{-0.0625f,-0.065625f,0.1f},
		  {-0.059375f,-0.0625f,0.109375f},
		  {-0.05625f,-0.059375f,0.11875f},
		  {-0.053125f,-0.059375f,0.125f},
		  {-0.046875f,-0.05625f,0.134375f},
		  {-0.046875f,-0.046875f,0.140625f},
		  {-0.0375f,-0.046875f,0.15f},
		  {-0.034375f,-0.0375f,0.15625f},
		  {-0.028125f,-0.03125f,0.1625f},
		  {-0.025f,-0.025f,0.16875f},
		  {-0.015625f,-0.015625f,0.171875f},
		  {-0.009375f,-0.009375f,0.175f},
		  {0.f,-0.00625f,0.178125f},
		  {0.003125f,0.003125f,0.178125f},
		  {0.00625f,0.00625f,0.18125f},
		  {0.009375f,0.009375f,0.18125f}},
		 {{-0.08125f,-0.046875f,0.096875f},
		  {-0.08125f,-0.040625f,0.10625f},
		  {-0.075f,-0.04375f,0.115625f},
		  {-0.071875f,-0.0375f,0.125f},
		  {-0.0625f,-0.04375f,0.134375f},
		  {-0.059375f,-0.040625f,0.140625f},
		  {-0.053125f,-0.034375f,0.15f},
		  {-0.046875f,-0.03125f,0.15625f},
		  {-0.040625f,-0.021875f,0.1625f},
		  {-0.03125f,-0.01875f,0.16875f},
		  {-0.028125f,-0.009375f,0.171875f},
		  {-0.021875f,-0.003125f,0.175f},
		  {-0.0125f,0.003125f,0.178125f},
		  {-0.00625f,0.003125f,0.18125f},
		  {0.003125f,0.009375f,0.18125f},
		  {0.00625f,0.0125f,0.18125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.096875f,-0.015625f,0.1f},
		  {-0.09375f,-0.015625f,0.109375f},
		  {-0.084375f,-0.021875f,0.125f},
		  {-0.078125f,-0.021875f,0.134375f},
		  {-0.071875f,-0.015625f,0.14375f},
		  {-0.0625f,-0.015625f,0.153125f},
		  {-0.05f,-0.01875f,0.1625f},
		  {-0.046875f,-0.009375f,0.165625f},
		  {-0.0375f,-0.00625f,0.171875f},
		  {-0.03125f,0.f,0.175f},
		  {-0.021875f,0.00625f,0.178125f},
		  {-0.009375f,0.003125f,0.18125f},
		  {-0.003125f,0.0125f,0.18125f},
		  {0.f,0.015625f,0.18125f}}},
		{{{0.021875f,-0.09375f,0.053125f},
		  {0.025f,-0.09375f,0.053125f},
		  {0.028125f,-0.09375f,0.05625f},
		  {0.03125f,-0.090625f,0.0625f},
		  {0.034375f,-0.090625f,0.065625f},
		  {0.0375f,-0.090625f,0.065625f},
		  {0.040625f,-0.0875f,0.071875f},
		  {0.046875f,-0.084375f,0.071875f},
		  {0.05f,-0.08125f,0.078125f},
		  {0.053125f,-0.078125f,0.08125f},
		  {0.059375f,-0.075f,0.084375f},
		  {0.065625f,-0.06875f,0.0875f},
		  {0.071875f,-0.059375f,0.09375f},
		  {0.08125f,-0.046875f,0.096875f},
		  {0.09375f,-0.021875f,0.096875f},
		  {0.1f,0.0375f,0.078125f}},
		 {{0.021875f,-0.096875f,0.05f},
		  {0.025f,-0.096875f,0.053125f},
		  {0.025f,-0.09375f,0.0625f},
		  {0.028125f,-0.09375f,0.065625f},
		  {0.034375f,-0.09375f,0.0625f},
		  {0.0375f,-0.0875f,0.071875f},
		  {0.040625f,-0.0875f,0.075f},
		  {0.04375f,-0.084375f,0.08125f},
		  {0.05f,-0.08125f,0.08125f},
		  {0.053125f,-0.078125f,0.0875f},
		  {0.059375f,-0.071875f,0.090625f},
		  {0.065625f,-0.065625f,0.09375f},
		  {0.06875f,-0.059375f,0.103125f},
		  {0.078125f,-0.046875f,0.10625f},
		  {0.090625f,-0.021875f,0.10625f},
		  {0.1f,0.040625f,0.078125f}},
		 {{0.01875f,-0.1f,0.05f},
		  {0.021875f,-0.1f,0.053125f},
		  {0.025f,-0.096875f,0.059375f},
		  {0.028125f,-0.096875f,0.0625f},
		  {0.03125f,-0.090625f,0.071875f},
		  {0.034375f,-0.090625f,0.075f},
		  {0.0375f,-0.0875f,0.08125f},
		  {0.040625f,-0.084375f,0.0875f},
		  {0.046875f,-0.08125f,0.090625f},
		  {0.053125f,-0.075f,0.09375f},
		  {0.05625f,-0.071875f,0.1f},
		  {0.0625f,-0.0625f,0.10625f},
		  {0.06875f,-0.053125f,0.1125f},
		  {0.078125f,-0.040625f,0.1125f},
		  {0.0875f,-0.01875f,0.115625f},
		  {0.096875f,0.046875f,0.08125f}},
		 {{0.015625f,-0.1f,0.05625f},
		  {0.01875f,-0.1f,0.059375f},
		  {0.021875f,-0.096875f,0.065625f},
		  {0.025f,-0.09375f,0.071875f},
		  {0.028125f,-0.090625f,0.078125f},
		  {0.03125f,-0.090625f,0.08125f},
		  {0.034375f,-0.0875f,0.0875f},
		  {0.040625f,-0.084375f,0.090625f},
		  {0.04375f,-0.078125f,0.1f},
		  {0.046875f,-0.075f,0.10625f},
		  {0.053125f,-0.06875f,0.109375f},
		  {0.059375f,-0.0625f,0.1125f},
		  {0.065625f,-0.05f,0.121875f},
		  {0.075f,-0.0375f,0.121875f},
		  {0.084375f,-0.01875f,0.121875f},
		  {0.096875f,0.034375f,0.1f}},
		 {{0.0125f,-0.1f,0.059375f},
		  {0.015625f,-0.1f,0.0625f},
		  {0.01875f,-0.1f,0.065625f},
		  {0.021875f,-0.1f,0.06875f},
		  {0.025f,-0.096875f,0.078125f},
		  {0.028125f,-0.0875f,0.090625f},
		  {0.03125f,-0.084375f,0.096875f},
		  {0.0375f,-0.08125f,0.1f},
		  {0.040625f,-0.078125f,0.10625f},
		  {0.04375f,-0.06875f,0.11875f},
		  {0.05f,-0.065625f,0.11875f},
		  {0.05625f,-0.05625f,0.125f},
		  {0.0625f,-0.05f,0.125f},
		  {0.06875f,-0.0375f,0.13125f},
		  {0.078125f,-0.021875f,0.13125f},
		  {0.090625f,0.01875f,0.121875f}},
		 {{0.009375f,-0.1f,0.0625f},
		  {0.0125f,-0.1f,0.065625f},
		  {0.0125f,-0.09375f,0.078125f},
		  {0.01875f,-0.1f,0.075f},
		  {0.01875f,-0.090625f,0.090625f},
		  {0.025f,-0.096875f,0.084375f},
		  {0.028125f,-0.0875f,0.1f},
		  {0.03125f,-0.08125f,0.109375f},
		  {0.0375f,-0.078125f,0.1125f},
		  {0.040625f,-0.06875f,0.121875f},
		  {0.046875f,-0.065625f,0.125f},
		  {0.053125f,-0.053125f,0.13125f},
		  {0.059375f,-0.046875f,0.134375f},
		  {0.065625f,-0.034375f,0.1375f},
		  {0.075f,-0.015625f,0.1375f},
		  {0.0875f,0.015625f,0.128125f}},
		 {{0.00625f,-0.1f,0.065625f},
		  {0.00625f,-0.096875f,0.075f},
		  {0.0125f,-0.1f,0.075f},
		  {0.0125f,-0.09375f,0.0875f},
		  {0.015625f,-0.090625f,0.09375f},
		  {0.021875f,-0.096875f,0.090625f},
		  {0.021875f,-0.084375f,0.109375f},
		  {0.028125f,-0.078125f,0.115625f},
		  {0.03125f,-0.075f,0.121875f},
		  {0.0375f,-0.071875f,0.125f},
		  {0.04375f,-0.0625f,0.13125f},
		  {0.05f,-0.05f,0.1375f},
		  {0.053125f,-0.040625f,0.14375f},
		  {0.059375f,-0.028125f,0.146875f},
		  {0.065625f,-0.01875f,0.146875f},
		  {0.075f,0.f,0.14375f}},
		 {{0.f,-0.1f,0.06875f},
		  {0.003125f,-0.1f,0.075f},
		  {0.00625f,-0.1f,0.08125f},
		  {0.009375f,-0.096875f,0.0875f},
		  {0.0125f,-0.09375f,0.096875f},
		  {0.015625f,-0.09375f,0.1f},
		  {0.01875f,-0.08125f,0.115625f},
		  {0.021875f,-0.078125f,0.121875f},
		  {0.028125f,-0.08125f,0.121875f},
		  {0.03125f,-0.0625f,0.1375f},
		  {0.0375f,-0.05625f,0.140625f},
		  {0.040625f,-0.046875f,0.146875f},
		  {0.046875f,-0.040625f,0.15f},
		  {0.053125f,-0.028125f,0.153125f},
		  {0.059375f,-0.01875f,0.153125f},
		  {0.065625f,-0.003125f,0.153125f}},
		 {{-0.003125f,-0.1f,0.071875f},
		  {0.f,-0.1f,0.078125f},
		  {0.003125f,-0.1f,0.084375f},
		  {0.003125f,-0.09375f,0.096875f},
		  {0.00625f,-0.09375f,0.103125f},
		  {0.009375f,-0.0875f,0.1125f},
		  {0.0125f,-0.084375f,0.11875f},
		  {0.01875f,-0.084375f,0.121875f},
		  {0.021875f,-0.071875f,0.134375f},
		  {0.025f,-0.059375f,0.14375f},
		  {0.03125f,-0.05625f,0.146875f},
		  {0.034375f,-0.04375f,0.153125f},
		  {0.040625f,-0.034375f,0.15625f},
		  {0.046875f,-0.021875f,0.159375f},
		  {0.053125f,-0.015625f,0.159375f},
		  {0.059375f,0.f,0.159375f}},
		 {{-0.009375f,-0.1f,0.078125f},
		  {-0.00625f,-0.1f,0.08125f},
		  {-0.003125f,-0.1f,0.084375f},
		  {0.f,-0.096875f,0.096875f},
		  {0.f,-0.090625f,0.109375f},
		  {0.003125f,-0.0875f,0.115625f},
		  {0.00625f,-0.08125f,0.125f},
		  {0.009375f,-0.075f,0.134375f},
		  {0.015625f,-0.075f,0.1375f},
		  {0.01875f,-0.05625f,0.15f},
		  {0.025f,-0.053125f,0.153125f},
		  {0.028125f,-0.040625f,0.159375f},
		  {0.034375f,-0.03125f,0.1625f},
		  {0.0375f,-0.021875f,0.165625f},
		  {0.046875f,-0.00625f,0.165625f},
		  {0.05f,0.f,0.165625f}},
		 {{-0.0125f,-0.1f,0.078125f},
		  {-0.0125f,-0.096875f,0.0875f},
		  {-0.009375f,-0.096875f,0.09375f},
		  {-0.009375f,-0.09375f,0.103125f},
		  {-0.00625f,-0.090625f,0.1125f},
		  {-0.003125f,-0.0875f,0.11875f},
		  {-0.003125f,-0.075f,0.134375f},
		  {0.003125f,-0.075f,0.1375f},
		  {0.00625f,-0.065625f,0.146875f},
		  {0.0125f,-0.059375f,0.153125f},
		  {0.015625f,-0.046875f,0.159375f},
		  {0.021875f,-0.04375f,0.1625f},
		  {0.025f,-0.025f,0.16875f},
		  {0.03125f,-0.021875f,0.16875f},
		  {0.034375f,-0.00625f,0.171875f},
		  {0.040625f,-0.003125f,0.171875f}},
		 {{-0.021875f,-0.096875f,0.084375f},
		  {-0.01875f,-0.096875f,0.090625f},
		  {-0.01875f,-0.09375f,0.1f},
		  {-0.015625f,-0.090625f,0.109375f},
		  {-0.015625f,-0.084375f,0.121875f},
		  {-0.0125f,-0.08125f,0.128125f},
		  {-0.009375f,-0.075f,0.1375f},
		  {-0.00625f,-0.065625f,0.146875f},
		  {-0.003125f,-0.059375f,0.153125f},
		  {0.003125f,-0.053125f,0.159375f},
		  {0.00625f,-0.0375f,0.165625f},
		  {0.0125f,-0.034375f,0.16875f},
		  {0.01875f,-0.025f,0.171875f},
		  {0.021875f,-0.0125f,0.175f},
		  {0.028125f,-0.00625f,0.175f},
		  {0.03125f,0.f,0.175f}},
		 {{-0.025f,-0.096875f,0.084375f},
		  {-0.028125f,-0.09375f,0.090625f},
		  {-0.028125f,-0.090625f,0.1f},
		  {-0.025f,-0.0875f,0.1125f},
		  {-0.025f,-0.084375f,0.11875f},
		  {-0.021875f,-0.075f,0.134375f},
		  {-0.021875f,-0.065625f,0.14375f},
		  {-0.015625f,-0.0625f,0.15f},
		  {-0.0125f,-0.05f,0.159375f},
		  {-0.009375f,-0.0375f,0.165625f},
		  {-0.003125f,-0.034375f,0.16875f},
		  {0.003125f,-0.03125f,0.171875f},
		  {0.009375f,-0.025f,0.175f},
		  {0.0125f,-0.00625f,0.178125f},
		  {0.01875f,-0.003125f,0.178125f},
		  {0.025f,0.f,0.178125f}},
		 {{-0.04375f,-0.0875f,0.090625f},
		  {-0.040625f,-0.0875f,0.096875f},
		  {-0.040625f,-0.08125f,0.1125f},
		  {-0.040625f,-0.075f,0.121875f},
		  {-0.040625f,-0.06875f,0.13125f},
		  {-0.0375f,-0.0625f,0.140625f},
		  {-0.03125f,-0.059375f,0.146875f},
		  {-0.028125f,-0.05f,0.15625f},
		  {-0.021875f,-0.04375f,0.1625f},
		  {-0.01875f,-0.040625f,0.165625f},
		  {-0.0125f,-0.028125f,0.171875f},
		  {-0.00625f,-0.021875f,0.175f},
		  {0.f,-0.0125f,0.178125f},
		  {0.f,-0.00625f,0.18125f},
		  {0.009375f,0.f,0.18125f},
		  {0.0125f,0.003125f,0.18125f}},
		 {{-0.065625f,-0.06875f,0.1f},
		  {-0.065625f,-0.065625f,0.10625f},
		  {-0.0625f,-0.065625f,0.1125f},
		  {-0.059375f,-0.059375f,0.125f},
		  {-0.059375f,-0.05f,0.134375f},
		  {-0.053125f,-0.046875f,0.14375f},
		  {-0.04375f,-0.05f,0.15f},
		  {-0.040625f,-0.04375f,0.15625f},
		  {-0.034375f,-0.0375f,0.1625f},
		  {-0.028125f,-0.028125f,0.16875f},
		  {-0.021875f,-0.028125f,0.171875f},
		  {-0.01875f,-0.01875f,0.175f},
		  {-0.0125f,-0.009375f,0.178125f},
		  {0.f,-0.003125f,0.18125f},
		  {0.f,0.f,0.18125f},
		  {0.f,0.f,0.f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.09375f,-0.021875f,0.10625f},
		  {-0.090625f,-0.021875f,0.115625f},
		  {-0.08125f,-0.028125f,0.128125f},
		  {-0.06875f,-0.034375f,0.140625f},
		  {-0.065625f,-0.028125f,0.146875f},
		  {-0.05625f,-0.025f,0.15625f},
		  {-0.046875f,-0.028125f,0.1625f},
		  {-0.0375f,-0.025f,0.16875f},
		  {-0.034375f,-0.015625f,0.171875f},
		  {-0.021875f,-0.0125f,0.178125f},
		  {-0.021875f,-0.00625f,0.178125f},
		  {-0.009375f,0.f,0.18125f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f}}},
		{{{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.03125f,-0.1f,0.05f},
		  {0.034375f,-0.1f,0.05f},
		  {0.034375f,-0.1f,0.053125f},
		  {0.0375f,-0.1f,0.05625f},
		  {0.040625f,-0.096875f,0.059375f},
		  {0.04375f,-0.096875f,0.059375f},
		  {0.046875f,-0.09375f,0.065625f},
		  {0.05f,-0.096875f,0.059375f},
		  {0.05625f,-0.09375f,0.065625f},
		  {0.0625f,-0.090625f,0.06875f},
		  {0.06875f,-0.0875f,0.071875f},
		  {0.071875f,-0.084375f,0.075f},
		  {0.1f,0.034375f,0.078125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.028125f,-0.1f,0.05f},
		  {0.028125f,-0.1f,0.05625f},
		  {0.03125f,-0.1f,0.059375f},
		  {0.034375f,-0.1f,0.059375f},
		  {0.0375f,-0.096875f,0.065625f},
		  {0.040625f,-0.096875f,0.065625f},
		  {0.040625f,-0.096875f,0.06875f},
		  {0.04375f,-0.096875f,0.06875f},
		  {0.05f,-0.090625f,0.075f},
		  {0.05625f,-0.096875f,0.06875f},
		  {0.059375f,-0.09375f,0.075f},
		  {0.0625f,-0.090625f,0.078125f},
		  {0.065625f,-0.0875f,0.08125f},
		  {0.1f,0.040625f,0.08125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.028125f,-0.1f,0.059375f},
		  {0.028125f,-0.1f,0.0625f},
		  {0.03125f,-0.1f,0.065625f},
		  {0.0375f,-0.096875f,0.06875f},
		  {0.0375f,-0.096875f,0.075f},
		  {0.04375f,-0.09375f,0.075f},
		  {0.04375f,-0.09375f,0.08125f},
		  {0.046875f,-0.090625f,0.084375f},
		  {0.05f,-0.0875f,0.090625f},
		  {0.053125f,-0.0875f,0.0875f},
		  {0.059375f,-0.078125f,0.1f},
		  {0.065625f,-0.071875f,0.103125f},
		  {0.1f,0.025f,0.096875f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.028125f,-0.1f,0.06875f},
		  {0.03125f,-0.1f,0.06875f},
		  {0.034375f,-0.096875f,0.078125f},
		  {0.0375f,-0.096875f,0.078125f},
		  {0.040625f,-0.09375f,0.084375f},
		  {0.04375f,-0.090625f,0.09375f},
		  {0.046875f,-0.0875f,0.096875f},
		  {0.053125f,-0.08125f,0.103125f},
		  {0.05625f,-0.078125f,0.10625f},
		  {0.059375f,-0.071875f,0.1125f},
		  {0.06875f,-0.059375f,0.11875f},
		  {0.078125f,-0.040625f,0.125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.028125f,-0.1f,0.078125f},
		  {0.03125f,-0.096875f,0.084375f},
		  {0.034375f,-0.096875f,0.0875f},
		  {0.0375f,-0.09375f,0.09375f},
		  {0.040625f,-0.0875f,0.103125f},
		  {0.046875f,-0.0875f,0.1f},
		  {0.05f,-0.078125f,0.115625f},
		  {0.05625f,-0.06875f,0.121875f},
		  {0.0625f,-0.065625f,0.11875f},
		  {0.065625f,-0.05625f,0.128125f},
		  {0.078125f,-0.028125f,0.134375f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.021875f,-0.1f,0.078125f},
		  {0.025f,-0.1f,0.08125f},
		  {0.028125f,-0.096875f,0.090625f},
		  {0.03125f,-0.09375f,0.096875f},
		  {0.034375f,-0.090625f,0.103125f},
		  {0.040625f,-0.0875f,0.10625f},
		  {0.04375f,-0.08125f,0.115625f},
		  {0.05f,-0.075f,0.11875f},
		  {0.053125f,-0.06875f,0.125f},
		  {0.059375f,-0.059375f,0.13125f},
		  {0.065625f,-0.040625f,0.140625f},
		  {0.071875f,-0.025f,0.14375f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.01875f,-0.1f,0.084375f},
		  {0.021875f,-0.1f,0.0875f},
		  {0.025f,-0.096875f,0.09375f},
		  {0.028125f,-0.09375f,0.103125f},
		  {0.03125f,-0.0875f,0.1125f},
		  {0.0375f,-0.084375f,0.115625f},
		  {0.040625f,-0.078125f,0.121875f},
		  {0.04375f,-0.06875f,0.134375f},
		  {0.05f,-0.065625f,0.134375f},
		  {0.05625f,-0.05625f,0.1375f},
		  {0.0625f,-0.040625f,0.14375f},
		  {0.06875f,-0.025f,0.146875f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.0125f,-0.1f,0.090625f},
		  {0.015625f,-0.096875f,0.1f},
		  {0.021875f,-0.096875f,0.1f},
		  {0.025f,-0.096875f,0.103125f},
		  {0.028125f,-0.0875f,0.115625f},
		  {0.03125f,-0.078125f,0.128125f},
		  {0.0375f,-0.078125f,0.128125f},
		  {0.040625f,-0.06875f,0.1375f},
		  {0.046875f,-0.05625f,0.14375f},
		  {0.05f,-0.046875f,0.15f},
		  {0.05625f,-0.034375f,0.153125f},
		  {0.0625f,-0.025f,0.153125f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {0.00625f,-0.1f,0.090625f},
		  {0.009375f,-0.1f,0.09375f},
		  {0.0125f,-0.096875f,0.103125f},
		  {0.015625f,-0.09375f,0.109375f},
		  {0.021875f,-0.096875f,0.109375f},
		  {0.025f,-0.09375f,0.115625f},
		  {0.028125f,-0.084375f,0.128125f},
		  {0.03125f,-0.06875f,0.140625f},
		  {0.034375f,-0.0625f,0.146875f},
		  {0.040625f,-0.05f,0.153125f},
		  {0.04375f,-0.0375f,0.159375f},
		  {0.05f,-0.03125f,0.159375f},
		  {0.05625f,-0.021875f,0.159375f}},
		 {{0.f,0.f,0.f},
		  {0.f,0.f,0.f},
		  {-0.003125f,-0.1f,0.0875f},
		  {0.f,-0.1f,0.09375f},
		  {0.003125f,-0.096875f,0.103125f},
		  {0.009375f,-0.1f,0.103125f},
		  {0.0125f,-0.1f,0.109375f},
		  {0.015625f,-0.090625f,0.121875f},
		  {0.01875f,-0.0875f,0.128125f},
		  {0.021875f,-0.078125f,0.1375f},
		  {0.025f,-0.0625f,0.15f},
		  {0.028125f,-0.053125f,0.15625f},
		  {0.034375f,-0.046875f,0.159375f},
		  {0.0375f,-0.03125f,0.165625f},
		  {0.04375f,-0.025f,0.165625f},
		  {0.046875f,-0.021875f,0.165625f}},
		 {{0.f,0.f,0.f},
		  {-0.009375f,-0.1f,0.084375f},
		  {-0.00625f,-0.1f,0.090625f},
		  {-0.003125f,-0.1f,0.096875f},
		  {0.f,-0.096875f,0.10625f},
		  {0.003125f,-0.096875f,0.1125f},
		  {0.00625f,-0.09375f,0.11875f},
		  {0.009375f,-0.090625f,0.125f},
		  {0.0125f,-0.08125f,0.1375f},
		  {0.015625f,-0.071875f,0.146875f},
		  {0.01875f,-0.065625f,0.153125f},
		  {0.021875f,-0.046875f,0.1625f},
		  {0.028125f,-0.040625f,0.165625f},
		  {0.03125f,-0.03125f,0.16875f},
		  {0.034375f,-0.01875f,0.171875f},
		  {0.0375f,-0.015625f,0.171875f}},
		 {{-0.015625f,-0.1f,0.08125f},
		  {-0.015625f,-0.1f,0.0875f},
		  {-0.0125f,-0.1f,0.09375f},
		  {-0.00625f,-0.1f,0.1f},
		  {-0.003125f,-0.1f,0.10625f},
		  {0.f,-0.1f,0.109375f},
		  {0.f,-0.09375f,0.121875f},
		  {0.f,-0.08125f,0.1375f},
		  {0.00625f,-0.078125f,0.14375f},
		  {0.00625f,-0.065625f,0.153125f},
		  {0.009375f,-0.05f,0.1625f},
		  {0.015625f,-0.05f,0.165625f},
		  {0.01875f,-0.03125f,0.171875f},
		  {0.021875f,-0.021875f,0.175f},
		  {0.028125f,-0.015625f,0.175f},
		  {0.03125f,-0.0125f,0.175f}},
		 {{-0.021875f,-0.1f,0.084375f},
		  {-0.01875f,-0.1f,0.090625f},
		  {-0.015625f,-0.1f,0.096875f},
		  {-0.0125f,-0.1f,0.103125f},
		  {-0.00625f,-0.1f,0.109375f},
		  {-0.00625f,-0.096875f,0.115625f},
		  {-0.00625f,-0.09375f,0.121875f},
		  {-0.009375f,-0.071875f,0.146875f},
		  {-0.003125f,-0.071875f,0.15f},
		  {-0.003125f,-0.053125f,0.1625f},
		  {0.f,-0.040625f,0.16875f},
		  {0.00625f,-0.0375f,0.171875f},
		  {0.009375f,-0.028125f,0.175f},
		  {0.0125f,-0.01875f,0.178125f},
		  {0.01875f,-0.015625f,0.178125f},
		  {0.f,0.f,0.f}},
		 {{-0.025f,-0.1f,0.084375f},
		  {-0.021875f,-0.1f,0.090625f},
		  {-0.01875f,-0.1f,0.096875f},
		  {-0.015625f,-0.1f,0.103125f},
		  {-0.015625f,-0.096875f,0.1125f},
		  {-0.015625f,-0.09375f,0.11875f},
		  {-0.021875f,-0.071875f,0.14375f},
		  {-0.01875f,-0.06875f,0.15f},
		  {-0.015625f,-0.05625f,0.159375f},
		  {-0.0125f,-0.046875f,0.165625f},
		  {-0.009375f,-0.034375f,0.171875f},
		  {-0.003125f,-0.03125f,0.175f},
		  {0.003125f,-0.021875f,0.178125f},
		  {0.003125f,-0.009375f,0.18125f},
		  {0.009375f,-0.00625f,0.18125f},
		  {0.0125f,-0.00625f,0.18125f}},
		 {{-0.028125f,-0.1f,0.084375f},
		  {-0.025f,-0.1f,0.09375f},
		  {-0.021875f,-0.1f,0.1f},
		  {-0.01875f,-0.1f,0.103125f},
		  {-0.034375f,-0.08125f,0.128125f},
		  {-0.0375f,-0.06875f,0.140625f},
		  {-0.0375f,-0.059375f,0.15f},
		  {-0.03125f,-0.059375f,0.153125f},
		  {-0.025f,-0.05f,0.1625f},
		  {-0.021875f,-0.040625f,0.16875f},
		  {-0.01875f,-0.034375f,0.171875f},
		  {-0.015625f,-0.01875f,0.178125f},
		  {-0.009375f,-0.021875f,0.178125f},
		  {-0.003125f,-0.009375f,0.18125f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f}},
		 {{-0.03125f,-0.1f,0.08125f},
		  {-0.028125f,-0.1f,0.090625f},
		  {-0.025f,-0.1f,0.096875f},
		  {-0.075f,-0.046875f,0.125f},
		  {-0.06875f,-0.046875f,0.134375f},
		  {-0.059375f,-0.046875f,0.14375f},
		  {-0.05625f,-0.046875f,0.146875f},
		  {-0.046875f,-0.04375f,0.15625f},
		  {-0.04375f,-0.034375f,0.1625f},
		  {-0.034375f,-0.03125f,0.16875f},
		  {-0.03125f,-0.025f,0.171875f},
		  {-0.021875f,-0.015625f,0.178125f},
		  {0.f,0.f,0.f},
		  {-0.0125f,-0.009375f,0.18125f},
		  {0.f,0.f,0.f},
		  {0.f,0.f,0.f}}}};
}
#endif
