open nat

protected theorem my_add_comm : ∀ (n m : ℕ), n + m = m + n
| n 0     := eq.symm (nat.zero_add n)
| n (m+1) :=
  suffices succ (n + m) = succ (m + n), from
    eq.symm (succ_add m n) ▸ this,
  congr_arg succ (my_add_comm n m)
