#include "ldastoolsal/Sed.hh"
#include "ldastoolsal/unittest.h"

using LDASTools::Cmd::Sed;

LDASTools::Testing::UnitTest Test;

void
test_1( )
{
  std::string	modified;
  Sed		s( "s/a/a.b/" );

  modified = s( "aba" );

  Test.Check( modified.compare( "a.bba" ) == 0 )
    << "Simple substitution"
    << std::endl
    ;
}

void
test_2( )
{
  std::string	modified;
  Sed		s( "s/a/a.b/i" );

  modified = s( "Aba" );

  Test.Check( modified.compare( "a.bba" ) == 0 )
    << "Ignore case substitution"
    << std::endl
    ;
}

void
test_global( )
{
  std::string	modified;
  Sed		s( "s/a/a.b/g" );

  modified = s( "aba" );

  Test.Check( modified.compare( "a.bba.b" ) == 0 )
    << "Global substitution"
    << std::endl
    ;
}

void
test_multi_line( )
{
  std::string		modified;
  Sed			s( "s/a/a.b/g" );
  std::ostringstream	buffer;
  std::ostringstream	answer;

  buffer
    << "aba" << std::endl
    << "bab"
    ;

  answer
    << "a.bba.b" << std::endl
    << "ba.bb"
    ;

  modified = s( buffer.str( ) );

  Test.Check( modified.compare( answer.str( ) ) == 0 )
    << "Multi line substitution"
    << std::endl
    ;
}

int
main( int ArgC, char** ArgV )
{
  //---------------------------------------------------------------------
  // Initialize the test structure
  //---------------------------------------------------------------------
  Test.Init(ArgC, ArgV);

  //---------------------------------------------------------------------
  // Run through a series of tests
  //---------------------------------------------------------------------

  test_1( );
  test_2( );
  test_global( );
  test_multi_line( );

  //---------------------------------------------------------------------
  // Exit with the appropriate exit status
  //---------------------------------------------------------------------
  Test.Exit();
  return 1;
}
