#ifndef GeneralRegexHH
#define GeneralRegexHH

#if ! defined(SWIGIMPORTED)
#include <string>
#include <regex.h>
#endif /* ! defined(SWIGIMPORTED) */

#include "ldasexception.hh"


//-----------------------------------------------------------------------------
/// \brief  POSIX Regular Expression
///
/// This class represents a POSIX regular expression.
///
class Regex
{
public:

  /* Constructors/Destructor */
  Regex( );
  explicit Regex( const std::string& regex, int flags = REG_EXTENDED );
  explicit Regex( const char* regex, int flags = REG_EXTENDED );
  Regex( const Regex& Source );
  ~Regex() throw();

  /* Accessors */
  bool compiled( ) const;
  const regex_t& getPattern() const;
  const std::string& getRegex() const;

  Regex& operator=( const Regex& Source );
    
private:
  void compile( );

  /* Data */
  std::string	mRegex;
  regex_t	mPattern;
  int		mFlags;
  bool		mCompiled;
};


//-----------------------------------------------------------------------------
/// \brief  Get compilation status
///
/// \return state of compilation
///
inline bool Regex::
compiled() const
{
    return mCompiled;
}

//-----------------------------------------------------------------------------
/// \brief  Get Compiled Pattern
///
/// \return const regex_t &
///
inline const regex_t& Regex::getPattern() const
{
    return mPattern;
}


//-----------------------------------------------------------------------------
/// \brief  Get Regular Expression
///
/// \return const std::string&
///
inline const std::string& Regex::getRegex() const
{
    return mRegex;
}


#endif // GeneralRegexHH
