#ifndef LDAS_TOOLS_AL__SIGNAL_HANDLER_HH
#define LDAS_TOOLS_AL__SIGNAL_HANDLER_HH

#include <list>

#include "ldastoolsal/Singleton.hh"
#include "ldastoolsal/unordered_map.hh"

namespace LDASTools
{
  namespace AL
  {
    class SignalHandler
      : public Singleton< SignalHandler >
    {
    public:
      enum signal_type {
	SIGNAL_HANGUP,
	SIGNAL_UNKNOWN
      };

      class Callback
      {
      public:
	virtual ~Callback( );

	virtual void SignalCallback( signal_type Signal ) = 0;
      };

      static void Register( Callback* CB,signal_type Signal );

      static void Unregister( Callback* CB, signal_type Signal );

      static void Callbacks( signal_type Signal );

    private:
      typedef std::list< Callback* > callbacks_type;
      typedef LDASTools::AL::unordered_map< int, callbacks_type > signal_queue_type;

      signal_queue_type		signal_queue;

      void callbacks( signal_type Signal );

      void reg( Callback* CB, signal_type Signal );

      void unreg( Callback* CB, signal_type Signal );
    };
    
  } // namespace - AL
} // namespace - LDASTools

#endif /* LDAS_TOOLS_AL__SIGNAL_HANDLER_HH */
