#include <iomanip>
#include <list>
#include <string>

#include "genericAPI/TCL.hh"

namespace GenericAPI
{
  namespace TCL
  {
    template< >
    void ListUnbounded< std::ostream, std::list< std::string >::const_iterator >
    ( std::ostream& Output,
      std::list< std::string >::const_iterator Cur,
      std::list< std::string >::const_iterator Stop )
    {
      while( Cur != Stop )
      {
        Output << *Cur;
        ++Cur;
	if ( Cur != Stop )
	{
	  Output << " ";
	}
      }
    }

    template< >
    void List< std::ostream, std::list< std::string >::const_iterator >
    ( std::ostream& Output,
      std::list< std::string >::const_iterator Cur,
      std::list< std::string >::const_iterator Stop )
    {
      Output << "{";
      while( Cur != Stop )
      {
        Output << " " << *Cur;
        ++Cur;
      }
      Output << " }";
    }

  } // namespace - TCL
} // namespace - GenericAPI
