#ifndef GENERIC_API__LOG_HTML_HH
#define GENERIC_API__LOG_HTML_HH

#include "genericAPI/LogLDAS.hh"

namespace GenericAPI
{
  namespace Log
  {
    //-------------------------------------------------------------------
    /// \brief HTML Logging class
    ///
    //---------------------------------------------------------------------
    class HTML
      : public Log::LDAS
    {
    public:
      //-------------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] BaseName
      ///     The base name to be used for creation of the log file.
      ///
      /// \return
      ///     An instance of this object.
      //-------------------------------------------------------------------
      HTML( const std::string& BaseName );

      //-------------------------------------------------------------------
      /// \brief Create a new instance
      ///
      /// \return
      ///     A new instance of this object
      //-------------------------------------------------------------------
      virtual HTML* Clone( const std::string& BaseName ) const;

      virtual const char* FileExtension( ) const;

      virtual std::string FormatJobInfo( const std::string& JobInfo ) const;

      virtual void Message( message_type MessageType, level_type Level,
			    const std::string& Caller, const std::string& JobInfo,
			    const std::string& Message );

    protected:

    private:
      //-------------------------------------------------------------------
      /// \brief Write the HTML header into the log.
      //-------------------------------------------------------------------
      void html_header( );

      //-------------------------------------------------------------------
      /// \brief Write the HTML trailer into the log.
      //-------------------------------------------------------------------
      void html_trailer( );
    }; // class - HTML
  } // namespace - Log
} // namespace - GenericAPI

#endif /* GENERIC_API__LOG_HTML_HH */
 
