#ifndef GENERICAPI__CHANNEL_NAME_LEXER_HH
#define GENERICAPI__CHANNEL_NAME_LEXER_HH

#include <string>
#include <map>

#ifndef FLEX_SCANNER
#include <FlexLexer.h>
#endif /* FLEX_SCANNER */

namespace GenericAPI
{
  /// \brief Supports parsing of channel names from input streams
  //
  // This class supports the extraction of channel names from stream input.
  class ChannelNameLexer
    : private yyFlexLexer
  {
  public:
    //: Data type to hold results
    // The channel name can be referenced by accessing the "first" member.
    // The number of times the channel name has been seen can be accessed
    //  by the "second" member.
    typedef std::map< std::string, int > data_list_type;

    //: Constructor
    //
    //!param: const std::string& NameString - Input string.
    ChannelNameLexer( const std::string& NameString = "" );

    //: Retrieve list of channel names.
    //
    // Returns a list of channel names that have been seen.
    //
    //!return: List of channel names and occurance counts.
    const data_list_type& GetChannelNames( ) const;

    //: Parse additional string for channel names.
    //
    // This routine will expand the list of channel names with any
    // channel names that exist in the input string.
    //
    // const std::string& ChannelData - Input string.
    void Parse( const std::string& ChannelData );

    void LexerError( const char* msg );

    //: List of channel names
    data_list_type	m_channel_names;
    
    //: Add channel to list
    //!param: const char* ChannelName - Name of channel to add
    void add_channel( const char* ChannelName );
    
    // This function is defined in db2_lex.ll
    virtual int yylex();
  };

  inline const ChannelNameLexer::data_list_type& ChannelNameLexer::
  GetChannelNames( ) const
  {
    return m_channel_names;
  }
} // namespace GenericAPI

#endif	/* GENERICAPI__CHANNEL_NAME_LEXER_HH */
