#include <ldas_tools_config.h>

#include "framecpp/Version8/FrameSpec.hh"

#include "framecpp/Version8/PTR_STRUCT.hh"
#include "framecpp/Version8/StreamRef.hh"

#include "framecpp/Version8/FrAdcData.hh"
#include "framecpp/Version8/FrameH.hh"
#include "framecpp/Version8/FrDetector.hh"
#include "framecpp/Version8/FrEndOfFile.hh"
#include "framecpp/Version8/FrEndOfFrame.hh"
#include "framecpp/Version8/FrEvent.hh"
#include "framecpp/Version8/FrHeader.hh"
#include "framecpp/Version8/FrHistory.hh"
#include "framecpp/Version8/FrMsg.hh"
#include "framecpp/Version8/FrProcData.hh"
#include "framecpp/Version8/FrRawData.hh"
#include "framecpp/Version8/FrSE.hh"
#include "framecpp/Version8/FrSerData.hh"
#include "framecpp/Version8/FrSH.hh"
#include "framecpp/Version8/FrSimData.hh"
#include "framecpp/Version8/FrSimEvent.hh"
#include "framecpp/Version8/FrStatData.hh"
#include "framecpp/Version8/FrSummary.hh"
#include "framecpp/Version8/FrTable.hh"
#include "framecpp/Version8/FrTOC.hh"
#include "framecpp/Version8/FrVect.hh"

namespace {
  const FrameCPP::Common::DetectorNames&
  dnt_init( )
  {
    static FrameCPP::Common::DetectorNames retval;

      //-----------------------------------------------------------------
      // Setup the DetectorNameTable from the appendix
      //-----------------------------------------------------------------
      typedef std::pair< int, int > dqb;

      retval( "TAMA_300", "TAMA 300",
	      "T1:", dqb( 0, 1 ) );
      retval( "Virgo_CITF", "Virgo Central Interferometer",
	      "V1:", dqb( 2, 3 ) );
      retval( "Virgo", "Virgo 3 km",
	      "V1:", dqb( 4, 5 ) );
      retval( "GEO_600", "GEO 600",
	      "G1:", dqb( 6, 7 ) );
      retval( "LHO_2k", "LIGO LHO 2 km",
	      "H2:", dqb( 8, 9 ) );
      retval( "LHO_4k", "LIGO LHO 4 km",
	      "H1:", dqb( 10, 11 ) );
      retval( "LLO_4k", "LIGO LLO 4 km",
	      "L1:", dqb( 12, 13 ) );
      retval( "CIT_40", "Caltech 40 meters",
	      "P1:", dqb( 14, 15 ) );
      retval( "ALLEGRO_<theta>", "Allegro with <theta> degrees azimuth",
	      "A1:", dqb( 16, 17 ) );
      retval( "AURIGA", "Auriga",
	      "O1:", dqb( 18, 19 ) );
      retval.Freeze( );

      return retval;
  }
}

namespace FrameCPP
{
  namespace Version_8
  {
    static const bool Initialized = init_frame_spec( );

    const Common::DetectorNames& DetectorNameTable = dnt_init( );

    bool init_frame_spec( )
    {
      using Common::FrameSpec;

      static bool initialized = false;

      if ( ! initialized )
      {
	//---------------------------------------------------------------
	// Local storage describing implementation of the frame spec
	//---------------------------------------------------------------
	std::auto_ptr< Common::FrameSpec::Info >
	  info( new Common::FrameSpec::Info( DATA_FORMAT_VERSION,
					     LIBRARY_MINOR_VERSION
					     /* , Verify :TODO: */ ) );
	
	info->FrameObject( new PTR_STRUCT );
	info->FrameObject( new StreamRef );

	info->FrameObject( new FrAdcData );
	info->FrameObject( new FrameH );
	info->FrameObject( new FrDetector );
	info->FrameObject( new FrEndOfFile );
	info->FrameObject( new FrEndOfFrame );
	info->FrameObject( new FrEvent );
	info->FrameObject( new FrHeader );
	info->FrameObject( new FrHistory );
	info->FrameObject( new FrMsg );
	info->FrameObject( new FrProcData );
	info->FrameObject( new FrRawData );
	info->FrameObject( new FrSE );
	info->FrameObject( new FrSerData );
	info->FrameObject( new FrSH );
	info->FrameObject( new FrSimData );
	info->FrameObject( new FrSimEvent );
	info->FrameObject( new FrStatData );
	info->FrameObject( new FrSummary );
	info->FrameObject( new FrTable );
	info->FrameObject( new FrTOC );
	info->FrameObject( new FrVect );

	//---------------------------------------------------------------
	// Register with the stream manipulator
	//---------------------------------------------------------------
	FrameSpec::SpecInfo( FrameSpec::version_type( DATA_FORMAT_VERSION ),
			     info.release( ) );
	initialized = true;
      }

      //-----------------------------------------------------------------
      // Initialization has been completed.
      //-----------------------------------------------------------------
      return true;
    }

  } // namespace - Version_8
} // namespace - FrameCPP
