#ifndef FrameCPP_VERSION_6_FrStatData_HH
#define FrameCPP_VERSION_6_FrStatData_HH

#include <vector>

#include "framecpp/Common/TOCInfo.hh"
#include "framecpp/Common/SearchContainer.hh"
#include "framecpp/Common/FrameStream.hh"
#include "framecpp/Common/FrStatData.hh"

#include "framecpp/Version4/FrStatData.hh"

#include "framecpp/Version6/FrameSpec.hh"
#include "framecpp/Version6/STRING.hh"
#include "framecpp/Version6/PTR_STRUCT.hh"

#include "framecpp/Version6/FrDetector.hh"
#include "framecpp/Version6/FrSE.hh"
#include "framecpp/Version6/FrTable.hh"
#include "framecpp/Version6/FrTOC.hh"
#include "framecpp/Version6/FrVect.hh"

namespace FrameCPP
{
  namespace Version_6
  {
    //===================================================================
    /// \todo Needs documentation
    //===================================================================

    typedef Previous::FrStatDataNPS FrStatDataNPS;

    //===================================================================
    /// \todo Needs documentation
    //===================================================================

    typedef Version_4::FrStatDataPST< PTR_STRUCT,
				      FrDetector, FrVect, FrTable >
    FrStatDataPS;

    //===================================================================
    //===================================================================
    class FrStatData
      : public Common::FrStatData,
	public FrStatDataNPS,
	public FrStatDataPS,
	public Common::TOCInfo
    {
    public:
      //: Default constructor
      FrStatData( );
      FrStatData( const FrStatData& statData );
      FrStatData( const std::string& name, const std::string& comment,
		  const std::string& representation,
		  INT_4U timeStart,INT_4U timeEnd,
		  INT_4U version );
      FrStatData( const Previous::FrStatData& Source,
		  istream_type* Stream );

      static promote_ret_type
      Promote( INT_2U Source,
	       promote_arg_type Obj,
	       istream_type* Stream );

      static const char* StructName( );

      static const Common::Description* StructDescription( );

      //: Number of bytes needed to write this structure
      cmn_streamsize_type Bytes( const Common::StreamBase& Stream) const;

      virtual FrStatData* Clone( ) const;

      virtual FrStatData* Create( istream_type& Stream ) const;

      virtual fr_detector_type GetDetector( ) const
      {
	return FrStatDataPS::GetDetector( );
      }

      virtual const char* ObjectStructName( ) const;

      virtual void Write( ostream_type& Stream ) const;

#if WORKING_VIRTUAL_TOCQUERY
      virtual void TOCQuery( int InfoClass, ... ) const;
#endif /*  WORKING_VIRTUAL_TOCQUERY */

      //: Merge with another FrAdcData
      FrStatData& Merge( const FrStatData& RHS );

      /// \brief comparison operator
      bool operator==( const FrStatData& RHS ) const;

      /// \brief comparison operator
      virtual bool operator==( const Common::FrameSpec::Object& Obj ) const;

    protected:
      /// \brief Down grade an object
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      istream_type* Stream ) const;

      /// \brief Upgrade an object
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       istream_type* Stream ) const;

#if ! WORKING_VIRTUAL_TOCQUERY
      virtual void vTOCQuery( int InfoClass, va_list vl ) const;
#endif /* ! WORKING_VIRTUAL_TOCQUERY */

    private:
      using Common::FrameSpec::Object::Create;

      FrStatData( istream_type& Stream );
    };

    //===================================================================
    //===================================================================
    inline FrStatData::promote_ret_type FrStatData::
    Promote( INT_2U Source,
	     promote_arg_type Obj,
	     istream_type* Stream )
    {
      return Object::PromoteObject< Previous::FrStatData, FrStatData >
	( DATA_FORMAT_VERSION, Source, Obj, Stream );
    }

    inline const char* FrStatData::
    StructName( )
    {
      static const char* name = "FrStatData";
      return name;
    }
  } // namespace - Version_6
} // namespace FrameCPP
#endif /* FrameCPP_VERSION_6_FrStatData_HH */
