#ifndef FrameCPP__COMMON__FRAME_H_HH
#define FrameCPP__COMMON__FRAME_H_HH

#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/StringStream.hh"

namespace FrameCPP
{
  namespace Common
  {
    class Description;

    class FrameH
      : public FrameSpec::Object
    {
    public:
      typedef IStringStream assign_stream_type;

      using FrameSpec::Object::Create;

      enum copy_type
      {
	DETECT_SIM	= 0x0001,
	DETECT_PROC	= 0x0002,
	HISTORY		= 0x0004,
	RAW_DATA	= 0x0008,
	AUX_DATA	= 0x0010,
	AUX_TABLE	= 0x0020
      };

#if 0
      enum detector_copy_type
      {
	DEEP_COPY_DETECTORS,
	SHALLOW_COPY_DETECTORS
      };
#endif /* 0 */

     static const Common::FrameSpec::Info::frame_object_types s_object_id
      = Common::FrameSpec::Info::FSI_FRAME_H;

      FrameH( const Description* Desc );

      virtual ~FrameH( );

      virtual start_time_normalized_type normalizedStartTime( ) const = 0;

      virtual delta_t_normalized_type normalizedDeltaT( ) const = 0;

      virtual void readSubset( IStream& Stream, INT_4U ElementMask ) = 0;

      //-----------------------------------------------------------------
      /// \brief Assign the contents of the instance
      ///
      /// \param[in] Stream
      ///     An input stream from which to read information for
      ///     the instance.
      //-----------------------------------------------------------------
      virtual void assign( assign_stream_type& Stream ) = 0;

    private:
    };
  } // namespace - Common
} // namespace - FrameCPP

#endif /* FrameCPP__COMMON__FRAME_H_HH */

