#ifndef HANNWINDOW_HH
#define HANNWINDOW_HH

//!ppp: {eval `cat $ENV{SRCDIR}/cc_rules.pl`}

#include "Window.hh"

namespace Filters {

    //
    //: A class representing a Hann window
    //
    class HannWindow : public Window {

    public:
	//
	//: Return window name
	//
	//!return: string - window name
	//
	virtual std::string name() const;

	//
	//: Return window parameter
	//
	//!return: double - window parameter
	//
	virtual double param() const;

	//
	//: Clone a window
	//
	//!return: HannWindow* - copy of current window
	//
	virtual HannWindow* Clone() const;

    private:
	//
	//: Get the ith element of the window
	//
	// A Hann window is defined by
	//
	//     w[i] = 0.5*(1.0 - cos(2*LDAS_PI*i/(n-1)))
	//
	// for i = 0,1, ... n-1
	//
	// NOTE: the above definition of the Hann window is taken from
	// "Discrete-time Signal Processing" by Oppenheim and Schafer,
	// 2nd ed. p.468.  This definition disagrees with that given in
	// Matlab for hanning(n).
	//
	//!param: i - the value at which the window is evaluated
	//
	//!return: double - the window element w[i]
	//
	virtual double element(const size_t i) const;

    };

} // namespace Filters

#endif // HANNWINDOW_HH

