#ifndef DISKCACHE_API__DISK_CACHE_HH
#define DISKCACHE_API__DISK_CACHE_HH

#include <limits>
#include <list>
#include <sstream>
#include <string>

#include "ldastoolsal/types.hh"

#include "diskcacheAPI/Common/Logging.hh"

#define	NEW_INTERFACE 1
#define DEPRICATED_INTERFACE 0

namespace diskCache
{
  enum dump_format_type {
    DUMP_FORMAT_TCL = 1
  };
  typedef INT_4S  mtime_type;

  typedef INT_8U  total_file_count_type;

  //---------------------------------------------------------------------
  const total_file_count_type	SCANNED_FILES_RESET
  = std::numeric_limits< total_file_count_type >::max( );


  total_file_count_type ScannedFiles( );

  void ScannedFiles( total_file_count_type IncrementValue );

#if NEW_INTERFACE
  void SetFilenameExtensions( const std::list< std::string >& Extensions );
#endif /* NEW_INTERFACE */
} // namespace - diskCache

#endif /* DISKCACHE_API__DISK_CACHE_HH */
