#include <ldas_tools_config.h>

#include <queue>

#include "diskcacheAPI/Streams/Binary.hh"

#include "MountPointManager.hh"

#if 0
#define DEBUG_MOUNT_POINT_MANAGER 1
#endif /* 0 */

namespace diskCache
{
  //---------------------------------------------------------------------
  /// Handles writing of a single collection of mount points to a binary
  /// stream.
  //---------------------------------------------------------------------
  template<>
  Streams::IBinary& MountPointManager::
  Read( Streams::IBinary& Stream )
  {
    mount_point_names_rw_type
      mpn_lock( mount_point_names_rw( ) );

    Stream >> mpn_lock.Var( )	// read the list of mount points
      ;
    mount_point_name_container_type	dictionary_order( mpn_lock.Var( ) );

    dictionary_order.sort( );
    m_mount_points_dictionary_order.swap( dictionary_order );

    //-------------------------------------------------------------------
    // Work is done so return to the caller
    //-------------------------------------------------------------------
    return Stream;
  }

  //---------------------------------------------------------------------
  /// Handles writing of a single collection of mount points to a binary
  /// stream.
  //---------------------------------------------------------------------
  template<>
  Streams::OBinary& MountPointManager::
  Write( Streams::OBinary& Stream )
  {
    const mount_point_names_ro_type
      mpn_lock( mount_point_names_ro( ) );

    Stream << mpn_lock.Var( )	// write the list of mount points
      ;
    //-----------------------------------------------------------------
    // Work is done so return to the caller
    //-----------------------------------------------------------------
    return Stream;
  }
} // namespace - diskCache
